/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.artifacts;

import com.intellij.database.dataSource.artifacts.ArtifactRepositoriesProvider;
import com.intellij.database.dataSource.artifacts.MavenSettingsRepositoriesProvider$getElementWithRegardToNamespace$;
import com.intellij.database.dataSource.artifacts.MavenSettingsRepositoriesProviderKt;
import com.intellij.database.dataSource.artifacts.RemoteRepositoryDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SystemProperties;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dataSource/artifacts/MavenSettingsRepositoriesProvider;", "Lcom/intellij/database/dataSource/artifacts/ArtifactRepositoriesProvider;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PATH_TO_SETTINGS_XML", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "cachedRepositories", "", "Lcom/intellij/database/dataSource/artifacts/RemoteRepositoryDescription;", "getRepositories", "getMirrorsFromSettings", "getElementWithRegardToNamespace", "Lorg/jdom/Element;", "parent", "childName", "", "getElementsWithRegardToNamespace", "childrenName", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nMavenSettingsRepositoriesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenSettingsRepositoriesProvider.kt\ncom/intellij/database/dataSource/artifacts/MavenSettingsRepositoriesProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,82:1\n477#2:83\n*S KotlinDebug\n*F\n+ 1 MavenSettingsRepositoriesProvider.kt\ncom/intellij/database/dataSource/artifacts/MavenSettingsRepositoriesProvider\n*L\n74#1:83\n*E\n"})
public final class MavenSettingsRepositoriesProvider
extends ArtifactRepositoriesProvider {
    @NotNull
    private final Logger LOG;
    private final Path PATH_TO_SETTINGS_XML;
    @NotNull
    private FileTime lastModifiedTime;
    @NotNull
    private List<RemoteRepositoryDescription> cachedRepositories;

    public MavenSettingsRepositoriesProvider() {
        Logger logger2 = Logger.getInstance(MavenSettingsRepositoriesProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.LOG = logger2;
        this.PATH_TO_SETTINGS_XML = Path.of(SystemProperties.getUserHome(), new String[0]).resolve(".m2").resolve("settings.xml");
        FileTime fileTime = FileTime.fromMillis(Long.MIN_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"fromMillis(...)");
        this.lastModifiedTime = fileTime;
        this.cachedRepositories = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public synchronized List<RemoteRepositoryDescription> getRepositories() {
        try {
            if (!Files.exists(this.PATH_TO_SETTINGS_XML, new LinkOption[0])) {
                return CollectionsKt.emptyList();
            }
            FileTime currentModifiedTime = Files.getLastModifiedTime(this.PATH_TO_SETTINGS_XML, new LinkOption[0]);
            if (currentModifiedTime.compareTo(this.lastModifiedTime) == 0) {
                return this.cachedRepositories;
            }
            Intrinsics.checkNotNull((Object)currentModifiedTime);
            this.lastModifiedTime = currentModifiedTime;
            this.cachedRepositories = this.getMirrorsFromSettings();
            return this.cachedRepositories;
        }
        catch (Throwable e) {
            String string = "Failed to read %s";
            Object[] objectArray = new Object[]{"settings.xml"};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            this.LOG.warn(string2, e);
            return CollectionsKt.emptyList();
        }
    }

    private final List<RemoteRepositoryDescription> getMirrorsFromSettings() {
        List repositories = new ArrayList();
        Element element = JDOMUtil.load((Reader)new InputStreamReader(Files.newInputStream(this.PATH_TO_SETTINGS_XML, new OpenOption[0]), StandardCharsets.UTF_8));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element root = element;
        Element mirrorParent = this.getElementWithRegardToNamespace(root, "mirrors");
        if (mirrorParent == null) {
            return repositories;
        }
        List<Element> mirrors = this.getElementsWithRegardToNamespace(mirrorParent, "mirror");
        for (Element mirror : mirrors) {
            Element url = this.getElementWithRegardToNamespace(mirror, "url");
            if (url == null) continue;
            String string = url.getTextTrim();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextTrim(...)");
            repositories.add(new RemoteRepositoryDescription(null, string));
        }
        return repositories;
    }

    private final Element getElementWithRegardToNamespace(Element parent, String childName) {
        List list = parent.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getElementWithRegardToNamespace$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (Element)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)sequence, arg_0 -> MavenSettingsRepositoriesProvider.getElementWithRegardToNamespace$lambda$0(childName, arg_0)));
    }

    private final List<Element> getElementsWithRegardToNamespace(Element parent, String childrenName) {
        List list = parent.getContent(arg_0 -> MavenSettingsRepositoriesProvider.getElementsWithRegardToNamespace$lambda$1(childrenName, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    private static final boolean getElementWithRegardToNamespace$lambda$0(String $childName, Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$childName) && MavenSettingsRepositoriesProviderKt.access$getSETTINGS_SET_NAMESPACES$p().contains(it.getNamespace());
    }

    private static final boolean getElementsWithRegardToNamespace$lambda$1(String $childrenName, Object it) {
        return it instanceof Element && Intrinsics.areEqual((Object)((Element)it).getName(), (Object)$childrenName) && MavenSettingsRepositoriesProviderKt.access$getSETTINGS_SET_NAMESPACES$p().contains(((Element)it).getNamespace());
    }
}

