/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.util.InternedJDomReader;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternSerialization;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import java.util.Objects;
import java.util.UUID;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlMapping {
    private final String myUniqueId;
    private String myName = "";
    private String myComment = "";
    private String myDataSourceId;
    private String myDdlDataSourceId;
    private TreePattern myScope;

    public DdlMapping(@Nullable String uniqueId) {
        this.myUniqueId = uniqueId == null ? UUID.randomUUID().toString() : uniqueId;
    }

    @NotNull
    public String getUniqueId() {
        String string = this.myUniqueId;
        if (string == null) {
            DdlMapping.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DdlMapping.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            DdlMapping.$$$reportNull$$$0(2);
        }
        this.myName = name2;
    }

    @Nullable
    public String getDataSourceId() {
        return this.myDataSourceId;
    }

    public void setDataSourceId(@Nullable String dataSourceId) {
        this.myDataSourceId = dataSourceId;
    }

    public boolean isDataSourceId(@Nullable String dataSourceId) {
        return Objects.equals(dataSourceId, this.myDataSourceId);
    }

    @Nullable
    public String getDdlDataSourceId() {
        return this.myDdlDataSourceId;
    }

    public void setDdlDataSourceId(@Nullable String ddlDataSourceId) {
        this.myDdlDataSourceId = ddlDataSourceId;
    }

    public boolean isDdlDataSourceId(@Nullable String ddlDataSourceId) {
        return Objects.equals(ddlDataSourceId, this.myDdlDataSourceId);
    }

    @Nullable
    public TreePattern getScope() {
        return this.myScope;
    }

    public void setScope(@Nullable TreePattern scope2) {
        this.myScope = scope2;
    }

    @NotNull
    public String getComment() {
        String string = this.myComment;
        if (string == null) {
            DdlMapping.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setComment(@NotNull String comment) {
        if (comment == null) {
            DdlMapping.$$$reportNull$$$0(4);
        }
        this.myComment = comment;
    }

    public DdlMapping copy(@Nullable String newName, boolean withId) {
        DdlMapping result2 = new DdlMapping(withId ? this.myUniqueId : "");
        result2.loadState(this.saveState(new Element("mapping")));
        result2.setName((String)ObjectUtils.chooseNotNull((Object)newName, (Object)this.myName));
        return result2;
    }

    @NotNull
    public Element saveState(@NotNull Element element) {
        if (element == null) {
            DdlMapping.$$$reportNull$$$0(5);
        }
        element.setAttribute("uuid", this.myUniqueId);
        if (!this.myName.isEmpty()) {
            element.setAttribute("name", this.myName);
        }
        if (!this.myComment.isEmpty()) {
            Element comment = new Element("comment");
            comment.setText(this.myComment);
            element.addContent(comment);
        }
        if (this.myDataSourceId != null || this.myDdlDataSourceId != null) {
            Element ds = new Element("data-sources");
            if (this.myDataSourceId != null) {
                ds.setAttribute("db", this.myDataSourceId);
            }
            if (this.myDdlDataSourceId != null) {
                ds.setAttribute("ddl", this.myDdlDataSourceId);
            }
            element.addContent(ds);
        }
        if (this.myScope != null) {
            Element scope2 = new Element("scope");
            TreePatternSerialization.serialize((HierarchicalStreamWriter)new JDomWriter(scope2), this.myScope, true);
            if (scope2.getContentSize() != 0) {
                element.addContent(scope2);
            }
        }
        Element element2 = element;
        if (element2 == null) {
            DdlMapping.$$$reportNull$$$0(6);
        }
        return element2;
    }

    public boolean equalConfiguration(@NotNull DdlMapping target2) {
        if (target2 == null) {
            DdlMapping.$$$reportNull$$$0(7);
        }
        return Objects.equals(this.myName, target2.myName) && Objects.equals(this.myComment, target2.myComment) && Objects.equals(this.myDataSourceId, target2.myDataSourceId) && Objects.equals(this.myDdlDataSourceId, target2.myDdlDataSourceId) && Objects.equals(this.myScope, target2.myScope);
    }

    @NotNull
    public static DdlMapping load(@NotNull Element element) {
        if (element == null) {
            DdlMapping.$$$reportNull$$$0(8);
        }
        DdlMapping mapping = new DdlMapping(element.getAttributeValue("uuid"));
        mapping.loadState(element);
        DdlMapping ddlMapping = mapping;
        if (ddlMapping == null) {
            DdlMapping.$$$reportNull$$$0(9);
        }
        return ddlMapping;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            DdlMapping.$$$reportNull$$$0(10);
        }
        this.myName = StringUtil.notNullize((String)element.getAttributeValue("name"));
        Element comment = element.getChild("comment");
        this.myComment = StringUtil.notNullize((String)(comment == null ? null : comment.getText()));
        Element ds = element.getChild("data-sources");
        this.myDataSourceId = ds == null ? null : StringUtil.nullize((String)ds.getAttributeValue("db"));
        this.myDdlDataSourceId = ds == null ? null : StringUtil.nullize((String)ds.getAttributeValue("ddl"));
        Element scope2 = element.getChild("scope");
        if (scope2 == null) {
            this.myScope = null;
        } else {
            InternedJDomReader reader = new InternedJDomReader(scope2);
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                this.myScope = TreePatternSerialization.deserialize((HierarchicalStreamReader)reader);
            } else {
                this.myScope = null;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 7, 8, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DdlMapping";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DdlMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 7, 8, 10 -> new IllegalArgumentException(string);
        };
    }
}

