/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DataSourceScheduler;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "dataSources", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/dataSource/DataSourceScheduler;", "validateDataSourceScheduler", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "validateActive", "remove", "createIfActive", "Companion", "DriverListener", "DataSourceListener", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseIntrospectionScheduleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseIntrospectionScheduleManager.kt\ncom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,274:1\n382#2,7:275\n*S KotlinDebug\n*F\n+ 1 DatabaseIntrospectionScheduleManager.kt\ncom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager\n*L\n77#1:275,7\n*E\n"})
public final class DatabaseIntrospectionScheduleManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Map<LocalDataSource, DataSourceScheduler> dataSources;

    public DatabaseIntrospectionScheduleManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.dataSources = new HashMap();
    }

    private final void validateDataSourceScheduler(Project project, LocalDataSource dataSource) {
        DataSourceScheduler dataSourceScheduler = this.validateActive(project, dataSource);
        if (dataSourceScheduler != null) {
            dataSourceScheduler.validate(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSourceScheduler validateActive(Project project, LocalDataSource dataSource) {
        DataSourceScheduler dataSourceScheduler;
        Map<LocalDataSource, DataSourceScheduler> map2 = this.dataSources;
        synchronized (map2) {
            boolean bl = false;
            dataSourceScheduler = this.dataSources.get(dataSource);
        }
        DataSourceScheduler dsScheduler = dataSourceScheduler;
        return dsScheduler == null ? this.createIfActive(dataSource, project) : (dsScheduler.isActive() ? dsScheduler : this.remove(dataSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSourceScheduler remove(LocalDataSource dataSource) {
        DataSourceScheduler dataSourceScheduler;
        Map<LocalDataSource, DataSourceScheduler> map2 = this.dataSources;
        synchronized (map2) {
            boolean bl = false;
            dataSourceScheduler = this.dataSources.remove(dataSource);
        }
        DataSourceScheduler dataSourceScheduler2 = dataSourceScheduler;
        if (dataSourceScheduler2 != null) {
            dataSourceScheduler2.cancel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final DataSourceScheduler createIfActive(LocalDataSource dataSource, Project project) {
        DataSourceScheduler dataSourceScheduler;
        Function0<DataSourceScheduler> function0 = DataSourceScheduler.Companion.factoryIfActive(this.cs, dataSource, project);
        if (function0 != null) {
            Function0<DataSourceScheduler> it = function0;
            boolean bl = false;
            Map<LocalDataSource, DataSourceScheduler> map2 = this.dataSources;
            synchronized (map2) {
                Object object;
                void $this$getOrPut$iv;
                boolean bl2 = false;
                Map<LocalDataSource, DataSourceScheduler> map3 = this.dataSources;
                LocalDataSource key$iv = dataSource;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    Object answer$iv = it.invoke();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                DataSourceScheduler dataSourceScheduler2 = (DataSourceScheduler)object;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl24 : MonitorExitStatement: MONITOREXIT : var5_5
                dataSourceScheduler = dataSourceScheduler2;
            }
        } else {
            dataSourceScheduler = null;
        }
        return dataSourceScheduler;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager;", "getInstance", "()Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager;", "validateDataSourceScheduler", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseIntrospectionScheduleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseIntrospectionScheduleManager.kt\ncom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,274:1\n30#2,2:275\n*S KotlinDebug\n*F\n+ 1 DatabaseIntrospectionScheduleManager.kt\ncom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$Companion\n*L\n42#1:275,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final DatabaseIntrospectionScheduleManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DatabaseIntrospectionScheduleManager> serviceClass$iv = DatabaseIntrospectionScheduleManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DatabaseIntrospectionScheduleManager)object;
        }

        public final void validateDataSourceScheduler(@Nullable Project project, @NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            this.getInstance().validateDataSourceScheduler(project, dataSource);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\f\rB\u0013\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dataSourceChanged", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "App", "Proj", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener$App;", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener$Proj;", "intellij.database.connectivity"})
    public static abstract class DataSourceListener
    implements DataSourceStorage.Listener {
        @Nullable
        private final Project project;

        private DataSourceListener(Project project) {
            this.project = project;
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
            if (dataSource != null) {
                Companion.validateDataSourceScheduler(this.project, dataSource);
            } else {
                for (LocalDataSource ds : DataSourceStorage.getStorage(this.project).getOwnDataSources()) {
                    Intrinsics.checkNotNull((Object)ds);
                    Companion.validateDataSourceScheduler(this.project, ds);
                }
            }
        }

        public /* synthetic */ DataSourceListener(Project project, DefaultConstructorMarker $constructor_marker) {
            this(project);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener$App;", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener;", "<init>", "()V", "intellij.database.connectivity"})
        public static final class App
        extends DataSourceListener {
            public App() {
                super(null, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener$Proj;", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "intellij.database.connectivity"})
        public static final class Proj
        extends DataSourceListener {
            public Proj(@Nullable Project project) {
                super(project, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DriverListener;", "Lcom/intellij/database/console/JdbcDriverManager$Listener;", "<init>", "()V", "onStarted", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "onTerminated", "intellij.database.connectivity"})
    public static final class DriverListener
    implements JdbcDriverManager.Listener {
        @Override
        public void onStarted(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Companion.validateDataSourceScheduler(configuration.getProject(), dataSource);
        }

        @Override
        public void onTerminated(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            ConsoleRunConfiguration consoleRunConfiguration = configuration;
            Companion.validateDataSourceScheduler((Project)(consoleRunConfiguration != null ? consoleRunConfiguration.getProject() : null), dataSource);
        }
    }
}

