/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.ui.DatabaseAuthPanel;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DatabaseCredentialsAuthProviderUi {
    private static Function<? super DatabaseAuthPanel, Boolean> ourCredentialsInterceptor = null;

    @TestOnly
    public static void setCredentialsInterceptor(Function<? super DatabaseAuthPanel, Boolean> di) {
        ourCredentialsInterceptor = di;
    }

    public static void askCredentials(@NlsContexts.DialogMessage @Nullable String message, boolean error, DatabaseConnectionConfig config, Project project, DatabaseCredentials dc) {
        boolean ok2;
        DatabaseAuthPanel auth = new DatabaseAuthPanel(project, config, dc);
        auth.reset(config, false);
        DatabaseAuthProvider.AuthWidget widget = auth.getAuthWidget();
        if (widget != null) {
            widget.forceSave();
        }
        if (ourCredentialsInterceptor == null) {
            auth.getComponent().setBorder((Border)JBUI.Borders.emptyTop((int)12));
            DialogBuilder builder = DatabaseCredentialsUi.prepareDialog(project, (error ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon(), auth.getComponent(), DatabaseBundle.message("dialog.title.connecting.to", config.getName()), StringUtil.notNullize((String)message));
            builder.setPreferredFocusComponent(auth.getPreferredFocusedComponent());
            ok2 = builder.show() == 0;
        } else {
            ok2 = (Boolean)ourCredentialsInterceptor.fun((Object)auth);
        }
        if (!ok2) {
            throw new ProcessCanceledException();
        }
        auth.save(config, true);
    }

    @NotNull
    public static String askChangePassword(Project project) {
        final FormBuilder form2 = FormBuilder.createFormBuilder();
        form2.addComponent((JComponent)new JBLabel(DatabaseBundle.message("password.expired.message", new Object[0])));
        form2.addVerticalGap(12);
        final JBPasswordField p1 = new JBPasswordField();
        p1.setColumns(15);
        form2.addLabeledComponent(DatabaseBundle.message("password.expired.new.password", new Object[0]), (JComponent)p1);
        final JBPasswordField p2 = new JBPasswordField();
        p2.setColumns(15);
        form2.addLabeledComponent(DatabaseBundle.message("password.expired.confirm.password", new Object[0]), (JComponent)p2);
        form2.addComponentFillVertically((JComponent)new JPanel(), 0);
        boolean res2 = new DialogWrapper(project){
            {
                super(arg0);
                this.setTitle(DatabaseBundle.message("password.expired.title", new Object[0]));
                this.init();
            }

            @Nullable
            protected JComponent createCenterPanel() {
                return form2.getPanel();
            }

            protected boolean postponeValidation() {
                return false;
            }

            @Nullable
            protected ValidationInfo doValidate() {
                return Arrays.equals(p1.getPassword(), p2.getPassword()) ? super.doValidate() : new ValidationInfo(DatabaseBundle.message("password.expired.do.not.match", new Object[0]), (JComponent)p2);
            }
        }.showAndGet();
        if (!res2) {
            throw new ProcessCanceledException();
        }
        return new String(p1.getPassword());
    }

    @Deprecated(forRemoval=true)
    public static class UserWidget
    implements DatabaseAuthProvider.AuthWidget {
        protected JBTextField myUserField;
        private JComponent myPanel;
        private final Supplier<@Nls String> myUserLabel;

        public UserWidget() {
            this(null);
        }

        public UserWidget(@Nullable Supplier<String> userLabel) {
            this.myUserLabel = userLabel;
        }

        protected JPanel createPanel() {
            JPanel panel2 = new JPanel((LayoutManager)new GridLayoutManager(1, 6));
            this.addUserField(panel2, 0);
            return panel2;
        }

        protected void addUserField(JComponent panel2, int row) {
            JBLabel userLabel = new JBLabel(this.myUserLabel != null ? this.myUserLabel.get() : DatabaseBundle.message("database.auth.user.label", new Object[0]));
            this.myUserField = new JBTextField();
            userLabel.setLabelFor((Component)this.myUserField);
            panel2.add((Component)userLabel, DatabaseUIUtils.createLabelConstraints(row, 0, userLabel.getPreferredSize().getWidth()));
            panel2.add((Component)this.myUserField, DatabaseUIUtils.createSimpleConstraints(row, 1, 3));
        }

        @Override
        public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
            if (config == null) {
                UserWidget.$$$reportNull$$$0(0);
            }
            LocalDataSource.setUsername(config, this.getUserName());
        }

        @Override
        public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            if (point == null) {
                UserWidget.$$$reportNull$$$0(1);
            }
            this.setUserName(LocalDataSource.getUsername(point));
        }

        @Nullable
        public String getUserName() {
            this.getComponent();
            return this.myUserField.getText();
        }

        @Override
        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                UserWidget.$$$reportNull$$$0(2);
            }
            this.getComponent();
            this.myUserField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserWidget$1", "textChanged"));
                }
            });
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            if (this.myPanel == null) {
                this.myPanel = this.createPanel();
            }
            JComponent jComponent = this.myPanel;
            if (jComponent == null) {
                UserWidget.$$$reportNull$$$0(3);
            }
            return jComponent;
        }

        @Override
        public void hidePassword() {
        }

        @Override
        public void reloadCredentials() {
        }

        public void setUserName(@Nullable String username) {
            this.getComponent();
            this.myUserField.setText(username);
        }

        @Override
        public boolean isPasswordChanged() {
            return false;
        }

        @Override
        @NotNull
        public JComponent getPreferredFocusedComponent() {
            JBTextField jBTextField = this.myUserField;
            if (jBTextField == null) {
                UserWidget.$$$reportNull$$$0(4);
            }
            return jBTextField;
        }

        @Override
        public void forceSave() {
        }

        @Override
        public void updateFromUrl(@NotNull ParametersHolder holder) {
            String userFromParser;
            if (holder == null) {
                UserWidget.$$$reportNull$$$0(5);
            }
            if (StringUtil.isNotEmpty((String)(userFromParser = holder.getParameter("user"))) && !Objects.equals(this.getUserName(), userFromParser)) {
                this.setUserName(userFromParser);
            }
        }

        @Override
        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                UserWidget.$$$reportNull$$$0(6);
            }
            model.setParameter("user", "");
            model.setParameter("password", "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserWidget";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredFocusedComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFromUrl";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateUrl";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

