/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.SqlUiService;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnectionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DatabaseIntrospectionSession;
import com.intellij.database.introspection.DbmsMismatchException;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncTaskKt;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ThrowableConsumer;
import java.lang.invoke.LambdaMetafactory;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 42\u00020\u0001:\u0006/01234B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\rH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007J(\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0007J4\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J4\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0086@\u00a2\u0006\u0002\u0010 J4\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0082@\u00a2\u0006\u0002\u0010#J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\n\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0007J&\u0010\u001f\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010%J \u0010&\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020'H\u0007J \u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020'H\u0086@\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\n\u001a\u00020\rH\u0007J\u0018\u0010+\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\n\u001a\u00020\rH\u0007J\u0018\u0010.\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager;", "", "<init>", "()V", "myQueue", "Lcom/intellij/database/dataSource/SyncQueue;", "isAbleToPerform", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "isActive", "Lcom/intellij/database/model/DasDataSource;", "getActiveTaskCount", "", "getActiveTaskInfo", "", "", "killTasks", "", "tryPerform", "Lcom/intellij/database/util/AsyncTask;", "Lcom/intellij/database/dataSource/SyncQueue$SyncResult;", "context", "Lcom/intellij/database/util/LoaderContext;", "stopRunning", "merge", "tryPerformAsync", "executor", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;", "tryPerformSync", "(Lcom/intellij/database/util/LoaderContext;ZZLcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "task", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask;", "(Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask;ZZLcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/intellij/sql/database/SqlDataSource;", "(Lcom/intellij/sql/database/SqlDataSource;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyMappingsAsync", "Lcom/intellij/database/dataSource/LocalDataSource;", "applyMappings", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "whenFinished", "awaitFinished", "(Lcom/intellij/database/model/DasDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopSynchronization", "stopSynchronizationAndAwait", "DatabaseExecutor", "SqlSyncTask", "SqlSyncProcessor", "DbSyncTask", "DbSyncProcessor", "Companion", "intellij.database.connectivity"})
public final class DataSourceSyncManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SyncQueue myQueue = new SyncQueue();
    @NotNull
    private static final DatabaseExecutor NEW_CONNECTION_EXECUTOR;
    @NotNull
    private static DatabaseExecutor ourDefaultExecutor;

    public final boolean isAbleToPerform(@NotNull Project project, @NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (!DataSourceSyncManager.Companion.isSyncAble(project, dataSource)) {
            return false;
        }
        return this.myQueue.isAbleToPerform(dataSource);
    }

    public final boolean isActive(@NotNull DasDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return this.myQueue.getActive(dataSource) != null;
    }

    @TestOnly
    public final int getActiveTaskCount(@NotNull DasDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return this.myQueue.getActiveTaskCount(dataSource);
    }

    @TestOnly
    @NotNull
    public final List<String> getActiveTaskInfo() {
        return this.myQueue.getActiveTaskInfo();
    }

    @TestOnly
    public final void killTasks() {
        this.myQueue.killTasks();
    }

    @Deprecated(message="Use coroutines", replaceWith=@ReplaceWith(expression="suspend tryPerform", imports={}))
    @Nullable
    public final AsyncTask<SyncQueue.SyncResult> tryPerform(@NotNull LoaderContext context, boolean stopRunning, boolean merge2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DataSourceSyncManager.tryPerformAsync$default(this, context, stopRunning, merge2, null, 8, null);
    }

    @Deprecated(message="Use coroutines", replaceWith=@ReplaceWith(expression="suspend tryPerform", imports={}))
    @JvmOverloads
    @Nullable
    public final AsyncTask<SyncQueue.SyncResult> tryPerformAsync(@NotNull LoaderContext context, boolean stopRunning, boolean merge2, @Nullable DatabaseExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DbSyncTask task = new DbSyncTask(context);
        Project project = task.context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DataSourceSyncManager.Companion.isSyncAble(project, task.getKey())) {
            return null;
        }
        AsyncTask.Frame frame = AsyncTask.Companion.currentFrame();
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getUnconfined();
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        return frame.asAsyncTask(coroutineDispatcher.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)new Function2<CoroutineScope, Continuation<? super SyncQueue.SyncResult>, Object>(this, task, stopRunning, merge2, executor, null){
            int label;
            final /* synthetic */ DataSourceSyncManager this$0;
            final /* synthetic */ DbSyncTask $task;
            final /* synthetic */ boolean $stopRunning;
            final /* synthetic */ boolean $merge;
            final /* synthetic */ DatabaseExecutor $executor;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                this.$stopRunning = $stopRunning;
                this.$merge = $merge;
                this.$executor = $executor;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DataSourceSyncManager.access$tryPerformSync(this.this$0, this.$task, this.$stopRunning, this.$merge, this.$executor, (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        Intrinsics.checkNotNull((Object)v0);
                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SyncQueue.SyncResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static /* synthetic */ AsyncTask tryPerformAsync$default(DataSourceSyncManager dataSourceSyncManager, LoaderContext loaderContext, boolean bl, boolean bl2, DatabaseExecutor databaseExecutor, int n, Object object) {
        if ((n & 8) != 0) {
            databaseExecutor = null;
        }
        return dataSourceSyncManager.tryPerformAsync(loaderContext, bl, bl2, databaseExecutor);
    }

    @Nullable
    public final Object tryPerformSync(@NotNull LoaderContext context, boolean stopRunning, boolean merge2, @Nullable DatabaseExecutor executor, @NotNull Continuation<? super SyncQueue.SyncResult> $completion) {
        return this.tryPerformSync(new DbSyncTask(context), stopRunning, merge2, executor, $completion);
    }

    public static /* synthetic */ Object tryPerformSync$default(DataSourceSyncManager dataSourceSyncManager, LoaderContext loaderContext, boolean bl, boolean bl2, DatabaseExecutor databaseExecutor, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            databaseExecutor = null;
        }
        return dataSourceSyncManager.tryPerformSync(loaderContext, bl, bl2, databaseExecutor, (Continuation<? super SyncQueue.SyncResult>)continuation);
    }

    private final Object tryPerformSync(DbSyncTask task, boolean stopRunning, boolean merge2, DatabaseExecutor executor, Continuation<? super SyncQueue.SyncResult> $completion) {
        Project project = task.context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DataSourceSyncManager.Companion.isSyncAble(project, task.getKey())) {
            return null;
        }
        return this.myQueue.tryPerform((SyncQueue.SyncTask)task, stopRunning, merge2, arg_0 -> DataSourceSyncManager.tryPerformSync$lambda$0(executor, arg_0), $completion);
    }

    static /* synthetic */ Object tryPerformSync$default(DataSourceSyncManager dataSourceSyncManager, DbSyncTask dbSyncTask, boolean bl, boolean bl2, DatabaseExecutor databaseExecutor, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            databaseExecutor = null;
        }
        return dataSourceSyncManager.tryPerformSync(dbSyncTask, bl, bl2, databaseExecutor, (Continuation<? super SyncQueue.SyncResult>)continuation);
    }

    @Deprecated(message="Use coroutines", replaceWith=@ReplaceWith(expression="suspend tryPerform", imports={}))
    @NotNull
    public final AsyncTask<SyncQueue.SyncResult> tryPerformAsync(@NotNull SqlDataSource dataSource, boolean stopRunning, boolean merge2) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        AsyncTask.Frame frame = AsyncTask.Companion.currentFrame();
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getUnconfined();
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        return frame.asAsyncTask(coroutineDispatcher.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)new Function2<CoroutineScope, Continuation<? super SyncQueue.SyncResult>, Object>(this, dataSource, stopRunning, merge2, null){
            int label;
            final /* synthetic */ DataSourceSyncManager this$0;
            final /* synthetic */ SqlDataSource $dataSource;
            final /* synthetic */ boolean $stopRunning;
            final /* synthetic */ boolean $merge;
            {
                this.this$0 = $receiver;
                this.$dataSource = $dataSource;
                this.$stopRunning = $stopRunning;
                this.$merge = $merge;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.tryPerformSync(this.$dataSource, this.$stopRunning, this.$merge, (Continuation<? super SyncQueue.SyncResult>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SyncQueue.SyncResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Nullable
    public final Object tryPerformSync(@NotNull SqlDataSource dataSource, boolean stopRunning, boolean merge2, @NotNull Continuation<? super SyncQueue.SyncResult> $completion) {
        return this.myQueue.tryPerform((SyncQueue.SyncTask)new SqlSyncTask(dataSource), stopRunning, merge2, DataSourceSyncManager::tryPerformSync$lambda$1, $completion);
    }

    @Deprecated(message="Use coroutines", replaceWith=@ReplaceWith(expression="suspend applyMappings", imports={}))
    @Nullable
    public final AsyncTask<SyncQueue.SyncResult> applyMappingsAsync(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (!DataSourceSyncManager.Companion.isSyncAble(project, dataSource)) {
            return null;
        }
        AsyncTask.Frame frame = AsyncTask.Companion.currentFrame();
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        return frame.asAsyncTask(ModalityKt.asContextElement((ModalityState)modalityState), (Function2)new Function2<CoroutineScope, Continuation<? super SyncQueue.SyncResult>, Object>(this, project, dataSource, null){
            int label;
            final /* synthetic */ DataSourceSyncManager this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ LocalDataSource $dataSource;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$dataSource = $dataSource;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.this$0.applyMappings(this.$project, this.$dataSource, (Continuation<? super SyncQueue.SyncResult>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        Intrinsics.checkNotNull((Object)v0);
                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SyncQueue.SyncResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Nullable
    public final Object applyMappings(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Continuation<? super SyncQueue.SyncResult> $completion) {
        if (!DataSourceSyncManager.Companion.isSyncAble(project, dataSource)) {
            return null;
        }
        LoaderContext ctx = LoaderContext.selectSkip(project, dataSource);
        Intrinsics.checkNotNull((Object)ctx);
        DbSyncTask syncTask = new DbSyncTask(ctx);
        return this.myQueue.tryPerform((SyncQueue.SyncTask)syncTask, false, true, DataSourceSyncManager::applyMappings$lambda$2, $completion);
    }

    @Deprecated(message="Use coroutines", replaceWith=@ReplaceWith(expression="suspend awaitFinished", imports={}))
    @NotNull
    public final AsyncTask<SyncQueue.SyncResult> whenFinished(@NotNull DasDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        AsyncTask.Frame frame = AsyncTask.Companion.currentFrame();
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        return frame.asAsyncTask(ModalityKt.asContextElement((ModalityState)modalityState), (Function2)new Function2<CoroutineScope, Continuation<? super SyncQueue.SyncResult>, Object>(this, dataSource, null){
            int label;
            final /* synthetic */ DataSourceSyncManager this$0;
            final /* synthetic */ DasDataSource $dataSource;
            {
                this.this$0 = $receiver;
                this.$dataSource = $dataSource;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.awaitFinished(this.$dataSource, (Continuation<? super SyncQueue.SyncResult>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SyncQueue.SyncResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Nullable
    public final Object awaitFinished(@NotNull DasDataSource dataSource, @NotNull Continuation<? super SyncQueue.SyncResult> $completion) {
        return this.myQueue.awaitFinished(dataSource, $completion);
    }

    @Deprecated(message="Use coroutines", replaceWith=@ReplaceWith(expression="suspend stopSynchronizationAndAwait", imports={}))
    @NotNull
    public final AsyncTask<SyncQueue.SyncResult> stopSynchronization(@NotNull DasDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        AsyncTask.Frame frame = AsyncTask.Companion.currentFrame();
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        return frame.asAsyncTask(ModalityKt.asContextElement((ModalityState)modalityState), (Function2)new Function2<CoroutineScope, Continuation<? super SyncQueue.SyncResult>, Object>(this, dataSource, null){
            int label;
            final /* synthetic */ DataSourceSyncManager this$0;
            final /* synthetic */ DasDataSource $dataSource;
            {
                this.this$0 = $receiver;
                this.$dataSource = $dataSource;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.stopSynchronizationAndAwait(this.$dataSource, (Continuation<? super SyncQueue.SyncResult>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SyncQueue.SyncResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Nullable
    public final Object stopSynchronizationAndAwait(@NotNull DasDataSource dataSource, @NotNull Continuation<? super SyncQueue.SyncResult> $completion) {
        return this.myQueue.stopSynchronization(dataSource, $completion);
    }

    @Deprecated(message="Use coroutines", replaceWith=@ReplaceWith(expression="suspend tryPerform", imports={}))
    @JvmOverloads
    @Nullable
    public final AsyncTask<SyncQueue.SyncResult> tryPerformAsync(@NotNull LoaderContext context, boolean stopRunning, boolean merge2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DataSourceSyncManager.tryPerformAsync$default(this, context, stopRunning, merge2, null, 8, null);
    }

    private static final SyncQueue.SyncProcessor tryPerformSync$lambda$0(DatabaseExecutor $executor, DbSyncTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DbSyncProcessor(it, $executor);
    }

    private static final SyncQueue.SyncProcessor tryPerformSync$lambda$1(SqlSyncTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SqlSyncProcessor(it);
    }

    private static final SyncQueue.SyncProcessor applyMappings$lambda$2(DbSyncTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return new DbSyncProcessor(task, null);
    }

    private static final void NEW_CONNECTION_EXECUTOR$lambda$3(DbSyncTask syncTask, ObjectPath path, boolean silent, ThrowableConsumer op) {
        Intrinsics.checkNotNullParameter((Object)syncTask, (String)"syncTask");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        DataSourceSyncManager.Companion.executeDatabaseOperation(syncTask, path, silent, (ThrowableConsumer<DatabaseConnection, Exception>)op);
    }

    @JvmStatic
    @NotNull
    public static final DataSourceSyncManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @TestOnly
    public static final void withDefaultExecutor(@NotNull Disposable disposableParent, @NotNull DatabaseExecutor e) {
        Companion.withDefaultExecutor(disposableParent, e);
    }

    public static final /* synthetic */ Object access$tryPerformSync(DataSourceSyncManager $this, DbSyncTask task, boolean stopRunning, boolean merge2, DatabaseExecutor executor, Continuation $completion) {
        return $this.tryPerformSync(task, stopRunning, merge2, executor, (Continuation<? super SyncQueue.SyncResult>)$completion);
    }

    static {
        ourDefaultExecutor = NEW_CONNECTION_EXECUTOR = DataSourceSyncManager::NEW_CONNECTION_EXECUTOR$lambda$3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007J:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager$Companion;", "", "<init>", "()V", "NEW_CONNECTION_EXECUTOR", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;", "ourDefaultExecutor", "getInstance", "Lcom/intellij/database/dataSource/DataSourceSyncManager;", "executeDatabaseOperation", "", "syncTask", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask;", "path", "Lcom/intellij/database/util/ObjectPath;", "silent", "", "op", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isSyncAble", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "withDefaultExecutor", "disposableParent", "Lcom/intellij/openapi/Disposable;", "e", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDataSourceSyncManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSyncManager.kt\ncom/intellij/database/dataSource/DataSourceSyncManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,360:1\n30#2,2:361\n*S KotlinDebug\n*F\n+ 1 DataSourceSyncManager.kt\ncom/intellij/database/dataSource/DataSourceSyncManager$Companion\n*L\n316#1:361,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataSourceSyncManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DataSourceSyncManager> serviceClass$iv = DataSourceSyncManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DataSourceSyncManager)object;
        }

        private final void executeDatabaseOperation(DbSyncTask syncTask, ObjectPath path, boolean silent, ThrowableConsumer<DatabaseConnection, Exception> op) {
            LoaderContext loaderContext = syncTask.context;
            Project project = loaderContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            LocalDataSource localDataSource = loaderContext.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource ds = localDataSource;
            SearchPath searchPath = SearchPath.of(path);
            DataSourceSessionTemplate dataSourceSessionTemplate = ds.getIntrospectorSessionTemplate();
            DatabaseConnectionConfig session = dataSourceSessionTemplate != null ? (DatabaseConnectionConfig)dataSourceSessionTemplate : (DatabaseConnectionConfig)ds;
            DatabaseSessionManager.Facade dbSessionManagerFacade = DatabaseSessionManager.getFacade(project2, session, loaderContext.getCredentialsStore(), searchPath, silent, loaderContext.getErrorHandler(), DGDepartment.INTROSPECTION);
            dbSessionManagerFacade.runSync(arg_0 -> Companion.executeDatabaseOperation$lambda$1(op, arg_0));
        }

        private final boolean isSyncAble(Project project, RawDataSource dataSource) {
            DataSourceManager<RawDataSource> manager = DataSourceManager.byDataSource(project, dataSource);
            return manager == null || !manager.isLoading(dataSource);
        }

        @JvmStatic
        @TestOnly
        public final void withDefaultExecutor(@NotNull Disposable disposableParent, @NotNull DatabaseExecutor e) {
            Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DatabaseExecutor prev2 = ourDefaultExecutor;
            Disposer.register((Disposable)disposableParent, () -> Companion.withDefaultExecutor$lambda$2(prev2));
            ourDefaultExecutor = e;
        }

        private static final Unit executeDatabaseOperation$lambda$1$lambda$0(ThrowableConsumer $op, InterruptibleDatabaseConnection $connection) {
            SessionsUtil.consumer($op).invoke((Object)$connection);
            return Unit.INSTANCE;
        }

        private static final Object executeDatabaseOperation$lambda$1(ThrowableConsumer $op, InterruptibleDatabaseConnection connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
            if (indicator == null) {
                throw new AssertionError((Object)"Indicator not found");
            }
            InterruptibleDatabaseConnectionKt.withCancelling(connection2, indicator, () -> Companion.executeDatabaseOperation$lambda$1$lambda$0($op, connection2));
            return null;
        }

        private static final void withDefaultExecutor$lambda$2(DatabaseExecutor $prev) {
            ourDefaultExecutor = $prev;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J:\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;", "", "perform", "", "task", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask;", "path", "Lcom/intellij/database/util/ObjectPath;", "silent", "", "op", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.database.connectivity"})
    public static interface DatabaseExecutor {
        public void perform(@NotNull DbSyncTask var1, @Nullable ObjectPath var2, boolean var3, @NotNull ThrowableConsumer<DatabaseConnection, Exception> var4);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\r\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J2\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u001c\u0010\u0016\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0017H\u0094@\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncProcessor;", "Lcom/intellij/database/dataSource/SyncQueue$SyncProcessor;", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask;", "task", "executor", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;", "<init>", "(Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask;Lcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;)V", "myDbExecutor", "run", "Lcom/intellij/database/dataSource/SyncQueue$SyncResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareAndRefresh", "saveDocumentsAndRefresh", "performSync", "performDatabaseOperations", "", "runSession", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runUnderNewReporter", "T", "action", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "SyncIntrospectionSession", "intellij.database.connectivity"})
    private static final class DbSyncProcessor
    extends SyncQueue.SyncProcessor<DbSyncTask> {
        @NotNull
        private final DatabaseExecutor myDbExecutor;

        public DbSyncProcessor(@NotNull DbSyncTask task, @Nullable DatabaseExecutor executor) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super((SyncQueue.SyncTask)task);
            DatabaseExecutor databaseExecutor = executor;
            if (databaseExecutor == null) {
                databaseExecutor = ourDefaultExecutor;
            }
            this.myDbExecutor = databaseExecutor;
        }

        @Override
        @Nullable
        public Object run(@NotNull Continuation<? super SyncQueue.SyncResult> $completion) {
            return this.prepareAndRefresh($completion);
        }

        private final Object prepareAndRefresh(Continuation<? super SyncQueue.SyncResult> $completion) {
            if (!((DbSyncTask)this.getMyTask()).context.getProject().isOpen()) {
                throw new CancellationException("project is closed");
            }
            return this.getMyProgress().run((Function1<Continuation<SyncQueue.SyncResult>, Object>)((Function1)new Function1<Continuation<? super SyncQueue.SyncResult>, Object>(this, null){
                int label;
                final /* synthetic */ DbSyncProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            String string = AnalysisBundle.message((String)"progress.title.refresh", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.label = 1;
                            Object object2 = AsyncTaskKt.traceableFrame(string, (Function1)new Function1<Continuation<? super SyncQueue.SyncResult>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ DbSyncProcessor this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = DbSyncProcessor.access$saveDocumentsAndRefresh(this.this$0, (Continuation)this);
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Continuation<? super SyncQueue.SyncResult> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super SyncQueue.SyncResult> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        /*
         * Unable to fully structure code
         */
        private final Object saveDocumentsAndRefresh(Continuation<? super SyncQueue.SyncResult> $completion) {
            if (!($completion instanceof saveDocumentsAndRefresh.1)) ** GOTO lbl-1000
            var3_2 = $completion;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ DbSyncProcessor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return DbSyncProcessor.access$saveDocumentsAndRefresh(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, saveDocumentsAndRefresh$lambda$0(), ()Lkotlin/Unit;)(), (Continuation)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    $continuation.label = 2;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SyncQueue.SyncResult>, Object>(this, null){
                        int label;
                        final /* synthetic */ DbSyncProcessor this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = AsyncTask.Companion.computeSuspend(() -> saveDocumentsAndRefresh.3.invokeSuspend$lambda$0(this.this$0), (Continuation)this);
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super SyncQueue.SyncResult> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final SyncQueue.SyncResult invokeSuspend$lambda$0(DbSyncProcessor this$0) {
                            return DbSyncProcessor.access$performSync(this$0);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl28
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl28:
                    // 2 sources

                    return v1;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final SyncQueue.SyncResult performSync() {
            if (!((DbSyncTask)this.getMyTask()).context.isEmpty()) {
                this.performDatabaseOperations();
            }
            DataSourceSnapshotManager dataSourceSnapshotManager = DataSourceSnapshotManager.Companion.getInstance();
            Project project = ((DbSyncTask)this.getMyTask()).context.getProject();
            LocalDataSource localDataSource = ((DbSyncTask)this.getMyTask()).context.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            dataSourceSnapshotManager.apply(project, localDataSource);
            return new SyncQueue.SyncResult((SyncQueue.SyncTask)this.getMyTask(), System.currentTimeMillis() - this.getMyStartTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void performDatabaseOperations() {
            block10: {
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                if (indicator == null) {
                    indicator = (ProgressIndicator)new EmptyProgressIndicator();
                }
                LoaderContext loaderContext = ((DbSyncTask)this.getMyTask()).context;
                LocalDataSource localDataSource = loaderContext.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                LocalDataSource dataSource = localDataSource;
                int[] nArray = new int[]{0};
                if (dataSource.getInfo().getExactVersion().isOrLess(nArray) && loaderContext.countTasks() > 0) {
                    this.myDbExecutor.perform((DbSyncTask)this.getMyTask(), null, true, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)DbSyncProcessor::performDatabaseOperations$lambda$1));
                }
                try {
                    try {
                        this.runSession(indicator);
                    }
                    catch (DbmsMismatchException dme) {
                        Dbms updatedDbms = ((DbSyncTask)this.getMyTask()).context.getDbms();
                        if (Intrinsics.areEqual((Object)dme.connectionDbms, (Object)updatedDbms)) {
                            this.runSession(indicator);
                            break block10;
                        }
                        throw dme;
                    }
                }
                catch (SQLException e) {
                    AsyncUtil.addUnhandledError(loaderContext.getErrorHandler(), e, dataSource);
                    throw new ProcessCanceledException();
                }
                finally {
                    DbSrcUtils.refresh();
                }
            }
        }

        private final void runSession(ProgressIndicator indicator) throws SQLException {
            LoaderContext loaderContext = ((DbSyncTask)this.getMyTask()).context;
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
            SyncIntrospectionSession session = new SyncIntrospectionSession(this.myDbExecutor, loaderContext, modalityState, indicator);
            session.run();
        }

        @Override
        @Nullable
        protected <T> Object runUnderNewReporter(@NotNull Function1<? super Continuation<? super T>, ? extends Object> action, @NotNull Continuation<? super T> $completion) {
            LoaderContext loaderContext = ((DbSyncTask)this.getMyTask()).context;
            if (loaderContext.isEmpty()) {
                return action.invoke($completion);
            }
            SqlUiService sqlUiService = SqlUiService.Companion.getInstance();
            Project project = loaderContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{loaderContext.getDataSource().getName()};
            String string = DatabaseBundle.message("action.DatabaseView.RefreshAction.progress", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return sqlUiService.withBackgroundProgress(project, string, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(action, null){
                int label;
                final /* synthetic */ Function1<Continuation<? super T>, Object> $action;
                {
                    this.$action = $action;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$action.invoke((Object)((Object)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
        }

        private static final Unit saveDocumentsAndRefresh$lambda$0() {
            FileDocumentManager.getInstance().saveAllDocuments();
            return Unit.INSTANCE;
        }

        private static final void performDatabaseOperations$lambda$1(DatabaseConnection connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            connection2.getVersion();
        }

        public static final /* synthetic */ Object access$prepareAndRefresh(DbSyncProcessor $this, Continuation $completion) {
            return $this.prepareAndRefresh((Continuation<? super SyncQueue.SyncResult>)$completion);
        }

        public static final /* synthetic */ Object access$saveDocumentsAndRefresh(DbSyncProcessor $this, Continuation $completion) {
            return $this.saveDocumentsAndRefresh((Continuation<? super SyncQueue.SyncResult>)$completion);
        }

        public static final /* synthetic */ SyncQueue.SyncResult access$performSync(DbSyncProcessor $this) {
            return $this.performSync();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ2\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncProcessor$SyncIntrospectionSession;", "Lcom/intellij/database/introspection/DatabaseIntrospectionSession;", "myExecutor", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;", "context", "Lcom/intellij/database/util/LoaderContext;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncProcessor;Lcom/intellij/database/dataSource/DataSourceSyncManager$DatabaseExecutor;Lcom/intellij/database/util/LoaderContext;Lcom/intellij/openapi/application/ModalityState;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "performDbSpecificOperation", "", "dbPath", "Lcom/intellij/database/util/ObjectPath;", "silent", "", "operation", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.database.connectivity"})
        private final class SyncIntrospectionSession
        extends DatabaseIntrospectionSession {
            @NotNull
            private final DatabaseExecutor myExecutor;

            public SyncIntrospectionSession(@NotNull DatabaseExecutor myExecutor, @NotNull LoaderContext context, @NotNull ModalityState modality, ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)myExecutor, (String)"myExecutor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)modality, (String)"modality");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                super(context, indicator, modality);
                this.myExecutor = myExecutor;
            }

            @Override
            protected void performDbSpecificOperation(@Nullable ObjectPath dbPath, boolean silent, @NotNull ThrowableConsumer<DatabaseConnection, Exception> operation) {
                Intrinsics.checkNotNullParameter(operation, (String)"operation");
                this.myExecutor.perform((DbSyncTask)DbSyncProcessor.this.getMyTask(), dbPath, silent, operation);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask;", "Lcom/intellij/database/dataSource/SyncQueue$SyncTask;", "context", "Lcom/intellij/database/util/LoaderContext;", "<init>", "(Lcom/intellij/database/util/LoaderContext;)V", "getKey", "Lcom/intellij/database/model/RawDataSource;", "merge", "task2", "toString", "", "Companion", "intellij.database.connectivity"})
    public static final class DbSyncTask
    extends SyncQueue.SyncTask {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final LoaderContext context;

        public DbSyncTask(@NotNull LoaderContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @Override
        @NotNull
        public RawDataSource getKey() {
            LocalDataSource localDataSource = this.context.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            return localDataSource;
        }

        @Override
        @NotNull
        public SyncQueue.SyncTask merge(@NotNull SyncQueue.SyncTask task2) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task2");
            return task2 instanceof DbSyncTask ? (SyncQueue.SyncTask)Companion.merge(this, (DbSyncTask)task2) : (SyncQueue.SyncTask)this;
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + " " + this.context;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask$Companion;", "", "<init>", "()V", "merge", "Lcom/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask;", "task1", "task2", "intellij.database.connectivity"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DbSyncTask merge(@NotNull DbSyncTask task1, @NotNull DbSyncTask task2) {
                Intrinsics.checkNotNullParameter((Object)task1, (String)"task1");
                Intrinsics.checkNotNullParameter((Object)task2, (String)"task2");
                LoaderContext loaderContext = task1.context.merge(task2.context);
                Intrinsics.checkNotNullExpressionValue((Object)loaderContext, (String)"merge(...)");
                LoaderContext context = loaderContext;
                context.setErrorHandler(task1.context.getErrorHandler());
                return new DbSyncTask(context);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\u0007H\u0082@\u00a2\u0006\u0002\u0010\bJ2\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u001c\u0010\f\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0094@\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager$SqlSyncProcessor;", "Lcom/intellij/database/dataSource/SyncQueue$SyncProcessor;", "Lcom/intellij/database/dataSource/DataSourceSyncManager$SqlSyncTask;", "task", "<init>", "(Lcom/intellij/database/dataSource/DataSourceSyncManager$SqlSyncTask;)V", "run", "Lcom/intellij/database/dataSource/SyncQueue$SyncResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performSync", "runUnderNewReporter", "T", "action", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.connectivity"})
    private static final class SqlSyncProcessor
    extends SyncQueue.SyncProcessor<SqlSyncTask> {
        public SqlSyncProcessor(@NotNull SqlSyncTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super((SyncQueue.SyncTask)task);
        }

        @Override
        @Nullable
        public Object run(@NotNull Continuation<? super SyncQueue.SyncResult> $completion) {
            return this.performSync($completion);
        }

        private final Object performSync(Continuation<? super SyncQueue.SyncResult> $completion) {
            return this.getMyProgress().run((Function1<Continuation<SyncQueue.SyncResult>, Object>)((Function1)new Function1<Continuation<? super SyncQueue.SyncResult>, Object>(this, null){
                int label;
                final /* synthetic */ SqlSyncProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object[] objectArray = new Object[]{((SqlSyncTask)this.this$0.getMyTask()).getMyDataSource().getName()};
                            String string = DatabaseBundle.message("action.DatabaseView.RefreshAction.progress", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.label = 1;
                            Object object2 = AsyncTaskKt.traceableFrame(string, (Function1)new Function1<Continuation<? super SyncQueue.SyncResult>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ SqlSyncProcessor this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = AsyncTask.Companion.computeSuspend(() -> performSync.1.invokeSuspend$lambda$0(this.this$0), (Continuation)this);
                                            if (object2 != object) return new SyncQueue.SyncResult((SyncQueue.SyncTask)this.this$0.getMyTask(), System.currentTimeMillis() - this.this$0.getMyStartTime());
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return new SyncQueue.SyncResult((SyncQueue.SyncTask)this.this$0.getMyTask(), System.currentTimeMillis() - this.this$0.getMyStartTime());
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Continuation<? super SyncQueue.SyncResult> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final Unit invokeSuspend$lambda$0(SqlSyncProcessor this$0) {
                                    ((SqlSyncTask)this$0.getMyTask()).getMyDataSource().sync();
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super SyncQueue.SyncResult> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Override
        @Nullable
        protected <T> Object runUnderNewReporter(@NotNull Function1<? super Continuation<? super T>, ? extends Object> action, @NotNull Continuation<? super T> $completion) {
            SqlUiService sqlUiService = SqlUiService.Companion.getInstance();
            Project project = ((SqlSyncTask)this.getMyTask()).getMyDataSource().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{((SqlSyncTask)this.getMyTask()).getMyDataSource().getName()};
            String string = DatabaseBundle.message("action.DatabaseView.RefreshAction.progress", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return sqlUiService.withBackgroundProgress(project, string, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(action, null){
                int label;
                final /* synthetic */ Function1<Continuation<? super T>, Object> $action;
                {
                    this.$action = $action;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$action.invoke((Object)((Object)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
        }

        public static final /* synthetic */ Object access$performSync(SqlSyncProcessor $this, Continuation $completion) {
            return $this.performSync((Continuation<? super SyncQueue.SyncResult>)$completion);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/DataSourceSyncManager$SqlSyncTask;", "Lcom/intellij/database/dataSource/SyncQueue$SyncTask;", "myDataSource", "Lcom/intellij/sql/database/SqlDataSource;", "<init>", "(Lcom/intellij/sql/database/SqlDataSource;)V", "getMyDataSource", "()Lcom/intellij/sql/database/SqlDataSource;", "getKey", "Lcom/intellij/database/model/DasDataSource;", "merge", "task2", "intellij.database.connectivity"})
    public static final class SqlSyncTask
    extends SyncQueue.SyncTask {
        @NotNull
        private final SqlDataSource myDataSource;

        public SqlSyncTask(@NotNull SqlDataSource myDataSource) {
            Intrinsics.checkNotNullParameter((Object)myDataSource, (String)"myDataSource");
            this.myDataSource = myDataSource;
        }

        @NotNull
        public final SqlDataSource getMyDataSource() {
            return this.myDataSource;
        }

        @Override
        @NotNull
        public DasDataSource getKey() {
            return this.myDataSource;
        }

        @Override
        @NotNull
        public SyncQueue.SyncTask merge(@NotNull SyncQueue.SyncTask task2) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task2");
            return this;
        }
    }
}

