/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.concurrency.ThreadContext;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceModelStorage;
import com.intellij.database.dataSource.DataSourceModelStorageImpl;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LoadingState;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.TreePattern;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.PreemptiveSafeFileOutputStream;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.xmlpull.v1.XmlPullParser;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0010\b6\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0003;<=B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0016\u0010\u001f\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0016J(\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%H\u0002J$\u0010&\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%H\u0002J\u0016\u0010'\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0002J,\u0010(\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%2\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u0010+\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0002J2\u0010\u001f\u001a\u00020,2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0006\u0010)\u001a\u00020*2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020/0.H\u0002J \u00100\u001a\u00020\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0002J\u000e\u00102\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u000bJ\u001c\u00103\u001a\u0010\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020,\u0018\u0001042\u0006\u0010\u001e\u001a\u00020\u000bJ\u0012\u00105\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0014\u00106\u001a\u0004\u0018\u0001072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\f\u001aJ\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010 \u000f*#\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\u0012\u00a2\u0006\u0002\b\u00110\r\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u0082\u0001\u0002>?\u00a8\u0006@"}, d2={"Lcom/intellij/database/dataSource/DataSourceModelStorageImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/database/dataSource/DataSourceModelStorage;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/components/ComponentManager;Lkotlinx/coroutines/CoroutineScope;)V", "myLoadingState", "Lcom/intellij/database/dataSource/LoadingState$Holder;", "Lcom/intellij/database/dataSource/LocalDataSource;", "myLocks", "", "", "kotlin.jvm.PlatformType", "com/intellij/database/dataSource/DataSourceModelStorageImpl$myLocks$1$1", "Lorg/jetbrains/annotations/NotNull;", "", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLoadedPromise", "Lorg/jetbrains/concurrency/Promise;", "dispose", "", "getLoadingPromise", "dataSource", "loadModels", "dataSources", "", "continueLoadingWhenInitialized", "Lcom/intellij/database/util/AsyncTask;", "currentState", "Lcom/intellij/database/dataSource/LoadingState;", "readStateHeavy", "validateDataSources", "finishModelLoading", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "applyMappings", "", "consumer", "Lcom/intellij/util/PairConsumer;", "Lcom/intellij/database/model/DasModel;", "cleanupOldFiles", "newDataSources", "writeModel", "readModel", "Lkotlin/Pair;", "getModelPath", "createSavingListener", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "lock", "", "ds", "App", "Prj", "Companion", "Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$App;", "Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$Prj;", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDataSourceModelStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceModelStorageImpl.kt\ncom/intellij/database/dataSource/DataSourceModelStorageImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,614:1\n1#2:615\n37#3:616\n36#3,3:617\n1761#4,3:620\n14#5:623\n*S KotlinDebug\n*F\n+ 1 DataSourceModelStorageImpl.kt\ncom/intellij/database/dataSource/DataSourceModelStorageImpl\n*L\n246#1:616\n246#1:617,3\n319#1:620,3\n488#1:623\n*E\n"})
public abstract class DataSourceModelStorageImpl
implements Disposable,
DataSourceModelStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final LoadingState.Holder<LocalDataSource> myLoadingState;
    @NotNull
    private final Map<String, myLocks.1.1> myLocks;
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private static final Logger LOG;

    private DataSourceModelStorageImpl(ComponentManager componentManager, CoroutineScope coroutineScope) {
        this.coroutineScope = coroutineScope;
        this.myLoadingState = new LoadingState.Holder();
        Map map2 = FactoryMap.create(arg_0 -> DataSourceModelStorageImpl.myLocks$lambda$1(DataSourceModelStorageImpl::myLocks$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"create(...)");
        this.myLocks = map2;
        MessageBus messageBus = componentManager.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        this.messageBus = messageBus;
        Project project = componentManager instanceof Project ? (Project)componentManager : null;
        DataSourceStorage.Listener listener2 = this.createSavingListener(project);
        if (listener2 != null) {
            MessageBusConnection messageBusConnection = this.messageBus.connect((Disposable)this);
            Topic<DataSourceStorage.Listener> topic = DataSourceStorage.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)listener2);
        }
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    @Override
    @NotNull
    public Promise<?> getLoadedPromise() {
        Promise promise = this.myLoadingState.get();
        if (promise == null || (promise = promise.getLoadingPromise()) == null) {
            promise = Promises.resolvedPromise();
        }
        return promise;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Promise<?> getLoadingPromise(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Promise<?> promise = this.myLoadingState.get();
        if (promise == null || (promise = promise.getLoadingPromise((RawDataSource)dataSource)) == null) {
            promise = Promises.resolvedPromise();
        }
        return promise;
    }

    public void loadModels(@NotNull List<? extends LocalDataSource> dataSources) {
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        String string = DatabaseBundle.message("progress.title.loading.models", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myLoadingState.run(AsyncTask.Companion.frame(string), (Function)new Function(dataSources, this){
            final /* synthetic */ List<LocalDataSource> $dataSources;
            final /* synthetic */ DataSourceModelStorageImpl this$0;
            {
                this.$dataSources = $dataSources;
                this.this$0 = $receiver;
            }

            public final AsyncTask<?> fun(LoadingState<LocalDataSource> currentState) {
                for (LocalDataSource dataSource : this.$dataSources) {
                    currentState.markLoading((LocalDataSource)((RawDataSource)dataSource));
                    dataSource.resolveDriver();
                    if (dataSource.getDatabaseDriver() != null && dataSource.getOwnClasspath().isEmpty()) continue;
                    dataSource.ensureDriverConfigured();
                }
                List<LocalDataSource> list = Collections.unmodifiableList(this.$dataSources);
                Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
                Intrinsics.checkNotNull(currentState);
                return DataSourceModelStorageImpl.access$continueLoadingWhenInitialized(this.this$0, list, currentState);
            }
        });
    }

    private final AsyncTask<?> continueLoadingWhenInitialized(List<? extends LocalDataSource> dataSources, LoadingState<LocalDataSource> currentState) {
        Project project = this.getProject();
        Project project2 = project;
        if (project2 == null) {
            project2 = DbImplUtilCore.getAnyProject();
        }
        Project anyProject = project2;
        return AsyncTask.Companion.currentFrame().computeAsync(anyProject == null ? AsyncUtil.getEdtExecutor() : AsyncTask.Companion.captureContext(arg_0 -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$2(anyProject, arg_0)), () -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$8(anyProject, this, dataSources, currentState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readStateHeavy(List<? extends LocalDataSource> dataSources, LoadingState<LocalDataSource> currentState) {
        Project project;
        Application application = ApplicationManager.getApplication();
        Project project2 = project = this.getProject();
        ComponentManager disposable = project2 != null ? (ComponentManager)project2 : (ComponentManager)application;
        ErrorHandler errorHandler = new ErrorHandler();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<DataSourceModelStorage.Listener> topic = DataSourceModelStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        DataSourceModelStorage.Listener publisher = (DataSourceModelStorage.Listener)messageBus.syncPublisher(topic);
        try {
            ProgressManager.checkCanceled();
            publisher.started(project);
            this.loadModels(dataSources, errorHandler, (PairConsumer<LocalDataSource, DasModel>)((PairConsumer)(arg_0, arg_1) -> DataSourceModelStorageImpl.readStateHeavy$lambda$9(currentState, arg_0, arg_1)));
        }
        catch (Throwable th) {
            if (AsyncUtil.isCancellation(th)) {
                throw new ProcessCanceledException(th);
            }
            errorHandler.addError(null, th);
        }
        finally {
            publisher.finished(project);
        }
        this.validateDataSources(dataSources);
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)((Disposable)disposable), () -> DataSourceModelStorageImpl.readStateHeavy$lambda$10(this, dataSources, currentState, errorHandler));
    }

    private final void validateDataSources(List<? extends LocalDataSource> dataSources) {
        if (DbSrcValidator.isEnabled()) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, dataSources, null){
                int label;
                final /* synthetic */ DataSourceModelStorageImpl this$0;
                final /* synthetic */ List<LocalDataSource> $dataSources;
                {
                    this.this$0 = $receiver;
                    this.$dataSources = $dataSources;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Project p2;
                            ResultKt.throwOnFailure((Object)$result);
                            Project project = this.this$0.getProject();
                            Project project2 = project;
                            if (project2 == null) {
                                project2 = p2 = DbImplUtilCore.getAnyProject();
                            }
                            if (project != null) {
                                Project project3 = p2;
                                Intrinsics.checkNotNull((Object)project3);
                                com.intellij.database.dataSource.DataSourceModelStorageImpl$Companion.access$validateModels(DataSourceModelStorageImpl.Companion, project3, this.$dataSources);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void finishModelLoading(List<? extends LocalDataSource> dataSources, LoadingState<LocalDataSource> currentState, ErrorHandler errorHandler) {
        List unsuccessful = new ArrayList();
        for (LocalDataSource localDataSource : dataSources) {
            if (!currentState.isLoading((LocalDataSource)((RawDataSource)localDataSource))) continue;
            localDataSource.setModel(DasUtil.emptyModel());
            currentState.markLoaded((LocalDataSource)((RawDataSource)localDataSource));
            unsuccessful.add(localDataSource);
        }
        AppExecutorUtil.getAppExecutorService().execute(() -> DataSourceModelStorageImpl.finishModelLoading$lambda$11(this, dataSources));
        ApplicationManager.getApplication().invokeLater(() -> DataSourceModelStorageImpl.finishModelLoading$lambda$12(this, errorHandler, unsuccessful));
    }

    private final void applyMappings(List<? extends LocalDataSource> dataSources) {
        if (this.messageBus.isDisposed()) {
            return;
        }
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)((Disposable)this.messageBus), () -> DataSourceModelStorageImpl.applyMappings$lambda$18(this, dataSources));
    }

    private final boolean loadModels(List<? extends LocalDataSource> dataSources, ErrorHandler errorHandler, PairConsumer<LocalDataSource, DasModel> consumer) {
        ProgressManager.checkCanceled();
        List newDataSources = new ArrayList(dataSources);
        boolean hasNoModelDs = false;
        boolean failed = false;
        for (LocalDataSource source : newDataSources) {
            try {
                Pair pair = this.readModel(source);
                if (pair == null) {
                    pair = new Pair(null, (Object)false);
                }
                Pair pair2 = pair;
                DasModel model = (DasModel)pair2.component1();
                boolean modelMigrated = (Boolean)pair2.component2();
                if (model != null) {
                    consumer.consume((Object)source, (Object)model);
                    if (!modelMigrated) continue;
                    failed |= !this.writeModel(source);
                    continue;
                }
                consumer.consume((Object)source, (Object)DasUtil.emptyModel());
                hasNoModelDs = true;
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            catch (Exception e) {
                failed = true;
                String file = this.getModelPath(source);
                if (file != null) {
                    DataSourceStorage.processCorruption(this.getProject(), Paths.get(file, new String[0]), e);
                }
                errorHandler.addError(e.getMessage(), (Throwable)e);
            }
        }
        if (hasNoModelDs) {
            JBIterable jBIterable = JBIterable.from((Iterable)newDataSources).filter(arg_0 -> DataSourceModelStorageImpl.loadModels$lambda$20(DataSourceModelStorageImpl::loadModels$lambda$19, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable empty = jBIterable;
            LOG.info("No model loaded for: " + StringUtil.join((Iterable)((Iterable)empty), arg_0 -> DataSourceModelStorageImpl.loadModels$lambda$22(DataSourceModelStorageImpl::loadModels$lambda$21, arg_0), (String)", "));
        }
        if (failed) {
            return false;
        }
        Project project = this.getProject();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.nonModal();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, (List<? extends LocalDataSource>)newDataSources, null){
            int label;
            final /* synthetic */ DataSourceModelStorageImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List<LocalDataSource> $newDataSources;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$newDataSources = $newDataSources;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DataSourceModelStorageImpl.access$cleanupOldFiles(this.this$0, this.$project, this.$newDataSources);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DbSrcValidator.checkOutdatedFiles(this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanupOldFiles(Project project, List<? extends LocalDataSource> newDataSources) {
        block10: {
            Path path;
            String dir;
            String string = dir = DataSourceStorage.getStorageDir(project);
            if (string != null) {
                String it = string;
                boolean bl = false;
                path = Paths.get(FileUtil.toSystemDependentName((String)it), new String[0]);
            } else {
                path = null;
            }
            Path root = path;
            Set toKeep = new HashSet();
            Set uids = new HashSet();
            for (LocalDataSource localDataSource : newDataSources) {
                String string2 = localDataSource.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUniqueId(...)");
                uids.add(string2);
                if (localDataSource.getModel() == DasUtil.emptyModel()) continue;
                String path2 = this.getModelPath(localDataSource);
                String string3 = path2;
                ContainerUtil.addIfNotNull((Collection)toKeep, string3 == null ? null : Paths.get(FileUtil.toSystemDependentName((String)string3), new String[0]));
            }
            Pattern filePattern = Pattern.compile("\\p{XDigit}{8}(?:-\\p{XDigit}{4}){3}-\\p{XDigit}{12}(?:\\.xml)?");
            Function1 function1 = arg_0 -> DataSourceModelStorageImpl.cleanupOldFiles$lambda$25(toKeep, uids, arg_0);
            try {
                Path path2;
                Object object = root;
                if (object == null) break block10;
                Path it = path2 = object;
                boolean bl = false;
                object = Files.isDirectory(root, new LinkOption[0]) ? path2 : null;
                if (object == null) break block10;
                Path it2 = object;
                boolean bl2 = false;
                Stream<Path> stream = Files.list(root);
                object = stream;
                if (stream == null) break block10;
                AutoCloseable autoCloseable = (AutoCloseable)object;
                Throwable throwable = null;
                try {
                    Stream files2 = (Stream)autoCloseable;
                    boolean bl3 = false;
                    files2.forEach(arg_0 -> DataSourceModelStorageImpl.cleanupOldFiles$lambda$30$lambda$29(arg_0 -> DataSourceModelStorageImpl.cleanupOldFiles$lambda$30$lambda$28(filePattern, function1, arg_0), arg_0));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeModel(@NotNull LocalDataSource dataSource) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Project project = this.getProject();
        ProgressManager.checkCanceled();
        if (project != null && project.isDefault()) {
            return false;
        }
        String string = this.getModelPath(dataSource);
        if (string == null) {
            return false;
        }
        String path = string;
        if (DataSourceModelStorageImpl.Companion.isReadonly(project, path)) {
            LOG.warn("Unable to save model. File is readonly: " + path);
            return false;
        }
        if (project != null && project.isDisposed()) {
            return false;
        }
        File file = new File(path);
        FileUtil.createParentDirs((File)file);
        DasModel dasModel = dataSource.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
        DasModel model = dasModel;
        if (model.getModelRoots().isEmpty()) {
            FileUtil.delete((File)file);
            return false;
        }
        Object object = this.lock(dataSource);
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = DataSourceModelStorageImpl.Companion.writeModel(file, dataSource);
            return bl2;
        }
    }

    @Nullable
    public final Pair<DasModel, Boolean> readModel(@NotNull LocalDataSource dataSource) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        ProgressManager.checkCanceled();
        Project project = this.getProject();
        if (project != null && project.isDefault()) {
            return null;
        }
        String path = this.getModelPath(dataSource);
        File file2 = file = path == null ? null : new File(path);
        if (file == null || !file.exists()) {
            return null;
        }
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<DataSourceModelStorage.Listener> topic = DataSourceModelStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        DataSourceModelStorage.Listener publisher = (DataSourceModelStorage.Listener)messageBus.syncPublisher(topic);
        publisher.started(project, dataSource);
        try {
            Pair pair;
            ModelFactory modelFactory = DbSrcModelStorageService.getInstance().createFactory(project, dataSource);
            Intrinsics.checkNotNullExpressionValue((Object)modelFactory, (String)"createFactory(...)");
            ModelFactory factory = modelFactory;
            Pair pair2 = Companion.readModel(factory, file, dataSource.getName());
            if (pair2 == null) {
                pair2 = new Pair(null, null);
            }
            Pair pair3 = pair2;
            DasModel model = (DasModel)pair3.component1();
            ModelImporter importer = (ModelImporter)pair3.component2();
            if (model != null && importer != null) {
                publisher.finished(project, dataSource, model, importer);
            } else {
                publisher.failed(project, dataSource, null);
            }
            DasModel dasModel = model;
            if (dasModel != null) {
                DasModel it = dasModel;
                boolean bl = false;
                ModelImporter modelImporter = importer;
                pair = new Pair((Object)it, (Object)(modelImporter != null ? modelImporter.wasMigrated : false));
            } else {
                pair = null;
            }
            return pair;
        }
        catch (Throwable th) {
            publisher.failed(project, dataSource, th);
            throw th;
        }
    }

    private final String getModelPath(LocalDataSource dataSource) {
        String dir;
        String string = dir = DataSourceStorage.getStorageDir(this.getProject());
        return string == null ? null : string + "/" + dataSource.getUniqueId() + ".xml";
    }

    private final DataSourceStorage.Listener createSavingListener(Project project) {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            return null;
        }
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"com/intellij/database/dataSource/DataSourceModelStorageImpl$createSavingListener$SavingListener", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "<init>", "(Lcom/intellij/database/dataSource/DataSourceModelStorageImpl;Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/project/Project;)V", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dataSourceRemoved", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "remove", "dataSourceChanged", "dataSourceAdded", "saveDataSource", "isMy", "", "save", "intellij.database.connectivity"})
        @SourceDebugExtension(value={"SMAP\nDataSourceModelStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceModelStorageImpl.kt\ncom/intellij/database/dataSource/DataSourceModelStorageImpl$createSavingListener$SavingListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,614:1\n1#2:615\n*E\n"})
        public final class SavingListener
        implements DataSourceStorage.Listener {
            private final MergingUpdateQueue queue;
            final /* synthetic */ DataSourceModelStorageImpl this$0;
            final /* synthetic */ Project $project;

            public SavingListener(DataSourceModelStorageImpl $receiver, Application $app, Project $project) {
                this.this$0 = $receiver;
                this.$project = $project;
                this.queue = MergingUpdateQueue.Companion.mergingUpdateQueue("DataSourceStorage xml writer queue", 30000, DataSourceModelStorageImpl.access$getCoroutineScope$p($receiver));
                SimpleMessageBusConnection connection2 = $app.getMessageBus().connect(DataSourceModelStorageImpl.access$getCoroutineScope$p($receiver));
                if ($project == null) {
                    Topic topic = AppLifecycleListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    connection2.subscribe(topic, (Object)new AppLifecycleListener(this){
                        final /* synthetic */ SavingListener this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void appWillBeClosed(boolean isRestart) {
                            SavingListener.access$getQueue$p(this.this$0).sendFlush();
                        }
                    });
                } else {
                    connection2.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener($project, this){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ SavingListener this$0;
                        {
                            this.$project = $project;
                            this.this$0 = $receiver;
                        }

                        public void projectClosing(Project p2) {
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
                            if (p2 == this.$project) {
                                SavingListener.access$getQueue$p(this.this$0).sendFlush();
                            }
                        }
                    });
                }
            }

            public void dataSourceRemoved(LocalDataSource dataSource) {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                String string = dataSource.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
                String uuid = string;
                String string2 = uuid + "_purger";
                this.queue.queue(new Update(this, dataSource, uuid, string2){
                    private boolean wasQueued;
                    final /* synthetic */ SavingListener this$0;
                    final /* synthetic */ LocalDataSource $dataSource;
                    final /* synthetic */ String $uuid;
                    {
                        this.this$0 = $receiver;
                        this.$dataSource = $dataSource;
                        this.$uuid = $uuid;
                        super((Object)$super_call_param$1, 10);
                    }

                    public final boolean getWasQueued() {
                        return this.wasQueued;
                    }

                    public final void setWasQueued(boolean bl) {
                        this.wasQueued = bl;
                    }

                    public void run() {
                        if (this.wasQueued) {
                            SavingListener.access$save(this.this$0, this.$dataSource);
                        }
                        SavingListener.access$remove(this.this$0, this.$dataSource);
                    }

                    public boolean canEat(Update update2) {
                        boolean isQueued;
                        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
                        Object[] objectArray = update2.getEqualityObjects();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getEqualityObjects(...)");
                        Object[] objects = objectArray;
                        boolean bl = isQueued = objects.length == 1 && Intrinsics.areEqual((Object)this.$uuid, (Object)objects[0]);
                        if (isQueued) {
                            this.wasQueued = true;
                        }
                        return isQueued;
                    }
                });
                this.queue.sendFlush();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void remove(LocalDataSource dataSource) {
                Map map2 = DataSourceModelStorageImpl.access$getMyLocks$p(this.this$0);
                DataSourceModelStorageImpl dataSourceModelStorageImpl = this.this$0;
                Map map3 = map2;
                synchronized (map3) {
                    boolean bl = false;
                    myLocks.1.1 var5_6 = DataSourceModelStorageImpl.access$getMyLocks$p(dataSourceModelStorageImpl).remove(dataSource.getUniqueId());
                }
            }

            public void dataSourceChanged(LocalDataSource dataSource) {
                if (dataSource == null) {
                    return;
                }
                this.saveDataSource(dataSource);
            }

            public void dataSourceAdded(LocalDataSource dataSource) {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                this.saveDataSource(dataSource);
            }

            private final void saveDataSource(LocalDataSource dataSource) {
                if (!this.isMy(dataSource)) {
                    return;
                }
                if (dataSource.isInBatch() || this.this$0.isLoading(dataSource)) {
                    return;
                }
                DataSourceModelStorageImpl.access$getLOG$cp().debug("Scheduling save " + dataSource.getName());
                this.queue.queue(Update.Companion.create((Object)dataSource.getUniqueId(), () -> SavingListener.saveDataSource$lambda$1(this, dataSource)));
            }

            private final boolean isMy(LocalDataSource dataSource) {
                return this.$project == null == dataSource.isGlobal();
            }

            private final void save(LocalDataSource dataSource) {
                Project project = this.$project;
                if ((project != null ? (ComponentManager)project : (ComponentManager)ApplicationManager.getApplication()).isDisposed()) {
                    return;
                }
                try {
                    this.this$0.writeModel(dataSource);
                }
                catch (IOException e) {
                    DataSourceModelStorageImpl.access$getLOG$cp().error("Failed to save model for: " + dataSource.getName(), (Throwable)e);
                }
            }

            private static final void saveDataSource$lambda$1(SavingListener this$0, LocalDataSource $dataSource) {
                this$0.save($dataSource);
            }

            public static final /* synthetic */ void access$save(SavingListener $this, LocalDataSource dataSource) {
                $this.save(dataSource);
            }

            public static final /* synthetic */ void access$remove(SavingListener $this, LocalDataSource dataSource) {
                $this.remove(dataSource);
            }

            public static final /* synthetic */ MergingUpdateQueue access$getQueue$p(SavingListener $this) {
                return $this.queue;
            }
        }
        return new SavingListener(this, app, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object lock(LocalDataSource ds) {
        Map<String, myLocks.1.1> map2 = this.myLocks;
        synchronized (map2) {
            boolean bl = false;
            myLocks.1.1 v0 = this.myLocks.get(ds.getUniqueId());
            Intrinsics.checkNotNull((Object)v0);
            myLocks.1.1 var5_4 = v0;
            return var5_4;
        }
    }

    private static final myLocks.1.1 myLocks$lambda$0(String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return new Object(key2){
            final /* synthetic */ String $key;
            {
                this.$key = $key;
            }

            public String toString() {
                return this.$key;
            }
        };
    }

    private static final myLocks.1.1 myLocks$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final void continueLoadingWhenInitialized$lambda$2(Project $anyProject, Runnable r) {
        StartupManager.getInstance((Project)$anyProject).runAfterOpened(r);
    }

    private static final void continueLoadingWhenInitialized$lambda$8$lambda$7$lambda$4(DataSourceModelStorageImpl this$0, Runnable it) {
        Intrinsics.checkNotNull((Object)it);
        Runnable r = ThreadContext.captureThreadContext((Runnable)it);
        boolean bl = false;
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(r, null){
            int label;
            final /* synthetic */ Runnable $r;
            {
                this.$r = $r;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$r.run();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void continueLoadingWhenInitialized$lambda$8$lambda$7$lambda$6$lambda$5(DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState) {
        this$0.readStateHeavy($dataSources, $currentState);
    }

    private static final Object continueLoadingWhenInitialized$lambda$8$lambda$7$lambda$6(DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState) {
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this$0, () -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$8$lambda$7$lambda$6$lambda$5(this$0, $dataSources, $currentState));
        return null;
    }

    private static final AsyncTask continueLoadingWhenInitialized$lambda$8$lambda$7(AsyncTask.Frame $frame, Project $anyProject, DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState) {
        return AsyncTask.Companion.withBgIndicator($frame, $anyProject, null, false).compute(arg_0 -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$8$lambda$7$lambda$4(this$0, arg_0), () -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$8$lambda$7$lambda$6(this$0, $dataSources, $currentState));
    }

    private static final AsyncTask continueLoadingWhenInitialized$lambda$8(Project $anyProject, DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState) {
        String string = DatabaseBundle.message("loading.data.sources", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        AsyncTask.Frame frame = AsyncTask.Companion.frame(string);
        return frame.computeAsync(AsyncUtil.getEdtExecutor(), () -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$8$lambda$7(frame, $anyProject, this$0, $dataSources, $currentState));
    }

    private static final void readStateHeavy$lambda$9(LoadingState $currentState, LocalDataSource dataSource, DasModel model) {
        dataSource.setModel(model);
        $currentState.markLoaded((RawDataSource)dataSource);
    }

    private static final void readStateHeavy$lambda$10(DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState, ErrorHandler $errorHandler) {
        this$0.finishModelLoading($dataSources, $currentState, $errorHandler);
    }

    private static final void finishModelLoading$lambda$11(DataSourceModelStorageImpl this$0, List $dataSources) {
        block2: {
            try {
                this$0.applyMappings($dataSources);
            }
            catch (Throwable th) {
                if (AsyncUtil.isCancellation(th)) break block2;
                LOG.error(th);
            }
        }
    }

    private static final void finishModelLoading$lambda$12(DataSourceModelStorageImpl this$0, ErrorHandler $errorHandler, List $unsuccessful) {
        DataSourceModelStorageImpl.Companion.notifyErrors(this$0.getProject(), $errorHandler, $unsuccessful);
    }

    private static final void applyMappings$lambda$18$lambda$13(List $dataSources, Project $anyProject, List $incomplete) {
        for (LocalDataSource dataSource : $dataSources) {
            AsyncTask<SyncQueue.SyncResult> task = DataSourceUtil.applyMappings($anyProject, dataSource);
            if (task == null) continue;
            try {
                task.handle().toFuture().get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                $incomplete.add(task.toFuture());
            }
            catch (Throwable throwable) {}
        }
    }

    private static final boolean applyMappings$lambda$18$lambda$14(CompletableFuture it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isDone();
    }

    private static final boolean applyMappings$lambda$18$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit applyMappings$lambda$18$lambda$16(DataSourceModelStorageImpl this$0, Void void_, Throwable throwable) {
        MessageBus messageBus = this$0.messageBus;
        Topic<DataSourceStorage.Listener> topic = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((DataSourceStorage.Listener)messageBus.syncPublisher(topic)).dataSourceChanged(null);
        return Unit.INSTANCE;
    }

    private static final void applyMappings$lambda$18$lambda$17(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void applyMappings$lambda$18(DataSourceModelStorageImpl this$0, List $dataSources) {
        Project project = this$0.getProject();
        Project project2 = project;
        if (project2 == null && (project2 = DbImplUtilCore.getAnyProject()) == null) {
            return;
        }
        Project anyProject = project2;
        List incomplete = new ArrayList();
        ProgressManager.getInstance().executeProcessUnderProgress(() -> DataSourceModelStorageImpl.applyMappings$lambda$18$lambda$13($dataSources, anyProject, incomplete), ProgressManager.getGlobalProgressIndicator());
        incomplete.removeIf(arg_0 -> DataSourceModelStorageImpl.applyMappings$lambda$18$lambda$15(DataSourceModelStorageImpl::applyMappings$lambda$18$lambda$14, arg_0));
        ProgressManager.checkCanceled();
        MessageBus messageBus = this$0.messageBus;
        Topic<DataSourceStorage.Listener> topic = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((DataSourceStorage.Listener)messageBus.syncPublisher(topic)).dataSourceChanged(null);
        if (!incomplete.isEmpty()) {
            Collection $this$toTypedArray$iv = incomplete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
            CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).whenComplete((arg_0, arg_1) -> DataSourceModelStorageImpl.applyMappings$lambda$18$lambda$17((arg_0, arg_1) -> DataSourceModelStorageImpl.applyMappings$lambda$18$lambda$16(this$0, arg_0, arg_1), arg_0, arg_1));
        }
    }

    private static final boolean loadModels$lambda$19(LocalDataSource it) {
        return it.getModel() == DasUtil.emptyModel();
    }

    private static final boolean loadModels$lambda$20(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence loadModels$lambda$21(LocalDataSource it) {
        return it.getName() + " (" + it.getUniqueId() + ")";
    }

    private static final CharSequence loadModels$lambda$22(Function1 $tmp0, Object p0) {
        return (CharSequence)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean cleanupOldFiles$lambda$25(Set $toKeep, Set $uids, Path f) {
        String it;
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if ($toKeep.contains(f)) return true;
        Iterable $this$any$iv = $uids;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.startsWith$default((String)PathsKt.getName((Path)f), (String)it, (boolean)false, (int)2, null));
        return true;
    }

    private static final Unit cleanupOldFiles$lambda$30$lambda$28(Pattern $filePattern, Function1 $keep, Path file) {
        Intrinsics.checkNotNull((Object)file);
        if ($filePattern.matcher(PathsKt.getName((Path)file)).matches() && !((Boolean)$keep.invoke((Object)file)).booleanValue()) {
            try {
                FileUtil.delete((Path)file);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void cleanupOldFiles$lambda$30$lambda$29(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public /* synthetic */ DataSourceModelStorageImpl(ComponentManager componentManager, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(componentManager, coroutineScope);
    }

    public static final /* synthetic */ AsyncTask access$continueLoadingWhenInitialized(DataSourceModelStorageImpl $this, List dataSources, LoadingState currentState) {
        return $this.continueLoadingWhenInitialized(dataSources, currentState);
    }

    public static final /* synthetic */ void access$cleanupOldFiles(DataSourceModelStorageImpl $this, Project project, List newDataSources) {
        $this.cleanupOldFiles(project, newDataSources);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(DataSourceModelStorageImpl $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ Map access$getMyLocks$p(DataSourceModelStorageImpl $this) {
        return $this.myLocks;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DataSourceModelStorageImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Service
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$App;", "Lcom/intellij/database/dataSource/DataSourceModelStorageImpl;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "intellij.database.connectivity"})
    private static final class App
    extends DataSourceModelStorageImpl {
        public App(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            super((ComponentManager)application, coroutineScope, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J,\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ$\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0002J\u001a\u0010!\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020\u0019H\u0002J.\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010\u0019J0\u0010#\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "notifyErrors", "", "project", "Lcom/intellij/openapi/project/Project;", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "unsuccessful", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "validateModels", "dataSources", "writeModel", "", "file", "Ljava/io/File;", "dataSource", "model", "Lcom/intellij/database/model/DasModel;", "name", "", "scope", "Lcom/intellij/database/util/TreePattern;", "writeHugeFileSafe", "consumer", "Lcom/intellij/util/ThrowableConsumer;", "Ljava/io/OutputStream;", "Ljava/io/IOException;", "isReadonly", "path", "readModel", "Lkotlin/Pair;", "Lcom/intellij/database/model/serialization/ModelImporter;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "dataSourceName", "Lcom/intellij/database/model/basic/BasicModModel;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        private final void notifyErrors(Project project, ErrorHandler errorHandler, List<? extends LocalDataSource> unsuccessful) {
            String summary = errorHandler.getSummary();
            if (StringUtil.isNotEmpty((String)summary)) {
                Object[] objectArray = new Object[]{project == null ? "Global" : "Project"};
                String string = DatabaseBundle.message("notification.title.data.sources.href.sync.refresh.required", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String title = string;
                new Notification("Database configuration", title, summary, NotificationType.ERROR).setListener((NotificationListener)new NotificationListener.Adapter(project, unsuccessful){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<LocalDataSource> $unsuccessful;
                    {
                        this.$project = $project;
                        this.$unsuccessful = $unsuccessful;
                    }

                    protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Project project = this.$project;
                        if (project == null && (project = DbImplUtilCore.getAnyProject()) == null) {
                            return;
                        }
                        Project anyProject = project;
                        for (LocalDataSource dataSource : this.$unsuccessful) {
                            DataSourceUtil.performAutoSyncTask(LoaderContext.selectGeneralTask(anyProject, dataSource));
                        }
                    }
                }).notify(project);
            }
        }

        private final void validateModels(Project project, List<? extends LocalDataSource> dataSources) {
            if (project.isDisposed()) {
                return;
            }
            Couple<List<LocalDataSource>> couple = new DbSrcValidator().collect(project, (Iterable<LocalDataSource>)dataSources);
            Intrinsics.checkNotNullExpressionValue(couple, (String)"collect(...)");
            Couple<List<LocalDataSource>> result2 = couple;
            if (project.isDisposed() || ((List)result2.first).isEmpty() && ((List)result2.second).isEmpty()) {
                return;
            }
            if (!((List)result2.second).isEmpty()) {
                DbSrcValidator.suggestIntrospecting(project, (List)result2.second);
            }
            if (!((List)result2.first).isEmpty()) {
                DbSrcValidator.regenerateSources(project, (List)result2.first);
            }
        }

        private final boolean writeModel(File file, LocalDataSource dataSource) throws IOException {
            String string = dataSource.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name2 = string;
            DasModel dasModel = dataSource.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
            DasModel model = dasModel;
            TreePattern treePattern = dataSource.getIntrospectionScope();
            Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
            TreePattern scope2 = treePattern;
            this.writeModel(file, model, name2, scope2);
            return true;
        }

        public final void writeModel(@NotNull File file, @Nullable DasModel model, @Nullable String name2, @Nullable TreePattern scope2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.writeHugeFileSafe(file, (ThrowableConsumer<OutputStream, IOException>)((ThrowableConsumer)arg_0 -> Companion.writeModel$lambda$0(name2, model, scope2, arg_0)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeHugeFileSafe(File file, ThrowableConsumer<OutputStream, IOException> consumer) throws IOException {
            int bufferSize = Registry.Companion.intValue("database.storage.output.buffer");
            OutputStream safe2 = bufferSize < 0 ? (OutputStream)new SafeFileOutputStream(file) : (OutputStream)new PreemptiveSafeFileOutputStream(file.toPath());
            Closeable closeable = bufferSize < 0 ? safe2 : (OutputStream)new BufferedOutputStream(safe2, bufferSize);
            Throwable throwable = null;
            try {
                OutputStream out = (OutputStream)closeable;
                boolean bl = false;
                try {
                    consumer.consume((Object)out);
                }
                catch (Throwable t) {
                    if (safe2 instanceof PreemptiveSafeFileOutputStream) {
                        ((PreemptiveSafeFileOutputStream)safe2).abort();
                    } else {
                        ((SafeFileOutputStream)safe2).abort();
                    }
                    throw t;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final boolean isReadonly(Project project, String path) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = project == null ? null : VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
            if (virtualFile == null) {
                return false;
            }
            boolean[] readOnly = new boolean[1];
            try {
                EdtInvocationManager.invokeAndWaitIfNeeded(() -> Companion.isReadonly$lambda$3(readOnly, project, virtualFile));
            }
            catch (Throwable th) {
                ExceptionUtil.rethrow((Throwable)th);
            }
            return readOnly[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Pair<DasModel, ModelImporter> readModel(@NotNull ModelFactory modelFactory, @NotNull File file, @Nullable String dataSourceName) throws IOException {
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try (HierarchicalStreamReader reader = (HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), (XmlPullParser)new MXParser());){
                Pair<BasicModModel, ModelImporter> pair = this.readModel(modelFactory, dataSourceName, reader);
                if (pair != null) {
                    Pair<BasicModModel, ModelImporter> it = pair;
                    boolean bl = false;
                    Pair<BasicModModel, ModelImporter> pair2 = it;
                    return pair2;
                }
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    pair = this.readModel(modelFactory, dataSourceName, reader);
                    if (pair != null) {
                        Pair<BasicModModel, ModelImporter> it = pair;
                        boolean bl = false;
                        Pair<BasicModModel, ModelImporter> pair3 = it;
                        return pair3;
                    }
                    reader.moveUp();
                }
                pair = null;
                return pair;
            }
        }

        private final Pair<BasicModModel, ModelImporter> readModel(ModelFactory modelFactory, String dataSourceName, HierarchicalStreamReader reader) {
            Pair pair;
            if (Intrinsics.areEqual((Object)"database-model", (Object)reader.getNodeName())) {
                ModelImporter importer = new ModelImporter(modelFactory);
                BasicModModel model = importer.deserialize(reader, dataSourceName);
                pair = new Pair((Object)model, (Object)importer);
            } else {
                pair = null;
            }
            return pair;
        }

        private static final void writeModel$lambda$0(String $name, DasModel $model, TreePattern $scope, OutputStream out) {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            HierarchicalStreamWriter writer = (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)printWriter);
            writer.startNode("dataSource");
            writer.addAttribute("name", $name);
            DasModel dasModel = $model;
            Intrinsics.checkNotNull((Object)dasModel);
            ModelSerializerKt.serialize(dasModel, writer, $scope);
            writer.endNode();
            writer.close();
        }

        /*
         * Unable to fully structure code
         */
        private static final void isReadonly$lambda$3$lambda$2(boolean[] $readOnly, Project $project, VirtualFile $virtualFile) {
            v0 = $project;
            Intrinsics.checkNotNull((Object)v0);
            if (v0.isDisposed()) ** GOTO lbl-1000
            var3_3 = new VirtualFile[]{$virtualFile};
            if (!ReadonlyStatusHandler.ensureFilesWritable((Project)$project, (VirtualFile[])var3_3)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            $readOnly[0] = v1;
        }

        private static final void isReadonly$lambda$3(boolean[] $readOnly, Project $project, VirtualFile $virtualFile) {
            NonProjectFileWritingAccessProvider.disableChecksDuring(() -> Companion.isReadonly$lambda$3$lambda$2($readOnly, $project, $virtualFile));
        }

        public static final /* synthetic */ void access$validateModels(Companion $this, Project project, List dataSources) {
            $this.validateModels(project, dataSources);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$Prj;", "Lcom/intellij/database/dataSource/DataSourceModelStorageImpl;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.database.connectivity"})
    private static final class Prj
    extends DataSourceModelStorageImpl {
        @NotNull
        private final Project project;

        public Prj(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            super((ComponentManager)project, coroutineScope, null);
            this.project = project;
        }

        @Override
        @NotNull
        protected Project getProject() {
            return this.project;
        }
    }
}

