/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.util.text.StringKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00170\u0016J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\bJ\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\bJ\b\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0013\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dataSource/ConfigUrlOverrider;", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)V", "paramOverrides", "", "", "cache", "Lcom/intellij/database/dataSource/ConfigUrlOverrider$Cache;", "getUrl", "isOverriden", "", "clear", "", "getCache", "getOrigParams", "", "getParamInfo", "Lcom/intellij/database/dataSource/url/template/StatelessParametersHolder;", "getParams", "", "", "getParam", "p", "setParam", "v", "computeUrl", "templatesHash", "", "equals", "other", "Cache", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConfigUrlOverrider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigUrlOverrider.kt\ncom/intellij/database/dataSource/ConfigUrlOverrider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,84:1\n1#2:85\n216#3,2:86\n*S KotlinDebug\n*F\n+ 1 ConfigUrlOverrider.kt\ncom/intellij/database/dataSource/ConfigUrlOverrider\n*L\n70#1:86,2\n*E\n"})
public final class ConfigUrlOverrider {
    @NotNull
    private final DatabaseConnectionPoint config;
    @NotNull
    private final Map<String, String> paramOverrides;
    @Nullable
    private Cache cache;

    public ConfigUrlOverrider(@NotNull DatabaseConnectionPoint config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.paramOverrides = new LinkedHashMap();
    }

    @Nullable
    public final String getUrl() {
        String origUrl = this.config.getUrl();
        Intrinsics.checkNotNull((Object)origUrl);
        if (((CharSequence)origUrl).length() == 0 || this.paramOverrides.isEmpty()) {
            return origUrl;
        }
        Cache cache2 = this.getCache();
        return cache2 != null ? cache2.getUrl() : null;
    }

    public final boolean isOverriden() {
        return !this.paramOverrides.isEmpty();
    }

    public final void clear() {
        this.paramOverrides.clear();
        this.cache = null;
    }

    private final Cache getCache() {
        Cache cache2 = this.cache;
        if (cache2 != null) {
            Cache cache3;
            Cache cache4;
            Cache it = cache4 = cache2;
            boolean bl = false;
            Cache cache5 = cache3 = Intrinsics.areEqual((Object)it.getOrig(), (Object)this.config.getUrl()) && it.getTemplatesHash() == this.templatesHash() ? cache4 : null;
            if (cache3 != null) {
                it = cache3;
                boolean bl2 = false;
                return it;
            }
        }
        this.cache = this.computeUrl();
        return this.cache;
    }

    @NotNull
    public final Map<String, String> getOrigParams() {
        Object object = this.getCache();
        if (object == null || (object = ((Cache)object).getOrigParams()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @Nullable
    public final StatelessParametersHolder getParamInfo() {
        Cache cache2 = this.getCache();
        return cache2 != null ? cache2.getParamInfo() : null;
    }

    @NotNull
    public final Iterable<Map.Entry<String, String>> getParams() {
        return this.paramOverrides.entrySet();
    }

    @Nullable
    public final String getParam(@NotNull String p2) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
        return this.paramOverrides.get(p2);
    }

    public final void setParam(@NotNull String p2, @Nullable String v) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
        if (v == null) {
            if (this.paramOverrides.remove(p2) != null) {
                this.cache = null;
            }
        } else if (!Intrinsics.areEqual((Object)this.paramOverrides.put(p2, v), (Object)v)) {
            this.cache = null;
        }
    }

    private final Cache computeUrl() {
        JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(this.config);
        LinkedHashMap<String, String> origParams = new LinkedHashMap<String, String>();
        if (parsed != null) {
            for (String p2 : parsed.getParameterNames()) {
                String it;
                if (StringKt.nullize$default((String)parsed.getParameter(p2), (boolean)false, (int)1, null) == null) continue;
                boolean bl = false;
                origParams.put(p2, it);
            }
            Map<String, String> $this$forEach$iv = this.paramOverrides;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String p3 = entry.getKey();
                String v = entry.getValue();
                parsed.setParameter(p3, v);
            }
        }
        JdbcUrlParser jdbcUrlParser = parsed;
        String string = jdbcUrlParser != null ? jdbcUrlParser.getUrlText() : null;
        String string2 = this.config.getUrl();
        Intrinsics.checkNotNull((Object)string2);
        JdbcUrlParser jdbcUrlParser2 = parsed;
        return new Cache(string, string2, (Map<String, String>)origParams, jdbcUrlParser2 != null ? jdbcUrlParser2.getParametersHolderDelegate() : null, this.templatesHash());
    }

    private final int templatesHash() {
        DatabaseDriver databaseDriver = this.config.getDatabaseDriver();
        List<StatelessJdbcUrlParser> list = databaseDriver != null ? databaseDriver.getJDBCUrlParsers() : null;
        return list != null ? ((Object)list).hashCode() : 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ConfigUrlOverrider && Intrinsics.areEqual(this.paramOverrides, ((ConfigUrlOverrider)other).paramOverrides);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003JK\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/database/dataSource/ConfigUrlOverrider$Cache;", "", "url", "", "orig", "origParams", "", "paramInfo", "Lcom/intellij/database/dataSource/url/template/StatelessParametersHolder;", "templatesHash", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lcom/intellij/database/dataSource/url/template/StatelessParametersHolder;I)V", "getUrl", "()Ljava/lang/String;", "getOrig", "getOrigParams", "()Ljava/util/Map;", "getParamInfo", "()Lcom/intellij/database/dataSource/url/template/StatelessParametersHolder;", "getTemplatesHash", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.database.core.impl"})
    private static final class Cache {
        @Nullable
        private final String url;
        @NotNull
        private final String orig;
        @NotNull
        private final Map<String, String> origParams;
        @Nullable
        private final StatelessParametersHolder paramInfo;
        private final int templatesHash;

        public Cache(@Nullable String url, @NotNull String orig, @NotNull Map<String, String> origParams, @Nullable StatelessParametersHolder paramInfo, int templatesHash) {
            Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
            Intrinsics.checkNotNullParameter(origParams, (String)"origParams");
            this.url = url;
            this.orig = orig;
            this.origParams = origParams;
            this.paramInfo = paramInfo;
            this.templatesHash = templatesHash;
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getOrig() {
            return this.orig;
        }

        @NotNull
        public final Map<String, String> getOrigParams() {
            return this.origParams;
        }

        @Nullable
        public final StatelessParametersHolder getParamInfo() {
            return this.paramInfo;
        }

        public final int getTemplatesHash() {
            return this.templatesHash;
        }

        @Nullable
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final String component2() {
            return this.orig;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.origParams;
        }

        @Nullable
        public final StatelessParametersHolder component4() {
            return this.paramInfo;
        }

        public final int component5() {
            return this.templatesHash;
        }

        @NotNull
        public final Cache copy(@Nullable String url, @NotNull String orig, @NotNull Map<String, String> origParams, @Nullable StatelessParametersHolder paramInfo, int templatesHash) {
            Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
            Intrinsics.checkNotNullParameter(origParams, (String)"origParams");
            return new Cache(url, orig, origParams, paramInfo, templatesHash);
        }

        public static /* synthetic */ Cache copy$default(Cache cache2, String string, String string2, Map map2, StatelessParametersHolder statelessParametersHolder, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = cache2.url;
            }
            if ((n2 & 2) != 0) {
                string2 = cache2.orig;
            }
            if ((n2 & 4) != 0) {
                map2 = cache2.origParams;
            }
            if ((n2 & 8) != 0) {
                statelessParametersHolder = cache2.paramInfo;
            }
            if ((n2 & 0x10) != 0) {
                n = cache2.templatesHash;
            }
            return cache2.copy(string, string2, map2, statelessParametersHolder, n);
        }

        @NotNull
        public String toString() {
            return "Cache(url=" + this.url + ", orig=" + this.orig + ", origParams=" + this.origParams + ", paramInfo=" + this.paramInfo + ", templatesHash=" + this.templatesHash + ")";
        }

        public int hashCode() {
            int result2 = this.url == null ? 0 : this.url.hashCode();
            result2 = result2 * 31 + this.orig.hashCode();
            result2 = result2 * 31 + ((Object)this.origParams).hashCode();
            result2 = result2 * 31 + (this.paramInfo == null ? 0 : this.paramInfo.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.templatesHash);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Cache)) {
                return false;
            }
            Cache cache2 = (Cache)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)cache2.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.orig, (Object)cache2.orig)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.origParams, cache2.origParams)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paramInfo, (Object)cache2.paramInfo)) {
                return false;
            }
            return this.templatesHash == cache2.templatesHash;
        }
    }
}

