/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.ssh;

import com.intellij.database.console.ssh.DirectClientHandler;
import com.intellij.database.console.ssh.RelayHandler;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.openapi.diagnostic.Logger;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.socksx.SocksMessage;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.function.Function;

public class SocksServerConnectHandler
extends SimpleChannelInboundHandler<SocksMessage> {
    private static final Logger LOG = Logger.getInstance(SocksServerConnectHandler.class);
    private final Function<HostPort, Integer> myLocalTunnelProvider;
    private final Bootstrap myBootstrap = new Bootstrap();

    public SocksServerConnectHandler(Function<HostPort, Integer> localTunnelProvider) {
        this.myLocalTunnelProvider = localTunnelProvider;
    }

    public void channelRead0(final ChannelHandlerContext ctx, SocksMessage message) throws Exception {
        if (message instanceof Socks5CommandRequest) {
            final Socks5CommandRequest request2 = (Socks5CommandRequest)message;
            Promise promise = ctx.executor().newPromise();
            promise.addListener((GenericFutureListener)new FutureListener<Channel>(){

                public void operationComplete(Future<Channel> future) throws Exception {
                    final Channel outboundChannel = (Channel)future.getNow();
                    if (future.isSuccess()) {
                        ChannelFuture responseFuture = ctx.channel().writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, request2.dstAddrType(), request2.dstAddr(), request2.dstPort()));
                        responseFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture channelFuture) {
                                ctx.pipeline().remove((ChannelHandler)SocksServerConnectHandler.this);
                                outboundChannel.pipeline().addLast(new ChannelHandler[]{new RelayHandler(ctx.channel())});
                                ctx.pipeline().addLast(new ChannelHandler[]{new RelayHandler(outboundChannel)});
                            }
                        });
                    } else {
                        ctx.channel().writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, request2.dstAddrType()));
                        SocksServerConnectHandler.closeChannel(ctx.channel(), future.cause());
                    }
                }
            });
            Channel inboundChannel = ctx.channel();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.myBootstrap.group((EventLoopGroup)inboundChannel.eventLoop())).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new DirectClientHandler((Promise<Channel>)promise));
            HostPort hostPort = new HostPort(request2.dstAddr(), request2.dstPort());
            this.myBootstrap.connect("localhost", this.myLocalTunnelProvider.apply(hostPort).intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (!future.isSuccess()) {
                        ctx.channel().writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, request2.dstAddrType()));
                        SocksServerConnectHandler.closeChannel(ctx.channel(), future.cause());
                    }
                }
            });
        } else {
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        SocksServerConnectHandler.closeChannel(ctx.channel(), cause);
    }

    private static void closeChannel(Channel channel, Throwable cause) {
        if (channel.isActive()) {
            LOG.error("Close channel", cause);
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

