/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.ssh;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.ssh.DatabaseProxyServer;
import com.intellij.database.console.ssh.SshTunnelsInfo;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTunnelListener;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSshTunnelsManager {
    private static final Logger LOG = Logger.getInstance(DatabaseSshTunnelsManager.class);
    private final Project myProject;
    private final Map<LocalDataSource, SshTunnelsInfo> myTunnelsMap;
    private final ConcurrentMap<Integer, MySshTunnelStateInfo> myTunnelStates;

    public DatabaseSshTunnelsManager(@NotNull Project project) {
        if (project == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(0);
        }
        this.myTunnelsMap = new ConcurrentHashMap<LocalDataSource, SshTunnelsInfo>();
        this.myTunnelStates = CollectionFactory.createConcurrentWeakMap();
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(SshTunnelListener.TOPIC, (localPort, th) -> {
            MySshTunnelStateInfo stateInfo = (MySshTunnelStateInfo)this.myTunnelStates.get(localPort);
            if (stateInfo != null) {
                stateInfo.state = th;
            }
        });
    }

    @NotNull
    public List<DatabaseSshTunnelEstablisher.SshTunnel> getTunnels(@NotNull LocalDataSource source) {
        SshTunnelsInfo tunnelsInfo;
        if (source == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(1);
        }
        List<Object> list = (tunnelsInfo = this.myTunnelsMap.get(source)) == null ? Collections.emptyList() : tunnelsInfo.getTunnels();
        if (list == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public Throwable getTunnelsState(@NotNull LocalDataSource dataSource) {
        SshTunnelsInfo tunnelsInfo;
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(3);
        }
        return (tunnelsInfo = this.myTunnelsMap.get(dataSource)) == null ? null : this.getTunnelsState(tunnelsInfo);
    }

    @Nullable
    private Throwable getTunnelsState(@NotNull Collection<Integer> tunnelsPort) {
        if (tunnelsPort == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(4);
        }
        for (Integer tunnelPort : tunnelsPort) {
            MySshTunnelStateInfo stateInfo = (MySshTunnelStateInfo)this.myTunnelStates.get(tunnelPort);
            Throwable state = stateInfo == null ? null : stateInfo.state;
            if (state == null) continue;
            return state;
        }
        return null;
    }

    @Nullable
    private Throwable getTunnelsState(@NotNull SshTunnelsInfo tunnelsInfo) {
        if (tunnelsInfo == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(5);
        }
        return this.getTunnelsState(tunnelsInfo.getAdditionalTunnels().values());
    }

    public void createTunnels(@NotNull LocalDataSource dataSource) throws ExecutionException {
        SshTunnelsInfo tunnelsInfo;
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(6);
        }
        if ((tunnelsInfo = this.myTunnelsMap.get(dataSource)) == null) {
            this.createTunnelsImpl(dataSource);
        }
    }

    private void createTunnelsImpl(@NotNull LocalDataSource dataSource) throws ExecutionException {
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(7);
        }
        try {
            SshTunnelsInfo tunnelsInfo = DatabaseSshTunnelEstablisher.createTunnelsSync(this.myProject, dataSource);
            if (tunnelsInfo == null) {
                return;
            }
            for (DatabaseSshTunnelEstablisher.SshTunnel tunnel : tunnelsInfo.getTunnels()) {
                this.trackTunnelState(tunnelsInfo.getSession(), tunnel.localPort);
            }
            this.myTunnelsMap.put(dataSource, tunnelsInfo);
        }
        catch (SshException | UnsupportedOperationException e) {
            throw new ExecutionException(DatabaseBundle.message("dialog.message.ssh", e.getMessage()), e);
        }
    }

    private void trackTunnelState(@NotNull SshSession session, int localPort) {
        MySshTunnelStateInfo existing2;
        if (session == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(8);
        }
        if ((existing2 = (MySshTunnelStateInfo)this.myTunnelStates.get(localPort)) == null || existing2.session != session) {
            this.myTunnelStates.put(localPort, new MySshTunnelStateInfo(session));
        }
    }

    public void validateSshTunnels(@NotNull LocalDataSource dataSource) throws ExecutionException {
        SshTunnelsInfo tunnelsInfo;
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(9);
        }
        if ((tunnelsInfo = this.myTunnelsMap.get(dataSource)) == null) {
            if (DataSourceSshTunnelConfiguration.hasTunnel(dataSource)) {
                LOG.warn("The tunnel was dropped. Recreating...");
                this.createTunnelsImpl(dataSource);
            }
            return;
        }
        Throwable tunnelsState = this.getTunnelsState(tunnelsInfo);
        if (tunnelsInfo.getSession().isConnected() && tunnelsState == null) {
            return;
        }
        LOG.warn("The tunnel is dead", tunnelsState);
        this.destroyTunnels(dataSource);
        LOG.warn("Long live the tunnel!");
        this.createTunnelsImpl(dataSource);
    }

    public void destroyAllTunnels() {
        ArrayList<SshTunnelsInfo> tunnelsInfos = new ArrayList<SshTunnelsInfo>(this.myTunnelsMap.values());
        this.myTunnelsMap.clear();
        for (SshTunnelsInfo tunnelsInfo : tunnelsInfos) {
            this.destroyTunnelsImpl(tunnelsInfo);
        }
    }

    public void destroyTunnels(@NotNull LocalDataSource dataSource) {
        SshTunnelsInfo tunnelsInfo;
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(10);
        }
        if ((tunnelsInfo = this.myTunnelsMap.remove(dataSource)) == null) {
            return;
        }
        this.destroyTunnelsImpl(tunnelsInfo);
    }

    private void destroyTunnelsImpl(@NotNull SshTunnelsInfo tunnelsInfo) {
        if (tunnelsInfo == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(11);
        }
        tunnelsInfo.getAdditionalTunnels().forEach((h, port) -> this.myTunnelStates.remove(port));
        tunnelsInfo.close();
    }

    public HostPort createProxyServer(@NotNull LocalDataSource dataSource) {
        SshTunnelsInfo tunnelsInfo;
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(12);
        }
        if ((tunnelsInfo = this.myTunnelsMap.get(dataSource)) == null) {
            throw new IllegalStateException("Tunnel should be created for " + String.valueOf(dataSource));
        }
        DatabaseProxyServer proxyServer = tunnelsInfo.getProxyServer();
        if (proxyServer != null) {
            return proxyServer.getHostPort();
        }
        Function<HostPort, Integer> localTunnelProvider = hostPort -> {
            int port = tunnelsInfo.addAdditionalTunnel((HostPort)hostPort, (Function1<? super HostPort, Integer>)((Function1)h -> DatabaseSshTunnelEstablisher.createAdditionalLocalTunnel(this.myProject, dataSource, h, tunnelsInfo)));
            this.trackTunnelState(tunnelsInfo.getSession(), port);
            return port;
        };
        proxyServer = DatabaseProxyServer.startProxyServer(localTunnelProvider);
        tunnelsInfo.setProxyServer(proxyServer);
        return proxyServer.getHostPort();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/ssh/DatabaseSshTunnelsManager";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tunnelsPort";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tunnelsInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/ssh/DatabaseSshTunnelsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTunnels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTunnels";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTunnelsState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTunnels";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTunnelsImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "trackTunnelState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateSshTunnels";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "destroyTunnels";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "destroyTunnelsImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProxyServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class MySshTunnelStateInfo {
        final SshSession session;
        Throwable state;

        private MySshTunnelStateInfo(@NotNull SshSession session) {
            if (session == null) {
                MySshTunnelStateInfo.$$$reportNull$$$0(0);
            }
            this.session = session;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/console/ssh/DatabaseSshTunnelsManager$MySshTunnelStateInfo", "<init>"));
        }
    }
}

