/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.SqlNotebookModel;
import com.intellij.database.run.actions.NotebookGridPatcher;
import com.intellij.database.run.actions.NotebookGridPatcherKt;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.table.SingleRowModeHelper;
import com.intellij.database.script.ScriptModel;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.sql.database.SqlNotebookManager;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DatabaseInEditorResults {
    private static final int MAX_ROWS = 8;
    private final MultiMap<Editor, ContainerWeakRef> myContainers = new MultiMap();

    @Nullable
    public ResultConstructor getOrCreateResult(@NotNull Arguments args2) {
        ScriptModel<?> sm;
        if (args2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(0);
        }
        if (args2.editor.isDisposed() || !EditorUtil.isRealFileEditor((Editor)args2.editor)) {
            return null;
        }
        PsiFile file = args2.console.getFile();
        SqlNotebookModel.CellsAccessor accessor = (SqlNotebookModel.CellsAccessor)ReadAction.compute(() -> DatabaseInEditorResults.lambda$getOrCreateResult$0(file, sm = args2.console.getScriptModel()));
        SqlNotebookManager.Cell cell = this.getCell(accessor, args2);
        return cell == null ? null : this.getContainer(args2, cell);
    }

    public void scrollTo(@NotNull Result result2, @NotNull Editor editor2) {
        if (result2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(2);
        }
        Document document = editor2.getDocument();
        int line = document.getLineNumber(result2.getOffset());
        int lStart = document.getLineStartOffset(line);
        editor2.getScrollingModel().scrollTo(editor2.offsetToLogicalPosition(lStart), ScrollType.MAKE_VISIBLE);
    }

    @NotNull
    public Collection<? extends RunnerLayoutUi> getUis() {
        List list = ContainerUtil.map((Collection)ContainerUtil.filter(this.getUncollectedResults(), Result::isShown), Result::getUi);
        if (list == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void show(@NotNull Result result2, @NotNull Content content, @NotNull Editor editor2) {
        if (result2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(4);
        }
        if (content == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(6);
        }
        result2.show();
        UIUtil.uiTraverser((Component)content.getComponent()).filter(EditorHeaderComponent.class).forEach(t -> t.addMouseWheelListener(event -> MouseEventAdapter.redispatch((MouseEvent)event, (Component)editor2.getContentComponent())));
    }

    @Nullable
    private SqlNotebookManager.Cell getCell(@NotNull SqlNotebookModel.CellsAccessor accessor, @NotNull Arguments arguments) {
        if (accessor == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(7);
        }
        if (arguments == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(8);
        }
        if (arguments.editor.isDisposed() || !EditorUtil.isRealFileEditor((Editor)arguments.editor)) {
            return null;
        }
        TextRange subQueryRange = arguments.subQuery.range;
        int offset = Math.max(subQueryRange.getStartOffset(), subQueryRange.getEndOffset() - 1);
        SqlNotebookManager.Cell cell = accessor.getCell(new LayoutProvider((Editor)arguments.editor), offset);
        if (cell == null) {
            return null;
        }
        TextRange requestRange = arguments.request.getRange();
        if (requestRange != null && requestRange.getEndOffset() >= cell.lastStatementEnd) {
            return cell;
        }
        DocumentEx document = arguments.editor.getDocument();
        int lsOffset = document.getLineStartOffset(document.getLineNumber(cell.lastStatementEnd));
        return DatabaseInEditorResults.isVisibleVertically(arguments.editor, arguments.editor.offsetToXY(lsOffset)) ? cell : DatabaseInEditorResults.argsToCell(arguments, subQueryRange);
    }

    private static boolean isVisibleVertically(@NotNull EditorEx editor2, @NotNull Point point) {
        if (editor2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(9);
        }
        if (point == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(10);
        }
        Rectangle visibleArea = editor2.getScrollingModel().getVisibleArea();
        Point areaXInlayY = new Point(visibleArea.x, point.y);
        return visibleArea.contains(areaXInlayY);
    }

    @NotNull
    private static SqlNotebookManager.Cell argsToCell(@NotNull Arguments arguments, @NotNull TextRange range) {
        if (arguments == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(11);
        }
        if (range == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(12);
        }
        int lineEnd = DatabaseInEditorResults.getLineEnd((Editor)arguments.editor, range.getEndOffset());
        TextRange finalRange = TextRange.create((int)range.getStartOffset(), (int)lineEnd);
        return new SqlNotebookManager.Cell(finalRange, Collections.singletonList(finalRange), lineEnd);
    }

    @NotNull
    private ResultConstructor getContainer(@NotNull Arguments args2, @NotNull SqlNotebookManager.Cell cell) {
        EditorEx editor2;
        ResultConstructor found;
        if (args2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(13);
        }
        if (cell == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(14);
        }
        if ((found = this.findContainer((Editor)(editor2 = args2.editor), cell)) != null) {
            ResultConstructor resultConstructor = found;
            if (resultConstructor == null) {
                DatabaseInEditorResults.$$$reportNull$$$0(15);
            }
            return resultConstructor;
        }
        final Disposable parent = Disposer.newDisposable();
        Project project = args2.console.getProject();
        BooleanFunction aliveChecker = c2 -> this.getUncollectedResults().contains(c2);
        int lse = cell.lastStatementEnd;
        EditorResultsContainer container = new EditorResultsContainer(parent, project, args2.editor, args2.console, (BooleanFunction<EditorResultsContainer>)aliveChecker, lse);
        final RunnerLayoutUi ui = container.getUi();
        ui.addListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ui.getContents().length == 0) {
                    Disposer.dispose((Disposable)parent);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/session/DatabaseInEditorResults$1", "contentRemoved"));
            }
        }, parent);
        ContainerWeakRef reference = container.getWeakRef();
        this.myContainers.putValue((Object)editor2, (Object)reference);
        EditorUtil.disposeWithEditor((Editor)editor2, (Disposable)parent);
        Disposer.register((Disposable)parent, () -> {
            this.myContainers.remove((Object)args2.editor, (Object)reference);
            EditorResultsContainer c2 = (EditorResultsContainer)reference.get();
            if (c2 != null) {
                c2.clearStrongReferences();
            }
        });
        EditorResultsContainer editorResultsContainer = container;
        if (editorResultsContainer == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(16);
        }
        return editorResultsContainer;
    }

    @NotNull
    public @Unmodifiable Collection<? extends Result> getResults(@NotNull Editor editor2) {
        if (editor2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(17);
        }
        return this.getUncollectedResults(editor2);
    }

    @Nullable
    private ResultConstructor findContainer(@NotNull Editor editor2, @NotNull SqlNotebookManager.Cell cell) {
        if (editor2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(18);
        }
        if (cell == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(19);
        }
        Collection<ResultConstructor> containers = this.getUncollectedResults(editor2);
        for (ResultConstructor container : containers) {
            if (!container.isShown() || !cell.range.containsOffset(container.getOffset())) continue;
            return container;
        }
        return null;
    }

    @NotNull
    private @Unmodifiable Collection<ResultConstructor> getUncollectedResults(@NotNull Editor editor2) {
        if (editor2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(20);
        }
        ArrayList refs = new ArrayList(this.myContainers.get((Object)editor2));
        List list = ContainerUtil.filter((Collection)ContainerUtil.mapNotNull(refs, r -> DatabaseInEditorResults.asResult(r)), Result::isShown);
        if (list == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private Collection<ResultConstructor> getUncollectedResults() {
        List list = ContainerUtil.mapNotNull(new ArrayList(this.myContainers.values()), r -> DatabaseInEditorResults.asResult(r));
        if (list == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Nullable
    private static ResultConstructor asResult(@NotNull ContainerWeakRef ref2) {
        EditorResultsContainer container;
        if (ref2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(23);
        }
        if ((container = (EditorResultsContainer)ref2.get()) == null || ref2.isOutdated() && !container.isShown()) {
            ref2.dispose();
            return null;
        }
        return container;
    }

    private static int getEditorTextWidth(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(24);
        }
        FontMetrics metrics = editor2.getFontMetrics(0);
        float spaceWidth = FontLayoutService.getInstance().charWidth2D(metrics, 32);
        return (int)spaceWidth * editor2.getSettings().getRightMargin(editor2.getProject());
    }

    private static int getLineEnd(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            DatabaseInEditorResults.$$$reportNull$$$0(25);
        }
        return editor2.getDocument().getLineEndOffset(editor2.getDocument().getLineNumber(offset));
    }

    @Nullable
    private static JScrollBar getHorizontalScrollBar(@Nullable DataGrid grid) {
        if (grid == null) {
            return null;
        }
        JScrollPane scrollPane = (JScrollPane)ObjectUtils.tryCast((Object)grid.getMainResultViewComponent(), JScrollPane.class);
        return scrollPane == null ? null : scrollPane.getHorizontalScrollBar();
    }

    @Nullable
    private static DataGrid getGrid(JComponent component) {
        Component cWithGrid = (Component)UIUtil.uiTraverser((Component)component).traverse(TreeTraversal.PRE_ORDER_DFS).find(c2 -> DataManager.getInstance().getDataContext(c2).getData(DatabaseDataKeys.DATA_GRID_KEY) != null);
        return cWithGrid == null ? null : (DataGrid)DataManager.getInstance().getDataContext(cWithGrid).getData(DatabaseDataKeys.DATA_GRID_KEY);
    }

    private static /* synthetic */ SqlNotebookModel.CellsAccessor lambda$getOrCreateResult$0(PsiFile file, ScriptModel sm) throws RuntimeException {
        return SqlNotebookModel.getCellAccessor(file, sm, (Condition<? super TextRange>)Conditions.alwaysTrue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 15, 16, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/DatabaseInEditorResults";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUis";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncollectedResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scrollTo";
                break;
            }
            case 3: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCell";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleVertically";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "argsToCell";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResults";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findContainer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getUncollectedResults";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "asResult";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTextWidth";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLineEnd";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 15, 16, 21, 22 -> new IllegalStateException(string);
        };
    }

    public static class Arguments {
        final EditorEx editor;
        final JdbcConsole console;
        final ConsoleDataRequest request;
        final ConsoleDataRequest.ResultSetSubQuery subQuery;

        public Arguments(@NotNull EditorEx editor2, @NotNull JdbcConsole console, @NotNull ConsoleDataRequest request2, @NotNull ConsoleDataRequest.ResultSetSubQuery subQuery) {
            if (editor2 == null) {
                Arguments.$$$reportNull$$$0(0);
            }
            if (console == null) {
                Arguments.$$$reportNull$$$0(1);
            }
            if (request2 == null) {
                Arguments.$$$reportNull$$$0(2);
            }
            if (subQuery == null) {
                Arguments.$$$reportNull$$$0(3);
            }
            this.editor = editor2;
            this.console = console;
            this.request = request2;
            this.subQuery = subQuery;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "subQuery";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/session/DatabaseInEditorResults$Arguments";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface ResultConstructor
    extends Result {
        public void setInProgress(boolean var1);
    }

    public static interface Result {
        public void hide();

        public void show();

        public void destroy();

        public boolean isShown();

        public boolean isStable();

        public int getOffset();

        public void saveBeforeChanges();

        public void restoreAfterChanges();

        @NotNull
        public RunnerLayoutUi getUi();

        @Nullable
        public Inlay<?> getInlay();
    }

    private class LayoutProvider
    implements SqlNotebookModel.EditorLayoutProvider {
        private final Editor myEditor;

        LayoutProvider(Editor editor2) {
            if (editor2 == null) {
                LayoutProvider.$$$reportNull$$$0(0);
            }
            this.myEditor = editor2;
        }

        @Override
        public int[] getInlayOffsets(@NotNull TextRange range) {
            if (range == null) {
                LayoutProvider.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertEventDispatchThread();
            IntArrayList result2 = new IntArrayList();
            for (Result result3 : DatabaseInEditorResults.this.getUncollectedResults(this.myEditor)) {
                if (result3 == null || !result3.isShown() || !range.contains(result3.getOffset())) continue;
                result2.add(result3.getOffset());
            }
            return result2.toIntArray();
        }

        @Override
        public int getInlayLength() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$LayoutProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInlayOffsets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class EditorResultsContainer
    implements ResultConstructor {
        private final Disposable myParent;
        private final BooleanFunction<EditorResultsContainer> myIsAlive;
        private final ContainerWeakRef myWeakRef;
        private final AtomicLong myLastScrollEvent;
        private final MyScrollBarListener myScrollBarListener;
        private EditorEx myEditor;
        private JdbcConsole myConsole;
        private RunnerLayoutUi myUi;
        private boolean myShown;
        private Inlay<?> myInlay;
        private int myInitialOffset;
        private ParentDisposalController myParentController;
        private boolean myInProgress;

        EditorResultsContainer(@NotNull Disposable parent, @NotNull Project project, @NotNull EditorEx editor2, @NotNull JdbcConsole console, @NotNull BooleanFunction<EditorResultsContainer> isAlive, int initialOffset) {
            if (parent == null) {
                EditorResultsContainer.$$$reportNull$$$0(0);
            }
            if (project == null) {
                EditorResultsContainer.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                EditorResultsContainer.$$$reportNull$$$0(2);
            }
            if (console == null) {
                EditorResultsContainer.$$$reportNull$$$0(3);
            }
            if (isAlive == null) {
                EditorResultsContainer.$$$reportNull$$$0(4);
            }
            this.myParent = parent;
            this.myEditor = editor2;
            this.myConsole = console;
            this.myIsAlive = isAlive;
            this.myInitialOffset = initialOffset;
            this.myLastScrollEvent = new AtomicLong();
            this.myScrollBarListener = new MyScrollBarListener(this.myLastScrollEvent);
            String title = console.getTitle();
            this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("not_persistent_id", title, title, parent);
            this.myUi.getDefaults().initTabDefaults(0, "not_persistent_id", null);
            this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false).setTabPopupActions((ActionGroup)ActionManager.getInstance().getAction("Console.TabPopupGroup.Embedded"));
            this.myShown = true;
            this.myWeakRef = new ContainerWeakRef(this, parent);
        }

        @Override
        public int getOffset() {
            return this.myInlay != null ? this.myInlay.getOffset() : this.myInitialOffset;
        }

        @Override
        public void setInProgress(boolean progress) {
            this.myInProgress = progress;
        }

        @Override
        public void hide() {
            if (this.myInlay == null) {
                return;
            }
            this.justHide();
            this.perform((UndoableAction)WriteIntentReadAction.compute(() -> new BasicUndoableAction(new Document[]{this.myEditor.getDocument()}){

                public void undo() {
                    this.justShow();
                }

                public void redo() {
                    this.justHide();
                }
            }), DatabaseBundle.message("console.notebook.mode.hide.results", new Object[0]));
        }

        @Override
        public void show() {
            if (this.myInlay != null) {
                return;
            }
            this.justShow();
            this.perform((UndoableAction)WriteIntentReadAction.compute(() -> new BasicUndoableAction(new Document[]{this.myEditor.getDocument()}){

                public void redo() {
                    this.justShow();
                }

                public void undo() {
                    this.justHide();
                }
            }), DatabaseBundle.message("console.notebook.mode.show.results", new Object[0]));
        }

        @Override
        public void saveBeforeChanges() {
            this.justHide();
        }

        @Override
        public void restoreAfterChanges() {
            this.justShow();
        }

        @Override
        public void destroy() {
            this.myParentController.run(() -> Disposer.dispose((Disposable)this.myParent));
        }

        @NotNull
        ContainerWeakRef getWeakRef() {
            ContainerWeakRef containerWeakRef = this.myWeakRef;
            if (containerWeakRef == null) {
                EditorResultsContainer.$$$reportNull$$$0(5);
            }
            return containerWeakRef;
        }

        private void perform(@NotNull UndoableAction action, @Nls @NotNull String name2) {
            if (action == null) {
                EditorResultsContainer.$$$reportNull$$$0(6);
            }
            if (name2 == null) {
                EditorResultsContainer.$$$reportNull$$$0(7);
            }
            CommandProcessor instance = CommandProcessor.getInstance();
            Project project = this.myConsole.getProject();
            instance.executeCommand(project, () -> UndoManager.getInstance((Project)project).undoableActionPerformed(action), name2, null);
        }

        private void justHide() {
            if (!this.myIsAlive.fun((Object)this) || this.myInlay == null) {
                return;
            }
            this.myEditor.getScrollPane().getVerticalScrollBar().removeAdjustmentListener(this.myScrollBarListener);
            this.myInitialOffset = this.myInlay.getOffset();
            this.myParentController.run(() -> Disposer.dispose(this.myInlay));
            this.myParentController = null;
            this.myInlay = null;
            this.myShown = false;
            this.myWeakRef.hidden();
        }

        private void justShow() {
            if (!this.myIsAlive.fun((Object)this) || this.myInlay != null) {
                return;
            }
            JComponent component = this.myUi.getComponent();
            this.clearLeftBorderOfRunnerUi();
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)component, "Center");
            MyJLayeredPane pane = new MyJLayeredPane();
            int rowHeight = (int)((double)this.myEditor.getLineHeight() * 0.35);
            if (this.myEditor instanceof EditorImpl) {
                final DatabaseInEditorGridPatcher patcher = new DatabaseInEditorGridPatcher(pane, this.myUi, (Editor)this.myEditor, rowHeight);
                DataGrid grid = DatabaseInEditorResults.getGrid(this.myUi.getComponent());
                if (grid != null) {
                    grid.putUserData(NotebookGridPatcherKt.RESULTS_PATCHER, (Object)patcher);
                }
                patcher.updateHeight();
                patcher.updateBorders();
                JScrollBar scrollBar = DatabaseInEditorResults.getHorizontalScrollBar(grid);
                if (scrollBar != null) {
                    UiNotifyConnector.Once.installOn((Component)scrollBar, (Activatable)new Activatable(){

                        public void showNotify() {
                            patcher.updateHeight();
                        }
                    });
                }
            }
            pane.add(panel2);
            pane.setLayer(panel2, JLayeredPane.DEFAULT_LAYER);
            EventTransparentPanel transparentPanel = new EventTransparentPanel(this.myLastScrollEvent);
            pane.add(transparentPanel);
            pane.setLayer(transparentPanel, JLayeredPane.DEFAULT_LAYER + 1);
            panel2.add(Box.createVerticalStrut(rowHeight), "North");
            panel2.setOpaque(false);
            transparentPanel.addMouseWheelListener(new MyMouseWheelListener(transparentPanel, panel2, (Editor)this.myEditor, this.myLastScrollEvent));
            this.myEditor.getScrollPane().getVerticalScrollBar().addAdjustmentListener(this.myScrollBarListener);
            int leOffset = DatabaseInEditorResults.getLineEnd((Editor)this.myEditor, this.myInitialOffset);
            EditorEmbeddedComponentManager.Properties properties2 = new EditorEmbeddedComponentManager.Properties(EditorEmbeddedComponentManager.ResizePolicy.any(), __ -> new CloseRenderer(this, rowHeight), true, false, false, true, 0, leOffset);
            Inlay inlay = Objects.requireNonNull(EditorEmbeddedComponentManager.getInstance().addComponent(this.myEditor, (JComponent)pane, properties2));
            this.setInlay(inlay);
        }

        private void clearLeftBorderOfRunnerUi() {
            JBRunnerTabs.JBRunnerTabsBorder border;
            JBRunnerTabs tabs;
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myUi.getComponent());
            RunnerContentUi contentUi = (RunnerContentUi)RunnerContentUi.KEY.getData(dataContext);
            JBRunnerTabs jBRunnerTabs = tabs = contentUi == null ? null : (JBRunnerTabs)ObjectUtils.tryCast((Object)contentUi.getTabs(), JBRunnerTabs.class);
            if (tabs != null && (border = (JBRunnerTabs.JBRunnerTabsBorder)ObjectUtils.tryCast((Object)tabs.getBorder(), JBRunnerTabs.JBRunnerTabsBorder.class)) != null) {
                border.setSideMask(0);
            }
        }

        @Override
        public boolean isStable() {
            return !this.myInProgress;
        }

        @Override
        public boolean isShown() {
            return this.myShown;
        }

        @Override
        @NotNull
        public RunnerLayoutUi getUi() {
            RunnerLayoutUi runnerLayoutUi = this.myUi;
            if (runnerLayoutUi == null) {
                EditorResultsContainer.$$$reportNull$$$0(8);
            }
            return runnerLayoutUi;
        }

        @Override
        @Nullable
        public Inlay<?> getInlay() {
            return this.myInlay;
        }

        private void setInlay(@NotNull Inlay<?> inlay) {
            if (inlay == null) {
                EditorResultsContainer.$$$reportNull$$$0(9);
            }
            this.myInlay = inlay;
            this.myShown = true;
            this.myParentController = new ParentDisposalController(this.myParent);
            Disposer.register((Disposable)this.myParent, this.myInlay);
            Disposer.register(this.myInlay, (Disposable)this.myParentController);
            this.myWeakRef.shown();
        }

        void clearStrongReferences() {
            this.myUi = null;
            this.myInlay = null;
            this.myConsole = null;
            this.myEditor = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isAlive";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWeakRef";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 8: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setInlay";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 8 -> new IllegalStateException(string);
            };
        }

        private static class MyScrollBarListener
        implements AdjustmentListener {
            private final AtomicLong myValue;

            MyScrollBarListener(@NotNull AtomicLong value) {
                if (value == null) {
                    MyScrollBarListener.$$$reportNull$$$0(0);
                }
                this.myValue = value;
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting()) {
                    this.myValue.set(System.currentTimeMillis());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer$MyScrollBarListener", "<init>"));
            }
        }

        private static class ParentDisposalController
        implements Disposable {
            private final Disposable myParent;
            private boolean myDisposalInProgress;

            ParentDisposalController(@NotNull Disposable parent) {
                if (parent == null) {
                    ParentDisposalController.$$$reportNull$$$0(0);
                }
                this.myParent = parent;
            }

            void run(@NotNull Runnable runnable) {
                if (runnable == null) {
                    ParentDisposalController.$$$reportNull$$$0(1);
                }
                if (this.myDisposalInProgress) {
                    return;
                }
                this.myDisposalInProgress = true;
                try {
                    runnable.run();
                }
                finally {
                    this.myDisposalInProgress = false;
                }
            }

            public void dispose() {
                if (!this.myDisposalInProgress) {
                    Disposer.dispose((Disposable)this.myParent);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runnable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer$ParentDisposalController";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class MyJLayeredPane
        extends JLayeredPane {
            private MyJLayeredPane() {
            }

            @Override
            public void doLayout() {
                Component[] components;
                for (Component component : components = this.getComponents()) {
                    component.setBounds(this.getBounds());
                }
            }
        }

        private static class EventTransparentPanel
        extends JPanel {
            private final AtomicLong myTime;

            EventTransparentPanel(@NotNull AtomicLong time) {
                if (time == null) {
                    EventTransparentPanel.$$$reportNull$$$0(0);
                }
                this.myTime = time;
                this.setOpaque(false);
            }

            @Override
            public boolean contains(int x, int y) {
                return System.currentTimeMillis() - this.myTime.get() < 100L && super.contains(x, y);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "time", "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer$EventTransparentPanel", "<init>"));
            }
        }

        private static class MyMouseWheelListener
        implements MouseWheelListener {
            private final JPanel myGlassPane;
            private final JPanel myPanel;
            private final Editor myEditor;
            private final AtomicLong myTime;

            MyMouseWheelListener(@NotNull JPanel glassPane, @NotNull JPanel panel2, @NotNull Editor editor2, @NotNull AtomicLong time) {
                if (glassPane == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(0);
                }
                if (panel2 == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(1);
                }
                if (editor2 == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(2);
                }
                if (time == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(3);
                }
                this.myGlassPane = glassPane;
                this.myPanel = panel2;
                this.myEditor = editor2;
                this.myTime = time;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (System.currentTimeMillis() - this.myTime.get() > 100L && MyMouseWheelListener.redispatch(e, this.myGlassPane, this.myPanel)) {
                    return;
                }
                MouseEventAdapter.redispatch((MouseEvent)e, (Component)this.myEditor.getContentComponent());
            }

            static boolean redispatch(@NotNull MouseEvent e, @NotNull JComponent from, @NotNull JComponent to) {
                if (e == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(4);
                }
                if (from == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(5);
                }
                if (to == null) {
                    MyMouseWheelListener.$$$reportNull$$$0(6);
                }
                Point converted = SwingUtilities.convertPoint(from, e.getPoint(), to);
                Component deepest = UIUtil.getDeepestComponentAt((Component)to, (int)converted.x, (int)converted.y);
                if (deepest == null) {
                    return false;
                }
                MouseEventAdapter.redispatch((MouseEvent)e, (Component)deepest);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "glassPane";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "time";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "from";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "to";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$EditorResultsContainer$MyMouseWheelListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "redispatch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class ContainerWeakRef
    extends WeakReference<EditorResultsContainer> {
        private static final long LIFETIME = TimeUnit.MINUTES.toMillis(5L);
        private final Disposable myParent;
        private long myHiddenTime;

        ContainerWeakRef(@NotNull EditorResultsContainer referent, @NotNull Disposable parent) {
            if (referent == null) {
                ContainerWeakRef.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                ContainerWeakRef.$$$reportNull$$$0(1);
            }
            super(referent);
            this.myHiddenTime = -1L;
            this.myParent = parent;
        }

        boolean isOutdated() {
            return this.myHiddenTime != -1L && System.currentTimeMillis() - this.myHiddenTime > LIFETIME;
        }

        void hidden() {
            this.myHiddenTime = System.currentTimeMillis();
        }

        void shown() {
            this.myHiddenTime = -1L;
        }

        void dispose() {
            Disposer.dispose((Disposable)this.myParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/session/DatabaseInEditorResults$ContainerWeakRef";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GridMeasurements {
        double numberOfRows;
        int scrollBarHeight;
        int bottomHeaderHeight;

        private GridMeasurements() {
        }

        double sum() {
            return this.numberOfRows + (double)this.scrollBarHeight + (double)this.bottomHeaderHeight;
        }
    }

    public static class DatabaseInEditorGridPatcher
    implements NotebookGridPatcher {
        final JLayeredPane myPane;
        final RunnerLayoutUi myUi;
        final Editor myEditor;
        final int myFillerHeight;

        DatabaseInEditorGridPatcher(@NotNull JLayeredPane pane, @NotNull RunnerLayoutUi ui, @NotNull Editor editor2, int fillerHeight) {
            if (pane == null) {
                DatabaseInEditorGridPatcher.$$$reportNull$$$0(0);
            }
            if (ui == null) {
                DatabaseInEditorGridPatcher.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                DatabaseInEditorGridPatcher.$$$reportNull$$$0(2);
            }
            this.myPane = pane;
            this.myUi = ui;
            this.myEditor = editor2;
            this.myFillerHeight = fillerHeight;
        }

        public void updateHeight() {
            int width = this.myPane.getPreferredSize().width;
            this.myPane.setPreferredSize(new Dimension(width, this.getHeight()));
        }

        public void updateBorders() {
            boolean tabsVisible = this.areTabsVisible();
            int thickness = tabsVisible ? 0 : 1;
            PanelBorder border = new PanelBorder(this.myEditor, thickness, thickness, thickness, 1);
            for (Content content : this.myUi.getContents()) {
                DataGrid grid = DatabaseInEditorResults.getGrid(content.getComponent());
                if (grid == null) continue;
                grid.getPanel().getCenterComponent().setBorder((Border)((Object)border));
            }
            PanelBorder componentBorder = tabsVisible ? new PanelBorder(this.myEditor) : null;
            this.myUi.getComponent().setBorder((Border)((Object)componentBorder));
        }

        int getHeight() {
            int tabsHeight = 0;
            if (this.areTabsVisible()) {
                tabsHeight = JBUI.scale((int)28);
            }
            GridMeasurements highestMeasurements = this.getHighestMeasurements();
            DataGrid visibleGrid = DatabaseInEditorResults.getGrid(this.myUi.getComponent());
            if (visibleGrid == null) {
                return this.myEditor.getLineHeight() * 8;
            }
            Component toolbar = visibleGrid.getPanel().getTopComponent();
            int height = toolbar == null ? 0 : toolbar.getPreferredSize().height;
            JTableHeader tableHeader = (JTableHeader)UIUtil.uiTraverser((Component)visibleGrid.getPanel().getComponent()).traverse().filter(JTableHeader.class).first();
            int tableHeaderHeight = tableHeader == null ? 0 : tableHeader.getPreferredSize().height;
            tableHeaderHeight = tableHeaderHeight != 0 ? tableHeaderHeight : new JBValue.UIInteger("TableHeader.height", 25).get();
            height += tableHeaderHeight;
            ResultViewWithRows resultView = (ResultViewWithRows)ObjectUtils.tryCast((Object)visibleGrid.getResultView(), ResultViewWithRows.class);
            height = resultView != null ? (height += ((Integer)ObjectUtils.notNull((Object)SingleRowModeHelper.calculateHeightForInEditorResult((DataGrid)visibleGrid, (int)8), (Object)(resultView.getRowHeight() * (int)highestMeasurements.numberOfRows))).intValue()) : (height += (int)((double)this.myEditor.getLineHeight() * highestMeasurements.numberOfRows));
            Insets gridBorder = visibleGrid.getPanel().getCenterComponent().getInsets();
            return height + this.myFillerHeight + gridBorder.top + gridBorder.bottom + tabsHeight + highestMeasurements.scrollBarHeight + highestMeasurements.bottomHeaderHeight;
        }

        private boolean areTabsVisible() {
            return this.myUi.getContentManager().getContentCount() > 1;
        }

        @NotNull
        GridMeasurements getHighestMeasurements() {
            GridMeasurements highest = new GridMeasurements();
            for (Content content : this.myUi.getContents()) {
                DataGrid grid = DatabaseInEditorResults.getGrid(content.getComponent());
                if (grid == null) continue;
                GridMeasurements measurements = new GridMeasurements();
                JComponent bottomHeader = grid.getPanel().getBottomHeaderComponent();
                measurements.bottomHeaderHeight = bottomHeader == null ? 0 : bottomHeader.getPreferredSize().height;
                int rowCount = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount();
                measurements.numberOfRows = Math.max(Math.min(rowCount, 8), 1);
                if (rowCount > 8) {
                    measurements.numberOfRows += 0.5;
                } else {
                    JBScrollPane scrollPane = (JBScrollPane)ObjectUtils.tryCast((Object)grid.getMainResultViewComponent(), JBScrollPane.class);
                    JScrollBar scrollBar = scrollPane == null ? null : scrollPane.getHorizontalScrollBar();
                    boolean hsbRequiresSpace = scrollBar != null && scrollBar.isVisible() && scrollBar.isOpaque() && !scrollPane.isOverlappingScrollBar();
                    int n = measurements.scrollBarHeight = hsbRequiresSpace ? scrollBar.getPreferredSize().height : 0;
                }
                if (!(measurements.sum() > highest.sum())) continue;
                highest = measurements;
            }
            GridMeasurements gridMeasurements = highest;
            if (gridMeasurements == null) {
                DatabaseInEditorGridPatcher.$$$reportNull$$$0(3);
            }
            return gridMeasurements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pane";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseInEditorResults$DatabaseInEditorGridPatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$DatabaseInEditorGridPatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighestMeasurements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class RemoveCellAction
    extends AnAction {
        private final ResultConstructor myResult;

        RemoveCellAction(@NotNull ResultConstructor result2) {
            if (result2 == null) {
                RemoveCellAction.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message("console.close.embedded.results", new Object[0]));
            this.myResult = result2;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RemoveCellAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveCellAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabledAndVisible(this.myResult.isStable());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveCellAction.$$$reportNull$$$0(3);
            }
            this.myResult.destroy();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseInEditorResults$RemoveCellAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$RemoveCellAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class CloseRenderer
    extends GutterIconRenderer {
        private final ResultConstructor myResult;
        private final RemoveCellAction myAction;
        private final Icon myIcon;

        CloseRenderer(@NotNull ResultConstructor result2, int height) {
            if (result2 == null) {
                CloseRenderer.$$$reportNull$$$0(0);
            }
            this.myResult = result2;
            this.myAction = new RemoveCellAction(this.myResult);
            this.myIcon = new MyIcon(height);
        }

        @Nullable
        public AnAction getClickAction() {
            return this.myAction;
        }

        @Nullable
        public String getTooltipText() {
            return this.myAction.getTemplateText();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            CloseRenderer renderer2 = (CloseRenderer)((Object)o);
            return this.myResult.equals(renderer2.myResult);
        }

        public int hashCode() {
            return this.myResult.hashCode();
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myResult.isStable() ? this.myIcon : EmptyIcon.ICON_0;
            if (icon == null) {
                CloseRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseInEditorResults$CloseRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseInEditorResults$CloseRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        private static class MyIcon
        implements Icon {
            private static final Icon CLOSE = AllIcons.Actions.Close;
            private final int myOffset;

            MyIcon(int offset) {
                this.myOffset = offset;
            }

            @Override
            public int getIconHeight() {
                return CLOSE.getIconHeight() + this.myOffset;
            }

            @Override
            public int getIconWidth() {
                return CLOSE.getIconWidth();
            }

            @Override
            public void paintIcon(Component c2, Graphics g, int x, int y) {
                CLOSE.paintIcon(c2, g, x, y + this.myOffset);
            }
        }
    }

    private static class PanelBorder
    extends CustomLineBorder {
        private final Editor myEditor;

        PanelBorder(@NotNull Editor editor2) {
            if (editor2 == null) {
                PanelBorder.$$$reportNull$$$0(0);
            }
            super((Insets)JBUI.insets((int)1));
            this.myEditor = editor2;
        }

        PanelBorder(@NotNull Editor editor2, int top, int left, int bottom, int right) {
            if (editor2 == null) {
                PanelBorder.$$$reportNull$$$0(1);
            }
            super(top, left, bottom, right);
            this.myEditor = editor2;
        }

        protected Color getColor() {
            return this.myEditor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/session/DatabaseInEditorResults$PanelBorder", "<init>"));
        }
    }
}

