/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.PassProxyOptionProvider;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/console/ProxyParamTuner;", "Lcom/intellij/database/run/ConsoleRunContextParametersTuner;", "<init>", "()V", "tuneParams", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "shouldPassProxySettings", "", "passProxySettings", "toSomeUri", "Ljava/net/URI;", "Companion", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nProxyParamTuner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyParamTuner.kt\ncom/intellij/database/console/ProxyParamTuner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1761#2,3:62\n*S KotlinDebug\n*F\n+ 1 ProxyParamTuner.kt\ncom/intellij/database/console/ProxyParamTuner\n*L\n25#1:62,3\n*E\n"})
public final class ProxyParamTuner
implements ConsoleRunContextParametersTuner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> NON_PROXY;

    @Override
    public void tuneParams(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull SimpleJavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!this.shouldPassProxySettings(dataSource, params)) {
            return;
        }
        this.passProxySettings(dataSource, params);
    }

    private final boolean shouldPassProxySettings(LocalDataSource dataSource, SimpleJavaParameters params) {
        boolean bl;
        block4: {
            List list = params.getVMParametersList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!StringsKt.contains((CharSequence)it, (CharSequence)"proxy", (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        return Intrinsics.areEqual(DbOptionProvider.getOptionValue(dataSource, new PassProxyOptionProvider().getClass()), (Object)true);
    }

    private final void passProxySettings(LocalDataSource dataSource, SimpleJavaParameters params) {
        URI uri = this.toSomeUri(dataSource);
        for (Pair<String, String> opt : DatabaseCoreUiService.getInstance().getProxyOptions(NON_PROXY, uri)) {
            params.getVMParametersList().addProperty((String)opt.first, (String)opt.second);
        }
    }

    private final URI toSomeUri(LocalDataSource dataSource) {
        try {
            JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(dataSource);
            if (parsed == null) {
                return null;
            }
            String host = parsed.getParameter("host");
            if (StringUtil.isEmpty((String)host)) {
                return null;
            }
            int port = StringUtil.parseInt((String)parsed.getParameter("port"), (int)-1);
            return new URI("http", null, host, port, null, null, null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        Object[] objectArray = new String[]{"localhost", "127.0.0.1", "::1"};
        NON_PROXY = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/console/ProxyParamTuner$Companion;", "", "<init>", "()V", "NON_PROXY", "", "", "getNON_PROXY", "()Ljava/util/List;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getNON_PROXY() {
            return NON_PROXY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

