/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.DataSourceInfoPage;
import com.intellij.database.console.DataSourcePage;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/DataSourceInfoTool;", "", "dbDataSource", "Lcom/intellij/database/psi/DbDataSourceImpl;", "toolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "<init>", "(Lcom/intellij/database/psi/DbDataSourceImpl;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "getDbDataSource", "()Lcom/intellij/database/psi/DbDataSourceImpl;", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "Lorg/jetbrains/annotations/NotNull;", "pages", "Ljava/util/ArrayList;", "Lcom/intellij/database/console/DataSourcePage;", "Lkotlin/collections/ArrayList;", "initPages", "", "getComponent", "Ljavax/swing/JComponent;", "intellij.database.impl"})
public final class DataSourceInfoTool {
    @NotNull
    private final DbDataSourceImpl dbDataSource;
    @NotNull
    private final ContentManager contentManager;
    @NotNull
    private final ArrayList<DataSourcePage> pages;

    public DataSourceInfoTool(@NotNull DbDataSourceImpl dbDataSource, @NotNull ActionGroup toolbarActionGroup) {
        Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
        Intrinsics.checkNotNullParameter((Object)toolbarActionGroup, (String)"toolbarActionGroup");
        this.dbDataSource = dbDataSource;
        ContentManager contentManager = ContentFactory.getInstance().createContentManager(ServiceViewUIUtils.getServicesAlignedTabbedPaneContentUI(), false, this.dbDataSource.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"createContentManager(...)");
        this.contentManager = contentManager;
        this.pages = new ArrayList();
        this.initPages();
        Iterator<DataSourcePage> iterator = this.pages.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<DataSourcePage> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Content content;
            DataSourcePage page;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue((Object)this.contentManager.getFactory().createContent(page.getPrimaryComponent(), page.getTabTitleSup().get(), true), (String)"createContent(...)");
            content.setActions(toolbarActionGroup, "ServicesToolbar", content.getComponent());
            this.contentManager.addContent(content);
        }
    }

    @NotNull
    public final DbDataSourceImpl getDbDataSource() {
        return this.dbDataSource;
    }

    private final void initPages() {
        ((Collection)this.pages).add(new DataSourceInfoPage(this.dbDataSource));
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.contentManager.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }
}

