/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.util;

import com.intellij.database.actions.util.Value;
import com.intellij.database.console.session.PerProjectFileAttributes;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0000\u001a0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"valueLOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getCurrentSettingId", "", "settingName", "isSettingEnabled", "", "perProjectFileAttributes", "Lcom/intellij/database/console/session/PerProjectFileAttributes;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "valueByDefault", "saveSettingValue", "", "value", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nSettingsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsUtils.kt\ncom/intellij/database/actions/util/SettingsUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n1#2:67\n14#3:68\n*S KotlinDebug\n*F\n+ 1 SettingsUtils.kt\ncom/intellij/database/actions/util/SettingsUtilsKt\n*L\n11#1:68\n*E\n"})
public final class SettingsUtilsKt {
    @NotNull
    private static final Logger valueLOG;

    @NotNull
    public static final String getCurrentSettingId(@NotNull String settingName) {
        Intrinsics.checkNotNullParameter((Object)settingName, (String)"settingName");
        PropertiesComponent component = PropertiesComponent.getInstance();
        String value = component.getValue(settingName);
        String string = value;
        if (string == null) {
            String string2;
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String it = string2 = string3;
            boolean bl = false;
            component.setValue(settingName, it);
            string = string2;
        }
        return string;
    }

    public static final boolean isSettingEnabled(@NotNull String settingName, @NotNull PerProjectFileAttributes perProjectFileAttributes, @NotNull Project project, @NotNull VirtualFile file, boolean valueByDefault) {
        Value value;
        String savedValue;
        Intrinsics.checkNotNullParameter((Object)settingName, (String)"settingName");
        Intrinsics.checkNotNullParameter((Object)perProjectFileAttributes, (String)"perProjectFileAttributes");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileAttribute fileAttribute = perProjectFileAttributes.get(project);
        if (fileAttribute == null) {
            return false;
        }
        FileAttribute attributes = fileAttribute;
        String id = SettingsUtilsKt.getCurrentSettingId(settingName);
        String string = savedValue = DbImplUtilCore.readVFSAttributeSafe(file, attributes);
        if (string != null) {
            String it = string;
            boolean bl = false;
            value = Value.Companion.from(it);
        } else {
            value = null;
        }
        Value value2 = value;
        return value2 == null || !Intrinsics.areEqual((Object)value2.getId(), (Object)id) ? valueByDefault : value2.getState();
    }

    public static final void saveSettingValue(@NotNull String settingName, @NotNull PerProjectFileAttributes perProjectFileAttributes, @NotNull Project project, @NotNull VirtualFile file, boolean value) {
        Intrinsics.checkNotNullParameter((Object)settingName, (String)"settingName");
        Intrinsics.checkNotNullParameter((Object)perProjectFileAttributes, (String)"perProjectFileAttributes");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String id = SettingsUtilsKt.getCurrentSettingId(settingName);
        FileAttribute fileAttribute = perProjectFileAttributes.get(project);
        if (fileAttribute == null) {
            return;
        }
        FileAttribute attributes = fileAttribute;
        DbImplUtilCore.writeVFSAttributeSafe(file, attributes, new Value(id, value).toString());
    }

    public static final /* synthetic */ Logger access$getValueLOG$p() {
        return valueLOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(Value.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        valueLOG = logger2;
    }
}

