/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.diagnostic;

import com.intellij.database.actions.diagnostic.DiagnosticFormatterKt;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u000b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\u0010\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0002J\f\u0010\u0015\u001a\u00020\u0005*\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/actions/diagnostic/DiagnosticFormatter;", "Ljava/util/logging/Formatter;", "<init>", "()V", "format", "", "record", "Ljava/util/logging/LogRecord;", "formatTime", "instant", "Ljava/time/Instant;", "appendTrimmed", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "str", "", "insertLinePrefix", "prefix", "fromIndex", "", "tillIndex", "toStr2", "intellij.database.connectivity"})
public final class DiagnosticFormatter
extends Formatter {
    @NotNull
    public static final DiagnosticFormatter INSTANCE = new DiagnosticFormatter();

    private DiagnosticFormatter() {
    }

    @Override
    @NotNull
    public String format(@NotNull LogRecord record) {
        String string;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        StringBuilder b = new StringBuilder();
        String timeStr = this.formatTime(record.getInstant());
        b.append(timeStr).append("  ");
        boolean was = false;
        LogRecord logRecord = record;
        if (logRecord instanceof DatabaseGlobalAuditService.DatabaseLogBlockRecord) {
            int p1 = b.length();
            for (DatabaseGlobalAuditService.Block block : ((DatabaseGlobalAuditService.DatabaseLogBlockRecord)record).getBlocks()) {
                String text2 = block.getText();
                if (((CharSequence)text2).length() == 0) continue;
                DatabaseGlobalAuditService.BlockType blockType = block.getType();
                if (blockType == DatabaseGlobalAuditService.BlockType.STATEMENT) {
                    b.append("Executing query:");
                    b.append("\n-- 8< --\n");
                    this.appendTrimmed(b, text2);
                    b.append("\n-- >8 --\n");
                    was = true;
                    continue;
                }
                if (!DiagnosticFormatterKt.access$getConsiderBlockTypes$p().contains((Object)blockType)) continue;
                this.appendTrimmed(b, text2).append('\n');
                was = true;
            }
            this.insertLinePrefix(b, "          ", p1, b.length() - 1);
        } else if (logRecord instanceof DatabaseGlobalAuditService.DatabaseLogRecord) {
            String msg = ((DatabaseGlobalAuditService.DatabaseLogRecord)record).getMessage();
            Intrinsics.checkNotNull((Object)msg);
            this.appendTrimmed(b, msg);
            DiagnosticFormatter.insertLinePrefix$default(this, b, "          ", 0, 0, 6, null);
            b.append('\n');
            boolean bl = was = ((CharSequence)msg).length() > 0;
        }
        if (was) {
            String string2 = b.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            string = "";
        }
        return string;
    }

    private final String formatTime(Instant instant) {
        if (instant == null) {
            return "        ";
        }
        ZonedDateTime time = instant.atZone(ZoneId.systemDefault());
        String h = this.toStr2(time.getHour());
        String m = this.toStr2(time.getMinute());
        String s = this.toStr2(time.getSecond());
        return h + ":" + m + ":" + s;
    }

    private final StringBuilder appendTrimmed(StringBuilder $this$appendTrimmed, CharSequence str) {
        int n;
        int b = 0;
        for (n = str.length(); n > 0 && CharsKt.isWhitespace((char)str.charAt(n - 1)); --n) {
        }
        while (b < n && CharsKt.isWhitespace((char)str.charAt(b))) {
            ++b;
        }
        $this$appendTrimmed.append(str, b, n);
        return $this$appendTrimmed;
    }

    private final StringBuilder insertLinePrefix(StringBuilder $this$insertLinePrefix, String prefix, int fromIndex, int tillIndex) {
        int i2 = tillIndex - 1;
        if (fromIndex <= i2) {
            while (true) {
                if ($this$insertLinePrefix.charAt(i2) == '\n') {
                    $this$insertLinePrefix.insert(i2 + 1, prefix);
                }
                if (i2 == fromIndex) break;
                --i2;
            }
        }
        return $this$insertLinePrefix;
    }

    static /* synthetic */ StringBuilder insertLinePrefix$default(DiagnosticFormatter diagnosticFormatter, StringBuilder stringBuilder, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = stringBuilder.length();
        }
        return diagnosticFormatter.insertLinePrefix(stringBuilder, string, n, n2);
    }

    private final String toStr2(int $this$toStr2) {
        String string;
        if ($this$toStr2 < 10) {
            char c2 = '0';
            String string2 = String.valueOf($this$toStr2);
            string = c2 + string2;
        } else {
            string = String.valueOf($this$toStr2);
        }
        return string;
    }
}

