/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.intentions.RunQueryIntentionActionAvailable;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunQueryAction
extends QueryActionBase {
    private final int myIndex;

    RunQueryAction(int index) {
        this.myIndex = index;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunQueryAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (e.getPlace().contains("EditorFloatingToolbar") && (virtualFile instanceof DatabaseElementVirtualFileImpl || DbSrcUtilsCore.isDbSrcFile(virtualFile))) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @Override
    protected boolean isEnabled(@Nullable JdbcConsole console, Editor editor2, PsiFile file) {
        for (RunQueryIntentionActionAvailable provider : RunQueryIntentionActionAvailable.EP_NAME.getExtensionList()) {
            if (provider.isAvailable(editor2)) continue;
            return false;
        }
        return !SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file.getVirtualFile());
    }

    @Override
    protected boolean isConsoleRequired() {
        return false;
    }

    @Override
    @NotNull
    protected DatabaseSettings.ExecOption getExecOption() {
        DatabaseSettings.ExecOption execOption = DatabaseSettings.getSettings().execOptions.get(this.myIndex - 1);
        if (execOption == null) {
            RunQueryAction.$$$reportNull$$$0(1);
        }
        return execOption;
    }

    @Override
    protected void onElementNotFound(@NotNull Editor editor2) {
        if (editor2 == null) {
            RunQueryAction.$$$reportNull$$$0(2);
        }
        HintManager.getInstance().showErrorHint(editor2, DatabaseBundle.message("hint.text.nothing.to.run", new Object[0]));
    }

    @Override
    protected void invokeImpl(@NotNull AnActionEvent e, JdbcConsole console, @NotNull JdbcConsoleProvider.Info info2) {
        if (e == null) {
            RunQueryAction.$$$reportNull$$$0(3);
        }
        if (info2 == null) {
            RunQueryAction.$$$reportNull$$$0(4);
        }
        if (console == null) {
            List<PersistenceConsoleProvider.Runner> runners = DatabaseRunners.getAttachDataSourceSchemasRunners(info2);
            if (runners.isEmpty() && info2.editor != null) {
                HintManager.getInstance().showErrorHint((Editor)info2.editor, DatabaseBundle.message("hint.text.nothing.to.run", new Object[0]));
                return;
            }
            RunQueryInConsoleIntentionAction.Manager.chooseAndRunRunners(DatabaseRunners.getAttachDataSourceSchemasRunners(info2), (Editor)info2.editor, e);
        } else {
            JdbcConsoleProvider.doRunQueryInConsole(console, info2);
        }
    }

    @Override
    protected void invokeImpl(@Nullable JdbcConsole console, @NotNull ScriptModel<?> scriptModel, @NotNull JdbcConsoleProvider.Info info2) {
        if (scriptModel == null) {
            RunQueryAction.$$$reportNull$$$0(5);
        }
        if (info2 == null) {
            RunQueryAction.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/RunQueryAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/RunQueryAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onElementNotFound";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class Alt3
    extends RunQueryAction {
        public Alt3() {
            super(3);
        }
    }

    public static class Alt2
    extends RunQueryAction {
        public Alt2() {
            super(2);
        }
    }

    public static class Alt1
    extends RunQueryAction {
        public Alt1() {
            super(1);
        }
    }
}

