/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.PerformActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QueryActionBase
extends PerformActionBase
implements Toggleable {
    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(0);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformCoreDataKeys.FILE_EDITOR);
        JdbcConsole console = QueryActionBase.getConsole(e);
        PsiElement @Nullable [] elements = (PsiElement[])e.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY);
        boolean applicable = QueryActionBase.isEditorOrStructurePopup(editor2, fileEditor) && (!this.isConsoleRequired() || console != null) && this.isApplicable(console, editor2, file) && !"EditorTabPopup".equals(e.getPlace());
        boolean bl = enabled = applicable && this.isEnabled(console, editor2, file) && (editor2 != null || elements != null && elements.length > 0);
        if (enabled && console != null && console.isValid()) {
            Editor resultEditor = editor2 == null ? ((TextEditor)fileEditor).getEditor() : editor2;
            TextRange range = ScriptModelUtil.getSelectedStatementsRange(console, resultEditor, this.getExecOption());
            e.getPresentation().setEnabled(range.getLength() > 0);
            e.getPresentation().setVisible(true);
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(applicable || e.isFromActionToolbar());
    }

    private static boolean isEditorOrStructurePopup(@Nullable Editor editor2, @Nullable FileEditor fileEditor) {
        return EditorUtil.isRealFileEditor((Editor)editor2) || editor2 == null && fileEditor instanceof TextEditor;
    }

    static boolean shouldBePromoted(@NotNull DataContext context) {
        if (context == null) {
            QueryActionBase.$$$reportNull$$$0(1);
        }
        FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(context);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context);
        return QueryActionBase.isEditorOrStructurePopup(editor2, fileEditor);
    }

    protected boolean isApplicable(@Nullable JdbcConsole console, @Nullable Editor editor2, @Nullable PsiFile file) {
        return JdbcConsoleProvider.isSqlAtPlace(file, editor2) || console != null && JdbcConsoleProvider.isJSAtPlace(file, editor2);
    }

    protected boolean isEnabled(@Nullable JdbcConsole console, Editor editor2, PsiFile file) {
        return true;
    }

    protected boolean isConsoleRequired() {
        return true;
    }

    @NotNull
    protected DatabaseSettings.ExecOption getExecOption() {
        DatabaseSettings.ExecOption execOption = DatabaseSettings.getDefaultExecOption();
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(2);
        }
        return execOption;
    }

    protected void onElementNotFound(@NotNull Editor editor2) {
        if (editor2 == null) {
            QueryActionBase.$$$reportNull$$$0(3);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        DatabaseSettings.ExecOption option = this.getExecOption();
        JdbcConsoleProvider.Info info2 = (JdbcConsoleProvider.Info)ObjectUtils.chooseNotNull((Object)QueryActionBase.getInfoClassic(e, option, editor2 -> this.onElementNotFound((Editor)editor2)), (Object)QueryActionBase.findInfoFromFileStructure(e, option));
        if (info2 == null) {
            return;
        }
        this.invokeImpl(e, QueryActionBase.getConsole(e), info2);
    }

    @Nullable
    public static JdbcConsoleProvider.Info getInfoClassic(@NotNull AnActionEvent e, @NotNull DatabaseSettings.ExecOption execOption, @Nullable Consumer<Editor> onElementNotFound) {
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(5);
        }
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(6);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        return QueryActionBase.getInfoClassic(file, editor2, execOption, onElementNotFound);
    }

    @Nullable
    public static JdbcConsoleProvider.Info getInfoClassic(@Nullable PsiFile file, @Nullable Editor editor2, @NotNull DatabaseSettings.ExecOption execOption, @Nullable Consumer<Editor> onElementNotFound) {
        PsiElement elementAt;
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(7);
        }
        if ((elementAt = JdbcConsoleProvider.elementAt(file, null, editor2)) == null) {
            if (editor2 != null && onElementNotFound != null) {
                onElementNotFound.accept(editor2);
            }
            return null;
        }
        return JdbcConsoleProvider.findScriptModel(file, elementAt, editor2, execOption);
    }

    @Nullable
    private static JdbcConsoleProvider.Info findInfoFromFileStructure(@NotNull AnActionEvent e, @NotNull DatabaseSettings.ExecOption execOption) {
        Editor editor2;
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(8);
        }
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(9);
        }
        JBIterable elements = JBIterable.of((Object[])((PsiElement[])e.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY)));
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformCoreDataKeys.FILE_EDITOR);
        if (fileEditor instanceof TextEditor) {
            TextEditor o = (TextEditor)fileEditor;
            v0 = o.getEditor();
        } else {
            v0 = editor2 = null;
        }
        if (file == null || elements.isEmpty() || editor2 == null) {
            return null;
        }
        HashSet<TextRange> set = new HashSet<TextRange>();
        for (PsiElement pe : elements) {
            if (!file.equals(pe.getContainingFile())) {
                return null;
            }
            set.add(pe.getTextRange());
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        ScriptModel<?> model = QueryActionBase.filterRanges(SqlPsiFacade.getInstance(project).createScriptModel(file), set);
        return new JdbcConsoleProvider.Info(file, file, (EditorEx)editor2, model, execOption, null);
    }

    private static <V> ScriptModel<V> filterRanges(ScriptModel<V> model, final Set<TextRange> set) {
        return model.rawTransform(new Function.Mono<SyntaxTraverser<V>>(){

            public SyntaxTraverser<V> fun(SyntaxTraverser<V> s) {
                return (SyntaxTraverser)s.regard(Conditions.compose((Function)s.api.TO_RANGE, range -> set.contains(range)));
            }
        });
    }

    protected void invokeImpl(@NotNull AnActionEvent e, @Nullable JdbcConsole console, @NotNull JdbcConsoleProvider.Info info2) {
        if (e == null) {
            QueryActionBase.$$$reportNull$$$0(10);
        }
        if (info2 == null) {
            QueryActionBase.$$$reportNull$$$0(11);
        }
        JdbcConsoleProvider.chooseStatements(info2, DatabaseBundle.message("no.query.found", new Object[0]), false, scriptModel -> this.invokeImpl(console, (ScriptModel<?>)scriptModel, info2));
    }

    protected abstract void invokeImpl(@Nullable JdbcConsole var1, @NotNull ScriptModel<?> var2, @NotNull JdbcConsoleProvider.Info var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/QueryActionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/QueryActionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldBePromoted";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onElementNotFound";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInfoClassic";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findInfoFromFileStructure";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

