/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"getSelectDbAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "file", "", "findOrCreateEditor", "Lcom/intellij/openapi/editor/Editor;", "target", "Lcom/intellij/database/psi/DbElement;", "preferExisting", "moveCaretToEnd", "", "editor", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.impl"})
@JvmName(name="DbActionUtils")
@SourceDebugExtension(value={"SMAP\nDbActionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbActionUtils.kt\ncom/intellij/database/actions/DbActionUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n295#2:68\n296#2:70\n1#3:69\n*S KotlinDebug\n*F\n+ 1 DbActionUtils.kt\ncom/intellij/database/actions/DbActionUtils\n*L\n38#1:68\n38#1:70\n*E\n"})
public final class DbActionUtils {
    @NotNull
    public static final AnAction getSelectDbAction(boolean file) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(file, !file, false, false, false, false);
        descriptor2.setHideIgnored(false);
        Object[] objectArray = new Object[]{file ? DatabaseBundle.message("dialog.title.choose.database.file", new Object[0]) : DatabaseBundle.message("dialog.title.choose.database.path", new Object[0])};
        descriptor2.setTitle(DatabaseBundle.message("dialog.title.choose.database", objectArray));
        return (AnAction)new ParamEditorBase.FMChooseAction(descriptor2);
    }

    @Nullable
    public static final Editor findOrCreateEditor(@NotNull DbElement target2, boolean preferExisting) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Project project = target2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DbDataSource dbDataSource = target2.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        DbDataSource dataSource = dbDataSource;
        if (preferExisting) {
            Object v4;
            block8: {
                Project project3 = target2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                Iterable $this$firstOrNull$iv = EditorTracker.Companion.getInstance(project3).getActiveEditors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DbDataSource dbDataSource2;
                    Editor it = (Editor)element$iv;
                    boolean bl = false;
                    if (DbActionUtils.getVirtualFile(it, project2) != null) {
                        VirtualFile it2;
                        boolean bl2 = false;
                        dbDataSource2 = DbVFSUtils.getDataSource(project2, it2);
                    } else {
                        dbDataSource2 = null;
                    }
                    if (!Intrinsics.areEqual(dbDataSource2, (Object)dataSource)) continue;
                    v4 = element$iv;
                    break block8;
                }
                v4 = null;
            }
            Editor activeEditor = v4;
            if (activeEditor != null) {
                VirtualFile virtualFile = DbActionUtils.getVirtualFile(activeEditor, project2);
                Intrinsics.checkNotNull((Object)virtualFile);
                VirtualFile virtualFile2 = virtualFile;
                FileEditorManager.getInstance((Project)project2).openFile(virtualFile2, true);
                return activeEditor;
            }
        }
        VirtualFile virtualFile = DbUIUtil.openInConsole(dataSource, target2, "", preferExisting);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(vFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Editor[] editorArray = EditorFactory.getInstance().getEditors(document2, project2);
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
        return (Editor)ArraysKt.firstOrNull((Object[])editorArray);
    }

    public static final void moveCaretToEnd(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int textLength = document2.getTextLength();
        if (textLength > 0 && document2.getCharsSequence().charAt(textLength - 1) != '\n') {
            WriteCommandAction.runWriteCommandAction((Project)editor2.getProject(), null, null, () -> DbActionUtils.moveCaretToEnd$lambda$2(document2, textLength), (PsiFile[])new PsiFile[0]);
        }
        editor2.getCaretModel().moveToOffset(document2.getTextLength());
    }

    private static final VirtualFile getVirtualFile(Editor $this$getVirtualFile, Project project) {
        PsiFile psiFile;
        Document document = $this$getVirtualFile.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiFile psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document2);
        return psiFile2 != null ? psiFile2.getVirtualFile() : null;
    }

    private static final void moveCaretToEnd$lambda$2(Document $document, int $textLength) {
        $document.insertString($textLength, (CharSequence)"\n");
    }
}

