/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceSettingsCapsule;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001d\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/actions/CreateDataSourceFromSettings;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkDestination", "", "findOurFlavor", "Ljava/awt/datatransfer/DataFlavor;", "flavors", "", "([Ljava/awt/datatransfer/DataFlavor;)Ljava/awt/datatransfer/DataFlavor;", "actionPerformed", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nCreateDataSourceFromSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateDataSourceFromSettings.kt\ncom/intellij/database/actions/CreateDataSourceFromSettings\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,73:1\n1310#2,2:74\n*S KotlinDebug\n*F\n+ 1 CreateDataSourceFromSettings.kt\ncom/intellij/database/actions/CreateDataSourceFromSettings\n*L\n64#1:74,2\n*E\n"})
public final class CreateDataSourceFromSettings
extends DumbAwareAction {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MIME_SUFFIX = "class=" + Reflection.getOrCreateKotlinClass(DataSourceSettingsCapsule.class).getQualifiedName();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || !this.checkDestination(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = false;
        Transferable t = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (t != null) {
            if (t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR)) {
                enabled = true;
            } else {
                DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
                Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
                if (this.findOurFlavor(dataFlavorArray) != null) {
                    enabled = true;
                } else if (!t.isDataFlavorSupported(DataFlavor.imageFlavor) && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    enabled = true;
                }
            }
        }
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private final boolean checkDestination(AnActionEvent e) {
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        if (StringsKt.endsWith$default((String)string, (String)"DatabaseViewToolbar", (boolean)false, (int)2, null)) {
            return true;
        }
        String string2 = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPlace(...)");
        if (StringsKt.endsWith$default((String)string2, (String)"DatabaseViewPopup", (boolean)false, (int)2, null)) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            return DatabaseViewTreeFun.isSelectedOneGroup(dataContext);
        }
        return false;
    }

    private final DataFlavor findOurFlavor(DataFlavor[] flavors) {
        DataFlavor dataFlavor;
        block1: {
            DataFlavor[] $this$firstOrNull$iv = flavors;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int j = 0; j < n; ++j) {
                DataFlavor element$iv;
                DataFlavor it = element$iv = $this$firstOrNull$iv[j];
                boolean bl = false;
                String string = it.getMimeType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMimeType(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)MIME_SUFFIX, (boolean)false, (int)2, null)) continue;
                dataFlavor = element$iv;
                break block1;
            }
            dataFlavor = null;
        }
        return dataFlavor;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataSourceSettingsHelperKt.importDataSourcesFromClipboard(project2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/actions/CreateDataSourceFromSettings$Companion;", "", "<init>", "()V", "MIME_SUFFIX", "", "getMIME_SUFFIX", "()Ljava/lang/String;", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMIME_SUFFIX() {
            return MIME_SUFFIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

