/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.access.LocalCredentialManager;
import com.intellij.database.dataSource.LocalDataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/access/OneTimeCredentialManager;", "Lcom/intellij/database/access/LocalCredentialManager;", "backend", "Lcom/intellij/database/access/DbCredentialManager;", "<init>", "(Lcom/intellij/database/access/DbCredentialManager;)V", "getBackend", "()Lcom/intellij/database/access/DbCredentialManager;", "setPassword", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "password", "Lcom/intellij/credentialStore/OneTimeString;", "storage", "Lcom/intellij/database/dataSource/LocalDataSource$Storage;", "prefix", "", "getPassword", "intellij.database.impl"})
public final class OneTimeCredentialManager
extends LocalCredentialManager {
    @NotNull
    private final DbCredentialManager backend;

    public OneTimeCredentialManager(@NotNull DbCredentialManager backend) {
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        this.backend = backend;
    }

    @NotNull
    public final DbCredentialManager getBackend() {
        return this.backend;
    }

    @Override
    public void setPassword(@NotNull LocalDataSource dataSource, @Nullable OneTimeString password, @NotNull LocalDataSource.Storage storage, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
        if (storage.isOneTime()) {
            super.setPassword(dataSource, password, LocalDataSource.Storage.MEMORY, prefix);
        }
        this.backend.setPassword(dataSource, password, storage, prefix);
    }

    @Override
    @Nullable
    public OneTimeString getPassword(@NotNull LocalDataSource dataSource, @NotNull LocalDataSource.Storage storage, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
        OneTimeString oneTimeString = super.getPassword(dataSource, LocalDataSource.Storage.MEMORY, prefix);
        if (oneTimeString == null) {
            oneTimeString = this.backend.getPassword(dataSource, storage, prefix);
        }
        return oneTimeString;
    }
}

