/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.ExceptionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\rJ\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0007J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/access/DatabaseCredentials;", "", "credentialManager", "Lcom/intellij/database/access/DbCredentialManager;", "<init>", "(Lcom/intellij/database/access/DbCredentialManager;)V", "getCredentialManager", "()Lcom/intellij/database/access/DbCredentialManager;", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "loadPassword", "Lcom/intellij/credentialStore/OneTimeString;", "key", "", "getPassword", "info", "Lcom/intellij/database/model/DasDataSource;", "getSslPassphrase", "storePassword", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "password", "setPassword", "setSslPassphrase", "handleSessionFinished", "getSshPassword", "getSshPassphrase", "Companion", "intellij.database.core.impl"})
public class DatabaseCredentials {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DbCredentialManager credentialManager;
    @NotNull
    private static final String DB_SSL_PHR = "db:ssl:phr@";

    public DatabaseCredentials(@NotNull DbCredentialManager credentialManager) {
        Intrinsics.checkNotNullParameter((Object)credentialManager, (String)"credentialManager");
        this.credentialManager = credentialManager;
    }

    @NotNull
    public final DbCredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    @NotNull
    public final Credentials getCredentials(@NotNull DatabaseConnectionPoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return new Credentials(LocalDataSource.getUsername(point), DatabaseCredentials.loadPassword$default(this, point, null, 2, null));
    }

    @JvmOverloads
    @Nullable
    public final OneTimeString loadPassword(@NotNull DatabaseConnectionPoint point, @Nullable String key2) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        LocalDataSource localDataSource = point.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        LocalDataSource dataSource = localDataSource;
        String prefix = DatabaseCredentials.Companion.getPasswordPrefix(point, key2);
        LocalDataSource.Storage storage = LocalDataSource.getPasswordStorage(point);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)storage), (String)"getPasswordStorage(...)");
        return this.credentialManager.getPassword(dataSource, storage, prefix);
    }

    public static /* synthetic */ OneTimeString loadPassword$default(DatabaseCredentials databaseCredentials, DatabaseConnectionPoint databaseConnectionPoint, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadPassword");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return databaseCredentials.loadPassword(databaseConnectionPoint, string);
    }

    @Deprecated(message="Use loadPassword")
    @Nullable
    public final OneTimeString getPassword(@NotNull DasDataSource info2) {
        LocalDataSource dataSource;
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        LocalDataSource localDataSource = dataSource = DatabaseCredentials.Companion.getLocalDataSource(info2);
        return localDataSource == null ? null : DatabaseCredentials.loadPassword$default(this, localDataSource, null, 2, null);
    }

    @Nullable
    public final OneTimeString getSslPassphrase(@NotNull DasDataSource info2) {
        OneTimeString oneTimeString;
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        LocalDataSource dataSource = DatabaseCredentials.Companion.getLocalDataSource(info2);
        if (dataSource == null) {
            return null;
        }
        DataSourceSslConfiguration cfg = dataSource.getSslCfg();
        if (cfg == null || !cfg.myEnabled) {
            oneTimeString = null;
        } else {
            LocalDataSource.Storage storage = cfg.myPasswordStorage;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)storage), (String)"myPasswordStorage");
            oneTimeString = this.credentialManager.getPassword(dataSource, storage, DB_SSL_PHR);
        }
        return oneTimeString;
    }

    public final void storePassword(@NotNull DatabaseConnectionConfig config, @Nullable OneTimeString password) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.storePassword(config, null, password);
    }

    public final void storePassword(@NotNull DatabaseConnectionConfig config, @Nullable String key2, @Nullable OneTimeString password) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        LocalDataSource localDataSource = config.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        LocalDataSource dataSource = localDataSource;
        String prefix = DatabaseCredentials.Companion.getPasswordPrefix(config, key2);
        LocalDataSource.Storage storage = LocalDataSource.getPasswordStorage(config);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)storage), (String)"getPasswordStorage(...)");
        this.credentialManager.setPassword(dataSource, password, storage, prefix);
    }

    @Deprecated(message="Use storePassword ")
    public final void setPassword(@NotNull DasDataSource info2, @Nullable OneTimeString password) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        LocalDataSource dataSource = DatabaseCredentials.Companion.getLocalDataSource(info2);
        if (dataSource == null) {
            return;
        }
        this.storePassword(dataSource, password);
    }

    public final void setSslPassphrase(@NotNull DasDataSource info2, @Nullable OneTimeString password) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        LocalDataSource dataSource = DatabaseCredentials.Companion.getLocalDataSource(info2);
        if (dataSource == null) {
            return;
        }
        DataSourceSslConfiguration cfg = dataSource.getSslCfg();
        if (cfg == null || !cfg.myEnabled) {
            return;
        }
        LocalDataSource.Storage storage = cfg.myPasswordStorage;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)storage), (String)"myPasswordStorage");
        this.credentialManager.setPassword(dataSource, password, storage, DB_SSL_PHR);
    }

    public final void handleSessionFinished(@NotNull DasDataSource info2) {
        DataSourceSslConfiguration ssl;
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        LocalDataSource dataSource = DatabaseCredentials.Companion.getLocalDataSource(info2);
        if (dataSource == null) {
            return;
        }
        LocalDataSource.Storage storage = dataSource.getPasswordStorage();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)storage), (String)"getPasswordStorage(...)");
        LocalDataSource.Storage storage2 = storage;
        if (storage2 == LocalDataSource.Storage.SESSION) {
            this.storePassword(dataSource, null);
        }
        if ((ssl = dataSource.getSslCfg()) != null && ssl.myPasswordStorage == LocalDataSource.Storage.SESSION) {
            this.setSslPassphrase(info2, null);
        }
    }

    @Deprecated(message="")
    @Nullable
    public final OneTimeString getSshPassword(@NotNull DasDataSource info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        LocalDataSource dataSource = info2 instanceof LocalDataSource ? (LocalDataSource)info2 : null;
        return dataSource != null ? this.credentialManager.getPassword(dataSource, LocalDataSource.Storage.PERSIST, "db:ssh:pwd@") : null;
    }

    @Deprecated(message="")
    @Nullable
    public final OneTimeString getSshPassphrase(@NotNull DasDataSource info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        LocalDataSource dataSource = info2 instanceof LocalDataSource ? (LocalDataSource)info2 : null;
        return dataSource != null ? this.credentialManager.getPassword(dataSource, LocalDataSource.Storage.PERSIST, "db:ssh:phr@") : null;
    }

    @JvmOverloads
    @Nullable
    public final OneTimeString loadPassword(@NotNull DatabaseConnectionPoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return DatabaseCredentials.loadPassword$default(this, point, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final DatabaseCredentials getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J|\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u001c\u0010\u0017\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00182$\u0010\u001a\u001a \b\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u00020\u00160\u0018H\u0086@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/access/DatabaseCredentials$Companion;", "", "<init>", "()V", "DB_SSL_PHR", "", "getInstance", "Lcom/intellij/database/access/DatabaseCredentials;", "getLocalDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "info", "Lcom/intellij/database/model/DasDataSource;", "getPasswordPrefix", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "key", "getSessionTemplatePrefix", "getInitialCredentials", "T", "storage", "Lcom/intellij/database/dataSource/LocalDataSource$Storage;", "canAskPassword", "", "get", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "ask", "Lkotlin/Function2;", "", "isEmpty", "(Lcom/intellij/database/dataSource/LocalDataSource$Storage;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseCredentials.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseCredentials.kt\ncom/intellij/database/access/DatabaseCredentials$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n30#2,2:151\n1#3:153\n*S KotlinDebug\n*F\n+ 1 DatabaseCredentials.kt\ncom/intellij/database/access/DatabaseCredentials$Companion\n*L\n104#1:151,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DatabaseCredentials getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DatabaseCredentials> serviceClass$iv = DatabaseCredentials.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DatabaseCredentials)object;
        }

        private final LocalDataSource getLocalDataSource(DasDataSource info2) {
            return info2 instanceof LocalDataSource ? (LocalDataSource)info2 : null;
        }

        private final String getPasswordPrefix(DatabaseConnectionPoint point, String key2) {
            Object object;
            String prefix = this.getSessionTemplatePrefix(point);
            if (key2 == null) {
                object = prefix;
            } else {
                String string = prefix;
                if (string == null) {
                    string = "";
                }
                object = string + "[" + key2 + "]";
            }
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getSessionTemplatePrefix(DatabaseConnectionPoint point) {
            DataSourceSessionTemplate dataSourceSessionTemplate;
            DataSourceSessionTemplate template;
            DatabaseConnectionConfig databaseConnectionConfig = point.getMutableConfig();
            if (!(databaseConnectionConfig instanceof DataSourceSessionTemplate)) return null;
            DataSourceSessionTemplate dataSourceSessionTemplate2 = (DataSourceSessionTemplate)databaseConnectionConfig;
            DataSourceSessionTemplate dataSourceSessionTemplate3 = template = dataSourceSessionTemplate2;
            DataSourceSessionTemplate dataSourceSessionTemplate4 = dataSourceSessionTemplate3;
            if (dataSourceSessionTemplate3 == null) return null;
            DataSourceSessionTemplate it = dataSourceSessionTemplate = dataSourceSessionTemplate4;
            boolean bl = false;
            if (it.getAuthProviderIdOverride() == null) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            DataSourceSessionTemplate dataSourceSessionTemplate5 = dataSourceSessionTemplate;
            dataSourceSessionTemplate4 = dataSourceSessionTemplate5;
            if (dataSourceSessionTemplate5 == null) return null;
            it = dataSourceSessionTemplate4;
            boolean bl3 = false;
            String string = "tpl:" + it.getTemplateId();
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final <T> Object getInitialCredentials(@NotNull LocalDataSource.Storage storage, boolean canAskPassword, @NotNull Function1<? super Continuation<? super T>, ? extends Object> get, @NotNull Function2<? super Throwable, ? super Continuation<? super T>, ? extends Object> ask, @NotNull Function1<? super T, Boolean> isEmpty, @NotNull Continuation<? super T> $completion) {
            block21: {
                if (!($completion instanceof getInitialCredentials.1)) ** GOTO lbl-1000
                var9_7 = $completion;
                if ((var9_7.label & -2147483648) != 0) {
                    var9_7.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        boolean Z$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ Companion this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getInitialCredentials(null, false, null, null, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var10_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!storage.isOneTime() || !canAskPassword) break;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)storage);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)get);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)ask);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)isEmpty);
                        $continuation.Z$0 = canAskPassword;
                        $continuation.label = 1;
                        v0 = ask.invoke(null, $continuation);
                        if (v0 == var10_9) {
                            return var10_9;
                        }
                        ** GOTO lbl31
                    }
                    case 1: {
                        canAskPassword = $continuation.Z$0;
                        isEmpty = (Function1)$continuation.L$3;
                        ask = (Function2)$continuation.L$2;
                        get = (Function1)$continuation.L$1;
                        storage = (LocalDataSource.Storage)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl31:
                        // 2 sources

                        return v0;
                    }
                }
                if (canAskPassword) break block21;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)storage);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)get);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)ask);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)isEmpty);
                $continuation.Z$0 = canAskPassword;
                $continuation.label = 2;
                v1 = get.invoke($continuation);
                if (v1 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl51
                {
                    case 2: {
                        canAskPassword = $continuation.Z$0;
                        isEmpty = (Function1)$continuation.L$3;
                        ask = (Function2)$continuation.L$2;
                        get = (Function1)$continuation.L$1;
                        storage = (LocalDataSource.Storage)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl51:
                        // 2 sources

                        return v1;
                    }
                }
            }
            $continuation.L$0 = storage;
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)get);
            $continuation.L$2 = ask;
            $continuation.L$3 = isEmpty;
            $continuation.Z$0 = canAskPassword;
            $continuation.label = 3;
            v2 = get.invoke($continuation);
            ** if (v2 != var10_9) goto lbl64
lbl63:
            // 1 sources

            return var10_9;
lbl64:
            // 1 sources

            ** GOTO lbl75
            {
                case 3: {
                    canAskPassword = $continuation.Z$0;
                    isEmpty = (Function1)$continuation.L$3;
                    ask = (Function2)$continuation.L$2;
                    get = (Function1)$continuation.L$1;
                    storage = (LocalDataSource.Storage)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = res = $result;
lbl75:
                        // 2 sources

                        if (!storage.isMemory() && !DatabaseCoreUiService.getInstance().isNonPersistentPasswordStorage() || !((Boolean)isEmpty.invoke(res)).booleanValue()) {
                            return res;
                        }
                        break;
                    }
                    catch (CancellationException c) {
                        throw c;
                    }
                    catch (Throwable th) {
                        if (AsyncUtil.isCancellation(th)) {
                            throw ExceptionsKt.CancellationException(null, (Throwable)th);
                        }
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)storage);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)get);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)ask);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)isEmpty);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)th);
                        $continuation.Z$0 = canAskPassword;
                        $continuation.label = 4;
                        v3 = ask.invoke((Object)th, $continuation);
                        if (v3 == var10_9) {
                            return var10_9;
                        }
                        ** GOTO lbl103
                    }
                }
                case 4: {
                    canAskPassword = $continuation.Z$0;
                    th = (Throwable)$continuation.L$4;
                    isEmpty = (Function1)$continuation.L$3;
                    ask = (Function2)$continuation.L$2;
                    get = (Function1)$continuation.L$1;
                    storage = (LocalDataSource.Storage)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl103:
                    // 2 sources

                    return v3;
                }
            }
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)storage);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)get);
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)ask);
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)isEmpty);
            $continuation.Z$0 = canAskPassword;
            $continuation.label = 5;
            v4 = ask.invoke(null, $continuation);
            if (v4 == var10_9) {
                return var10_9;
            }
            ** GOTO lbl122
            {
                case 5: {
                    canAskPassword = $continuation.Z$0;
                    isEmpty = (Function1)$continuation.L$3;
                    ask = (Function2)$continuation.L$2;
                    get = (Function1)$continuation.L$1;
                    storage = (LocalDataSource.Storage)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl122:
                    // 2 sources

                    return v4;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

