/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.builtInHelp.settings;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.builtInHelp.BuiltInHelpBundle;
import com.jetbrains.builtInHelp.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;

public class SettingsPage
implements Configurable {
    @NonNls
    public static final SettingKey OPEN_HELP_FROM_WEB = SettingKey.simple("bundled.help.open.web.site.when.possible");
    @NonNls
    public static final SettingKey USE_BROWSER = SettingKey.simple("bundled.help.use.specific.web.browser");
    @NonNls
    public static final SettingKey OPEN_HELP_BASE_URL = SettingKey.simple("bundled.help.open.web.site.base.url");
    private final SettingsPageUI ui = new SettingsPageUI();

    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.SettingsPage.display.name", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        this.ui.addListeners();
        WebBrowserManager mgr = WebBrowserManager.getInstance();
        this.ui.webBrowserList.addItem(BuiltInHelpBundle.message("use.default.browser", new Object[0]));
        for (WebBrowser browser : mgr.getBrowsers()) {
            this.ui.webBrowserList.addItem(browser.getName());
        }
        return this.ui.root;
    }

    public boolean isModified() {
        return this.ui.modified;
    }

    public void disposeUIResources() {
        this.ui.removeListeners();
    }

    public void reset() {
        this.ui.reset();
    }

    public void apply() {
        this.ui.apply();
    }

    static class SettingsPageUI {
        boolean modified = false;
        ActionListener actionListener;
        JPanel root;
        JCheckBox openWebSite;
        JTextField baseUrl;
        JComboBox<String> webBrowserList;
        DocumentListener textChangeListener;

        SettingsPageUI() {
            this.$$$setupUI$$$();
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    modified = true;
                }
            };
            this.textChangeListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    modified = true;
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    modified = true;
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    modified = true;
                }
            };
        }

        void addListeners() {
            this.openWebSite.addActionListener(this.actionListener);
            this.webBrowserList.addActionListener(this.actionListener);
            this.baseUrl.getDocument().addDocumentListener(this.textChangeListener);
            this.baseUrl.addActionListener(this.actionListener);
        }

        void removeListeners() {
            this.openWebSite.removeActionListener(this.actionListener);
            this.webBrowserList.removeActionListener(this.actionListener);
            this.baseUrl.getDocument().removeDocumentListener(this.textChangeListener);
        }

        void apply() {
            Utils.setStoredValue(OPEN_HELP_FROM_WEB, String.valueOf(this.openWebSite.isSelected()));
            Utils.setStoredValue(USE_BROWSER, String.valueOf(this.webBrowserList.getSelectedItem()));
            Utils.setStoredValue(OPEN_HELP_BASE_URL, this.baseUrl.getText());
            this.modified = false;
        }

        void reset() {
            String storedSelection = Utils.getStoredValue(USE_BROWSER, BuiltInHelpBundle.message("use.default.browser", new Object[0]));
            int totalItems = this.webBrowserList.getItemCount();
            for (int i = 0; i < totalItems; ++i) {
                if (!this.webBrowserList.getItemAt(i).equals(storedSelection)) continue;
                this.webBrowserList.setSelectedIndex(i);
                break;
            }
            this.openWebSite.setSelected(Boolean.parseBoolean(Utils.getStoredValue(OPEN_HELP_FROM_WEB, "true")));
            this.baseUrl.setText(Utils.getStoredValue(OPEN_HELP_BASE_URL, "https://www.jetbrains.com/"));
            this.modified = false;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.root = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/BuiltInHelpBundle", SettingsPageUI.class).getString("settings.border.title"), (int)0, (int)0, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/BuiltInHelpBundle", SettingsPageUI.class).getString("try.opening.online.help.when.available"));
            jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.openWebSite = jCheckBox = new JCheckBox();
            jCheckBox.setText("");
            jPanel2.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/BuiltInHelpBundle", SettingsPageUI.class).getString("online.help.base.url"));
            jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/BuiltInHelpBundle", SettingsPageUI.class).getString("use.this.browser"));
            jPanel2.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JComboBox jComboBox = new JComboBox();
            this.webBrowserList = jComboBox;
            jPanel2.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.baseUrl = jTextField = new JTextField();
            jPanel2.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.root;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }

    public static class SettingKey
    extends Pair<String, Boolean> {
        SettingKey(String first, Boolean second) {
            super((Object)first, (Object)second);
        }

        static SettingKey simple(String name) {
            return new SettingKey(name, false);
        }

        static SettingKey secure(String name) {
            return new SettingKey(name, true);
        }
    }
}

