/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.builtInHelp.search;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ResourceUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.builtInHelp.search.HelpSearchResult;
import com.jetbrains.builtInHelp.search.HelpSearchResults;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/builtInHelp/search/HelpSearch;", "", "<init>", "()V", "Companion", "intellij.builtInHelp"})
public final class HelpSearch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    private static final String NOT_FOUND = "[]";
    @NotNull
    private static final StandardAnalyzer analyzer = new StandardAnalyzer();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/builtInHelp/search/HelpSearch$Companion;", "", "<init>", "()V", "NOT_FOUND", "", "analyzer", "Lorg/apache/lucene/analysis/standard/StandardAnalyzer;", "search", "query", "maxHits", "", "intellij.builtInHelp"})
    @SourceDebugExtension(value={"SMAP\nHelpSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelpSearch.kt\ncom/jetbrains/builtInHelp/search/HelpSearch$Companion\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n57#2:156\n1#3:157\n1321#4,2:158\n1563#5:160\n1634#5,3:161\n*S KotlinDebug\n*F\n+ 1 HelpSearch.kt\ncom/jetbrains/builtInHelp/search/HelpSearch$Companion\n*L\n50#1:156\n50#1:157\n51#1:158,2\n76#1:160\n76#1:161,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String search(@Nullable String query, int maxHits) {
            if (query != null) {
                Path indexDir = Files.createTempDirectory("search-index", new FileAttribute[0]);
                NIOFSDirectory indexDirectory = null;
                DirectoryReader reader = null;
                if (indexDir != null) {
                    block45: {
                        Object object;
                        try {
                            void $this$mapTo$iv$iv;
                            int $i$f$forEach;
                            Object it$iv;
                            Pair[] resourceList;
                            String indexDirPath = ((Object)indexDir.toAbsolutePath()).toString();
                            Files.createDirectories(indexDir, new FileAttribute[0]);
                            Closeable closeable = ResourceUtil.getResourceAsStream((ClassLoader)HelpSearch.class.getClassLoader(), (String)"search", (String)"rlist");
                            Throwable throwable = null;
                            try {
                                resourceList = (Pair[])closeable;
                                boolean bl = false;
                                Reader $this$useLines$iv = new BufferedReader(new InputStreamReader((InputStream)resourceList));
                                boolean $i$f$useLines = false;
                                object = $this$useLines$iv;
                                object = (BufferedReader)object;
                                Throwable throwable2 = null;
                                try {
                                    it$iv = (BufferedReader)object;
                                    boolean bl2 = false;
                                    Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                                    boolean bl3 = false;
                                    Sequence $this$forEach$iv = lines;
                                    $i$f$forEach = 0;
                                    for (Object element$iv : $this$forEach$iv) {
                                        Unit unit;
                                        String line = (String)element$iv;
                                        boolean bl4 = false;
                                        Object object2 = new String[]{line};
                                        Path path = Paths.get(indexDirPath, object2);
                                        object2 = ResourceUtil.getResourceAsStream((ClassLoader)HelpSearch.class.getClassLoader(), (String)"search", (String)line);
                                        if (object2 != null) {
                                            Closeable closeable2 = (Closeable)object2;
                                            Throwable throwable3 = null;
                                            try {
                                                InputStream resourceStream = (InputStream)closeable2;
                                                boolean bl5 = false;
                                                Intrinsics.checkNotNull((Object)path);
                                                Closeable closeable3 = PathKt.safeOutputStream((Path)path);
                                                Throwable throwable4 = null;
                                                try {
                                                    OutputStream resourceOutput = (OutputStream)closeable3;
                                                    boolean bl6 = false;
                                                    resourceOutput.write(resourceStream.readAllBytes());
                                                    Unit unit2 = Unit.INSTANCE;
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable4 = throwable5;
                                                    throw throwable5;
                                                }
                                                finally {
                                                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable4);
                                                }
                                                Unit unit3 = Unit.INSTANCE;
                                            }
                                            catch (Throwable throwable6) {
                                                throwable3 = throwable6;
                                                throw throwable6;
                                            }
                                            finally {
                                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                                            }
                                            unit = Unit.INSTANCE;
                                            continue;
                                        }
                                        unit = null;
                                    }
                                    it$iv = Unit.INSTANCE;
                                }
                                catch (Throwable bl2) {
                                    throwable2 = bl2;
                                    throw bl2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                                }
                                resourceList = Unit.INSTANCE;
                            }
                            catch (Throwable bl) {
                                throwable = bl;
                                throw bl;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            indexDirectory = new NIOFSDirectory(indexDir);
                            reader = DirectoryReader.open((Directory)((Directory)indexDirectory));
                            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                            resourceList = new Pair[]{new Pair((Object)"contents", (Object)Float.valueOf(1.0f)), new Pair((Object)"title", (Object)Float.valueOf(1.5f))};
                            Query q = new SimpleQueryParser((Analyzer)analyzer, MapsKt.mapOf((Pair[])resourceList)).parse(query);
                            TopDocs hits = (TopDocs)searcher.search(q, (CollectorManager)new TopScoreDocCollectorManager(maxHits, maxHits));
                            Scorer scorer = (Scorer)new QueryScorer(q);
                            Highlighter highlighter = new Highlighter(scorer);
                            Intrinsics.checkNotNullExpressionValue((Object)hits.scoreDocs, (String)"scoreDocs");
                            Iterable $this$map$iv = (Iterable)ArraysKt.getIndices((Object[])hits.scoreDocs);
                            boolean $i$f$map = false;
                            it$iv = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            Iterator iterator = $this$mapTo$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                StringBuilder stringBuilder;
                                void index;
                                int item$iv$iv;
                                $i$f$forEach = item$iv$iv = ((IntIterator)iterator).nextInt();
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                Document doc = searcher.storedFields().document(hits.scoreDocs[index].doc);
                                StringBuilder $this$search_u24lambda_u246_u24lambda_u245 = stringBuilder = new StringBuilder();
                                boolean bl7 = false;
                                $this$search_u24lambda_u246_u24lambda_u245.append(highlighter.getBestFragment((Analyzer)analyzer, "contents", doc.get("contents")));
                                $this$search_u24lambda_u246_u24lambda_u245.append("...");
                                String contentValue = stringBuilder.toString();
                                String string = doc.get("filename");
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                                String string2 = doc.get("title");
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                                String string3 = doc.get("title");
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
                                String string4 = String.valueOf((int)index);
                                HelpSearchResult.SnippetResult snippetResult = new HelpSearchResult.SnippetResult(new HelpSearchResult.SnippetResult.Content(contentValue, "full"));
                                String string5 = doc.get("filename");
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"get(...)");
                                HelpSearchResult.HelpSearchResultDetails helpSearchResultDetails = new HelpSearchResult.HelpSearchResultDetails(string5, null, false, null, 14, null);
                                String string6 = doc.get("title");
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"get(...)");
                                HelpSearchResult.HelpSearchResultDetails helpSearchResultDetails2 = new HelpSearchResult.HelpSearchResultDetails(string6, null, false, null, 14, null);
                                HelpSearchResult.HelpSearchResultDetails helpSearchResultDetails3 = new HelpSearchResult.HelpSearchResultDetails(contentValue, null, false, null, 14, null);
                                String string7 = doc.get("title");
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"get(...)");
                                HelpSearchResult.HelpSearchResultDetails helpSearchResultDetails4 = new HelpSearchResult.HelpSearchResultDetails(string7, null, false, null, 14, null);
                                String string8 = doc.get("title");
                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"get(...)");
                                collection.add(new HelpSearchResult(string, string2, "", string3, string4, snippetResult, new HelpSearchResult.HighlightedResult(helpSearchResultDetails, helpSearchResultDetails2, helpSearchResultDetails3, helpSearchResultDetails4, new HelpSearchResult.HelpSearchResultDetails(string8, null, false, null, 14, null))));
                            }
                            List results = (List)destination$iv$iv;
                            if (!(!((Collection)results).isEmpty())) break block45;
                            String string = ExtensionsKt.jacksonObjectMapper().writeValueAsString((Object)new HelpSearchResults(results));
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                            object = string;
                        }
                        catch (Throwable e) {
                            NIOFSDirectory nIOFSDirectory;
                            try {
                                Logger.getInstance(HelpSearch.class).info("Error searching help for " + query, e);
                                nIOFSDirectory = indexDirectory;
                            }
                            catch (Throwable throwable) {
                                NIOFSDirectory nIOFSDirectory2 = indexDirectory;
                                if (nIOFSDirectory2 != null) {
                                    nIOFSDirectory2.close();
                                    v23 = Unit.INSTANCE;
                                } else {
                                    v23 = null;
                                }
                                DirectoryReader directoryReader = reader;
                                if (directoryReader != null) {
                                    directoryReader.close();
                                    v25 = Unit.INSTANCE;
                                } else {
                                    v25 = null;
                                }
                                File file = indexDir.toFile();
                                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                                FilesKt.deleteRecursively((File)file);
                                throw throwable;
                            }
                            if (nIOFSDirectory != null) {
                                nIOFSDirectory.close();
                                v27 = Unit.INSTANCE;
                            } else {
                                v27 = null;
                            }
                            DirectoryReader directoryReader = reader;
                            if (directoryReader != null) {
                                directoryReader.close();
                                v29 = Unit.INSTANCE;
                            } else {
                                v29 = null;
                            }
                            File file = indexDir.toFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                            FilesKt.deleteRecursively((File)file);
                        }
                        indexDirectory.close();
                        DirectoryReader directoryReader = reader;
                        if (directoryReader != null) {
                            directoryReader.close();
                            v16 = Unit.INSTANCE;
                        } else {
                            v16 = null;
                        }
                        File file = indexDir.toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                        FilesKt.deleteRecursively((File)file);
                        return object;
                    }
                    indexDirectory.close();
                    DirectoryReader directoryReader = reader;
                    if (directoryReader != null) {
                        directoryReader.close();
                        v19 = Unit.INSTANCE;
                    } else {
                        v19 = null;
                    }
                    File file = indexDir.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    FilesKt.deleteRecursively((File)file);
                }
            }
            return HelpSearch.NOT_FOUND;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

