/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.builtInHelp;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.util.PropertiesComponent;
import com.jetbrains.builtInHelp.settings.SettingsPage;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/builtInHelp/Utils;", "", "<init>", "()V", "Companion", "intellij.builtInHelp"})
public final class Utils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    private static final String EMPTY_STRING = "";
    @NonNls
    @NotNull
    public static final String BASE_HELP_URL = "https://www.jetbrains.com/";
    @NotNull
    private static final CredentialAttributes secureKey = new CredentialAttributes("Web Help Bundle");

    @JvmStatic
    @NonNls
    @NotNull
    public static final String getStoredValue(@NotNull SettingsPage.SettingKey key, @NotNull String string) {
        return Companion.getStoredValue(key, string);
    }

    @JvmStatic
    public static final boolean setStoredValue(@NotNull SettingsPage.SettingKey key, @Nullable String value) {
        return Companion.setStoredValue(key, value);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/builtInHelp/Utils$Companion;", "", "<init>", "()V", "EMPTY_STRING", "", "BASE_HELP_URL", "secureKey", "Lcom/intellij/credentialStore/CredentialAttributes;", "getStoredValue", "key", "Lcom/jetbrains/builtInHelp/settings/SettingsPage$SettingKey;", "default", "setStoredValue", "", "value", "intellij.builtInHelp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NonNls
        @NotNull
        public final String getStoredValue(@NotNull SettingsPage.SettingKey key, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            Intrinsics.checkNotNullParameter((Object)string, (String)"default");
            if (!((Boolean)key.second).booleanValue()) {
                String string2 = PropertiesComponent.getInstance().getValue((String)key.first, string);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                return string2;
            }
            PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
            Credentials credentials = passwordSafe.get(secureKey);
            if (credentials != null) {
                return String.valueOf(credentials.getPasswordAsString());
            }
            return Utils.EMPTY_STRING;
        }

        @JvmStatic
        public final boolean setStoredValue(@NotNull SettingsPage.SettingKey key, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            if (!((Boolean)key.second).booleanValue()) {
                PropertiesComponent.getInstance().setValue((String)key.first, value, Utils.EMPTY_STRING);
                return true;
            }
            PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
            passwordSafe.set(secureKey, new Credentials((String)key.first, value));
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

