/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.builtInHelp;

import com.intellij.util.ResourceUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004R\u0016\u0010\u0004\u001a\u00020\u00058\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/builtInHelp/HelpRequestHandlerBase;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "prefix", "", "getPrefix", "()Ljava/lang/String;", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "sendResource", "resourceName", "resourceLocation", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.builtInHelp"})
public abstract class HelpRequestHandlerBase
extends HttpRequestHandler {
    @NonNls
    @NotNull
    private final String prefix;

    public HelpRequestHandlerBase() {
        this.prefix = "/help/";
    }

    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isAccessible(request)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)this.getPrefix(), (boolean)false, (int)2, null)) return false;
        return true;
    }

    protected final boolean sendResource(@NotNull String resourceName, @NotNull String resourceLocation, @NotNull FullHttpRequest request, @NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        Object object;
        block6: {
            block5: {
                InputStream resStream;
                String retrieveName;
                Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
                Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
                boolean isImage = StringsKt.contains$default((CharSequence)resourceLocation, (CharSequence)"/img/", (boolean)false, (int)2, null);
                if (isImage) {
                    Path path = Paths.get(resourceName, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Path base = path;
                    String baseName = PathsKt.getNameWithoutExtension((Path)base);
                    v1 = StringsKt.substringBeforeLast$default((String)baseName, (String)"_dark", null, (int)2, null) + "." + PathsKt.getExtension((Path)base);
                } else {
                    v1 = retrieveName = resourceName;
                }
                if ((object = (resStream = ResourceUtil.getResourceAsStream((ClassLoader)HelpRequestHandlerBase.class.getClassLoader(), (String)(isImage ? "images" : "topics"), (String)retrieveName))) == null) break block5;
                byte[] byArray = ((InputStream)object).readAllBytes();
                object = byArray;
                if (byArray != null) break block6;
            }
            throw new Exception(resourceName + " not found in " + resourceLocation + " via " + request.uri());
        }
        return this.sendData((byte[])object, resourceName, request, channel, extraHeaders);
    }
}

