/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.builtInHelp;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import com.jetbrains.builtInHelp.HelpRequestHandlerBase;
import com.jetbrains.builtInHelp.mapping.HelpMap;
import com.jetbrains.builtInHelp.mapping.HelpMapId;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/builtInHelp/HelpContentRequestHandler;", "Lcom/jetbrains/builtInHelp/HelpRequestHandlerBase;", "<init>", "()V", "propsToRemove", "", "", "process", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.builtInHelp"})
@SourceDebugExtension(value={"SMAP\nHelpContentRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelpContentRequestHandler.kt\ncom/jetbrains/builtInHelp/HelpContentRequestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1869#2,2:113\n*S KotlinDebug\n*F\n+ 1 HelpContentRequestHandler.kt\ncom/jetbrains/builtInHelp/HelpContentRequestHandler\n*L\n79#1:113,2\n*E\n"})
public final class HelpContentRequestHandler
extends HelpRequestHandlerBase {
    @NotNull
    private final List<String> propsToRemove;

    public HelpContentRequestHandler() {
        Object[] objectArray = new String[]{"searchAlgoliaApiKey", "searchAlgoliaId", "searchAlgoliaIndexName", "versionsService"};
        this.propsToRemove = CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (Object k : urlDecoder.parameters().keySet()) {
            Intrinsics.checkNotNullExpressionValue(k, (String)"next(...)");
            String name = (String)k;
            List param = (List)urlDecoder.parameters().get(name);
            if (param == null || !param.isEmpty() && !StringUtil.isEmpty((String)((String)param.get(0)))) continue;
            InputStream mapStream = ResourceUtil.getResourceAsStream((ClassLoader)HelpContentRequestHandler.class.getClassLoader(), (String)"topics", (String)"Map.jhm");
            Class[] classArray = new Class[]{HelpMap.class, HelpMapId.class};
            Object object = JAXBContext.newInstance((Class[])classArray).createUnmarshaller().unmarshal(mapStream);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.builtInHelp.mapping.HelpMap");
            HelpMap map = (HelpMap)object;
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.PERMANENT_REDIRECT);
            String location = "http://127.0.0.1:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() + "/help/" + map.getUrlForId(name);
            if (urlDecoder.parameters().containsKey("keymap")) {
                Object v = urlDecoder.parameters().get("keymap");
                Intrinsics.checkNotNull(v);
                location = location + "?keymap=" + URLEncoder.encode((String)((List)v).get(0), StandardCharsets.UTF_8);
            }
            response.headers().add("Location", (Object)location);
            context.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return true;
        }
        String string = urlDecoder.path();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path(...)");
        String resourceName = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
        if (Intrinsics.areEqual((Object)resourceName, (Object)"config.json")) {
            InputStream configStream = ResourceUtil.getResourceAsStream((ClassLoader)HelpContentRequestHandler.class.getClassLoader(), (String)"topics", (String)"config.json");
            Object object = ExtensionsKt.jacksonObjectMapper().readValue(configStream, LinkedHashMap.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<kotlin.String, kotlin.Any>");
            LinkedHashMap configJson = (LinkedHashMap)object;
            Set set = configJson.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            CollectionsKt.removeAll((Iterable)set, arg_0 -> HelpContentRequestHandler.process$lambda$0(this, arg_0));
            Set set2 = configJson.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(configJson.get(it) instanceof String)) continue;
                Object v = configJson.get(it);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                String current = (String)v;
                ((Map)configJson).put(it, StringsKt.replace$default((String)StringsKt.replace$default((String)current, (String)"https://data.services.jetbrains.com", (String)("http://127.0.0.1:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort()), (boolean)false, (int)4, null), (String)"true", (String)"false", (boolean)false, (int)4, null));
            }
            byte[] byArray = ExtensionsKt.jacksonObjectMapper().writeValueAsBytes((Object)configJson);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            HttpHeaders httpHeaders = request.headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
            this.sendData(byArray, "config.json", request, channel, httpHeaders);
        } else {
            Object object;
            try {
                String string2 = urlDecoder.path();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path(...)");
                String string3 = StringsKt.substringBeforeLast$default((String)string2, (String)"/", null, (int)2, null);
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                HttpHeaders httpHeaders = request.headers();
                Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
                object = this.sendResource(resourceName, string3, request, channel, httpHeaders);
            }
            catch (Throwable e) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), (String)e.getMessage(), null, (int)8, null);
                object = Unit.INSTANCE;
            }
        }
        return true;
    }

    private static final boolean process$lambda$0(HelpContentRequestHandler this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.propsToRemove.contains(it);
    }
}

