/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.ide.hierarchy;

import com.intellij.database.ide.hierarchy.SqlCallHierarchyBrowser;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.DbContextElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/ide/hierarchy/SqlCallHierarchyProvider;", "Lcom/intellij/ide/hierarchy/HierarchyProvider;", "<init>", "()V", "getTarget", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createHierarchyBrowser", "Lcom/intellij/ide/hierarchy/HierarchyBrowser;", "target", "browserActivated", "", "hierarchyBrowser", "intellij.datagrip.impl"})
public final class SqlCallHierarchyProvider
implements HierarchyProvider {
    @Nullable
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        JBIterable jBIterable;
        DbContextDataSourceElements dbContextDataSourceElements;
        DbContextDataSourceElements dbContextDataSourceElements2;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!Registry.Companion.is("database.enable.routine.call.hierarchy")) {
            return null;
        }
        DbContextElements dbContextElements = DbContextElementsKt.computeContextElements((DataContext)dataContext);
        DbElement dbElement = dbContextElements != null && (dbContextDataSourceElements2 = dbContextElements.getSingleDataSource()) != null && (dbContextDataSourceElements = dbContextDataSourceElements2.asDbElements()) != null && (jBIterable = dbContextDataSourceElements.asIterable()) != null ? (DbElement)jBIterable.single() : null;
        DbRoutine target = dbElement instanceof DbRoutine ? (DbRoutine)dbElement : null;
        return (PsiElement)target;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (HierarchyBrowser)new SqlCallHierarchyBrowser(project, target);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        Intrinsics.checkNotNullParameter((Object)hierarchyBrowser, (String)"hierarchyBrowser");
        ((HierarchyBrowserBaseEx)hierarchyBrowser).changeView(CallHierarchyBrowserBase.getCalleeType());
    }
}

