/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.ide.hierarchy;

import com.intellij.database.ide.hierarchy.SqlCalleeTreeStructure;
import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\f2\u0016\u0010\u0010\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0012\u0012\u0006\b\u0000\u0012\u00020\u00130\u0011H\u0014J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J \u0010\u001c\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001dj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e`\u001fH\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/database/ide/hierarchy/SqlCallHierarchyBrowser;", "Lcom/intellij/ide/hierarchy/CallHierarchyBrowserBase;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;)V", "getElementFromDescriptor", "descriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "prependActions", "", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createTrees", "trees", "", "", "Ljavax/swing/JTree;", "createTree", "baseOnThisAction", "Lcom/intellij/ide/hierarchy/CallHierarchyBrowserBase$BaseOnThisMethodAction;", "isApplicableElement", "", "createHierarchyTreeStructure", "Lcom/intellij/ide/hierarchy/HierarchyTreeStructure;", "type", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "Lkotlin/Comparator;", "intellij.datagrip.impl"})
@SourceDebugExtension(value={"SMAP\nSqlCallHierarchyBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCallHierarchyBrowser.kt\ncom/intellij/database/ide/hierarchy/SqlCallHierarchyBrowser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n14#2:63\n*S KotlinDebug\n*F\n+ 1 SqlCallHierarchyBrowser.kt\ncom/intellij/database/ide/hierarchy/SqlCallHierarchyBrowser\n*L\n51#1:63\n*E\n"})
public final class SqlCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    public SqlCallHierarchyBrowser(@NotNull Project project, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(project, element);
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return descriptor.getPsiElement();
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        super.prependActions(actionGroup);
        AnAction showCallerHierarchy = actionGroup.getChildActionsOrStubs()[0];
        AnAction changeScope = actionGroup.getChildActionsOrStubs()[3];
        actionGroup.remove(showCallerHierarchy);
        actionGroup.remove(changeScope);
    }

    protected void createTrees(@NotNull Map<? super String, ? super JTree> trees) {
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        CallHierarchyBrowserBase.BaseOnThisMethodAction baseOnThisAction = new CallHierarchyBrowserBase.BaseOnThisMethodAction();
        trees.put(CallHierarchyBrowserBase.getCalleeType(), this.createTree(baseOnThisAction));
        trees.put(CallHierarchyBrowserBase.getCallerType(), this.createTree(baseOnThisAction));
    }

    private final JTree createTree(CallHierarchyBrowserBase.BaseOnThisMethodAction baseOnThisAction) {
        JTree jTree = this.createTree(false);
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"createTree(...)");
        JTree tree = jTree;
        PopupHandler.installPopupMenu((JComponent)tree, (String)"CallHierarchyPopupMenu", (String)"CallHierarchyViewPopup");
        ShortcutSet shortcutSet = ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getShortcutSet(...)");
        ShortcutSet callHierarchyShortcut = shortcutSet;
        baseOnThisAction.registerCustomShortcutSet(callHierarchyShortcut, (JComponent)tree);
        return tree;
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return true;
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String type, @NotNull PsiElement element) {
        HierarchyTreeStructure hierarchyTreeStructure;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)CallHierarchyBrowserBase.getCallerType())) {
            hierarchyTreeStructure = null;
        } else if (Intrinsics.areEqual((Object)string, (Object)CallHierarchyBrowserBase.getCalleeType())) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            hierarchyTreeStructure = new SqlCalleeTreeStructure(project, element);
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SqlCallHierarchyBrowser.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("unexpected type: " + type);
            hierarchyTreeStructure = null;
        }
        return hierarchyTreeStructure;
    }

    @NotNull
    protected Comparator<NodeDescriptor<?>> getComparator() {
        Comparator comparator;
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance((Project)this.myProject).getState();
        if (state != null && state.SORT_ALPHABETICALLY) {
            AlphaComparator alphaComparator = AlphaComparator.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)alphaComparator, (String)"getInstance(...)");
            comparator = (Comparator)alphaComparator;
        } else {
            comparator = new Comparator(){

                public final int compare(T a, T b) {
                    NodeDescriptor it = (NodeDescriptor)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getIndex());
                    it = (NodeDescriptor)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
                }
            };
        }
        return comparator;
    }
}

