/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.ide.actions;

import com.intellij.database.ide.DataGripBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.ui.ExperimentalUI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class NewProjectAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            NewProjectAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NewProjectAction.$$$reportNull$$$0(1);
        }
        Messages.InputDialog dialog = new Messages.InputDialog(e.getProject(), DataGripBundle.message((String)"dialog.message.enter.new.project.name", (Object[])new Object[0]), DataGripBundle.message((String)"dialog.title.new.project", (Object[])new Object[0]), Messages.getQuestionIcon(), "", new MyValidator()){

            protected JTextComponent createTextFieldComponent() {
                TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
                field.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
                field.getTextField().setColumns(30);
                return field.getTextField();
            }
        };
        dialog.show();
        String name = dialog.getInputString();
        if (name == null) {
            return;
        }
        Path path = Path.of(FileUtil.expandUserHome((String)name), new String[0]);
        if (!path.isAbsolute()) {
            path = Paths.get(ProjectUtil.getProjectPath(), new String[0]).resolve(path);
        }
        ProjectUtil.openOrCreateProject((String)path.getFileName().toString(), (Path)path);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NewProjectAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setApplicationScope(true);
        if (ExperimentalUI.isNewUI() && "ProjectWidgetPopup".equals(e.getPlace())) {
            e.getPresentation().setText(ActionsBundle.actionText((String)"NewProject.ProjectWidgetPopup"));
            e.getPresentation().setIcon(AllIcons.General.Add);
        }
        NewWelcomeScreen.updateNewProjectIconIfWelcomeScreen((AnActionEvent)e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/ide/actions/NewProjectAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/ide/actions/NewProjectAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class MyValidator
    implements InputValidator {
        private MyValidator() {
        }

        public boolean checkInput(String inputString) {
            try {
                Paths.get(inputString, new String[0]);
                return true;
            }
            catch (InvalidPathException p) {
                return false;
            }
        }

        public boolean canClose(String inputString) {
            return this.checkInput(inputString);
        }
    }
}

