/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.ide;

import com.intellij.ide.ApplicationInitializedListenerJavaShim;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class DataGripProjectMigration
extends ApplicationInitializedListenerJavaShim {
    private static final Logger LOG = Logger.getInstance(DataGripProjectMigration.class);

    DataGripProjectMigration() {
        if (ApplicationManager.getApplication().isCommandLine()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public void componentsInitialized() {
        Map<Path, Path> mapping = DataGripProjectMigration.moveProjectsOutOfConfig();
        if (!mapping.isEmpty()) {
            DataGripProjectMigration.patchRecentProjects(mapping);
        }
    }

    private static void patchRecentProjects(Map<Path, Path> mapping) {
        RecentProjectsManagerBase manager;
        RecentProjectsManager obj = RecentProjectsManager.getInstance();
        RecentProjectsManagerBase recentProjectsManagerBase = manager = obj instanceof RecentProjectsManagerBase ? (RecentProjectsManagerBase)obj : null;
        if (manager != null) {
            manager.patchRecentPaths(path -> {
                Path p = Path.of(FileUtilRt.toSystemDependentName((String)path), new String[0]);
                if (!mapping.containsKey(p) || Files.exists(p, new LinkOption[0])) {
                    return null;
                }
                return FileUtilRt.toSystemIndependentName((String)((Path)mapping.get(p)).toAbsolutePath().toString());
            });
        }
    }

    private static Map<Path, Path> moveProjectsOutOfConfig() {
        try {
            String configPath = PathManager.getConfigPath();
            return DataGripProjectMigration.moveProjectsOutOfConfig(Paths.get(configPath, new String[0]));
        }
        catch (IOException e) {
            LOG.warn("failed to move projects from config dir", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static Map<Path, Path> moveProjectsOutOfConfig(Path configDir) throws IOException {
        Path configProjects = configDir.resolve("projects");
        if (!Files.exists(configProjects, new LinkOption[0])) {
            LOG.info("no projects in config folder");
            return Collections.emptyMap();
        }
        LOG.info("found projects in config folder");
        Path userProjects = Paths.get(ProjectUtil.getProjectPath(), new String[0]);
        Files.createDirectories(userProjects, new FileAttribute[0]);
        Path tmpProjects = DataGripProjectMigration.movePreservingTarget(configProjects, userProjects, "projects-from-config");
        HashMap<Path, Path> mapping = new HashMap<Path, Path>();
        try (Stream<Path> pStream = Files.list(tmpProjects);){
            for (Path project : pStream::iterator) {
                Path newPath = DataGripProjectMigration.movePreservingTarget(project, userProjects, project.getFileName().toString());
                Path oldPath = configProjects.resolve(project.getFileName());
                mapping.put(oldPath, newPath);
                DataGripProjectMigration.patchProjectFiles(newPath, oldPath);
            }
        }
        NioFiles.deleteRecursively((Path)tmpProjects);
        return mapping;
    }

    private static void patchProjectFiles(Path projectPath, Path oldProjectDir) {
        ExpandMacroToPathMap map = DataGripProjectMigration.prepareReplacements(oldProjectDir);
        try (Stream<Path> files = Files.list(projectPath.resolve(".idea"));){
            files.filter(f -> DataGripProjectMigration.shouldPatch(f)).forEach(f -> DataGripProjectMigration.patchProjectFile(f, map));
        }
        catch (IOException e) {
            LOG.warn("Failed to patch project " + String.valueOf(projectPath));
        }
    }

    private static boolean shouldPatch(Path f) {
        String name = f.getFileName().toString();
        return name.endsWith(".xml") || name.endsWith(".iml");
    }

    @NotNull
    private static ExpandMacroToPathMap prepareReplacements(Path oldProjectDir) {
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        String path = PathUtil.toSystemIndependentName((String)oldProjectDir.toAbsolutePath().toString());
        DataGripProjectMigration.addTraversals(map, "MODULE_DIR", path);
        DataGripProjectMigration.addTraversals(map, "PROJECT_DIR", path);
        ExpandMacroToPathMap expandMacroToPathMap = map;
        if (expandMacroToPathMap == null) {
            DataGripProjectMigration.$$$reportNull$$$0(0);
        }
        return expandMacroToPathMap;
    }

    private static void addTraversals(ExpandMacroToPathMap map, String macroName, String path) {
        String macroVal = "$" + macroName + "$";
        PathMacroManager.addFileHierarchyReplacements((ExpandMacroToPathMap)map, (String)macroName, (String)path);
        map.put(macroVal, macroVal);
    }

    private static void patchProjectFile(Path file, ExpandMacroToPathMap map) {
        try {
            String content = Files.readString(file);
            String patched = map.substitute(content, SystemInfoRt.isFileSystemCaseSensitive);
            Files.writeString(file, (CharSequence)patched, new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.warn("Failed to patch " + String.valueOf(file));
        }
    }

    @NotNull
    private static Path movePreservingTarget(Path what, Path targetDir, String targetName) throws IOException {
        Path target = targetDir.resolve(targetName);
        boolean renamed = false;
        while (Files.exists(target, new LinkOption[0])) {
            target = targetDir.resolve(targetName + "-" + String.valueOf(UUID.randomUUID()));
            renamed = true;
        }
        if (renamed) {
            LOG.warn(targetName + " already exists. Moving to " + String.valueOf(target.getFileName()));
        }
        Files.move(what, target, new CopyOption[0]);
        Path path = target;
        if (path == null) {
            DataGripProjectMigration.$$$reportNull$$$0(1);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/ide/DataGripProjectMigration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareReplacements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "movePreservingTarget";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

