/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.ide;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.grid.scripting.impl.ScriptedTableFileEditorProvider;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionRuntimeRegistrar;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.toolWindow.EnableStripeGroup;
import com.intellij.ui.NewUI;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0002\u0007\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/database/ide/DataGripPluginConfigurator;", "Lcom/intellij/ide/ApplicationInitializedListener;", "<init>", "()V", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "PatchKeymap", "Companion", "intellij.datagrip.impl"})
final class DataGripPluginConfigurator
implements ApplicationInitializedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Object execute(@NotNull Continuation<? super Unit> $completion) {
        PluginVerifier.verifyUltimatePlugin();
        Application application = ApplicationManager.getApplication();
        boolean showUI = !application.isHeadlessEnvironment() && !ApplicationManagerEx.isInIntegrationTest();
        DataGripPluginConfigurator.Companion.patchRootAreaExtensions();
        MessageBusConnection connection = application.getMessageBus().connect();
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new AppLifecycleListener(showUI){
            final /* synthetic */ boolean $showUI;
            {
                this.$showUI = $showUI;
            }

            public void appFrameCreated(List<String> commandLineArgs) {
                Intrinsics.checkNotNullParameter(commandLineArgs, (String)"commandLineArgs");
                if (this.$showUI) {
                    RecentProjectsManager recentProjectsManager = RecentProjectsManager.Companion.getInstance();
                    Intrinsics.checkNotNull((Object)recentProjectsManager, (String)"null cannot be cast to non-null type com.intellij.ide.RecentProjectsManagerBase");
                    RecentProjectsManagerBase recentProjectsManagerBase = (RecentProjectsManagerBase)recentProjectsManager;
                    CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)codeInsightSettings, (String)"getInstance(...)");
                    com.intellij.database.ide.DataGripPluginConfigurator$Companion.access$customizeRootUI(DataGripPluginConfigurator.Companion, recentProjectsManagerBase, codeInsightSettings);
                }
            }
        });
        Topic topic2 = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new ProjectManagerListener(showUI){
            final /* synthetic */ boolean $showUI;
            {
                this.$showUI = $showUI;
            }

            public void projectOpened(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                com.intellij.database.ide.DataGripPluginConfigurator$Companion.access$patchProjectAreaExtensions(DataGripPluginConfigurator.Companion, project);
                if (this.$showUI) {
                    com.intellij.database.ide.DataGripPluginConfigurator$Companion.access$customizeProjectUI(DataGripPluginConfigurator.Companion, project);
                }
            }
        });
        DataGripPluginConfigurator.Companion.enableSingleStripe();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bH\u0002J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u001a\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0005H\u0002J\b\u0010\"\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020\u0005H\u0002J,\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010*\u001a\u00020\u0013H\u0002J\b\u0010+\u001a\u00020\u0005H\u0002J-\u0010,\u001a\u00020\u00052\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t00\"\u00020\tH\u0002\u00a2\u0006\u0002\u00101J-\u00102\u001a\u00020\u00052\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t00\"\u00020\tH\u0002\u00a2\u0006\u0002\u00101J,\u00104\u001a\u00020\u00052\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\u0016\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010605H\u0002\u00a8\u00067"}, d2={"Lcom/intellij/database/ide/DataGripPluginConfigurator$Companion;", "", "<init>", "()V", "removeFromGroup", "", "actionRegistrar", "Lcom/intellij/openapi/actionSystem/ex/ActionRuntimeRegistrar;", "groupId", "", "predicate", "Ljava/util/function/Predicate;", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "cond", "patchRunWidget", "registrar", "enableSingleStripe", "trackLocaleChange", "", "executeInBackgroundIfNeeded", "runnable", "Ljava/lang/Runnable;", "checkOneTimeFlag", "name", "customizeRootUI", "recentProjectsManager", "Lcom/intellij/ide/RecentProjectsManagerBase;", "codeInsightSettings", "Lcom/intellij/codeInsight/CodeInsightSettings;", "customizeProjectUI", "project", "Lcom/intellij/openapi/project/Project;", "patchRootAreaExtensions", "patchConfigurables", "patchProjectAreaExtensions", "patchKeymap", "rebindShortcut", "keymapImpl", "Lcom/intellij/openapi/keymap/impl/KeymapImpl;", "from", "to", "preserve", "removeOptimizeImports", "unregisterByIds", "epName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "ids", "", "(Lcom/intellij/openapi/extensions/ExtensionPointName;[Ljava/lang/String;)V", "unregisterByClass", "classNames", "unregisterImpl", "Ljava/util/function/BiPredicate;", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "intellij.datagrip.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void removeFromGroup(ActionRuntimeRegistrar actionRegistrar, String groupId, Predicate<String> predicate) {
            DefaultActionGroup group;
            AnAction anAction = actionRegistrar.getActionOrStub(groupId);
            DefaultActionGroup defaultActionGroup = group = anAction instanceof DefaultActionGroup ? (DefaultActionGroup)anAction : null;
            if (group != null) {
                this.removeFromGroup(group, predicate);
            }
        }

        private final void removeFromGroup(DefaultActionGroup group, Predicate<String> cond) {
            for (AnAction stub : group.getChildActionsOrStubs()) {
                if (!(stub instanceof ActionStub) || !cond.test(((ActionStub)stub).getId())) continue;
                group.remove(stub, ((ActionStub)stub).getId());
            }
        }

        private final void patchRunWidget(ActionRuntimeRegistrar registrar) {
            AnAction widget = registrar.getActionOrStub("NewUiRunWidget");
            if (widget != null) {
                DefaultActionGroup actionGroup;
                AnAction[] anActionArray = registrar.getActionOrStub("MainToolbarRight");
                DefaultActionGroup defaultActionGroup = actionGroup = anActionArray instanceof DefaultActionGroup ? (DefaultActionGroup)anActionArray : null;
                if (defaultActionGroup != null) {
                    defaultActionGroup.remove(widget, registrar.getId(widget));
                }
                anActionArray = new AnAction[]{widget};
                registrar.registerAction("DG.NewUiRunWidget", (AnAction)new DefaultActionGroup(anActionArray));
            }
        }

        private final void enableSingleStripe() {
            if (!NewUI.isEnabled()) {
                return;
            }
            this.executeInBackgroundIfNeeded(Companion::enableSingleStripe$lambda$0);
        }

        private final boolean trackLocaleChange() {
            String flagName = "DG.SingleStripe.LastLocale";
            String lastLocale = PropertiesComponent.getInstance().getValue(flagName);
            String currentLocale = DynamicBundle.getLocale().toLanguageTag();
            PropertiesComponent.getInstance().setValue(flagName, currentLocale);
            return !Intrinsics.areEqual((Object)currentLocale, (Object)lastLocale);
        }

        private final void executeInBackgroundIfNeeded(Runnable runnable) {
            if (EDT.isCurrentThreadEdt()) {
                AppJavaExecutorUtil.executeOnPooledIoThread((Runnable)runnable);
            } else {
                runnable.run();
            }
        }

        private final boolean checkOneTimeFlag(String name) {
            PropertiesComponent pc = PropertiesComponent.getInstance();
            if (!pc.getBoolean(name, false)) {
                pc.setValue(name, true);
                return false;
            }
            return true;
        }

        private final void customizeRootUI(RecentProjectsManagerBase recentProjectsManager, CodeInsightSettings codeInsightSettings) {
            if (ConfigImportHelper.isNewUser()) {
                codeInsightSettings.REFORMAT_ON_PASTE = 1;
            }
        }

        private final void customizeProjectUI(Project project) {
            if (!FileChooserUtil.isLastOpenedPathSet((Project)project)) {
                FileChooserUtil.setLastOpenedFile((Project)project, (Path)Paths.get(SystemProperties.getUserHome(), new String[0]));
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
            toolWindowManager.invokeLater(() -> Companion.customizeProjectUI$lambda$1(project, toolWindowManager));
        }

        private final void patchRootAreaExtensions() {
            ExtensionPointName extensionPointName = Configurable.APPLICATION_CONFIGURABLE;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"APPLICATION_CONFIGURABLE");
            String[] stringArray = new String[]{"preferences.pathVariables"};
            this.unregisterByIds(extensionPointName, stringArray);
            ScriptedTableFileEditorProvider.OpenDetectedTables.overrideDefaultOpenOption((ScriptedTableFileEditorProvider.OpenDetectedTables)ScriptedTableFileEditorProvider.OpenDetectedTables.ALL);
            ExtensionPointName extensionPointName2 = UsageGroupingRuleProvider.EP_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName2, (String)"EP_NAME");
            stringArray = new String[]{"com.intellij.usages.impl.UsageGroupingRuleProviderImpl"};
            this.unregisterByClass(extensionPointName2, stringArray);
            ExtensionPointName extensionPointName3 = SearchEverywhereContributor.EP_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName3, (String)"EP_NAME");
            stringArray = new String[]{"org.jetbrains.yaml.navigation.YAMLKeysSearchEverywhereContributor$Factory", "com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor$Factory"};
            this.unregisterByClass(extensionPointName3, stringArray);
            ExtensionPointName extensionPointName4 = InternalTemplateBean.EP_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName4, (String)"EP_NAME");
            stringArray = new String[]{"html", "html4", "xhtml"};
            this.unregisterByIds(extensionPointName4, stringArray);
            this.patchConfigurables();
            this.removeOptimizeImports();
        }

        private final void patchConfigurables() {
            for (ConfigurableEP ep : Configurable.APPLICATION_CONFIGURABLE.getExtensionList()) {
                if (Intrinsics.areEqual((Object)"database.main", (Object)ep.id)) {
                    ep.groupId = "database.main";
                    ep.groupWeight = 1000;
                    continue;
                }
                if (Intrinsics.areEqual((Object)"project.propDebugger", (Object)ep.id)) {
                    ep.parentId = "tools";
                    continue;
                }
                if (Intrinsics.areEqual((Object)"database.data.csv.formats", (Object)ep.id)) {
                    ep.groupId = "database.main";
                    ep.groupWeight = 200;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)"Console", (Object)ep.id)) continue;
                ep.key = "configurable.Output.Console.display.name";
                ep.bundle = "messages.DataGripBundle";
            }
            ConfigurableExtensionPointUtil.patch((String)"build", (String)"tools", (String)"messages.DataGripBundle");
            ConfigurableExtensionPointUtil.patch((String)"language", null, (String)"messages.DataGripBundle");
        }

        private final void patchProjectAreaExtensions(Project project) {
            for (ConfigurableEP ep : Configurable.PROJECT_CONFIGURABLE.getExtensions((AreaInstance)project)) {
                if (Intrinsics.areEqual((Object)"sql.dialects.configurable", (Object)ep.key) || Intrinsics.areEqual((Object)"sql.resolve.configurable", (Object)ep.key)) {
                    ep.groupId = "database.main";
                    continue;
                }
                if (!Intrinsics.areEqual((Object)"coverage", (Object)ep.id)) continue;
                ep.parentId = "tools";
            }
        }

        private final void patchKeymap() {
            KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
            Object[] objectArray = new String[]{"OptimizeImports", "RearrangeCode", "MethodHierarchy", "CompileDirty", "Compile"};
            Set droppedActions = SetsKt.mutableSetOf((Object[])objectArray);
            String databaseId = ActivateToolWindowAction.Manager.getActionIdForToolWindow((String)"Database");
            String projectId = ActivateToolWindowAction.Manager.getActionIdForToolWindow((String)"Project");
            String bookmarksId = ActivateToolWindowAction.Manager.getActionIdForToolWindow((String)"Bookmarks");
            Iterator iterator = ArrayIteratorKt.iterator((Object[])keymapManager.getAllKeymaps());
            while (iterator.hasNext()) {
                Keymap keymap = (Keymap)iterator.next();
                if (keymap.canModify()) continue;
                Intrinsics.checkNotNull((Object)keymap, (String)"null cannot be cast to non-null type com.intellij.openapi.keymap.impl.KeymapImpl");
                KeymapImpl keymapImpl = (KeymapImpl)keymap;
                com.intellij.database.ide.DataGripPluginConfigurator$Companion.rebindShortcut$default(this, keymapImpl, projectId, databaseId, false, 8, null);
                com.intellij.database.ide.DataGripPluginConfigurator$Companion.rebindShortcut$default(this, keymapImpl, bookmarksId, projectId, false, 8, null);
                com.intellij.database.ide.DataGripPluginConfigurator$Companion.rebindShortcut$default(this, keymapImpl, "GotoImplementation", "GotoRelated", false, 8, null);
                this.rebindShortcut(keymapImpl, "ShowProjectStructureSettings", "DatabaseView.PropertiesAction", true);
                com.intellij.database.ide.DataGripPluginConfigurator$Companion.rebindShortcut$default(this, keymapImpl, "GotoClass", "GotoDatabaseObject", false, 8, null);
                for (String id : keymapImpl.getOwnActionIds()) {
                    if (!droppedActions.contains(id)) continue;
                    keymapImpl.clearOwnActionsId(id);
                }
            }
        }

        private final void rebindShortcut(KeymapImpl keymapImpl, String from, String to, boolean preserve) {
            if (!keymapImpl.hasOwnActionId(from)) {
                if (to != null && keymapImpl.hasOwnActionId(to)) {
                    keymapImpl.clearOwnActionsId(to);
                }
                return;
            }
            if (to != null) {
                Shortcut[] prev = keymapImpl.getShortcuts(to);
                for (Shortcut shortcut : keymapImpl.getShortcuts(from)) {
                    keymapImpl.addShortcut(to, shortcut);
                }
                for (Shortcut shortcut : prev) {
                    Object[] cur;
                    if (ArraysKt.indexOf((Object[])cur, (Object)shortcut) >= 0) continue;
                    keymapImpl.removeShortcut(to, shortcut);
                    if (!preserve) continue;
                    keymapImpl.addShortcut(to, shortcut);
                }
            }
            keymapImpl.clearOwnActionsId(from);
        }

        static /* synthetic */ void rebindShortcut$default(Companion companion, KeymapImpl keymapImpl, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.rebindShortcut(keymapImpl, string, string2, bl);
        }

        private final void removeOptimizeImports() {
            ExtensionPointName extensionPointName = CheckinHandlerFactory.EP_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"EP_NAME");
            String[] stringArray = new String[]{"com.intellij.openapi.vcs.checkin.OptimizeOptionsCheckinHandlerFactory", "com.intellij.openapi.vcs.checkin.RearrangeCheckinHandlerFactory"};
            this.unregisterByClass(extensionPointName, stringArray);
        }

        private final void unregisterByIds(ExtensionPointName<?> epName, String ... ids) {
            this.unregisterImpl(epName, (arg_0, arg_1) -> Companion.unregisterByIds$lambda$2(ids, arg_0, arg_1));
        }

        private final void unregisterByClass(ExtensionPointName<?> epName, String ... classNames) {
            this.unregisterImpl(epName, (arg_0, arg_1) -> Companion.unregisterByClass$lambda$3(classNames, arg_0, arg_1));
        }

        private final void unregisterImpl(ExtensionPointName<?> epName, BiPredicate<String, ExtensionComponentAdapter> predicate) {
            epName.getPoint().unregisterExtensions(predicate, false);
        }

        private static final void enableSingleStripe$lambda$0() {
            boolean hasActionOnToolbar = EnableStripeGroup.Companion.hasActionOnToolbar();
            boolean isLocaleChanged = Companion.trackLocaleChange();
            boolean shouldEnable = false;
            if (!Companion.checkOneTimeFlag("DG.SingleStripe.Customization2")) {
                boolean wasDisabled = PropertiesComponent.getInstance().getBoolean("DG.SingleStripe.Customization") && !hasActionOnToolbar;
                PropertiesComponent.getInstance().unsetValue("DG.SingleStripe.Customization");
                shouldEnable = !wasDisabled;
            } else if (hasActionOnToolbar) {
                shouldEnable = false;
            } else {
                boolean bl = shouldEnable = EnableStripeGroup.Companion.shouldSingleStripeBeEnabled() && isLocaleChanged;
            }
            if (shouldEnable) {
                EnableStripeGroup.Companion.setSingleStripeEnabled(true);
            }
        }

        private static final void customizeProjectUI$lambda$1(Project $project, ToolWindowManager $toolWindowManager) {
            block1: {
                ToolWindow window;
                if (FileEditorManager.getInstance((Project)$project).hasOpenFiles()) break block1;
                ToolWindow toolWindow = window = $toolWindowManager.getToolWindow("Database");
                if (toolWindow != null) {
                    toolWindow.activate(null);
                }
            }
        }

        private static final boolean unregisterByIds$lambda$2(String[] $ids, String className, ExtensionComponentAdapter adapter) {
            ExtensionComponentAdapter extensionComponentAdapter = adapter;
            Intrinsics.checkNotNull((Object)extensionComponentAdapter);
            return !ArrayUtil.contains((String)extensionComponentAdapter.getOrderId(), (String[])Arrays.copyOf($ids, $ids.length));
        }

        private static final boolean unregisterByClass$lambda$3(String[] $classNames, String className, ExtensionComponentAdapter adapter) {
            return !ArrayUtil.contains((String)className, (String[])Arrays.copyOf($classNames, $classNames.length));
        }

        public static final /* synthetic */ void access$customizeRootUI(Companion $this, RecentProjectsManagerBase recentProjectsManager, CodeInsightSettings codeInsightSettings) {
            $this.customizeRootUI(recentProjectsManager, codeInsightSettings);
        }

        public static final /* synthetic */ void access$patchProjectAreaExtensions(Companion $this, Project project) {
            $this.patchProjectAreaExtensions(project);
        }

        public static final /* synthetic */ void access$customizeProjectUI(Companion $this, Project project) {
            $this.customizeProjectUI(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/ide/DataGripPluginConfigurator$PatchKeymap;", "Lcom/intellij/openapi/actionSystem/impl/ActionConfigurationCustomizer;", "Lcom/intellij/openapi/actionSystem/impl/ActionConfigurationCustomizer$LightCustomizeStrategy;", "<init>", "()V", "customize", "", "actionRegistrar", "Lcom/intellij/openapi/actionSystem/ex/ActionRuntimeRegistrar;", "(Lcom/intellij/openapi/actionSystem/ex/ActionRuntimeRegistrar;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.datagrip.impl"})
    public static final class PatchKeymap
    implements ActionConfigurationCustomizer,
    ActionConfigurationCustomizer.LightCustomizeStrategy {
        @Nullable
        public Object customize(@NotNull ActionRuntimeRegistrar actionRegistrar, @NotNull Continuation<? super Unit> $completion) {
            Companion.patchRunWidget(actionRegistrar);
            Companion.removeFromGroup(actionRegistrar, "SettingsEntryPointGroup", PatchKeymap::customize$lambda$0);
            AppJavaExecutorUtil.executeOnPooledIoThread(PatchKeymap::customize$lambda$1);
            return Unit.INSTANCE;
        }

        private static final boolean customize$lambda$0(String id) {
            return Intrinsics.areEqual((Object)"RunAnything", (Object)id);
        }

        private static final void customize$lambda$1() {
            Companion.patchKeymap();
        }
    }
}

