<ATTRIBUTE>#[macro_use]</ATTRIBUTE>
extern crate <CRATE>log</CRATE>;

use std::collections::<STRUCT>HashMap</STRUCT>;
use std::rc::<STRUCT>Rc</STRUCT>;

mod <MODULE>stuff</MODULE>;

pub enum <ENUM>Flag</ENUM> {
    <ENUM_VARIANT>Good</ENUM_VARIANT>,
    <ENUM_VARIANT>Bad</ENUM_VARIANT>,
    <ENUM_VARIANT>Ugly</ENUM_VARIANT>
}

impl <ENUM>Flag</ENUM> {
    fn <METHOD>is_good</METHOD>(&self) -> bool {
        match *self {
            <ENUM>Flag</ENUM>::<ENUM_VARIANT>Good</ENUM_VARIANT> => true,
            _ => false
        }
    }

    fn <ASSOC_FUNCTION>new</ASSOC_FUNCTION>() -> Self {
        <ENUM>Flag</ENUM>::<ENUM_VARIANT>Good</ENUM_VARIANT>
    }
}

fn <FUNCTION>create_good_flag</FUNCTION>() -> <ENUM>Flag</ENUM> {
    let <VARIABLE>flag</VARIABLE> = <ENUM>Flag</ENUM>::<ASSOC_FUNCTION>new</ASSOC_FUNCTION>();
    <MACRO>assert!</MACRO>(<VARIABLE>flag</VARIABLE>.<METHOD_CALL>is_good</METHOD_CALL>());
    <VARIABLE>flag</VARIABLE>
}

const <CONSTANT>QUALITY</CONSTANT>: <ENUM>Flag</ENUM> = <ENUM>Flag</ENUM>::<ENUM_VARIANT>Good</ENUM_VARIANT>;

static <STATIC>COUNTER</STATIC>: <STRUCT>AtomicUsize</STRUCT> = <STRUCT>AtomicUsize</STRUCT>::<ASSOC_FUNCTION_CALL>new</ASSOC_FUNCTION_CALL>(0);

extern "C" {
    static mut <MUT_STATIC>ERROR_MESSAGE</MUT_STATIC>: *mut std::os::raw::c_char;
}

struct Table<const <CONST_PARAMETER>N</CONST_PARAMETER>: usize>([[i32; <CONST_PARAMETER>N</CONST_PARAMETER>]; <CONST_PARAMETER>N</CONST_PARAMETER>])

pub trait <TRAIT>Write</TRAIT> {
    fn <TRAIT_METHOD>write</TRAIT_METHOD>(&mut <SELF_PARAMETER>self</SELF_PARAMETER>, <PARAMETER>buf</PARAMETER>: &[<PRIMITIVE_TYPE>u8</PRIMITIVE_TYPE>]) -> <ENUM>Result</ENUM><usize>;
}

struct <STRUCT>Object</STRUCT><<TYPE_PARAMETER>T</TYPE_PARAMETER>> {
    <FIELD>flag</FIELD>: <ENUM>Flag</ENUM>,
    <FIELD>fields</FIELD>: <STRUCT>HashMap</STRUCT><<TYPE_PARAMETER>T</TYPE_PARAMETER>, <PRIMITIVE_TYPE>u64</PRIMITIVE_TYPE>>
}

<KEYWORD>union</KEYWORD> <UNION>MyUnion</UNION> {
    <FIELD>f1</FIELD>: <PRIMITIVE_TYPE>u32</PRIMITIVE_TYPE>,
    <FIELD>f2</FIELD>: <PRIMITIVE_TYPE>f32</PRIMITIVE_TYPE>,
}

type <TYPE_ALIAS>RcObject</TYPE_ALIAS><<TYPE_PARAMETER>T</TYPE_PARAMETER>> = <STRUCT>Rc</STRUCT><<STRUCT>Object</STRUCT><<TYPE_PARAMETER>T</TYPE_PARAMETER>>>;

impl<<TYPE_PARAMETER>T</TYPE_PARAMETER>> Write for <STRUCT>Object</STRUCT><<TYPE_PARAMETER>T</TYPE_PARAMETER>> {
    fn <TRAIT_METHOD>write</TRAIT_METHOD>(&mut <SELF_PARAMETER>self</SELF_PARAMETER>, <PARAMETER>buf</PARAMETER>: &[<PRIMITIVE_TYPE>u8</PRIMITIVE_TYPE>]) -> <ENUM>Result</ENUM><usize> {
        let <VARIABLE>s</VARIABLE> = stuff::<FUNCTION_CALL>write_map</FUNCTION_CALL>(&self.<FIELD>fields</FIELD>, <PARAMETER>buf</PARAMETER>)<Q_OPERATOR>?</Q_OPERATOR>;
        <MACRO>info!</MACRO>("{} byte(s) written", <VARIABLE>s</VARIABLE>);
        <ENUM_VARIANT>Ok</ENUM_VARIANT>(<VARIABLE>s</VARIABLE>)
    }
}

impl<<TYPE_PARAMETER>T</TYPE_PARAMETER>> <TRAIT>Default</TRAIT> for <STRUCT>Object</STRUCT><<TYPE_PARAMETER>T</TYPE_PARAMETER>> {
    fn <ASSOC_TRAIT_FUNCTION>default</ASSOC_TRAIT_FUNCTION>() -> Self {
        <STRUCT>Object</STRUCT> { <FIELD>flag</FIELD>: <ENUM>Flag</ENUM>::<ENUM_VARIANT>Good</ENUM_VARIANT>, <FIELD>fields</FIELD>: <STRUCT>HashMap</STRUCT>::<ASSOC_FUNCTION_CALL>new</ASSOC_FUNCTION_CALL>() }
    }
}

impl<<TYPE_PARAMETER>T</TYPE_PARAMETER>> <STRUCT>Object</STRUCT><<TYPE_PARAMETER>T</TYPE_PARAMETER>> {
    fn <METHOD>new</METHOD>() -> Self {
        <STRUCT>Object</STRUCT>::<ASSOC_TRAIT_FUNCTION_CALL>default</ASSOC_TRAIT_FUNCTION_CALL>()
    }

    fn <METHOD>set_flag</METHOD>(&mut <MUT_SELF_PARAMETER>self</MUT_SELF_PARAMETER>, <PARAMETER>flag</PARAMETER>: <ENUM>Flag</ENUM>) {
        <SELF_PARAMETER>self</SELF_PARAMETER>.<FIELD>flag</FIELD> = <PARAMETER>flag</PARAMETER>;
    }
}

<MACRO_RULES>macro_rules</MACRO_RULES><MACRO_EXCL>!</MACRO_EXCL> <MACRO_IDENTIFIER>make_wrapper</MACRO_IDENTIFIER> {
    (<MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>wrapper_ty</MACRO_META_VAR_IDENTIFIER><MACRO_COLON>:</MACRO_COLON><MACRO_BINDING_IDENTIFIER>ident</MACRO_BINDING_IDENTIFIER>, <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>base_ty</MACRO_META_VAR_IDENTIFIER><MACRO_COLON>:</MACRO_COLON><MACRO_BINDING_IDENTIFIER>ty</MACRO_BINDING_IDENTIFIER> <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_GROUP_ELEMENTS>(</MACRO_GROUP_ELEMENTS>, <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>lu_ty</MACRO_META_VAR_IDENTIFIER><MACRO_COLON>:</MACRO_COLON><MACRO_BINDING_IDENTIFIER>ty</MACRO_BINDING_IDENTIFIER><MACRO_GROUP_ELEMENTS>)</MACRO_GROUP_ELEMENTS><MACRO_GROUP_ELEMENTS>?</MACRO_GROUP_ELEMENTS>) => {
        pub struct <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>wrapper_ty</MACRO_META_VAR_IDENTIFIER>(<MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>base_ty</MACRO_META_VAR_IDENTIFIER>);
        impl From<<MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>base_ty</MACRO_META_VAR_IDENTIFIER>> for <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>wrapper_ty</MACRO_META_VAR_IDENTIFIER> {
            fn from(base: <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>base_ty</MACRO_META_VAR_IDENTIFIER>) -> Self {
                Self(base)
            }
        }
        <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_GROUP_ELEMENTS>(</MACRO_GROUP_ELEMENTS>
            impl From<<MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>lu_ty</MACRO_META_VAR_IDENTIFIER>> for <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>wrapper_ty</MACRO_META_VAR_IDENTIFIER> {
                fn from(lu: <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>lu_ty</MACRO_META_VAR_IDENTIFIER>) -> Self {
                    Self(lu.get())
                }
            }
            impl From<<MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>wrapper_ty</MACRO_META_VAR_IDENTIFIER>> for <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>lu_ty</MACRO_META_VAR_IDENTIFIER> {
                fn from(st: <MACRO_DOLLAR>$</MACRO_DOLLAR><MACRO_META_VAR_IDENTIFIER>wrapper_ty</MACRO_META_VAR_IDENTIFIER>) -> Self {
                    Self::new(st.0)
                }
            }
        <MACRO_GROUP_ELEMENTS>)</MACRO_GROUP_ELEMENTS><MACRO_GROUP_ELEMENTS>?</MACRO_GROUP_ELEMENTS>
    }
}


/* Block comment */
fn <FUNCTION>main</FUNCTION>() {
    // A simple integer calculator:
    // `+` or `-` means add or subtract by 1
    // `*` or `/` means multiply or divide by 2
    <MODULE>stuff</MODULE>::<STRUCT>AppVersion</STRUCT>::<ASSOC_FUNCTION_CALL>print</ASSOC_FUNCTION_CALL>();

    let <VARIABLE>input</VARIABLE> = <ENUM>Option</ENUM>::<ENUM_VARIANT>None</ENUM_VARIANT>;
    let <VARIABLE>program</VARIABLE> = <VARIABLE>input</VARIABLE>.<TRAIT_METHOD_CALL>unwrap_or_else</TRAIT_METHOD_CALL>(<CLOSURE>||</CLOSURE> "+ + * - /");
    let mut <MUT_BINDING><VARIABLE>accumulator</VARIABLE></MUT_BINDING> = 0;

    for <VARIABLE>token</VARIABLE> in <VARIABLE>program</VARIABLE>.<METHOD_CALL>chars</METHOD_CALL>() {
        match <VARIABLE>token</VARIABLE> {
            '+' => <MUT_BINDING><VARIABLE>accumulator</VARIABLE></MUT_BINDING> += 1,
            '-' => <MUT_BINDING><VARIABLE>accumulator</VARIABLE></MUT_BINDING> -= 1,
            '*' => <MUT_BINDING><VARIABLE>accumulator</VARIABLE></MUT_BINDING> *= 2,
            '/' => <MUT_BINDING><VARIABLE>accumulator</VARIABLE></MUT_BINDING> /= 2,
            _ => { /* ignore everything else */ }
        }
    }

    <MACRO>info!</MACRO>("The program \"{}\" calculates the value {}",
            <VARIABLE>program</VARIABLE>, <MUT_BINDING><VARIABLE>accumulator</VARIABLE></MUT_BINDING>);
}

<DOC_COMMENT>/// Some documentation <DOC_CODE>`with a code`</DOC_CODE>, <DOC_EMPHASIS>*an italic text*</DOC_EMPHASIS>
/// and <DOC_STRONG>**a bold text**</DOC_STRONG>
/// <DOC_HEADING># Heading</DOC_HEADING>
/// <DOC_LINK>[Rust](https://www.rust-lang.org/)</DOC_LINK></DOC_COMMENT>
<ATTRIBUTE>#[cfg(target_os=</ATTRIBUTE>"linux"<ATTRIBUTE>)]</ATTRIBUTE>
<KEYWORD_UNSAFE>unsafe</KEYWORD_UNSAFE> fn <FUNCTION>a_function</FUNCTION><<TYPE_PARAMETER>T</TYPE_PARAMETER>: <LIFETIME>'lifetime</LIFETIME>>(<MUT_PARAMETER>count</MUT_PARAMETER>: &mut i64) -> ! {
    <MUT_PARAMETER>count</MUT_PARAMETER> += 1;
    'label: loop {
        let mut <MUT_BINDING><VARIABLE>str_with_escapes</VARIABLE></MUT_BINDING> = <STRUCT>String</STRUCT>::<ASSOC_FUNCTION_CALL>new</ASSOC_FUNCTION_CALL>(
            "Hello\x20W\u{f3}rld!\u{abcdef}"
        );
        <MUT_BINDING><VARIABLE>str_with_escapes</VARIABLE></MUT_BINDING> <OVERLOADED_OPERATOR>+=</OVERLOADED_OPERATOR> "more";
        <MACRO>println!</MACRO>("<FORMAT_PARAMETER>{}</FORMAT_PARAMETER> <FORMAT_PARAMETER>{<FORMAT_SPECIFIER>foo</FORMAT_SPECIFIER>:<<FORMAT_SPECIFIER>4</FORMAT_SPECIFIER>}</FORMAT_PARAMETER>", str_with_escapes, foo = 42);
    }
}

fn <FUNCTION>test</FUNCTION>() {
    <KEYWORD_UNSAFE>unsafe</KEYWORD_UNSAFE> {
        <UNSAFE_CODE>a_function</UNSAFE_CODE>(1);
    }
}

<CFG_DISABLED_CODE>#[cfg(feature = "disabled_feature")]
fn cfg_disabled_function() {}</CFG_DISABLED_CODE>
