from common import RegisterStacking
from common.cortex_m import line_by_part_num, CPUID, ARM_CPUID_PARTNO_MASK, deref_long_from_addr

cortex_m_stack_offsets = {
    "sp": -1,
    "r4": 0x04,
    "r5": 0x08,
    "r6": 0x0C,
    "r7": 0x10,
    "r8": 0x14,
    "r9": 0x18,
    "r10": 0x1C,
    "r11": 0x20,
    "r0": 0x24,
    "r1": 0x28,
    "r2": 0x2C,
    "r3": 0x30,
    "r12": 0x34,
    "lr": 0x38,
    "pc": 0x3C,
    "xPSR": 0x40,
}

cortex_m_fpu_stack_offsets = {
    "sp": -1,
    "r4": 0x44,
    "r5": 0x48,
    "r6": 0x4C,
    "r7": 0x50,
    "r8": 0x54,
    "r9": 0x58,
    "r10": 0x5C,
    "r11": 0x60,
    "r0": 0x64,
    "r1": 0x68,
    "r2": 0x6C,
    "r3": 0x70,
    "r12": 0x74,
    "lr": 0x78,
    "pc": 0x7C,
    "xPSR": 0x80,
}


def get_arm_cm_azure_stacking(stack_ptr, uint32_type):
    i = deref_long_from_addr(CPUID, uint32_type) & ARM_CPUID_PARTNO_MASK
    line = line_by_part_num[i]
    if line.startswith("ARM_CM"):
        print("Detected " + line)

        if (deref_long_from_addr(stack_ptr, uint32_type) & 0x10) != 0x10:  # read EXC_RETURN
            frame_size = 0xC8
            stack_offsets = cortex_m_fpu_stack_offsets
            print("Detected FPU")
        else:
            frame_size = 0x44
            stack_offsets = cortex_m_stack_offsets

        # Check if stack aligned to 8 bytes
        if (deref_long_from_addr(stack_ptr + stack_offsets["xPSR"], uint32_type) & 0x100) == 0x100:  # read CCR.STKALIGN
            frame_size += 0x4

        print("Detected size:" + str(frame_size))
        return RegisterStacking(frame_size, stack_offsets)

    print("Unknown MCU!")
    return RegisterStacking(0x44, cortex_m_stack_offsets)
