/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.platformio.project;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.cidr.CidrProjectOpenProcessor;
import com.jetbrains.cidr.ProjectOpenHelper;
import com.jetbrains.cidr.cpp.embedded.platformio.PlatformioFileType;
import com.jetbrains.cidr.cpp.embedded.platformio.project.PlatformioProjectSettings;
import com.jetbrains.cidr.cpp.embedded.platformio.project.PlatformioWorkspace;
import com.jetbrains.cidr.cpp.embedded.platformio.project.PlatformioWorkspaceKt;
import com.jetbrains.cidr.cpp.external.system.CLionExternalUtilKt;
import com.jetbrains.cidr.external.system.fus.CidrExternalUsageUtil;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor;", "Lcom/jetbrains/cidr/CidrProjectOpenProcessor;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "openProjectAsync", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectToClose", "forceOpenInNewFrame", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "linkPlatformioProject", "", "project", "projectPath", "Companion", "intellij.clion.embedded.platformio"})
@SourceDebugExtension(value={"SMAP\nPlatformioProjectOpenProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformioProjectOpenProcessor.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,63:1\n30#2,2:64\n*S KotlinDebug\n*F\n+ 1 PlatformioProjectOpenProcessor.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor\n*L\n42#1:64,2\n*E\n"})
public final class PlatformioProjectOpenProcessor
extends CidrProjectOpenProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Key<Companion.OpenProjectSpec> DATA_KEY;

    public PlatformioProjectOpenProcessor() {
        super((ProjectOpenHelper)Companion.PlatformioProjectOpenHelper.INSTANCE);
        this.name = "PlatformIO";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Object openProjectAsync(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull Continuation<? super Project> $completion) {
        VirtualFile virtualFile2 = Companion.PlatformioProjectOpenHelper.INSTANCE.findSupportedSubFile(virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile platformioIniFile = virtualFile2;
        Project existingProject = Companion.PlatformioProjectOpenHelper.INSTANCE.openExistingProjectInDirectory(platformioIniFile, projectToClose, forceOpenInNewFrame);
        if (existingProject != null) {
            return existingProject;
        }
        Companion.OpenProjectSpec spec = new Companion.OpenProjectSpec(platformioIniFile);
        Project project = ProjectOpenHelper.openProject$default((ProjectOpenHelper)Companion.PlatformioProjectOpenHelper.INSTANCE, (VirtualFile)platformioIniFile, (Project)projectToClose, (boolean)forceOpenInNewFrame, (Object)spec, null, (int)16, null);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        CidrExternalUsageUtil.INSTANCE.logProjectCreated(PlatformioWorkspaceKt.getID(), project2);
        VirtualFile externalProjectPath = platformioIniFile.getParent();
        Intrinsics.checkNotNull((Object)externalProjectPath);
        this.linkPlatformioProject(project2, externalProjectPath);
        return project2;
    }

    @RequiresEdt
    public final void linkPlatformioProject(@NotNull Project project, @NotNull VirtualFile projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        PlatformioProjectSettings settings = PlatformioProjectSettings.Companion.default();
        settings.setExternalProjectPath(projectPath.getPath());
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<PlatformioWorkspace> serviceClass$iv = PlatformioWorkspace.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        PlatformioWorkspace workspace = (PlatformioWorkspace)((Object)object);
        CLionExternalUtilKt.linkExternalProject((Project)project, (ProjectSystemId)PlatformioWorkspaceKt.getID(), (ExternalProjectSettings)settings, (ExternalWorkspace)workspace);
    }

    static {
        Key key = Key.create((String)"PLATFORMIO_FILE_TO_OPEN_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DATA_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor$Companion;", "", "<init>", "()V", "DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor$Companion$OpenProjectSpec;", "PlatformioProjectOpenHelper", "OpenProjectSpec", "SupportedFileChecker", "intellij.clion.embedded.platformio"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor$Companion$OpenProjectSpec;", "", "platformioIni", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getPlatformioIni", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clion.embedded.platformio"})
        public static final class OpenProjectSpec {
            @NotNull
            private final VirtualFile platformioIni;

            public OpenProjectSpec(@NotNull VirtualFile platformioIni) {
                Intrinsics.checkNotNullParameter((Object)platformioIni, (String)"platformioIni");
                this.platformioIni = platformioIni;
            }

            @NotNull
            public final VirtualFile getPlatformioIni() {
                return this.platformioIni;
            }

            @NotNull
            public final VirtualFile component1() {
                return this.platformioIni;
            }

            @NotNull
            public final OpenProjectSpec copy(@NotNull VirtualFile platformioIni) {
                Intrinsics.checkNotNullParameter((Object)platformioIni, (String)"platformioIni");
                return new OpenProjectSpec(platformioIni);
            }

            public static /* synthetic */ OpenProjectSpec copy$default(OpenProjectSpec openProjectSpec, VirtualFile virtualFile, int n, Object object) {
                if ((n & 1) != 0) {
                    virtualFile = openProjectSpec.platformioIni;
                }
                return openProjectSpec.copy(virtualFile);
            }

            @NotNull
            public String toString() {
                return "OpenProjectSpec(platformioIni=" + this.platformioIni + ")";
            }

            public int hashCode() {
                return this.platformioIni.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OpenProjectSpec)) {
                    return false;
                }
                OpenProjectSpec openProjectSpec = (OpenProjectSpec)other;
                return Intrinsics.areEqual((Object)this.platformioIni, (Object)openProjectSpec.platformioIni);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor$Companion$PlatformioProjectOpenHelper;", "Lcom/jetbrains/cidr/ProjectOpenHelper;", "Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor$Companion$OpenProjectSpec;", "<init>", "()V", "intellij.clion.embedded.platformio"})
        public static final class PlatformioProjectOpenHelper
        extends ProjectOpenHelper<OpenProjectSpec> {
            @NotNull
            public static final PlatformioProjectOpenHelper INSTANCE = new PlatformioProjectOpenHelper();

            private PlatformioProjectOpenHelper() {
                super(DATA_KEY, (ProjectOpenHelper.SupportedFileChecker)SupportedFileChecker.INSTANCE);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor$Companion$SupportedFileChecker;", "Lcom/jetbrains/cidr/ProjectOpenHelper$SupportedFileChecker;", "<init>", "()V", "isSupportedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.clion.embedded.platformio"})
        @SourceDebugExtension(value={"SMAP\nPlatformioProjectOpenProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformioProjectOpenProcessor.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor$Companion$SupportedFileChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,63:1\n12970#2,2:64\n*S KotlinDebug\n*F\n+ 1 PlatformioProjectOpenProcessor.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectOpenProcessor$Companion$SupportedFileChecker\n*L\n57#1:64,2\n*E\n"})
        public static final class SupportedFileChecker
        implements ProjectOpenHelper.SupportedFileChecker {
            @NotNull
            public static final SupportedFileChecker INSTANCE = new SupportedFileChecker();

            private SupportedFileChecker() {
            }

            public boolean isSupportedFile(@NotNull VirtualFile file) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (file.isDirectory()) {
                        VirtualFile[] virtualFileArray = file.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                        Object[] $this$any$iv = virtualFileArray;
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            VirtualFile p0 = (VirtualFile)element$iv;
                            boolean bl2 = false;
                            if (!PlatformioFileType.isFileOfType(p0)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    } else {
                        bl = PlatformioFileType.isFileOfType(file);
                    }
                }
                return bl;
            }
        }
    }
}

