/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.platformio.project;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.CustomStepProjectGenerator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.GeneratorPeerImpl;
import com.intellij.platform.ProjectGeneratorPeer;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.CLionProjectGenerator;
import com.jetbrains.cidr.cpp.embedded.platformio.ClionEmbeddedPlatformioBundle;
import com.jetbrains.cidr.cpp.embedded.platformio.project.BoardInfo;
import com.jetbrains.cidr.cpp.embedded.platformio.project.PlatformioProjectGeneratorKt;
import com.jetbrains.cidr.cpp.embedded.platformio.project.PlatformioProjectOpenProcessor;
import com.jetbrains.cidr.cpp.embedded.platformio.project.PlatformioProjectSettingsStep;
import com.jetbrains.cidr.cpp.embedded.platformio.project.SourceTemplate;
import icons.ClionEmbeddedPlatformioIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J4\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\r\u0010\u001e\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016\u00a8\u0006\""}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioProjectGenerator;", "Lcom/jetbrains/cidr/cpp/cmake/projectWizard/generators/CLionProjectGenerator;", "Lcom/intellij/openapi/util/Ref;", "Lcom/jetbrains/cidr/cpp/embedded/platformio/project/BoardInfo;", "Lcom/intellij/ide/util/projectWizard/CustomStepProjectGenerator;", "<init>", "()V", "createStep", "Lcom/intellij/openapi/wm/impl/welcomeScreen/AbstractActionWithPanel;", "projectGenerator", "Lcom/intellij/platform/DirectoryProjectGenerator;", "callback", "Lcom/intellij/ide/util/projectWizard/AbstractNewProjectStep$AbstractCallback;", "getLogo", "Ljavax/swing/Icon;", "generateProject", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "module", "Lcom/intellij/openapi/module/Module;", "createPeer", "Lcom/intellij/platform/ProjectGeneratorPeer;", "getGroupName", "", "getGroupOrder", "", "getGroupDisplayName", "Lorg/jetbrains/annotations/Nls;", "getName", "getDescription", "intellij.clion.embedded.platformio"})
public final class PlatformioProjectGenerator
extends CLionProjectGenerator<Ref<BoardInfo>>
implements CustomStepProjectGenerator<Ref<BoardInfo>> {
    @NotNull
    public AbstractActionWithPanel createStep(@NotNull DirectoryProjectGenerator<Ref<BoardInfo>> projectGenerator, @NotNull AbstractNewProjectStep.AbstractCallback<Ref<BoardInfo>> callback) {
        Intrinsics.checkNotNullParameter(projectGenerator, (String)"projectGenerator");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return (AbstractActionWithPanel)new PlatformioProjectSettingsStep(projectGenerator, callback);
    }

    @NotNull
    public Icon getLogo() {
        Icon icon = ClionEmbeddedPlatformioIcons.LogoPlatformIO;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LogoPlatformIO");
        return icon;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<BoardInfo> settings, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super.generateProject(project, baseDir, settings, module);
        Key<BoardInfo> key = PlatformioProjectGeneratorKt.getPROJECT_INIT_KEY();
        BoardInfo boardInfo = (BoardInfo)settings.get();
        if (boardInfo == null) {
            boardInfo = new BoardInfo(SourceTemplate.ARDUINO, CollectionsKt.emptyList());
        }
        project.putUserData(key, (Object)boardInfo);
        new PlatformioProjectOpenProcessor().linkPlatformioProject(project, baseDir);
    }

    @NotNull
    public ProjectGeneratorPeer<Ref<BoardInfo>> createPeer() {
        return (ProjectGeneratorPeer)new GeneratorPeerImpl((Object)new Ref(), (JComponent)new JPanel());
    }

    @NotNull
    public String getGroupName() {
        return "Embedded";
    }

    public int getGroupOrder() {
        return CLionProjectGenerator.GroupOrders.EMBEDDED.order + 1;
    }

    @NotNull
    public String getGroupDisplayName() {
        Object t = EmbeddedBundle.messagePointer((String)"embedded.display.name", (Object[])new Object[0]).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (String)t;
    }

    @NotNull
    public String getName() {
        String string = ClionEmbeddedPlatformioBundle.message("platformio.project.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = ClionEmbeddedPlatformioBundle.message("platformio.project.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

