/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.platformio.project;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Platform;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.embedded.platformio.ClionEmbeddedPlatformioBundle;
import com.jetbrains.cidr.cpp.embedded.platformio.PlatformioConfigurable;
import com.jetbrains.cidr.cpp.embedded.platformio.PlatformioDebugConfiguration;
import com.jetbrains.cidr.cpp.embedded.platformio.PlatformioService;
import com.jetbrains.cidr.cpp.embedded.platformio.project.PlatformioExecutionTarget;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\f\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\f\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J\u0010\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioCliBuilder;", "", "usePty", "", "project", "Lcom/intellij/openapi/project/Project;", "useEnvName", "verboseAllowed", "<init>", "(ZLcom/intellij/openapi/project/Project;ZZ)V", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "withParams", "params", "", "", "([Ljava/lang/String;)Lcom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioCliBuilder;", "", "withEnvName", "appendKeys", "withVerboseAllowed", "build", "withGdbHomeCompatibility", "withRedirectErrorStream", "q", "intellij.clion.embedded.platformio"})
@SourceDebugExtension(value={"SMAP\nPlatformioCliBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformioCliBuilder.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioCliBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1#2:102\n30#3,2:103\n19#4:105\n2746#5,3:106\n*S KotlinDebug\n*F\n+ 1 PlatformioCliBuilder.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/project/PlatformioCliBuilder\n*L\n61#1:103,2\n66#1:105\n76#1:106,3\n*E\n"})
public final class PlatformioCliBuilder {
    @Nullable
    private final Project project;
    private boolean useEnvName;
    private boolean verboseAllowed;
    @NotNull
    private final GeneralCommandLine commandLine;

    public PlatformioCliBuilder(boolean usePty, @Nullable Project project, boolean useEnvName, boolean verboseAllowed) {
        GeneralCommandLine generalCommandLine;
        boolean bl;
        this.project = project;
        this.useEnvName = useEnvName;
        this.verboseAllowed = verboseAllowed;
        Project project2 = this.project;
        if (project2 != null) {
            Project it = project2;
            boolean bl2 = false;
            bl = !TrustedProjects.isProjectTrusted((Project)it);
        } else {
            bl = false;
        }
        if (bl) {
            throw new ExecutionException(ClionEmbeddedPlatformioBundle.message("project.not.trusted", new Object[0]));
        }
        if (usePty) {
            PtyCommandLine ptyCommandLine = new PtyCommandLine().withConsoleMode(false);
            Intrinsics.checkNotNullExpressionValue((Object)ptyCommandLine, (String)"withConsoleMode(...)");
            generalCommandLine = (GeneralCommandLine)ptyCommandLine;
        } else {
            generalCommandLine = new GeneralCommandLine();
        }
        this.commandLine = generalCommandLine;
    }

    public /* synthetic */ PlatformioCliBuilder(boolean bl, Project project, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        this(bl, project, bl2, bl3);
    }

    @NotNull
    public final PlatformioCliBuilder withParams(String ... params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.commandLine.withParameters(Arrays.copyOf(params, params.length));
        return this;
    }

    @NotNull
    public final PlatformioCliBuilder withParams(@NotNull List<String> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.commandLine.withParameters(params);
        return this;
    }

    @NotNull
    public final PlatformioCliBuilder withEnvName(boolean appendKeys) {
        this.useEnvName = appendKeys;
        return this;
    }

    public static /* synthetic */ PlatformioCliBuilder withEnvName$default(PlatformioCliBuilder platformioCliBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return platformioCliBuilder.withEnvName(bl);
    }

    @NotNull
    public final PlatformioCliBuilder withVerboseAllowed(boolean verboseAllowed) {
        this.verboseAllowed = verboseAllowed;
        return this;
    }

    public static /* synthetic */ PlatformioCliBuilder withVerboseAllowed$default(PlatformioCliBuilder platformioCliBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return platformioCliBuilder.withVerboseAllowed(bl);
    }

    @NotNull
    public final GeneralCommandLine build() throws ExecutionException {
        Object object;
        boolean bl;
        String path;
        Path pioBinFolder;
        block15: {
            Object envName;
            PlatformioService service;
            Object $this$service$iv;
            Project project = this.project;
            if (project != null) {
                $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<PlatformioService> serviceClass$iv = PlatformioService.class;
                Object object2 = $this$service$iv.getService(serviceClass$iv);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                v2 = (PlatformioService)object2;
            } else {
                v2 = service = null;
            }
            if (this.verboseAllowed) {
                PlatformioService platformioService = service;
                boolean bl2 = platformioService != null ? platformioService.getVerbose() : false;
                if (bl2) {
                    String[] stringArray = new String[]{"-v"};
                    this.commandLine.withParameters(stringArray);
                }
            }
            this.commandLine.setExePath(PlatformioConfigurable.Companion.pioExePath());
            if (this.useEnvName && this.project != null) {
                ExecutionTarget $this$asSafely$iv = ExecutionTargetManager.getActiveTarget((Project)this.project);
                boolean $i$f$asSafely = false;
                ExecutionTarget executionTarget = $this$asSafely$iv;
                if (!(executionTarget instanceof PlatformioExecutionTarget)) {
                    executionTarget = null;
                }
                PlatformioExecutionTarget platformioExecutionTarget = (PlatformioExecutionTarget)executionTarget;
                envName = platformioExecutionTarget != null ? platformioExecutionTarget.getId() : null;
                $this$service$iv = (CharSequence)envName;
                if (!($this$service$iv == null || $this$service$iv.length() == 0)) {
                    $this$service$iv = new String[]{"-e", envName};
                    this.commandLine.withParameters((String[])$this$service$iv);
                }
            }
            PlatformioService platformioService = service;
            boolean bl3 = platformioService != null ? !platformioService.isUploadPortAuto() : false;
            if (bl3) {
                Map map = this.commandLine.getEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
                envName = map;
                $this$service$iv = "PLATFORMIO_UPLOAD_PORT";
                String $this$asSafely$iv = service.getUploadPort();
                envName.put($this$service$iv, $this$asSafely$iv);
            }
            pioBinFolder = PlatformioConfigurable.Companion.pioBinFolder();
            path = this.commandLine.getEffectiveEnvironment().getOrDefault("PATH", "");
            List list = PathEnvironmentVariableUtil.getPathDirs((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathDirs(...)");
            Iterable $this$none$iv = list;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)pioBinFolder, (Object)Path.of(it, new String[0]))) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (bl) {
            this.commandLine.withEnvironment("PATH", path + Platform.current().pathSeparator + pioBinFolder.toAbsolutePath());
        }
        if ((object = this.project) == null || (object = object.getBasePath()) == null) {
            String string = FileUtil.getTempDirectory();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempDirectory(...)");
        }
        this.commandLine.withWorkDirectory((String)object);
        if (this.project != null) {
            PlatformioDebugConfiguration runConfiguration;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(this.project).getSelectedConfiguration();
            RunConfiguration runConfiguration2 = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
            PlatformioDebugConfiguration platformioDebugConfiguration = runConfiguration = runConfiguration2 instanceof PlatformioDebugConfiguration ? (PlatformioDebugConfiguration)runConfiguration2 : null;
            this.commandLine.withEnvironment(platformioDebugConfiguration != null ? platformioDebugConfiguration.getEnvs() : null);
        }
        return this.commandLine;
    }

    @NotNull
    public final PlatformioCliBuilder withGdbHomeCompatibility() {
        if (this.commandLine.getEffectiveEnvironment().get("HOME") == null) {
            Object v = this.commandLine.getEffectiveEnvironment().get("USERPROFILE");
            Intrinsics.checkNotNull(v);
            this.commandLine.withEnvironment("HOME", (String)v);
        }
        return this;
    }

    @NotNull
    public final PlatformioCliBuilder withRedirectErrorStream(boolean q) {
        this.commandLine.withRedirectErrorStream(q);
        return this;
    }
}

