/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.platformio.project;

import com.jetbrains.cidr.cpp.embedded.platformio.project.BoardInfo;
import icons.ClionEmbeddedPlatformioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001'B.\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0001H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J \u0010\"\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000#H\u0016J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000J\b\u0010&\u001a\u00020\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/DeviceTreeNode;", "Ljavax/swing/tree/TreeNode;", "myParent", "type", "Lcom/jetbrains/cidr/cpp/embedded/platformio/project/DeviceTreeNode$TYPE;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "boardInfo", "Lcom/jetbrains/cidr/cpp/embedded/platformio/project/BoardInfo;", "<init>", "(Lcom/jetbrains/cidr/cpp/embedded/platformio/project/DeviceTreeNode;Lcom/jetbrains/cidr/cpp/embedded/platformio/project/DeviceTreeNode$TYPE;Ljava/lang/String;Lcom/jetbrains/cidr/cpp/embedded/platformio/project/BoardInfo;)V", "getType", "()Lcom/jetbrains/cidr/cpp/embedded/platformio/project/DeviceTreeNode$TYPE;", "getName", "()Ljava/lang/String;", "getBoardInfo", "()Lcom/jetbrains/cidr/cpp/embedded/platformio/project/BoardInfo;", "children", "", "getChildren", "()Ljava/util/List;", "setChildren", "(Ljava/util/List;)V", "getChildAt", "childIndex", "", "getChildCount", "getParent", "getAllowsChildren", "", "getIndex", "node", "isLeaf", "hasSameValues", "Ljava/util/Enumeration;", "add", "child", "toString", "TYPE", "intellij.clion.embedded.platformio"})
public final class DeviceTreeNode
implements TreeNode {
    @Nullable
    private final DeviceTreeNode myParent;
    @NotNull
    private final TYPE type;
    @NotNull
    private final String name;
    @NotNull
    private final BoardInfo boardInfo;
    @NotNull
    private List<DeviceTreeNode> children;

    public DeviceTreeNode(@Nullable DeviceTreeNode myParent, @NotNull TYPE type, @NotNull String name, @NotNull BoardInfo boardInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)boardInfo, (String)"boardInfo");
        this.myParent = myParent;
        this.type = type;
        this.name = name;
        this.boardInfo = boardInfo;
        this.children = new ArrayList();
    }

    @NotNull
    public final TYPE getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final BoardInfo getBoardInfo() {
        return this.boardInfo;
    }

    @NotNull
    public final List<DeviceTreeNode> getChildren() {
        return this.children;
    }

    public final void setChildren(@NotNull List<DeviceTreeNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.children = list;
    }

    @Override
    @NotNull
    public DeviceTreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    @Nullable
    public DeviceTreeNode getParent() {
        return this.myParent;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public int getIndex(@NotNull TreeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return CollectionsKt.indexOf(this.children, (Object)node);
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @TestOnly
    public final boolean hasSameValues(@NotNull String name, @NotNull TYPE type, @NotNull BoardInfo boardInfo) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)boardInfo, (String)"boardInfo");
        return Intrinsics.areEqual((Object)name, (Object)this.name) && type == this.type && Intrinsics.areEqual((Object)boardInfo, (Object)this.boardInfo);
    }

    @NotNull
    public Enumeration<DeviceTreeNode> children() {
        Enumeration<DeviceTreeNode> enumeration = Collections.enumeration((Collection)this.children);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(...)");
        return enumeration;
    }

    @NotNull
    public final DeviceTreeNode add(@NotNull DeviceTreeNode child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        this.children.add(child);
        return child;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/DeviceTreeNode$TYPE;", "", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/lang/String;ILjavax/swing/Icon;)V", "getIcon", "()Ljavax/swing/Icon;", "ROOT", "VENDOR", "BOARD", "FRAMEWORK", "intellij.clion.embedded.platformio"})
    public static final class TYPE
    extends Enum<TYPE> {
        @Nullable
        private final Icon icon;
        public static final /* enum */ TYPE ROOT = new TYPE(null);
        public static final /* enum */ TYPE VENDOR = new TYPE(ClionEmbeddedPlatformioIcons.ComponentVendor);
        public static final /* enum */ TYPE BOARD = new TYPE(ClionEmbeddedPlatformioIcons.ElectronicBoard);
        public static final /* enum */ TYPE FRAMEWORK = new TYPE(ClionEmbeddedPlatformioIcons.SoftwareFramework);
        private static final /* synthetic */ TYPE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TYPE(Icon icon) {
            this.icon = icon;
        }

        @Nullable
        public final Icon getIcon() {
            return this.icon;
        }

        public static TYPE[] values() {
            return (TYPE[])$VALUES.clone();
        }

        public static TYPE valueOf(String value) {
            return Enum.valueOf(TYPE.class, value);
        }

        @NotNull
        public static EnumEntries<TYPE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tYPEArray = new TYPE[]{TYPE.ROOT, TYPE.VENDOR, TYPE.BOARD, TYPE.FRAMEWORK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

