/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.platformio.project;

import com.jetbrains.cidr.cpp.embedded.platformio.project.BoardInfo;
import com.jetbrains.cidr.cpp.embedded.platformio.project.DeviceTreeNode;
import com.jetbrains.cidr.cpp.embedded.platformio.project.SourceTemplate;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.JsonReaderEx;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/project/BoardsJsonParser;", "", "<init>", "()V", "parse", "Lcom/jetbrains/cidr/cpp/embedded/platformio/project/DeviceTreeNode;", "text", "", "readNumber", "", "jsonReader", "Lorg/jetbrains/io/JsonReaderEx;", "convert", "Lkotlin/Function1;", "", "intellij.clion.embedded.platformio"})
public final class BoardsJsonParser {
    @NotNull
    public static final BoardsJsonParser INSTANCE = new BoardsJsonParser();

    private BoardsJsonParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DeviceTreeNode parse(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SortedMap boardsByVendor = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        DeviceTreeNode rootNode = new DeviceTreeNode(null, DeviceTreeNode.TYPE.ROOT, "", SourceTemplate.Companion.getEMPTY_BOARD_INFO());
        Closeable closeable = (Closeable)new JsonReaderEx(text);
        Throwable throwable = null;
        try {
            JsonReaderEx jsonReader = (JsonReaderEx)closeable;
            boolean bl = false;
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginObject();
                String vendorName = "Generic";
                String boardId = "";
                Object boardName = "";
                String mcuName = null;
                String ram = null;
                String rom = null;
                String fcpu = null;
                SortedSet frameworks = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                block26: while (jsonReader.hasNext()) {
                    block39: {
                        String string = jsonReader.nextName();
                        if (string == null) break block39;
                        int n = -1;
                        switch (string.hashCode()) {
                            case 113104: {
                                if (string.equals("rom")) {
                                    n = 1;
                                }
                                break;
                            }
                            case -248492491: {
                                if (string.equals("frameworks")) {
                                    n = 2;
                                }
                                break;
                            }
                            case -820075192: {
                                if (string.equals("vendor")) {
                                    n = 3;
                                }
                                break;
                            }
                            case 3373707: {
                                if (string.equals("name")) {
                                    n = 4;
                                }
                                break;
                            }
                            case 3355: {
                                if (string.equals("id")) {
                                    n = 5;
                                }
                                break;
                            }
                            case 3137410: {
                                if (string.equals("fcpu")) {
                                    n = 6;
                                }
                                break;
                            }
                            case 107935: {
                                if (string.equals("mcu")) {
                                    n = 7;
                                }
                                break;
                            }
                            case 112670: {
                                if (string.equals("ram")) {
                                    n = 8;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 5: {
                                boardId = jsonReader.nextAsString();
                                continue block26;
                            }
                            case 4: {
                                Intrinsics.checkNotNullExpressionValue((Object)jsonReader.nextAsString(), (String)"nextAsString(...)");
                                continue block26;
                            }
                            case 3: {
                                Intrinsics.checkNotNullExpressionValue((Object)Objects.toString(jsonReader.nextAsString(), vendorName), (String)"toString(...)");
                                continue block26;
                            }
                            case 7: {
                                mcuName = jsonReader.nextAsString();
                                continue block26;
                            }
                            case 8: {
                                ram = INSTANCE.readNumber(jsonReader, (Function1<? super Long, String>)((Function1)BoardsJsonParser::parse$lambda$0$0));
                                continue block26;
                            }
                            case 1: {
                                rom = INSTANCE.readNumber(jsonReader, (Function1<? super Long, String>)((Function1)BoardsJsonParser::parse$lambda$0$1));
                                continue block26;
                            }
                            case 6: {
                                fcpu = INSTANCE.readNumber(jsonReader, (Function1<? super Long, String>)((Function1)BoardsJsonParser::parse$lambda$0$2));
                                continue block26;
                            }
                            case 2: {
                                jsonReader.beginArray();
                                while (jsonReader.hasNext()) {
                                    String frameworkName = jsonReader.nextAsString();
                                    frameworks.add(frameworkName);
                                }
                                jsonReader.endArray();
                                continue block26;
                            }
                        }
                    }
                    jsonReader.skipValue();
                }
                jsonReader.endObject();
                if (boardId == null) continue;
                DeviceTreeNode vendorNode = boardsByVendor.computeIfAbsent(vendorName, arg_0 -> BoardsJsonParser.parse$lambda$0$4(arg_0 -> BoardsJsonParser.parse$lambda$0$3(rootNode, arg_0), arg_0));
                Object[] objectArray = new String[]{"--board", boardId};
                BoardInfo boardInfo = new BoardInfo(SourceTemplate.Companion.byFrameworkName(frameworks), CollectionsKt.listOf((Object[])objectArray));
                Object[] objectArray2 = new String[]{mcuName, fcpu, rom, ram};
                String description = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                if (!(((CharSequence)description).length() == 0)) {
                    boardName = (String)boardName + " (" + description + ")";
                }
                DeviceTreeNode board = new DeviceTreeNode(vendorNode, DeviceTreeNode.TYPE.BOARD, (String)boardName, boardInfo);
                vendorNode.add(board);
                if (frameworks.size() <= 1) continue;
                for (String frameworkName : frameworks) {
                    Intrinsics.checkNotNull((Object)frameworkName);
                    Object[] objectArray3 = new String[]{"--board", boardId, "-O", "framework=" + frameworkName};
                    BoardInfo frameworkBoardInfo = new BoardInfo(SourceTemplate.Companion.byFrameworkName(frameworkName), CollectionsKt.listOf((Object[])objectArray3));
                    DeviceTreeNode framework = new DeviceTreeNode(board, DeviceTreeNode.TYPE.FRAMEWORK, frameworkName, frameworkBoardInfo);
                    board.add(framework);
                }
            }
            jsonReader.endArray();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        List<DeviceTreeNode> list = rootNode.getChildren();
        Collection collection = boardsByVendor.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        list.addAll(collection);
        return rootNode;
    }

    private final String readNumber(JsonReaderEx jsonReader, Function1<? super Long, String> convert) {
        try {
            String string = jsonReader.nextString(true);
            Intrinsics.checkNotNull((Object)string);
            return (String)convert.invoke((Object)Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static final String parse$lambda$0$0(long it) {
        return it < 0x20C000L ? "RAM: " + it / (long)1024 + "K" : "RAM: " + it / (long)1024 / (long)1024 + "M";
    }

    private static final String parse$lambda$0$1(long it) {
        return it < 0x20C000L ? "ROM: " + it / (long)1024 + "K" : "ROM: " + it / (long)1024 / (long)1024 + "M";
    }

    private static final String parse$lambda$0$2(long it) {
        return it / (long)1000000 + "MHz";
    }

    private static final DeviceTreeNode parse$lambda$0$3(DeviceTreeNode $rootNode, String name) {
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        return new DeviceTreeNode($rootNode, DeviceTreeNode.TYPE.VENDOR, string, SourceTemplate.Companion.getEMPTY_BOARD_INFO());
    }

    private static final DeviceTreeNode parse$lambda$0$4(Function1 $tmp0, Object p0) {
        return (DeviceTreeNode)$tmp0.invoke(p0);
    }
}

