/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.platformio;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.ui.validation.ValidationUtilKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.util.FontUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.EDT;
import com.jetbrains.cidr.cpp.embedded.platformio.ClionEmbeddedPlatformioBundle;
import com.jetbrains.cidr.cpp.embedded.platformio.ui.OpenInstallGuide;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/PlatformioConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "<init>", "()V", "settingsPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getDisplayName", "", "Lcom/intellij/openapi/util/NlsContexts$ConfigurableName;", "disposable", "Lcom/intellij/openapi/Disposable;", "checkLocation", "", "path", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "", "isModified", "apply", "reset", "getId", "getHelpTopic", "PlatformioConfigurableService", "Companion", "intellij.clion.embedded.platformio"})
@SourceDebugExtension(value={"SMAP\nPlatformioConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformioConfigurable.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/PlatformioConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
public final class PlatformioConfigurable
implements SearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DialogPanel settingsPanel;
    @Nullable
    private Disposable disposable;
    @NotNull
    private static final String ID = "PlatformIO.settings";
    @NotNull
    private static final String PIO_LOCATION_KEY = "PlatformIO.settings.platformio.location";
    @NotNull
    private static final String PIO_VENV_FOLDER = "penv";
    @NotNull
    private static final String PIO_EXECUTABLE = "pio" + (SystemInfo.isWindows ? ".exe" : "");
    @NotNull
    private static final String PLATFORMIO_EXECUTABLE = "platformio" + (SystemInfo.isWindows ? ".exe" : "");
    @NotNull
    private static final String BIN_FOLDER = SystemInfo.isWindows ? "Scripts" : "bin";

    @NotNull
    public String getDisplayName() {
        String string = ClionEmbeddedPlatformioBundle.message("configurable.ClionEmbeddedPlatformioBundle.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final boolean checkLocation(String path) {
        EDT.assertIsEdt();
        if (StringsKt.isBlank((CharSequence)path)) {
            return false;
        }
        CharSequence charSequence = PlatformioConfigurable.Companion.adjustPioPath(path);
        return charSequence == null || charSequence.length() == 0;
    }

    @NotNull
    public JComponent createComponent() {
        DialogPanel newSettingsPanel2 = BuilderKt.panel(arg_0 -> PlatformioConfigurable.createComponent$lambda$0(this, arg_0));
        Disposable disposable = this.disposable = Disposer.newDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        newSettingsPanel2.registerValidators(disposable);
        newSettingsPanel2.validateAll();
        this.settingsPanel = newSettingsPanel2;
        return (JComponent)newSettingsPanel2;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        Disposable disposable = this.disposable;
        if (disposable != null) {
            Disposable disposable2;
            Disposable it = disposable2 = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.disposable = null;
    }

    public boolean isModified() {
        DialogPanel dialogPanel = this.settingsPanel;
        return dialogPanel != null ? dialogPanel.isModified() : false;
    }

    public void apply() {
        block0: {
            DialogPanel dialogPanel = this.settingsPanel;
            if (dialogPanel == null) break block0;
            dialogPanel.apply();
        }
    }

    public void reset() {
        block0: {
            DialogPanel dialogPanel = this.settingsPanel;
            if (dialogPanel == null) break block0;
            dialogPanel.reset();
        }
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getHelpTopic() {
        return "settings.plugin.platformio";
    }

    private static final Unit createComponent$lambda$0(PlatformioConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PlatformioConfigurable.createComponent$lambda$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, PlatformioConfigurable::createComponent$lambda$0$1, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$0(PlatformioConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor().withShowHiddenFiles(true).withTitle(ClionEmbeddedPlatformioBundle.message("dialog.title.home.location", new Object[0]));
        Intrinsics.checkNotNull((Object)descriptor);
        Cell cell = Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)descriptor, null, null, (int)6, null).align(Align.FILL);
        String string = ClionEmbeddedPlatformioBundle.message("home.location", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell2 = TextFieldWithBrowseButtonKt.bindText((Cell)cell.label(string, LabelPosition.TOP), (MutableProperty)MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(Companion){

            public Object get() {
                return com.jetbrains.cidr.cpp.embedded.platformio.PlatformioConfigurable$Companion.access$getManualPioLocation((Companion)this.receiver);
            }

            public void set(Object value) {
                com.jetbrains.cidr.cpp.embedded.platformio.PlatformioConfigurable$Companion.access$setManualPioLocation((Companion)this.receiver, (String)value);
            }
        })));
        DialogValidation.WithParameter[] withParameterArray = new DialogValidation.WithParameter[1];
        String string2 = ClionEmbeddedPlatformioBundle.message("dialog.message.platformio.utility.not.found.inside", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        withParameterArray[0] = ValidationUtilKt.validationErrorIf((String)string2, (Function1)((Function1)new Function1<String, Boolean>((Object)this$0){

            public final Boolean invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return PlatformioConfigurable.access$checkLocation((PlatformioConfigurable)this.receiver, p0);
            }
        }));
        TextFieldWithBrowseButtonKt.trimmedTextValidation((Cell)cell2, (DialogValidation.WithParameter[])withParameterArray).applyToComponent(PlatformioConfigurable::createComponent$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$0$0(TextFieldWithBrowseButton $this$applyToComponent) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        EDT.assertIsEdt();
        Path location = PlatformioConfigurable.Companion.pioBinLookup();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(location, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            string = ClionEmbeddedPlatformioBundle.message("auto.not.detected.platformio", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{((Object)location).toString()};
            string = ClionEmbeddedPlatformioBundle.message("auto.detected.platformio", objectArray);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String text = string2;
        JTextField jTextField = $this$applyToComponent.getTextField();
        Intrinsics.checkNotNull((Object)jTextField, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBTextField");
        ((JBTextField)jTextField).getEmptyText().setText(text);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ClionEmbeddedPlatformioBundle.message("install.guide", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, (Function1)new Function1<ActionEvent, Unit>((Object)OpenInstallGuide.INSTANCE){

            public final void invoke(ActionEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((OpenInstallGuide)this.receiver).actionPerformed(p0);
            }
        }).applyToComponent(PlatformioConfigurable::createComponent$lambda$0$1$0);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$1$0(ActionLink $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont(FontUtil.minusOne((Font)$this$applyToComponent.getFont()));
        $this$applyToComponent.setContextHelpIcon();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$checkLocation(PlatformioConfigurable $this, String path) {
        return $this.checkLocation(path);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0006\u0010\u0016\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/PlatformioConfigurable$Companion;", "", "<init>", "()V", "ID", "", "PIO_LOCATION_KEY", "PIO_VENV_FOLDER", "PIO_EXECUTABLE", "PLATFORMIO_EXECUTABLE", "BIN_FOLDER", "path", "manualPioLocation", "getManualPioLocation", "()Ljava/lang/String;", "setManualPioLocation", "(Ljava/lang/String;)V", "pioBinFolder", "Ljava/nio/file/Path;", "adjustPioPath", "pathString", "pioBinLookup", "pioExePath", "intellij.clion.embedded.platformio"})
    @SourceDebugExtension(value={"SMAP\nPlatformioConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformioConfigurable.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/PlatformioConfigurable$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n42#2,3:199\n42#2,3:202\n295#3,2:205\n1#4:207\n*S KotlinDebug\n*F\n+ 1 PlatformioConfigurable.kt\ncom/jetbrains/cidr/cpp/embedded/platformio/PlatformioConfigurable$Companion\n*L\n154#1:199,3\n155#1:202,3\n178#1:205,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getManualPioLocation() {
            boolean $i$f$service = false;
            Class<PlatformioConfigurableService> serviceClass$iv = PlatformioConfigurableService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((PlatformioConfigurableService)object).getManualPioLocation();
        }

        private final void setManualPioLocation(String path) {
            boolean $i$f$service = false;
            Class<PlatformioConfigurableService> serviceClass$iv = PlatformioConfigurableService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((PlatformioConfigurableService)object).setManualPioLocation(path);
        }

        @NotNull
        public final Path pioBinFolder() {
            Path path;
            if (((CharSequence)this.getManualPioLocation()).length() > 0) {
                String string = this.adjustPioPath(this.getManualPioLocation());
                if (string == null) {
                    string = this.getManualPioLocation();
                }
                Path path2 = Path.of(string, new String[0]);
                Intrinsics.checkNotNull((Object)path2);
                path = path2;
            } else {
                path = this.pioBinLookup();
            }
            return path;
        }

        /*
         * WARNING - void declaration
         */
        private final String adjustPioPath(String pathString) {
            Object v2;
            Object object;
            block2: {
                void $this$firstOrNull$iv;
                Path path = Path.of(pathString, new String[0]);
                Path path2 = path.getFileName();
                String fileName = path2 != null ? ((Object)path2).toString() : null;
                Intrinsics.checkNotNull((Object)path);
                if (Files.isExecutable(path) && (Intrinsics.areEqual((Object)fileName, (Object)PIO_EXECUTABLE) || Intrinsics.areEqual((Object)fileName, (Object)PLATFORMIO_EXECUTABLE))) {
                    Path path3 = path.getParent();
                    return path3 != null ? ((Object)path3).toString() : null;
                }
                object = new Path[3];
                String[] stringArray = new String[]{PIO_EXECUTABLE};
                object[0] = Path.of(pathString, stringArray);
                stringArray = new String[]{BIN_FOLDER, PIO_EXECUTABLE};
                object[1] = Path.of(pathString, stringArray);
                stringArray = new String[]{PlatformioConfigurable.PIO_VENV_FOLDER, BIN_FOLDER, PIO_EXECUTABLE};
                object[2] = Path.of(pathString, stringArray);
                object = CollectionsKt.listOf((Object[])object);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!Files.isExecutable(it)) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            Path path = v2;
            return path != null && (object = path.getParent()) != null ? object.toString() : null;
        }

        private final Path pioBinLookup() {
            Path path;
            Object object = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)PIO_EXECUTABLE);
            if (object != null && (object = ((File)object).getParent()) != null) {
                Object it = object;
                boolean bl = false;
                v1 = Path.of((String)it, new String[0]);
            } else {
                v1 = path = null;
            }
            if (path != null) {
                return path;
            }
            String[] stringArray = new String[]{".platformio", PlatformioConfigurable.PIO_VENV_FOLDER, BIN_FOLDER};
            Path defaultPath1 = Path.of(SystemProperties.getUserHome(), stringArray);
            Intrinsics.checkNotNull((Object)defaultPath1);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(defaultPath1, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return defaultPath1;
            }
            String[] stringArray2 = new String[]{".pio", PlatformioConfigurable.PIO_VENV_FOLDER, BIN_FOLDER};
            Path defaultPath2 = Path.of(SystemProperties.getUserHome(), stringArray2);
            Intrinsics.checkNotNull((Object)defaultPath2);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(defaultPath2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                return defaultPath2;
            }
            return defaultPath1;
        }

        @NotNull
        public final String pioExePath() {
            return ((Object)this.pioBinFolder().resolve(PIO_EXECUTABLE)).toString();
        }

        public static final /* synthetic */ String access$getManualPioLocation(Companion $this) {
            return $this.getManualPioLocation();
        }

        public static final /* synthetic */ void access$setManualPioLocation(Companion $this, String path) {
            $this.setManualPioLocation(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/cpp/embedded/platformio/PlatformioConfigurable$PlatformioConfigurableService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "manualPioLocationValue", "Ljava/util/concurrent/atomic/AtomicReference;", "", "path", "manualPioLocation", "getManualPioLocation", "()Ljava/lang/String;", "setManualPioLocation", "(Ljava/lang/String;)V", "writeEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "handlePioPathChange", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clion.embedded.platformio"})
    public static final class PlatformioConfigurableService {
        @NotNull
        private AtomicReference<String> manualPioLocationValue;
        @NotNull
        private final MutableSharedFlow<String> writeEvents;

        public PlatformioConfigurableService(@NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.writeEvents = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
            BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ PlatformioConfigurableService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.collectLatest((Flow)FlowKt.distinctUntilChanged((Flow)((Flow)this.this$0.writeEvents)), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ PlatformioConfigurableService this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    String string = (String)this.L$0;
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void it;
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                            this.label = 1;
                                            Object object2 = this.this$0.handlePioPathChange((String)it, (Continuation<? super Unit>)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(String p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            this.manualPioLocationValue = new AtomicReference<String>(PropertiesComponent.getInstance().getValue(PlatformioConfigurable.PIO_LOCATION_KEY, ""));
        }

        @NotNull
        public final String getManualPioLocation() {
            String string = this.manualPioLocationValue.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }

        public final void setManualPioLocation(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.writeEvents.tryEmit((Object)path);
            this.manualPioLocationValue.set(path);
        }

        private final Object handlePioPathChange(String path, Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path, null){
                int label;
                final /* synthetic */ String $path;
                {
                    this.$path = $path;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            PropertiesComponent.getInstance().setValue("PlatformIO.settings.platformio.location", ((Object)StringsKt.trim((CharSequence)this.$path)).toString());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }
}

