/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumLiteralType;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSwitchBranchesProcessor {
    @Nullable
    public static JSType findTypeForCases(@Nullable JSSwitchStatement statement) {
        if (statement == null) {
            return null;
        }
        JSExpression expression = statement.getSwitchExpression();
        if (expression == null) {
            return null;
        }
        return JSSwitchBranchesProcessor.expandTypeForSwitch(expression);
    }

    @Nullable
    public static JSType expandTypeForSwitch(@Nullable JSExpression expression) {
        JSType type2 = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive((JSExpression)expression);
        if (type2 instanceof JSTypeWithIncompleteSubstitution) {
            type2 = ((JSTypeWithIncompleteSubstitution)type2).substituteCompletely();
        }
        return JSTypeUtils.getValuableType((JSType)type2, (PsiElement)expression);
    }

    public static List<JSEnumValue> getAllCaseVariants(JSSwitchStatement statement) {
        return JSSwitchBranchesProcessor.getAllCaseVariants(JSSwitchBranchesProcessor.findTypeForCases(statement), false);
    }

    @NotNull
    public static List<JSEnumValue> getAllCaseVariants(@Nullable JSType type2, boolean widen) {
        if (type2 instanceof TypeScriptEnumLiteralType) {
            TypeScriptEnumLiteralType enumLiteralType = (TypeScriptEnumLiteralType)type2;
            Object literal = enumLiteralType.getLiteral();
            String qualifiedName = enumLiteralType.getEnumQualifiedName() + "." + enumLiteralType.getEnumFieldName();
            String valueAsString = enumLiteralType.getValueAsString();
            List<JSEnumValue> list = Collections.singletonList(new JSEnumValue(literal, qualifiedName, valueAsString));
            if (list == null) {
                JSSwitchBranchesProcessor.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (type2 instanceof JSStringLiteralTypeImpl || type2 instanceof JSNumberLiteralTypeImpl || type2 instanceof JSBooleanLiteralTypeImpl || type2 instanceof JSBigIntLiteralTypeImpl) {
            if (widen && ((JSPrimitiveLiteralType)type2).allowWidening()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JSSwitchBranchesProcessor.$$$reportNull$$$0(1);
                }
                return list;
            }
            Object literal = ((JSPrimitiveLiteralType)type2).getLiteral();
            List<JSEnumValue> list = Collections.singletonList(new JSEnumValue(literal, null, ((JSPrimitiveLiteralType)type2).getValueAsString()));
            if (list == null) {
                JSSwitchBranchesProcessor.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (type2 instanceof JSResolvableType) {
            TypeScriptEnum enumeration;
            JSResolvableType resolvableType = (JSResolvableType)type2;
            ArrayList<JSEnumValue> result2 = new ArrayList<JSEnumValue>();
            JSResolvedTypeInfo info = resolvableType.resolveType();
            if (info.isEnumLiteral()) {
                TypeScriptEnum enumeration2;
                TypeScriptEnumField enumField = (TypeScriptEnumField)info.getDeclarationOfType(TypeScriptEnumField.class);
                TypeScriptEnum typeScriptEnum = enumeration2 = enumField != null ? enumField.getOwner() : null;
                if (enumField != null && enumeration2 != null) {
                    JSSwitchBranchesProcessor.addValueFromField((JSField)enumField, enumeration2, result2);
                }
            } else if (info.isEnum() && (enumeration = (TypeScriptEnum)info.getDeclarationOfType(TypeScriptEnum.class)) != null) {
                for (JSField enumField : enumeration.getFields()) {
                    JSSwitchBranchesProcessor.addValueFromField(enumField, enumeration, result2);
                }
            }
            ArrayList<JSEnumValue> arrayList = result2;
            if (arrayList == null) {
                JSSwitchBranchesProcessor.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        if (type2 instanceof JSUnionType) {
            JSUnionType unionType = (JSUnionType)type2;
            ArrayList<JSEnumValue> result3 = new ArrayList<JSEnumValue>();
            for (JSType componentType : unionType.getTypes()) {
                List<JSEnumValue> variants = JSSwitchBranchesProcessor.getAllCaseVariants(componentType, widen);
                if (variants.isEmpty()) {
                    List<JSEnumValue> list = Collections.emptyList();
                    if (list == null) {
                        JSSwitchBranchesProcessor.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                result3.addAll(variants);
            }
            ArrayList<JSEnumValue> arrayList = result3;
            if (arrayList == null) {
                JSSwitchBranchesProcessor.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        List<JSEnumValue> list = Collections.emptyList();
        if (list == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static void addValueFromField(JSField enumField, TypeScriptEnum enumeration, ArrayList<JSEnumValue> result2) {
        JSEnumValue enumValue = JSSwitchBranchesProcessor.getEnumValue(enumeration, (JSFieldVariable)enumField);
        if (enumValue != null) {
            result2.add(enumValue);
        }
    }

    @Nullable
    private static JSEnumValue getEnumValue(@NotNull TypeScriptEnum enumeration, @NotNull JSFieldVariable enumField) {
        JSEnumValue jSEnumValue;
        JSType type2;
        if (enumeration == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(7);
        }
        if (enumField == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(8);
        }
        if ((type2 = JSSwitchBranchesProcessor.createEnumLiteralType(enumeration, enumField)) instanceof TypeScriptEnumLiteralType) {
            TypeScriptEnumLiteralType enumLiteral = (TypeScriptEnumLiteralType)type2;
            jSEnumValue = new JSEnumValue(enumLiteral.getLiteral(), enumField.getQualifiedName(), null);
        } else {
            jSEnumValue = null;
        }
        return jSEnumValue;
    }

    @NotNull
    public static List<JSCaseClauseValue> getExistingVariants(@Nullable JSSwitchStatement statement) {
        if (statement == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSSwitchBranchesProcessor.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<JSCaseClauseValue> existingTypes = new ArrayList<JSCaseClauseValue>();
        JSType typeForCases = JSSwitchBranchesProcessor.findTypeForCases(statement);
        for (JSCaseClause clause : statement.getCaseClauses()) {
            existingTypes.addAll(ContainerUtil.map(JSSwitchBranchesProcessor.getExistingVariants(clause, typeForCases), it -> new JSCaseClauseValue(clause, (JSEnumValue)it)));
        }
        ArrayList<JSCaseClauseValue> arrayList = existingTypes;
        if (arrayList == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSEnumValue> getExistingVariants(@NotNull JSCaseClause clause, @Nullable JSType typeForCases) {
        JSExpression expression;
        JSType type2;
        if (clause == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(11);
        }
        if ((type2 = JSSwitchBranchesProcessor.replaceByEnumConstantOrLiteralIfNeeded(JSResolveUtil.getExpressionJSType((JSExpression)(expression = clause.getCaseExpression())), expression, typeForCases)) != null) {
            return JSSwitchBranchesProcessor.getAllCaseVariants(type2, false);
        }
        List<JSEnumValue> list = Collections.emptyList();
        if (list == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static Set<Object> getExistingValues(@NotNull List<JSCaseClauseValue> existingVariants) {
        if (existingVariants == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(13);
        }
        Set<Object> set = existingVariants.stream().map(JSCaseClauseValue::value).map(JSEnumValue::value).collect(Collectors.toSet());
        if (set == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(14);
        }
        return set;
    }

    @Nullable
    private static JSType replaceByEnumConstantOrLiteralIfNeeded(@Nullable JSType type2, @Nullable JSExpression context2, @Nullable JSType typeForCases) {
        JSType match;
        JSResolvedTypeInfo resolvedInfo;
        if (context2 == null) {
            return type2;
        }
        if (type2 instanceof JSLiteralType) {
            JSType match2 = JSSwitchBranchesProcessor.findMatch(type2, typeForCases, JSSwitchBranchesProcessor::findMatchForLiteral);
            if (match2 != null) {
                return match2;
            }
        } else if (type2 instanceof JSTypeImpl && (resolvedInfo = ((JSTypeImpl)type2).resolveType()).isEnumLiteral() && (match = JSSwitchBranchesProcessor.findMatch(type2, typeForCases, JSSwitchBranchesProcessor::findMatchForEnum)) != null) {
            return match;
        }
        return type2;
    }

    @Nullable
    private static JSType findMatch(@NotNull JSType type2, @Nullable JSType typeForCases, @NotNull BiFunction<? super JSType, ? super JSType, ? extends JSType> matchFinder) {
        JSType singleMatch;
        if (type2 == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(15);
        }
        if (matchFinder == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(16);
        }
        if ((singleMatch = matchFinder.apply((JSType)type2, (JSType)typeForCases)) != null) {
            return singleMatch;
        }
        if (typeForCases instanceof JSUnionType) {
            for (JSType jsType : ((JSUnionType)typeForCases).getTypes()) {
                JSType matchingEnum = matchFinder.apply((JSType)type2, (JSType)jsType);
                if (matchingEnum == null) continue;
                return matchingEnum;
            }
        }
        return null;
    }

    @Nullable
    private static JSType findMatchForLiteral(@Nullable JSType type2, @Nullable JSType jsType) {
        JSType matchingEnum;
        if (jsType instanceof JSTypeImpl && type2 instanceof JSLiteralType && (matchingEnum = JSSwitchBranchesProcessor.findMatchingEnumType((JSLiteralType)type2, (JSTypeImpl)jsType)) != null) {
            return matchingEnum;
        }
        return null;
    }

    @Nullable
    private static JSType findMatchForEnum(@Nullable JSType type2, @Nullable JSType jsType) {
        JSType matchingEnum;
        if (type2 instanceof JSTypeImpl && jsType instanceof JSLiteralType && (matchingEnum = JSSwitchBranchesProcessor.findMatchingEnumType((JSLiteralType)jsType, (JSTypeImpl)type2)) != null) {
            return jsType;
        }
        return null;
    }

    @Nullable
    private static JSType findMatchingEnumType(@NotNull JSLiteralType type2, @NotNull JSTypeImpl enumOrEnumLiteral) {
        JSResolvedTypeInfo info;
        EnumConstantValue value;
        if (type2 == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(17);
        }
        if (enumOrEnumLiteral == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(18);
        }
        if (JSSwitchBranchesProcessor.matchesConstantValue(type2, value = (info = enumOrEnumLiteral.resolveType()).getEnumConstValue())) {
            return enumOrEnumLiteral;
        }
        if (info.isEnumWithLiteralValues()) {
            Collection enums = info.getDeclarationsOfType(TypeScriptEnum.class);
            if (enums.size() != 1) {
                return null;
            }
            TypeScriptEnum decl = (TypeScriptEnum)enums.iterator().next();
            for (JSField field : decl.getFields()) {
                EnumConstantValue constValue;
                if (!(field instanceof TypeScriptEnumField) || !JSSwitchBranchesProcessor.matchesConstantValue(type2, constValue = ((TypeScriptEnumField)field).getConstantValue())) continue;
                return JSSwitchBranchesProcessor.createEnumLiteralType(decl, (JSFieldVariable)field);
            }
        }
        return null;
    }

    private static boolean matchesConstantValue(@NotNull JSLiteralType type2, @NotNull EnumConstantValue value) {
        if (type2 == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(19);
        }
        if (value == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(20);
        }
        return type2 instanceof JSStringLiteralTypeImpl && ((JSStringLiteralTypeImpl)type2).getLiteral().equals(value.getStringValue()) || type2 instanceof JSNumberLiteralTypeImpl && ((JSNumberLiteralTypeImpl)type2).getLiteral().equals(value.getNumericValue());
    }

    @NotNull
    private static JSType createEnumLiteralType(@NotNull TypeScriptEnum enumeration, @NotNull JSFieldVariable enumField) {
        if (enumeration == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(21);
        }
        if (enumField == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(22);
        }
        String qualifiedName = Objects.requireNonNullElse(enumeration.getQualifiedName(), "");
        JSType jSType = JSNamedTypeFactory.createEnumLiteralType((String)qualifiedName, (JSFieldVariable)enumField, (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)enumField, (boolean)true));
        if (jSType == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(23);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 8, 11, 13, 15, 16, 17, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSwitchBranchesProcessor";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumField";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingVariants";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchFinder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumOrEnumLiteral";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCaseVariants";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSwitchBranchesProcessor";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingVariants";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingValues";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEnumValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExistingVariants";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExistingValues";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findMatch";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingEnumType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "matchesConstantValue";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createEnumLiteralType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 8, 11, 13, 15, 16, 17, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string);
        };
    }

    public record JSEnumValue(@NotNull Object value, @Nullable String enumFieldName, @Nullable String valueAsString) {
        @NotNull
        private final Object value;

        public JSEnumValue(@NotNull Object value, @Nullable String enumFieldName, @Nullable String valueAsString) {
            if (value == null) {
                JSEnumValue.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String asPropertyName(char quote) {
            Object object = this.enumFieldName != null ? this.enumFieldName : (this.valueAsString != null ? this.valueAsString : (this.value instanceof String ? String.valueOf(quote) + String.valueOf(this.value) + quote : this.value.toString()));
            if (object == null) {
                JSEnumValue.$$$reportNull$$$0(1);
            }
            return object;
        }

        @NotNull
        public Object value() {
            Object object = this.value;
            if (object == null) {
                JSEnumValue.$$$reportNull$$$0(2);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSwitchBranchesProcessor$JSEnumValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSwitchBranchesProcessor$JSEnumValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asPropertyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public record JSCaseClauseValue(@NotNull JSCaseClause clause, @NotNull JSEnumValue value) {
        @NotNull
        private final JSCaseClause clause;
        @NotNull
        private final JSEnumValue value;

        public JSCaseClauseValue(@NotNull JSCaseClause clause, @NotNull JSEnumValue value) {
            if (clause == null) {
                JSCaseClauseValue.$$$reportNull$$$0(0);
            }
            if (value == null) {
                JSCaseClauseValue.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public JSCaseClause clause() {
            JSCaseClause jSCaseClause = this.clause;
            if (jSCaseClause == null) {
                JSCaseClauseValue.$$$reportNull$$$0(2);
            }
            return jSCaseClause;
        }

        @NotNull
        public JSEnumValue value() {
            JSEnumValue jSEnumValue = this.value;
            if (jSEnumValue == null) {
                JSCaseClauseValue.$$$reportNull$$$0(3);
            }
            return jSEnumValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clause";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSwitchBranchesProcessor$JSCaseClauseValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSwitchBranchesProcessor$JSCaseClauseValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clause";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

