/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.lang.javascript.dialects.JSDialectsMappings;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfo;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfoKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageKind;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class JSSettingsUsagesCollector
extends ProjectUsagesCollector {
    public static final EventLogGroup GROUP = new EventLogGroup("js.settings", 9);
    private static final List<String> LEVELS = Stream.concat(Arrays.stream(JSLanguageLevel.values()).map(JSLanguageLevel::getId), JSLanguageLevel.OBSOLETE_LEVELS.keySet().stream()).sorted().collect(Collectors.toList());
    private static final EventId1<String> LANGUAGE_LEVEL = GROUP.registerEvent("language.level", (EventField)EventFields.String((String)"value", LEVELS));
    private static final EventId1<Boolean> HAS_MAPPINGS = GROUP.registerEvent("has.mappings", (EventField)EventFields.Boolean((String)"has_mappings"));
    private static final EventId1<TypeScriptServerKind> TYPESCRIPT_SERVER_KIND = GROUP.registerEvent("typescript.server.kind", (EventField)EventFields.Enum((String)"value", TypeScriptServerKind.class));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            JSSettingsUsagesCollector.$$$reportNull$$$0(0);
        }
        HashSet<MetricEvent> metrics = new HashSet<MetricEvent>();
        String level = JSRootConfiguration.getInstance((Project)project).getStoredLanguageLevel();
        if (level != null) {
            metrics.add(LANGUAGE_LEVEL.metric((Object)level));
        }
        if (!JSDialectsMappings.getInstance(project).getMappings().isEmpty()) {
            metrics.add(HAS_MAPPINGS.metric((Object)true));
        }
        TypeScriptServiceDirectoryWatcher tsDirService = TypeScriptServiceDirectoryWatcher.getService(project);
        String serviceDir = (String)ReadAction.nonBlocking(tsDirService::calcServiceDirectory).executeSynchronously();
        if (tsDirService.getDefaultServicePath().equals(serviceDir)) {
            metrics.add(TYPESCRIPT_SERVER_KIND.metric((Object)TypeScriptServerKind.BUNDLED));
        } else {
            TypeScriptGoPackageInfo tsGoInfo = TypeScriptGoPackageInfoKt.getTypeScriptGoPackageInfo(serviceDir);
            if (tsGoInfo == null) {
                metrics.add(TYPESCRIPT_SERVER_KIND.metric((Object)TypeScriptServerKind.TS_JS));
            } else if (tsGoInfo.getKind() == TypeScriptGoPackageKind.LocallyClonedAndBuilt) {
                metrics.add(TYPESCRIPT_SERVER_KIND.metric((Object)TypeScriptServerKind.TS_GO_LOCAL_BUILD));
            } else if (tsGoInfo.getKind() == TypeScriptGoPackageKind.NativePreviewPackage) {
                metrics.add(TYPESCRIPT_SERVER_KIND.metric((Object)TypeScriptServerKind.TS_GO_NATIVE_PREVIEW));
            } else if (tsGoInfo.getKind() == TypeScriptGoPackageKind.JetBrainsFork) {
                metrics.add(TYPESCRIPT_SERVER_KIND.metric((Object)TypeScriptServerKind.TS_GO_JETBRAINS_FORK));
            }
        }
        HashSet<MetricEvent> hashSet = metrics;
        if (hashSet == null) {
            JSSettingsUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSSettingsUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSSettingsUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static enum TypeScriptServerKind {
        BUNDLED,
        TS_JS,
        TS_GO_LOCAL_BUILD,
        TS_GO_NATIVE_PREVIEW,
        TS_GO_JETBRAINS_FORK;

    }
}

