/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.monorepo.JSMonorepoManager;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.psi.impl.JSLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSParsedPathElement;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptImportPathBuilder
extends JSImportPathBuilder {
    @NotNull
    private final JSMonorepoManager myMonorepoManager;
    @NotNull
    private final TypeScriptConfigService myConfigService;

    public TypeScriptImportPathBuilder(@NotNull JSImportPathConfiguration configuration) {
        if (configuration == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(0);
        }
        super(configuration);
        Project project = configuration.getProject();
        this.myMonorepoManager = JSMonorepoManager.getInstance(project);
        this.myConfigService = TypeScriptConfigService.Provider.get((Project)project);
    }

    @Override
    @Nullable
    protected JSLinkedProject getLinkedProject(@NotNull VirtualFile referencedRoot, @Nullable VirtualFile placePackageJson, @Nullable String importPackageName) {
        VirtualFile linkedPackage;
        if (referencedRoot == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(1);
        }
        if (importPackageName == null) {
            return null;
        }
        JSLinkedProject linkedProject = super.getLinkedProject(referencedRoot, placePackageJson, importPackageName);
        if (TypeScriptUtil.isDefinitionFile((VirtualFile)this.myFileToImport)) {
            return linkedProject;
        }
        VirtualFile virtualFile = linkedPackage = linkedProject != null ? linkedProject.getLinkedPackageRoot() : null;
        if (linkedPackage == null) {
            return null;
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForFile((Project)this.myProject, (VirtualFile)this.myFileToImport);
        if (config == null) {
            return null;
        }
        VirtualFile configDirectory = config.getConfigDirectory();
        if (!VfsUtilCore.isAncestor((VirtualFile)configDirectory, (VirtualFile)this.myFileToImport, (boolean)true)) {
            return null;
        }
        VirtualFile sourceRoot = this.getSourceRoot(config, this.myFileToImport);
        if (sourceRoot == null) {
            return null;
        }
        VirtualFile outDirectory = config.getEffectiveOutDirectory();
        if (outDirectory.equals(sourceRoot)) {
            return new TypeScriptSymlinkLinkedProject(referencedRoot, linkedPackage, referencedRoot, referencedRoot, importPackageName);
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)referencedRoot, (VirtualFile)outDirectory, (boolean)false)) {
            return null;
        }
        return new TypeScriptSymlinkLinkedProject(referencedRoot, linkedPackage, sourceRoot, outDirectory, importPackageName);
    }

    @Override
    @NotNull
    protected VirtualFile adjustFileToImport(String mapping) {
        VirtualFile directory;
        if (!this.myMonorepoManager.isWorkspaceMonorepo()) {
            VirtualFile virtualFile = this.myFileToImport;
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }
        TypeScriptConfig config = this.getConfigWithExplicitDeclarationDir();
        if (config == null) {
            VirtualFile virtualFile = this.myFileToImport;
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }
        VirtualFile declarationDir = config.getEffectiveDeclarationDirectory();
        String declarationDirName = declarationDir.getName();
        Object[] pathElements = JSParsedPathElement.Parser.parseReferenceText(mapping, false);
        if (!ContainerUtil.exists((Object[])pathElements, el -> declarationDirName.equals(el.getText()))) {
            VirtualFile virtualFile = this.myFileToImport;
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }
        VirtualFile sourceRootDir = TypeScriptImportPathBuilder.detectRootDir(this.myProject, config);
        VirtualFile canonicalFile = this.myFileToImport.getCanonicalFile();
        if (canonicalFile == null) {
            VirtualFile virtualFile = this.myFileToImport;
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(5);
            }
            return virtualFile;
        }
        String relativeOutPath = VfsUtilCore.getRelativePath((VirtualFile)canonicalFile.getParent(), (VirtualFile)sourceRootDir);
        VirtualFile virtualFile = directory = relativeOutPath == null ? null : declarationDir.findFileByRelativePath(relativeOutPath);
        if (directory == null) {
            VirtualFile virtualFile2 = this.myFileToImport;
            if (virtualFile2 == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(6);
            }
            return virtualFile2;
        }
        String fileName = mapping.endsWith("*") || mapping.endsWith("/") ? this.myFileToImport.getName() : StringUtil.substringAfterLast((String)mapping, (String)"/");
        String fileNameWithoutExtension = JSFileReferencesUtil.getFileNameWithoutExtension((String)fileName, (String[])this.myExtensions);
        if (StringUtil.isEmpty((String)fileNameWithoutExtension)) {
            VirtualFile virtualFile3 = this.myFileToImport;
            if (virtualFile3 == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(7);
            }
            return virtualFile3;
        }
        for (String extension : this.myExtensions) {
            VirtualFile child = directory.findChild(fileNameWithoutExtension + extension);
            if (child == null) continue;
            VirtualFile virtualFile4 = child;
            if (virtualFile4 == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(8);
            }
            return virtualFile4;
        }
        VirtualFile virtualFile5 = this.myFileToImport;
        if (virtualFile5 == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(9);
        }
        return virtualFile5;
    }

    @Nullable
    private TypeScriptConfig getConfigWithExplicitDeclarationDir() {
        VirtualFile parentTsConfigFile = TypeScriptConfigUtil.getParentConfigWithName((VirtualFile)this.myFileToImport, (String)"tsconfig.json");
        if (parentTsConfigFile == null || VfsUtilCore.isAncestor((VirtualFile)parentTsConfigFile.getParent(), (VirtualFile)this.myPlaceModuleFile.getParent(), (boolean)false)) {
            return null;
        }
        TypeScriptConfig parentConfig = this.myConfigService.parseConfigFile(parentTsConfigFile);
        if (parentConfig == null) {
            return null;
        }
        VirtualFile parentDir = parentConfig.getConfigDirectory();
        VirtualFile declarationDir = parentConfig.getEffectiveDeclarationDirectory();
        if (!declarationDir.equals(parentDir)) {
            return parentConfig;
        }
        for (VirtualFile referencedConfigFile : parentConfig.getReferences()) {
            TypeScriptConfig referencedConfig;
            if (!Objects.equals(referencedConfigFile.getParent(), parentDir) || (referencedConfig = this.myConfigService.parseConfigFile(referencedConfigFile)) == null || (declarationDir = referencedConfig.getEffectiveDeclarationDirectory()).equals(parentDir)) continue;
            return referencedConfig;
        }
        return null;
    }

    @Nullable
    private VirtualFile getSourceRoot(@NotNull TypeScriptConfig importFileConfig, @NotNull VirtualFile fileToImport) {
        VirtualFile rootDir;
        if (importFileConfig == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(10);
        }
        if (fileToImport == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(11);
        }
        return VfsUtilCore.isAncestor((VirtualFile)(rootDir = TypeScriptImportPathBuilder.detectRootDir(this.myProject, importFileConfig)), (VirtualFile)fileToImport, (boolean)true) ? rootDir : null;
    }

    @NotNull
    private static VirtualFile getCommonGraphAncestor(@NotNull VirtualFile configDir, @NotNull Set<VirtualFile> nodes) {
        List realFiles;
        if (configDir == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(12);
        }
        if (nodes == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(13);
        }
        VirtualFile ancestor = (realFiles = ContainerUtil.filter(nodes, el -> !TypeScriptUtil.isDefinitionFile((VirtualFile)el))).size() == 1 ? ((VirtualFile)realFiles.getFirst()).getParent() : VfsUtil.getCommonAncestor((Collection)realFiles);
        VirtualFile virtualFile = ancestor != null && VfsUtilCore.isAncestor((VirtualFile)configDir, (VirtualFile)ancestor, (boolean)false) ? ancestor : configDir;
        if (virtualFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile getDefaultRoot(@NotNull TypeScriptConfig importFileConfig) {
        VirtualFile rootDir;
        if (importFileConfig == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(15);
        }
        if ((rootDir = importFileConfig.getRootDirFile()) != null) {
            return rootDir;
        }
        if (importFileConfig.isComposite()) {
            return importFileConfig.getConfigDirectory();
        }
        return null;
    }

    @NotNull
    public static VirtualFile detectRootDir(@NotNull Project project, @NotNull TypeScriptConfig importFileConfig) {
        VirtualFile root;
        if (project == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(16);
        }
        if (importFileConfig == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(17);
        }
        if ((root = TypeScriptImportPathBuilder.getDefaultRoot(importFileConfig)) != null) {
            VirtualFile virtualFile = root;
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(18);
            }
            return virtualFile;
        }
        VirtualFile file = importFileConfig.getConfigFile();
        if (importFileConfig instanceof UserDataHolder) {
            VirtualFile virtualFile = (VirtualFile)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)importFileConfig, () -> {
                JSFileImports structure = importFileConfig.getConfigImportResolveStructure();
                Set roots = structure.getRootFiles();
                VirtualFile ancestor = TypeScriptImportPathBuilder.getCommonGraphAncestor(file.getParent(), roots);
                ArrayList<ModificationTracker> dependencies = new ArrayList<ModificationTracker>(importFileConfig.getDependencies());
                dependencies.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
                return CachedValueProvider.Result.create((Object)ancestor, dependencies);
            });
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(19);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = importFileConfig.getConfigDirectory();
        if (virtualFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 14, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
                break;
            }
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importFileConfig";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustFileToImport";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonGraphAncestor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRootDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProject";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoot";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommonGraphAncestor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRoot";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "detectRootDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 14, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

