/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.insight;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectors;
import com.intellij.javascript.testing.insight.SelectInTestTreeAction;
import com.intellij.javascript.testing.runConfiguration.JSTestLocation;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectInTestTree
implements LocalQuickFix,
Iconable {
    private final SmartPsiElementPointer<PsiElement> myPointer;
    private final ConfigurationFactory myConfigurationFactory;

    private SelectInTestTree(@NotNull PsiElement element2, @NotNull ConfigurationFactory configurationFactory) {
        if (element2 == null) {
            SelectInTestTree.$$$reportNull$$$0(0);
        }
        if (configurationFactory == null) {
            SelectInTestTree.$$$reportNull$$$0(1);
        }
        this.myPointer = SmartPointerManager.createPointer((PsiElement)element2);
        this.myConfigurationFactory = configurationFactory;
    }

    @Nullable
    public static SelectInTestTree create(@NotNull PsiElement element2) {
        ConfigurationContext context2;
        RunnerAndConfigurationSettings settings;
        if (element2 == null) {
            SelectInTestTree.$$$reportNull$$$0(2);
        }
        RunConfiguration conf = (settings = (context2 = new ConfigurationContext(element2)).getConfiguration()) != null ? settings.getConfiguration() : null;
        ConfigurationFactory factory = conf != null ? conf.getFactory() : null;
        return factory != null ? new SelectInTestTree(element2, factory) : null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            SelectInTestTree.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            SelectInTestTree.$$$reportNull$$$0(4);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            SelectInTestTree.$$$reportNull$$$0(5);
        }
        return intentionPreviewInfo;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"intention.family.name.select.in.test.tree", (Object[])new Object[0]);
        if (string == null) {
            SelectInTestTree.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        JsTestElementPath path2;
        if (project == null) {
            SelectInTestTree.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            SelectInTestTree.$$$reportNull$$$0(8);
        }
        if ((path2 = SelectInTestTree.findContextTestPath(this.myPointer.getElement())) != null) {
            new SelectInTestTreeAction(JSTestLocation.fromTestElementPath(path2), Set.of(this.myConfigurationFactory)).selectTest(project);
        }
    }

    public Icon getIcon(int flags) {
        return this.myConfigurationFactory.getIcon();
    }

    @Nullable
    private static JsTestElementPath findContextTestPath(@Nullable PsiElement element2) {
        JSFile file = (JSFile)ObjectUtils.tryCast((Object)(element2 != null ? element2.getContainingFile() : null), JSFile.class);
        if (file == null) {
            return null;
        }
        for (JsTestFrameworkDetector detector : JsTestFrameworkDetectors.Companion.getDetectorsSortedByDetectionPriority()) {
            JsTestElementPath path2;
            AbstractTestFileStructure structure = detector.findTestsStructure(file);
            if (structure == null || (path2 = structure.findTestElementPath(element2.getTextRange())) == null) continue;
            return path2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFactory";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/insight/SelectInTestTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/insight/SelectInTestTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

