/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.library.exclude;

import com.intellij.javascript.library.exclude.JsExcludeEntity;
import com.intellij.javascript.library.exclude.JsExcludeEntityBuilder;
import com.intellij.javascript.library.exclude.JsExcludeEntityWrapper;
import com.intellij.javascript.library.exclude.JsExcludeManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.workspaceModel.YarnPnpEntityHelperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0002J\u0016\u0010\u0012\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/library/exclude/JsExcludeModelSynchronizer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "sync", "", "buildActualEntities", "", "Lcom/intellij/javascript/library/exclude/JsExcludeEntityBuilder;", "areEntitiesOutdated", "", "actualEntities", "getWorkspaceModelEntities", "Lcom/intellij/javascript/library/exclude/JsExcludeEntity;", "updateEntities", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJsExcludeStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsExcludeStartupActivity.kt\ncom/intellij/javascript/library/exclude/JsExcludeModelSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1563#2:76\n1634#2,3:77\n1634#2,3:80\n1634#2,3:83\n*S KotlinDebug\n*F\n+ 1 JsExcludeStartupActivity.kt\ncom/intellij/javascript/library/exclude/JsExcludeModelSynchronizer\n*L\n31#1:76\n31#1:77,3\n39#1:80,3\n40#1:83,3\n*E\n"})
public final class JsExcludeModelSynchronizer {
    @NotNull
    private final Project project;
    @NotNull
    private final WorkspaceModel workspaceModel;

    public JsExcludeModelSynchronizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
    }

    public final void sync() {
        List<JsExcludeEntityBuilder> actualEntities = this.buildActualEntities();
        if (this.areEntitiesOutdated(actualEntities)) {
            this.updateEntities(actualEntities);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsExcludeEntityBuilder> buildActualEntities() {
        void $this$mapTo$iv$iv;
        List<VirtualFile> excludedFilesOrDirs = JsExcludeManager.Companion.getInstance(this.project).getExcludedFilesOrDirs();
        if (excludedFilesOrDirs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        VirtualFileUrlManager virtualFileUrlManager = this.workspaceModel.getVirtualFileUrlManager();
        Iterable $this$map$iv = excludedFilesOrDirs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JsExcludeManager.Companion.createEntity$intellij_javascript_backend((VirtualFile)it, virtualFileUrlManager));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areEntitiesOutdated(List<? extends JsExcludeEntityBuilder> actualEntities) {
        void $this$mapTo$iv;
        Collection collection;
        void $this$mapTo$iv2;
        List<JsExcludeEntity> workspaceModelEntities = this.getWorkspaceModelEntities();
        if (workspaceModelEntities.size() != actualEntities.size()) {
            return true;
        }
        Iterable iterable = workspaceModelEntities;
        Iterable destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            void it;
            JsExcludeEntity jsExcludeEntity = (JsExcludeEntity)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new JsExcludeEntityWrapper((JsExcludeEntity)it, null));
        }
        HashSet wrappedWorkspaceModelEntities = (HashSet)destination$iv;
        destination$iv = actualEntities;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            JsExcludeEntityBuilder bl = (JsExcludeEntityBuilder)item$iv;
            collection = destination$iv2;
            boolean bl2 = false;
            collection.add(new JsExcludeEntityWrapper(null, (JsExcludeEntityBuilder)it));
        }
        HashSet wrappedActualEntities = (HashSet)destination$iv2;
        return !Intrinsics.areEqual((Object)wrappedWorkspaceModelEntities, (Object)wrappedActualEntities);
    }

    private final List<JsExcludeEntity> getWorkspaceModelEntities() {
        return SequencesKt.toList((Sequence)this.workspaceModel.getCurrentSnapshot().entities(JsExcludeEntity.class));
    }

    private final void updateEntities(List<? extends JsExcludeEntityBuilder> actualEntities) {
        MutableEntityStorage entitiesStorage = YarnPnpEntityHelperKt.createStorageFrom(actualEntities);
        JsExcludeManager.Companion.invokeUnderWriteAction(this.project, () -> JsExcludeModelSynchronizer.updateEntities$lambda$0(this, entitiesStorage));
    }

    private static final void updateEntities$lambda$0(JsExcludeModelSynchronizer this$0, MutableEntityStorage $entitiesStorage) {
        this$0.workspaceModel.updateProjectModel("synchronizing js exclude entities", arg_0 -> JsExcludeModelSynchronizer.updateEntities$lambda$0$0($entitiesStorage, arg_0));
    }

    private static final Unit updateEntities$lambda$0$0(MutableEntityStorage $entitiesStorage, MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        storage.replaceBySource(JsExcludeModelSynchronizer::updateEntities$lambda$0$0$0, (EntityStorage)$entitiesStorage);
        return Unit.INSTANCE;
    }

    private static final boolean updateEntities$lambda$0$0$0(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == JsExcludeEntity.MyEntitySource.INSTANCE;
    }
}

