/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbIndirectReferenceModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbReferenceModelApplier;
import com.intellij.database.schemaEditor.model.state.DbIndirectReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.AutoSelectListener;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbTextEditorBase;
import com.intellij.database.schemaEditor.ui.ManualPopupButton;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Font;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbReferenceEditor<E extends BasicElement, T extends BasicElement, S extends DbIndirectReferenceModelState<T, String>>
extends DbTextEditorBase<E, S> {
    protected final TextFieldWithCompletion myTextField;

    public static <E extends BasicElement> DbReferenceEditor<E, ?, ?> create(@NotNull DbEditorController controller, @NotNull DbModelRef<E, ? extends DbIndirectReferenceModelState<?, String>> model) {
        if (controller == null) {
            DbReferenceEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbReferenceEditor.$$$reportNull$$$0(1);
        }
        return new DbReferenceEditor(controller, model);
    }

    public DbReferenceEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model) {
        if (controller == null) {
            DbReferenceEditor.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DbReferenceEditor.$$$reportNull$$$0(3);
        }
        super(controller, model, DbTextModelState.valueAccessor());
        this.myTextField = new TextFieldWithCompletion(this.getController().getProject(), (TextCompletionProvider)new TextFieldCompletionProvider(true){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                DbReferenceEditor.this.addVariants(result2);
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/ui/DbReferenceEditor$1";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "", true, true, true);
        this.myTextField.setPreferredWidth(GraphicsUtil.stringWidth((String)"m", (Font)this.myTextField.getFont()) * 20);
        this.myTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                DbReferenceEditor.this.modified();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/schemaEditor/ui/DbReferenceEditor$2", "documentChanged"));
            }
        });
        AutoSelectListener.INSTANCE.install((JComponent)this.myTextField);
        ManualPopupButton.INSTANCE.install((EditorTextField)this.myTextField, false);
    }

    @Override
    @NotNull
    protected String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            DbReferenceEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected void setText(@NotNull String text) {
        if (text == null) {
            DbReferenceEditor.$$$reportNull$$$0(5);
        }
        this.myTextField.setText(text);
    }

    private void addVariants(@NotNull CompletionResultSet result2) {
        BasicElement e;
        if (result2 == null) {
            DbReferenceEditor.$$$reportNull$$$0(6);
        }
        DbEditorModelController controller = this.getController().getModelController();
        JBIterable<T> traverser = this.createTraverser(controller, (DbIndirectReferenceModelApplier<S, T, ?, ?>)this.getApplier());
        ElementOwner owner = controller.getActualOwner();
        BasicElement basicElement = e = owner == null ? null : owner.find(this.getIdentity());
        if (traverser != null && e != null) {
            NamingService ns = this.getNamingService();
            BasicMetaReference baseRef = ((DbReferenceModelApplier)this.getApplier()).getReference().getReferenceDesc().getBaseRef();
            BasicElement base = baseRef == null ? null : BasicMetaUtils.resolve((BasicElement)e, (BasicMetaReferenceDesc)baseRef.getReferenceDesc(), (BasicReference)((BasicReference)baseRef.get(e)), (BasicResolveAssistant)owner.getResolveAssistant());
            ObjectPath mainPath = base != null ? ObjectPaths.of(base) : (ObjectPath)JBIterable.generate(this.getIdentity(), arg_0 -> ((ElementMatcher)controller.getMatcher()).getParent(arg_0)).filterMap(id -> ObjectPaths.of((DasObject)owner.find(id))).first();
            Set mainPathItems = JBIterable.generate((Object)mainPath, p -> p.parent).toSet();
            result2.addAllElements((Iterable)traverser.map(o -> DbReferenceEditor.createLookupItem(ns, o, mainPathItems)).filter(o -> ContainerUtil.or((Iterable)o.getAllLookupStrings(), arg_0 -> ((PrefixMatcher)result2.getPrefixMatcher()).prefixMatches(arg_0))));
        }
        result2.stopHere();
    }

    @NotNull
    public DbIndirectReferenceModelApplier<E, T, String, S> getApplier() {
        DbIndirectReferenceModelApplier dbIndirectReferenceModelApplier = (DbIndirectReferenceModelApplier)super.getApplier();
        if (dbIndirectReferenceModelApplier == null) {
            DbReferenceEditor.$$$reportNull$$$0(7);
        }
        return dbIndirectReferenceModelApplier;
    }

    @NotNull
    private NamingService getNamingService() {
        NamingService namingService = NamingServices.getNamingService((Dbms)this.getDbms());
        if (namingService == null) {
            DbReferenceEditor.$$$reportNull$$$0(8);
        }
        return namingService;
    }

    @NotNull
    private static LookupElement createLookupItem(@NotNull NamingService ns, BasicElement o, Set<ObjectPath> mainPathItems) {
        if (ns == null) {
            DbReferenceEditor.$$$reportNull$$$0(9);
        }
        String text = DbReferenceEditor.getText(ns, o, mainPathItems);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)text).withPresentableText(o.getName()).withLookupString(text).withIcon(DbPresentationCore.getIcon((DasObject)o)).withTypeText(DasUtil.getName((DasObject)o.getParent())), (double)DbReferenceEditor.getWeight(o, mainPathItems));
        if (lookupElement == null) {
            DbReferenceEditor.$$$reportNull$$$0(10);
        }
        return lookupElement;
    }

    private static int getWeight(BasicElement o, Set<ObjectPath> path) {
        int dist = 0;
        ObjectPath p = ObjectPaths.of((DasObject)o);
        while (p != null && !path.contains(p)) {
            ++dist;
            p = p.parent;
        }
        return -dist;
    }

    private static String getText(@NotNull NamingService ns, BasicElement o, Set<ObjectPath> path) {
        if (ns == null) {
            DbReferenceEditor.$$$reportNull$$$0(11);
        }
        StringBuilder res2 = new StringBuilder();
        ObjectPath p = ObjectPaths.of((DasObject)o);
        while (p != null && !path.contains(p)) {
            if (!res2.isEmpty()) {
                res2.insert(0, ".");
            }
            res2.insert(0, ns.catToScript(p.name, p.kind, !p.isQuoted()));
            p = p.parent;
        }
        return res2.isEmpty() ? o.getName() : res2.toString();
    }

    @Nullable
    private <S extends BasicElement> JBIterable<T> createTraverser(DbEditorModelController modelController, DbIndirectReferenceModelApplier<S, T, ?, ?> applier) {
        return DbReferenceEditor.createTraverser(modelController, this.getIdentity(), applier);
    }

    @Nullable
    private static <S extends BasicElement, T extends BasicElement> JBIterable<T> createTraverser(DbEditorModelController modelController, ElementIdentity<S> id, DbIndirectReferenceModelApplier<S, T, ?, ?> applier) {
        ElementOwner owner = modelController.getActualOwner();
        if (owner == null) {
            return null;
        }
        BasicElement root = owner.find(id);
        if (root == null) {
            return null;
        }
        return applier.getReference().getReferenceDesc().candidates(root, id.getMetaObject(), owner.getResolveAssistant());
    }

    @Nullable
    private static <T extends BasicElement> T findElement(ElementOwner owner, ElementIdentity<?> identity, Class<T> clazz) {
        while (identity != null) {
            BasicElement e;
            if (identity.getMetaObject().kindOf(clazz) && (e = (BasicElement)ObjectUtils.tryCast((Object)owner.find(identity), clazz)) != null) {
                return (T)e;
            }
            identity = owner.getParent(identity);
        }
        return null;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TextFieldWithCompletion textFieldWithCompletion = this.myTextField;
        if (textFieldWithCompletion == null) {
            DbReferenceEditor.$$$reportNull$$$0(12);
        }
        return textFieldWithCompletion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbReferenceEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbReferenceEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupItem";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 10, 12 -> new IllegalStateException(string);
        };
    }
}

