/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.ddl;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ddl.CreateObjectAction;
import com.intellij.database.actions.ddl.DbModifyObjectDialog;
import com.intellij.database.actions.ddl.DbModifyObjectDialogPanel;
import com.intellij.database.actions.ddl.ModifyObjectAction;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.VmActiveElement;
import com.intellij.database.model.basic.VmElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbeTierUtil;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseModifyObjectAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(1);
        }
        this.update(e, BaseModifyObjectAction.getTarget(e));
    }

    @Nullable
    private static DbContextDataSourceElements<BasicObjectNode> getTarget(@NotNull AnActionEvent e) {
        DbContextDataSourceElements<?> elements;
        if (e == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(2);
        }
        if ((elements = DbContextElementsKt.getSingleDsContextElements(e)) == null) {
            return null;
        }
        return elements.expandGroups().asNodes().replace(sel -> JBIterable.of((Object)((BasicObjectNode)sel.asIterable().filter(BasicObjectNode.class).single()))).nullize();
    }

    protected void update(@NotNull AnActionEvent e, @Nullable DbContextDataSourceElements<BasicObjectNode> selection) {
        BasicObjectNode element;
        if (e == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(3);
        }
        boolean visible = (element = BaseModifyObjectAction.getElement(selection)) != null && this.isAcceptable(element.extractObject()) && BaseModifyObjectAction.canPerformOn(selection.getDataSource(), element.getMetaObject(), e.getProject()) && this.isSupported(element.extractObject());
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && CreateObjectAction.canModify(selection.getProject(), (DasDataSource)selection.getDataSource(), element, element.getMetaObject()));
        DbeTierUtil.adjustPaidTier(e);
    }

    @Nullable
    public static BasicObjectNode getElement(@Nullable DbContextDataSourceElements<BasicObjectNode> selection) {
        return selection == null ? null : (BasicObjectNode)selection.asIterable().first();
    }

    public static boolean canPerformOn(@NotNull RawDataSource dataSource, @NotNull BasicMetaObject<?> meta, @NotNull Project project) {
        if (dataSource == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(4);
        }
        if (meta == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(6);
        }
        return dataSource instanceof LocalDataSource && (meta.kindOf(VmElement.class) || DbImplUtilCore.canConnectTo((LocalDataSource)((LocalDataSource)dataSource), (Project)project)) || dataSource instanceof SqlDataSource && !meta.kindOf(VmActiveElement.class);
    }

    public boolean isSupported(@NotNull BasicElement e) {
        if (e == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(7);
        }
        if (e instanceof VmElement) {
            return true;
        }
        Dbms dbms = DbImplUtilCore.getDbms((BasicElement)e);
        ScriptingCapabilities capabilities = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(e);
        BasicModel model = e.getModel();
        Version version = model == null ? Version.INFINITY : model.getRoot().getServerVersion();
        return this.isSupported(capabilities, version);
    }

    protected abstract boolean isSupported(ScriptingCapabilities var1, Version var2);

    protected boolean isAcceptable(BasicElement e) {
        return true;
    }

    @Contract(value="null->null")
    static BasicElement getElement(DbElement single) {
        BasicElement element;
        BasicElement basicElement = element = single == null ? null : (BasicElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicElement.class);
        if (element == null && single != null) {
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)single.getDataSource().getModel(), BasicModel.class);
            element = model == null ? null : model.getRoot();
        }
        return element;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DbContextDataSourceElements<BasicObjectNode> selection;
        BasicObjectNode element;
        BasicModel model;
        if (e == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(8);
        }
        BasicModel basicModel = model = (element = BaseModifyObjectAction.getElement(selection = BaseModifyObjectAction.getTarget(e))) == null ? null : element.getModel();
        if (model == null) {
            return;
        }
        Project project = selection.getProject();
        RawDataSource dataSource = selection.getDataSource();
        if (element instanceof BasicElement && BaseModifyObjectAction.shouldAbort(project, dataSource, (BasicElement)element, e.getPresentation().getText())) {
            return;
        }
        BasicNamespace current = CreateObjectAction.getCurrentNamespaceOrAnotherDb((DasDataSource)dataSource, selection.asIterable().toSet());
        SearchPath searchPath = ObjectPaths.searchPathOf((DasObject)current);
        Consumer postIntrospectionCallback = (Consumer)e.getDataContext().getData(ModifyObjectAction.POST_INTROSPECTION_CALLBACK);
        DbImportDialog.withCoroutineScopeBoundToDialog((Function1<? super CoroutineScope, ? extends DialogWrapper>)((Function1)cs -> {
            DbModifyObjectDialog dialog = this.createRefactoringDialog(project, (CoroutineScope)cs, dataSource, model, element, searchPath, postIntrospectionCallback);
            dialog.initAndShow();
            return dialog;
        }));
    }

    private static boolean shouldAbort(@NotNull Project project, @NotNull RawDataSource dataSource, @NotNull BasicElement element, @Nls String actionName) {
        if (project == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(9);
        }
        if (dataSource == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(10);
        }
        if (element == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(11);
        }
        return dataSource instanceof LocalDataSource && DetailsSyncHelper.askUserForSyncOrAbort((Project)project, (LocalDataSource)((LocalDataSource)dataSource), (BasicElement)element, (String)actionName);
    }

    @NotNull
    protected abstract DbModifyObjectDialog createRefactoringDialog(@NotNull Project var1, @NotNull CoroutineScope var2, @NotNull RawDataSource var3, @NotNull BasicModel var4, @NotNull BasicObjectNode var5, @Nullable SearchPath var6, @Nullable Consumer<List<ObjectPath>> var7);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ddl/BaseModifyObjectAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ddl/BaseModifyObjectAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canPerformOn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldAbort";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    protected static abstract class ModifyBootstrapper
    extends DbModifyObjectDialogPanel.ObjectEditorBootstrapper {
        @NotNull
        private final BasicObjectNode myElement;

        public ModifyBootstrapper(@NotNull Project project, @NotNull BasicModel model, @NotNull BasicObjectNode element, @Nullable Consumer<List<ObjectPath>> postIntrospectionCallback) {
            if (project == null) {
                ModifyBootstrapper.$$$reportNull$$$0(0);
            }
            if (model == null) {
                ModifyBootstrapper.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ModifyBootstrapper.$$$reportNull$$$0(2);
            }
            super(project, model, postIntrospectionCallback);
            this.myElement = element;
        }

        @Override
        @NotNull
        public ElementIdentity<?> createTargetId(@NotNull ElementMatcher matcher, @NotNull ElementOwner targetOwner) {
            if (matcher == null) {
                ModifyBootstrapper.$$$reportNull$$$0(3);
            }
            if (targetOwner == null) {
                ModifyBootstrapper.$$$reportNull$$$0(4);
            }
            ElementIdentity<?> elementIdentity = this.pull(Objects.requireNonNull(matcher.getOriginalOwner()), this.myElement);
            if (elementIdentity == null) {
                ModifyBootstrapper.$$$reportNull$$$0(5);
            }
            return elementIdentity;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetOwner";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ddl/BaseModifyObjectAction$ModifyBootstrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ddl/BaseModifyObjectAction$ModifyBootstrapper";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTargetId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createTargetId";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

