/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.moduleRoots.ModuleSearchPath;
import com.jetbrains.cidr.project.CidrChangeProjectContentRootAction;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 b2\u00020\u0001:\u0004_`abB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u0011H\u0004J\u0006\u0010\u001f\u001a\u00020\u0011J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\tH\u0004J\b\u0010#\u001a\u00020!H\u0004J\u001a\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\u0011H\u0004J\u0012\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010\tH\u0002J\u001c\u0010'\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\t2\b\u0010(\u001a\u0004\u0018\u00010\u000fH\u0004J\u0012\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u000fH&J\u000e\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tJ\b\u00102\u001a\u00020\u0011H\u0014J\u0010\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u0011H\u0016J\u0010\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u0011H\u0016J\b\u00107\u001a\u00020\u0011H\u0002J\b\u00108\u001a\u00020\u0011H\u0002J\u0018\u00109\u001a\b\u0012\u0004\u0012\u00020\u000f0:2\b\u0010+\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010;\u001a\u0004\u0018\u00010\u000f2\b\u0010+\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020*H\u0016J\b\u0010>\u001a\u00020\u0011H\u0016J\b\u0010?\u001a\u00020!H\u0007J\u000e\u0010@\u001a\u00020!H\u0086@\u00a2\u0006\u0002\u0010AJ\u0018\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00152\u0006\u0010=\u001a\u00020*H\u0014J$\u0010C\u001a\u00020!2\u000b\u0010D\u001a\u00070E\u00a2\u0006\u0002\bF2\r\u0010G\u001a\t\u0018\u00010E\u00a2\u0006\u0002\bHH\u0014J\u0010\u0010I\u001a\u00020!2\u0006\u0010+\u001a\u00020JH\u0007J\u0016\u0010K\u001a\u00020!2\u0006\u0010+\u001a\u00020JH\u0087@\u00a2\u0006\u0002\u0010LJ\u0006\u0010W\u001a\u00020XJ\b\u0010\\\u001a\u00020!H\u0016J\u000e\u0010]\u001a\u00020!2\u0006\u0010^\u001a\u00020XR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0013R\u0014\u0010.\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\fR\u0011\u00100\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\fR\u0016\u0010M\u001a\u0004\u0018\u00010J8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0013\u0010P\u001a\u0004\u0018\u00010Q8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR(\u0010+\u001a\u0004\u0018\u00010\u000f2\b\u0010(\u001a\u0004\u0018\u00010\u000f8F@DX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010U\"\u0004\b'\u0010VR\u001b\u0010Y\u001a\t\u0018\u00010E\u00a2\u0006\u0002\bH8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[\u00a8\u0006c"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Ljava/nio/file/Path;", "projectPathOrNull", "getProjectPathOrNull", "()Ljava/nio/file/Path;", "myProject", "myContentRoot", "Ljava/io/File;", "myBaseStateInitialized", "", "isInitialized", "()Z", "myFilesOutsideRootsToReport", "", "myIgnoreFilesOutsideOfProjectRoot", "myFilesOutsideRootsNotification", "Lcom/intellij/notification/Notification;", "myBusConnectionDisposable", "Lcom/intellij/openapi/Disposable;", "getMyBusConnectionDisposable", "()Lcom/intellij/openapi/Disposable;", "shouldLoadWorkspaceForProject", "isLinked", "wasLinkedBefore", "linkWithProject", "", "projectDir", "unlink", "preserveContentRoot", "preserveContentRootIfNecessary", "newProjectDir", "setContentRoot", "newContentRoot", "collectRootsInfo", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "contentRoot", "getProjectSubDir", "subdir", "fallbackProjectPath", "getFallbackProjectPath", "projectPath", "getProjectPath", "initializeAndStart", "load", "projectOpening", "unload", "projectClosing", "markInitialized", "markUninitialized", "collectExcludeRoots", "", "beforeUpdateContentRoots", "afterUpdateContentRoots", "rootsInfo", "shouldEnableRootConfiguration", "updateContentRootsBlocking", "updateContentRoots", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectFilesOutsideContentRoots", "reportFilesOutsideContentRoot", "message", "", "Lorg/jetbrains/annotations/Nls;", "toolWindowId", "Lorg/jetbrains/annotations/NonNls;", "changeContentRootBlocking", "Lcom/intellij/openapi/vfs/VirtualFile;", "changeContentRoot", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "effectiveContentRoot", "getEffectiveContentRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getContentRoot", "()Ljava/io/File;", "(Ljava/io/File;)V", "getBaseState", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$State;", "clientKey", "getClientKey", "()Ljava/lang/String;", "noStateLoaded", "loadBaseState", "state", "State", "BalloonNotifier", "NullFallbackProjectPathException", "Companion", "intellij.cidr.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nCidrWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrWorkspace.kt\ncom/jetbrains/cidr/project/workspace/CidrWorkspace\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,467:1\n67#2,4:468\n67#2,4:472\n13#2:476\n*S KotlinDebug\n*F\n+ 1 CidrWorkspace.kt\ncom/jetbrains/cidr/project/workspace/CidrWorkspace\n*L\n110#1:468,4\n115#1:472,4\n418#1:476\n*E\n"})
public abstract class CidrWorkspace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private volatile Path projectPathOrNull;
    @JvmField
    @NotNull
    protected final Project myProject;
    @JvmField
    @Nullable
    protected volatile File myContentRoot;
    private volatile boolean myBaseStateInitialized;
    private volatile boolean isInitialized;
    private volatile Set<? extends File> myFilesOutsideRootsToReport;
    private volatile boolean myIgnoreFilesOutsideOfProjectRoot;
    @Nullable
    private volatile Notification myFilesOutsideRootsNotification;
    @NotNull
    private final Disposable myBusConnectionDisposable;
    @NotNull
    private static final Logger LOG;
    @Nullable
    private static BalloonNotifier ourBalloonNotifier;

    protected CidrWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myProject = this.project = project;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.myBusConnectionDisposable = disposable;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    protected final Path getProjectPathOrNull() {
        return this.projectPathOrNull;
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    @NotNull
    protected final Disposable getMyBusConnectionDisposable() {
        return this.myBusConnectionDisposable;
    }

    protected final boolean shouldLoadWorkspaceForProject() {
        return !this.myProject.isDefault() && !ProjectManagerImpl.Companion.isLight(this.myProject);
    }

    public final boolean isLinked() {
        return this.projectPathOrNull != null;
    }

    public final boolean wasLinkedBefore() {
        return this.isLinked() || this.myContentRoot != null;
    }

    protected final void linkWithProject(@Nullable Path projectDir) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Linking with project " + projectDir);
        }
        this.projectPathOrNull = projectDir;
    }

    protected final void unlink() {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Unlinking from project " + this.projectPathOrNull);
        }
        this.projectPathOrNull = null;
    }

    protected final void linkWithProject(@Nullable Path projectDir, boolean preserveContentRoot) {
        if (preserveContentRoot) {
            this.preserveContentRootIfNecessary(projectDir);
        }
        this.linkWithProject(projectDir);
    }

    private final void preserveContentRootIfNecessary(Path newProjectDir) {
        Path projectDir = this.projectPathOrNull;
        if (projectDir == null && newProjectDir == null || projectDir != null && this.myContentRoot != null) {
            return;
        }
        this.setContentRoot(newProjectDir, this.getProjectPath().toFile());
    }

    protected final void setContentRoot(@Nullable Path projectDir, @Nullable File newContentRoot) {
        File oldContentRoot = this.myContentRoot;
        File file = this.myContentRoot = newContentRoot != null && (projectDir == null || !FileUtil.pathsEqual((String)((Object)projectDir).toString(), (String)newContentRoot.getPath())) ? newContentRoot : null;
        if (!FileUtil.filesEqual((File)this.myContentRoot, (File)oldContentRoot)) {
            this.myIgnoreFilesOutsideOfProjectRoot = false;
        }
    }

    @NotNull
    public abstract OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File var1);

    @NotNull
    public final Path getProjectSubDir(@NotNull Path subdir) {
        Intrinsics.checkNotNullParameter((Object)subdir, (String)"subdir");
        if (subdir.isAbsolute()) {
            return subdir;
        }
        Path path = this.getProjectPath().resolve(subdir).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    private final Path getFallbackProjectPath() {
        String basePath = this.myProject.getBasePath();
        if (basePath == null) {
            throw new NullFallbackProjectPathException("Project base path is null. default = " + this.myProject.isDefault());
        }
        Path path = Paths.get(basePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path getProjectPath() {
        Path projectDir = this.projectPathOrNull;
        Path path = projectDir;
        if (path == null) {
            path = this.getFallbackProjectPath();
        }
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        return path2;
    }

    protected boolean initializeAndStart() {
        return this.markInitialized();
    }

    public boolean load(boolean projectOpening) {
        return this.shouldLoadWorkspaceForProject() && this.isLinked() && this.initializeAndStart();
    }

    public boolean unload(boolean projectClosing) {
        return this.markUninitialized();
    }

    private final synchronized boolean markInitialized() {
        this.isInitialized = true;
        return CidrWorkspaceManager.Companion.getInstance(this.myProject).markInitializing(this);
    }

    private final synchronized boolean markUninitialized() {
        if (!this.isInitialized) {
            return true;
        }
        this.isInitialized = false;
        return CidrWorkspaceManager.Companion.getInstance(this.myProject).markShutdown(this);
    }

    @NotNull
    public List<File> collectExcludeRoots(@Nullable File contentRoot) {
        return CollectionsKt.emptyList();
    }

    @Nullable
    public File beforeUpdateContentRoots(@Nullable File contentRoot) {
        if (contentRoot != null && this.isLinked()) {
            this.setContentRoot(contentRoot);
            return this.myContentRoot;
        }
        return contentRoot;
    }

    public void afterUpdateContentRoots(@NotNull OCRootsSynchronizer.RootsInfo rootsInfo) {
        Intrinsics.checkNotNullParameter((Object)rootsInfo, (String)"rootsInfo");
        Set<File> outsideFiles = this.collectFilesOutsideContentRoots(rootsInfo);
        if (outsideFiles.isEmpty()) {
            this.myIgnoreFilesOutsideOfProjectRoot = false;
        }
        this.myFilesOutsideRootsToReport = outsideFiles;
    }

    public boolean shouldEnableRootConfiguration() {
        return this.isLinked();
    }

    @Deprecated(message="Use suspend variant instead")
    @RequiresWriteLock
    @ApiStatus.ScheduledForRemoval
    public final void updateContentRootsBlocking() {
        OCRootsSynchronizer.Companion.getInstance(this.myProject).updateRootsBlocking(MapsKt.mapOf((Pair)TuplesKt.to((Object)this, (Object)this.myContentRoot)));
    }

    @Nullable
    public final Object updateContentRoots(@NotNull Continuation<? super Unit> $completion) {
        Object object = OCRootsSynchronizer.Companion.getInstance(this.myProject).updateRoots(MapsKt.mapOf((Pair)TuplesKt.to((Object)this, (Object)this.myContentRoot)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected Set<File> collectFilesOutsideContentRoots(@NotNull OCRootsSynchronizer.RootsInfo rootsInfo) {
        Intrinsics.checkNotNullParameter((Object)rootsInfo, (String)"rootsInfo");
        return OCRootsSynchronizer.Companion.collectFilesNotUnder((Collection<? extends File>)rootsInfo.contentRoots, (Collection<? extends File>)rootsInfo.sourceFiles);
    }

    protected void reportFilesOutsideContentRoot(@NotNull String message, @Nullable String toolWindowId) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Notification existingNotification = this.myFilesOutsideRootsNotification;
        Set<? extends File> set = this.myFilesOutsideRootsToReport;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myFilesOutsideRootsToReport");
            set = null;
        }
        if (!set.isEmpty() && !this.myIgnoreFilesOutsideOfProjectRoot && existingNotification == null) {
            ThreadingAssertions.assertEventDispatchThread();
            Set<? extends File> set2 = this.myFilesOutsideRootsToReport;
            if (set2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myFilesOutsideRootsToReport");
                set2 = null;
            }
            LOG.info("The following files are located outside of the project: \n\t\t" + CollectionsKt.joinToString$default((Iterable)set2, (CharSequence)"\n\t\t", null, null, (int)0, null, null, (int)62, null));
            this.myFilesOutsideRootsToReport = SetsKt.emptySet();
            HyperlinkAdapter listener2 = new HyperlinkAdapter(this){
                final /* synthetic */ CidrWorkspace this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Intrinsics.areEqual((Object)"change", (Object)e.getDescription())) {
                        CidrChangeProjectContentRootAction.perform(this.this$0.myProject, this.this$0);
                    } else if (Intrinsics.areEqual((Object)"ignore", (Object)e.getDescription())) {
                        CidrWorkspace.access$setMyIgnoreFilesOutsideOfProjectRoot$p(this.this$0, true);
                    }
                }
            };
            BalloonNotifier notifier = ourBalloonNotifier;
            if (notifier != null) {
                MessageType messageType = MessageType.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
                notifier.notify(messageType, message, (HyperlinkListener)listener2);
            } else if (toolWindowId != null) {
                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.myProject);
                MessageType messageType = MessageType.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
                toolWindowManager.notifyByBalloon(toolWindowId, messageType, message, null, (HyperlinkListener)listener2);
            } else {
                Notification notification;
                NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Workspace");
                Notification notification2 = notificationGroup.createNotification(message, NotificationType.WARNING).setListener((arg_0, arg_1) -> CidrWorkspace.reportFilesOutsideContentRoot$lambda$0(listener2, this, arg_0, arg_1));
                Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"setListener(...)");
                this.myFilesOutsideRootsNotification = notification = notification2;
                notification.notify(this.myProject);
            }
        } else if (existingNotification != null && !existingNotification.isExpired()) {
            Set<? extends File> set3 = this.myFilesOutsideRootsToReport;
            if (set3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myFilesOutsideRootsToReport");
                set3 = null;
            }
            if (set3.isEmpty()) {
                existingNotification.expire();
                this.myFilesOutsideRootsNotification = null;
            }
        }
    }

    @Deprecated(message="Use suspend variant instead")
    @RequiresWriteLock
    @ApiStatus.ScheduledForRemoval
    public final void changeContentRootBlocking(@NotNull VirtualFile contentRoot) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        this.myIgnoreFilesOutsideOfProjectRoot = false;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        File contentRootFile = file;
        OCRootsSynchronizer.Companion.getInstance(this.myProject).updateRootsBlocking(MapsKt.mapOf((Pair)TuplesKt.to((Object)this, (Object)contentRootFile)));
    }

    @RequiresWriteLock
    @Nullable
    public final Object changeContentRoot(@NotNull VirtualFile contentRoot, @NotNull Continuation<? super Unit> $completion) {
        this.myIgnoreFilesOutsideOfProjectRoot = false;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        File contentRootFile = file;
        Object object = OCRootsSynchronizer.Companion.getInstance(this.myProject).updateRoots(MapsKt.mapOf((Pair)TuplesKt.to((Object)this, (Object)contentRootFile)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public VirtualFile getEffectiveContentRoot() {
        File root = this.myContentRoot;
        return root == null ? null : LocalFileSystem.getInstance().findFileByIoFile(root);
    }

    @Nullable
    public final Module getModule() {
        return OCRootsSynchronizer.Companion.getInstance(this.myProject).getModuleIfExists();
    }

    @Nullable
    public final File getContentRoot() {
        return this.myContentRoot;
    }

    protected final void setContentRoot(@Nullable File newContentRoot) {
        this.setContentRoot(this.projectPathOrNull, newContentRoot);
    }

    @NotNull
    public final State getBaseState() {
        Path path = this.projectPathOrNull;
        return new State(path != null ? path.toFile() : null, this.myContentRoot, this.myIgnoreFilesOutsideOfProjectRoot);
    }

    @Nullable
    public String getClientKey() {
        return null;
    }

    public void noStateLoaded() {
        this.myBaseStateInitialized = true;
    }

    public final void loadBaseState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        File file = state.getMyProjectDir();
        Path projectDir = file != null ? file.toPath() : null;
        this.myContentRoot = state.getMyContentRoot();
        this.myIgnoreFilesOutsideOfProjectRoot = state.getMyIgnoreFilesOutsideOfProjectRoot();
        this.linkWithProject(projectDir, this.myBaseStateInitialized);
        this.myBaseStateInitialized = true;
    }

    private static final void reportFilesOutsideContentRoot$lambda$0(HyperlinkAdapter $listener, CidrWorkspace this$0, Notification notification, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        $listener.hyperlinkUpdate(event);
        notification.expire();
        this$0.myFilesOutsideRootsNotification = null;
    }

    @JvmStatic
    @NotNull
    public static final List<CidrWorkspace> getInitializedWorkspaces(@NotNull Project project) {
        return Companion.getInitializedWorkspaces(project);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OCRootsSynchronizer.RootsInfo createRootsInfo(@NotNull List<? extends OCResolveConfiguration> resolveConfigurations, @NotNull List<? extends File> roots, @NotNull List<? extends File> additionalSourceFiles, @NotNull List<? extends File> generatedSourceFiles) {
        return Companion.createRootsInfo(resolveConfigurations, roots, additionalSourceFiles, generatedSourceFiles);
    }

    @JvmStatic
    @TestOnly
    public static final void setBalloonNotifierInTests(@Nullable BalloonNotifier notifier) {
        Companion.setBalloonNotifierInTests(notifier);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OCRootsSynchronizer.RootsInfo createRootsInfo(@NotNull List<? extends OCResolveConfiguration> resolveConfigurations, @NotNull List<? extends File> roots, @NotNull List<? extends File> additionalSourceFiles) {
        return Companion.createRootsInfo(resolveConfigurations, roots, additionalSourceFiles);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OCRootsSynchronizer.RootsInfo createRootsInfo(@NotNull List<? extends OCResolveConfiguration> resolveConfigurations, @NotNull List<? extends File> roots) {
        return Companion.createRootsInfo(resolveConfigurations, roots);
    }

    public static final /* synthetic */ void access$setMyIgnoreFilesOutsideOfProjectRoot$p(CidrWorkspace $this, boolean bl) {
        $this.myIgnoreFilesOutsideOfProjectRoot = bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CidrWorkspace.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$BalloonNotifier;", "", "notify", "", "type", "Lcom/intellij/openapi/ui/MessageType;", "message", "", "listener", "Ljavax/swing/event/HyperlinkListener;", "intellij.cidr.workspaceModel"})
    public static interface BalloonNotifier {
        public void notify(@NotNull MessageType var1, @NotNull String var2, @NotNull HyperlinkListener var3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007JD\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\rH\u0007J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ourBalloonNotifier", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$BalloonNotifier;", "getOurBalloonNotifier", "()Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$BalloonNotifier;", "setOurBalloonNotifier", "(Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$BalloonNotifier;)V", "getInitializedWorkspaces", "", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "project", "Lcom/intellij/openapi/project/Project;", "createRootsInfo", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "resolveConfigurations", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "roots", "Ljava/io/File;", "additionalSourceFiles", "generatedSourceFiles", "setBalloonNotifierInTests", "", "notifier", "intellij.cidr.workspaceModel"})
    @SourceDebugExtension(value={"SMAP\nCidrWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrWorkspace.kt\ncom/jetbrains/cidr/project/workspace/CidrWorkspace$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,467:1\n1563#2:468\n1634#2,3:469\n*S KotlinDebug\n*F\n+ 1 CidrWorkspace.kt\ncom/jetbrains/cidr/project/workspace/CidrWorkspace$Companion\n*L\n446#1:468\n446#1:469,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        protected final BalloonNotifier getOurBalloonNotifier() {
            return ourBalloonNotifier;
        }

        protected final void setOurBalloonNotifier(@Nullable BalloonNotifier balloonNotifier) {
            ourBalloonNotifier = balloonNotifier;
        }

        @JvmStatic
        @NotNull
        public final List<CidrWorkspace> getInitializedWorkspaces(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return CidrWorkspaceManager.Companion.getInstance(project).getInitializedWorkspaces();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OCRootsSynchronizer.RootsInfo createRootsInfo(@NotNull List<? extends OCResolveConfiguration> resolveConfigurations, @NotNull List<? extends File> roots, @NotNull List<? extends File> additionalSourceFiles, @NotNull List<? extends File> generatedSourceFiles) {
            Intrinsics.checkNotNullParameter(resolveConfigurations, (String)"resolveConfigurations");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Intrinsics.checkNotNullParameter(additionalSourceFiles, (String)"additionalSourceFiles");
            Intrinsics.checkNotNullParameter(generatedSourceFiles, (String)"generatedSourceFiles");
            OCRootsSynchronizer.RootsInfo info = new OCRootsSynchronizer.RootsInfo();
            info.contentRoots.addAll((Collection<File>)roots);
            for (OCResolveConfiguration oCResolveConfiguration : resolveConfigurations) {
                for (String sourceUrl : oCResolveConfiguration.getSourceUrls()) {
                    info.sourceFiles.add(new File(VfsUtilCore.urlToPath((String)sourceUrl)));
                }
                oCResolveConfiguration.getAllCompilerSettings().forEach(arg_0 -> Companion.createRootsInfo$lambda$1(arg_0 -> Companion.createRootsInfo$lambda$0(info, arg_0), arg_0));
            }
            info.sourceFiles.addAll((Collection<File>)additionalSourceFiles);
            info.generatedSourceFiles.addAll((Collection<File>)generatedSourceFiles);
            return info;
        }

        public static /* synthetic */ OCRootsSynchronizer.RootsInfo createRootsInfo$default(Companion companion, List list, List list2, List list3, List list4, int n, Object object) {
            if ((n & 4) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                list4 = CollectionsKt.emptyList();
            }
            return companion.createRootsInfo(list, list2, list3, list4);
        }

        @JvmStatic
        @TestOnly
        public final void setBalloonNotifierInTests(@Nullable BalloonNotifier notifier) {
            this.setOurBalloonNotifier(notifier);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OCRootsSynchronizer.RootsInfo createRootsInfo(@NotNull List<? extends OCResolveConfiguration> resolveConfigurations, @NotNull List<? extends File> roots, @NotNull List<? extends File> additionalSourceFiles) {
            Intrinsics.checkNotNullParameter(resolveConfigurations, (String)"resolveConfigurations");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Intrinsics.checkNotNullParameter(additionalSourceFiles, (String)"additionalSourceFiles");
            return com.jetbrains.cidr.project.workspace.CidrWorkspace$Companion.createRootsInfo$default(this, resolveConfigurations, roots, additionalSourceFiles, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OCRootsSynchronizer.RootsInfo createRootsInfo(@NotNull List<? extends OCResolveConfiguration> resolveConfigurations, @NotNull List<? extends File> roots) {
            Intrinsics.checkNotNullParameter(resolveConfigurations, (String)"resolveConfigurations");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            return com.jetbrains.cidr.project.workspace.CidrWorkspace$Companion.createRootsInfo$default(this, resolveConfigurations, roots, null, null, 12, null);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit createRootsInfo$lambda$0(OCRootsSynchronizer.RootsInfo $info, OCCompilerSettings settings) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            $info.headersSearchRoots.addAll(settings.getHeadersSearchRoots().getAllRoots());
            List<File> list = $info.moduleSearchRoots;
            List list2 = settings.getModuleSearchPaths();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getModuleSearchPaths(...)");
            Iterable iterable = list2;
            List<File> list3 = list;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void moduleSearchPath;
                ModuleSearchPath moduleSearchPath2 = (ModuleSearchPath)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(moduleSearchPath.getModulePath().getParent().toFile());
            }
            list3.addAll((List)destination$iv$iv);
            return Unit.INSTANCE;
        }

        private static final void createRootsInfo$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$NullFallbackProjectPathException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "intellij.cidr.workspaceModel"})
    public static final class NullFallbackProjectPathException
    extends RuntimeException {
        public NullFallbackProjectPathException(@Nullable String message) {
            super(message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B%\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$State;", "", "<init>", "()V", "projectDir", "Ljava/io/File;", "contentRoot", "ignoreFilesOutsideOfProjectRoot", "", "(Ljava/io/File;Ljava/io/File;Z)V", "myProjectDir", "getMyProjectDir", "()Ljava/io/File;", "setMyProjectDir", "(Ljava/io/File;)V", "myContentRoot", "getMyContentRoot", "setMyContentRoot", "myIgnoreFilesOutsideOfProjectRoot", "getMyIgnoreFilesOutsideOfProjectRoot", "()Z", "setMyIgnoreFilesOutsideOfProjectRoot", "(Z)V", "createElement", "Lorg/jdom/Element;", "loadElement", "", "element", "Companion", "intellij.cidr.workspaceModel"})
    public static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private File myProjectDir;
        @Nullable
        private File myContentRoot;
        private boolean myIgnoreFilesOutsideOfProjectRoot;

        @Nullable
        public final File getMyProjectDir() {
            return this.myProjectDir;
        }

        public final void setMyProjectDir(@Nullable File file) {
            this.myProjectDir = file;
        }

        @Nullable
        public final File getMyContentRoot() {
            return this.myContentRoot;
        }

        public final void setMyContentRoot(@Nullable File file) {
            this.myContentRoot = file;
        }

        public final boolean getMyIgnoreFilesOutsideOfProjectRoot() {
            return this.myIgnoreFilesOutsideOfProjectRoot;
        }

        public final void setMyIgnoreFilesOutsideOfProjectRoot(boolean bl) {
            this.myIgnoreFilesOutsideOfProjectRoot = bl;
        }

        public State() {
        }

        public State(@Nullable File projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
            this.myProjectDir = projectDir;
            this.myContentRoot = contentRoot;
            this.myIgnoreFilesOutsideOfProjectRoot = ignoreFilesOutsideOfProjectRoot;
        }

        @NotNull
        public final Element createElement() {
            return Companion.createStateElement(this);
        }

        public final void loadElement(@NotNull Element element) {
            Element contentRootElement;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String projectDirString = element.getAttributeValue("PROJECT_DIR");
            this.myProjectDir = projectDirString == null ? null : new File(projectDirString);
            Element element2 = contentRootElement = element.getChild("contentRoot");
            String contentRootDirString = element2 != null ? element2.getAttributeValue("DIR") : null;
            this.myContentRoot = contentRootDirString == null ? null : new File(contentRootDirString);
            this.myIgnoreFilesOutsideOfProjectRoot = Boolean.parseBoolean(element.getAttributeValue("IGNORE_OUTSIDE_FILES"));
        }

        @JvmStatic
        @NotNull
        public static final State loadStateElement(@NotNull Element element) {
            return Companion.loadStateElement(element);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$State$Companion;", "", "<init>", "()V", "createStateElement", "Lorg/jdom/Element;", "projectDir", "Ljava/nio/file/Path;", "contentRoot", "Ljava/io/File;", "ignoreFilesOutsideOfProjectRoot", "", "state", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace$State;", "loadStateElement", "element", "intellij.cidr.workspaceModel"})
        public static final class Companion {
            private Companion() {
            }

            @TestOnly
            @NotNull
            public final Element createStateElement(@Nullable Path projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
                Path path = projectDir;
                return this.createStateElement(new State(path != null ? path.toFile() : null, contentRoot, ignoreFilesOutsideOfProjectRoot));
            }

            @NotNull
            public final Element createStateElement(@NotNull State state) {
                File stateContentRoot;
                File stateProjectDir;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Element element = new Element("state");
                if (state.getMyIgnoreFilesOutsideOfProjectRoot()) {
                    element.setAttribute("IGNORE_OUTSIDE_FILES", "true");
                }
                if ((stateProjectDir = state.getMyProjectDir()) != null) {
                    element.setAttribute("PROJECT_DIR", FileUtil.toSystemIndependentName((String)stateProjectDir.getPath()));
                }
                if ((stateContentRoot = state.getMyContentRoot()) != null) {
                    Element contentRootElement = new Element("contentRoot");
                    contentRootElement.setAttribute("DIR", FileUtil.toSystemIndependentName((String)stateContentRoot.getPath()));
                    element.addContent(contentRootElement);
                }
                return element;
            }

            @JvmStatic
            @NotNull
            public final State loadStateElement(@NotNull Element element) {
                State state;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                State $this$loadStateElement_u24lambda_u240 = state = new State();
                boolean bl = false;
                $this$loadStateElement_u24lambda_u240.loadElement(element);
                return state;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

