/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.workspace.compiler.resolver;

import com.jetbrains.cidr.cpp.workspace.compiler.resolver.CppCMakeLanguageVariable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeSyntaxLexer;", "", "<init>", "()V", "BOOLEAN", "Lkotlin/text/Regex;", "INTEGER", "QUOTED_STRING", "LIST", "LIST_SEPARATOR", "VARIABLE_REFERENCE", "", "IDENTIFIER", "ASSIGNMENT", "CMAKE_OUTPUT_CHARSET", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getCMAKE_OUTPUT_CHARSET$intellij_cmake", "()Ljava/nio/charset/Charset;", "readVariables", "", "Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeLanguageVariable;", "cmakeFileContent", "intellij.cmake"})
@SourceDebugExtension(value={"SMAP\nCppCMakeSyntaxLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppCMakeSyntaxLexer.kt\ncom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeSyntaxLexer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,100:1\n1321#2,2:101\n*S KotlinDebug\n*F\n+ 1 CppCMakeSyntaxLexer.kt\ncom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeSyntaxLexer\n*L\n64#1:101,2\n*E\n"})
public final class CppCMakeSyntaxLexer {
    @NotNull
    public static final CppCMakeSyntaxLexer INSTANCE = new CppCMakeSyntaxLexer();
    @NotNull
    private static final Regex BOOLEAN = new Regex("TRUE|FALSE");
    @NotNull
    private static final Regex INTEGER = new Regex("-?[0-9]+");
    @NotNull
    private static final Regex QUOTED_STRING = new Regex("\"[^\"]*\"");
    @NotNull
    private static final Regex LIST = new Regex(QUOTED_STRING + "(?:\\s+" + QUOTED_STRING + ")*");
    @NotNull
    private static final Regex LIST_SEPARATOR = new Regex("\"\\s+\"|;");
    @Language(value="RegExp")
    @NotNull
    private static final String VARIABLE_REFERENCE = "\\$\\{(?<variable>[^}]+)}";
    @Language(value="RegExp")
    @NotNull
    private static final String IDENTIFIER = "[A-Za-z0-9_]+";
    @NotNull
    private static final Regex ASSIGNMENT = new Regex("^\\h*set\\((?<key>[A-Za-z0-9_]+)(?:\\s+(?<values>" + BOOLEAN + "|" + INTEGER + "|\\$\\{(?<variable>[^}]+)}|" + LIST + "))?\\s*\\)", RegexOption.MULTILINE);
    private static final Charset CMAKE_OUTPUT_CHARSET = StandardCharsets.UTF_8;

    private CppCMakeSyntaxLexer() {
    }

    public final Charset getCMAKE_OUTPUT_CHARSET$intellij_cmake() {
        return CMAKE_OUTPUT_CHARSET;
    }

    @NotNull
    public final Map<String, CppCMakeLanguageVariable> readVariables(@NotNull String cmakeFileContent) {
        Intrinsics.checkNotNullParameter((Object)cmakeFileContent, (String)"cmakeFileContent");
        LinkedHashMap variables = new LinkedHashMap();
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)ASSIGNMENT, (CharSequence)cmakeFileContent, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List parsedValues;
            Object object;
            MatchResult matchResult = (MatchResult)element$iv;
            boolean bl = false;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"key");
            String key = matchGroup != null ? matchGroup.getValue() : null;
            if (key == null) continue;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"values");
            String rawValues = matchGroup2 != null ? matchGroup2.getValue() : null;
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"variable");
            String referencedVariable = matchGroup3 != null ? matchGroup3.getValue() : null;
            if (rawValues == null) {
                ((Map)variables).put(key, CppCMakeLanguageVariable.CppCMakeLanguageUndefined.INSTANCE);
                continue;
            }
            if (referencedVariable != null) {
                ((Map)variables).put(key, new CppCMakeLanguageVariable.CppCMakeLanguageVariableReference(referencedVariable));
                continue;
            }
            if (BOOLEAN.matches((CharSequence)rawValues)) {
                if (Intrinsics.areEqual((Object)rawValues, (Object)"TRUE")) {
                    ((Map)variables).put(key, new CppCMakeLanguageVariable.CppCMakeLanguageBoolean(true));
                    continue;
                }
                ((Map)variables).put(key, new CppCMakeLanguageVariable.CppCMakeLanguageBoolean(false));
                continue;
            }
            if (INTEGER.matches((CharSequence)rawValues)) {
                ((Map)variables).put(key, new CppCMakeLanguageVariable.CppCMakeLanguageInteger(Integer.parseInt(rawValues)));
                continue;
            }
            if (QUOTED_STRING.matches((CharSequence)rawValues)) {
                String string = rawValues.substring(1, rawValues.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = new char[]{';'};
                parsedValues = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
                if (parsedValues.size() == 1) {
                    ((Map)variables).put(key, new CppCMakeLanguageVariable.CppCMakeLanguageQuotedString((String)parsedValues.get(0)));
                    continue;
                }
                ((Map)variables).put(key, new CppCMakeLanguageVariable.CppCMakeLanguageList(parsedValues));
                continue;
            }
            if (!LIST.matches((CharSequence)rawValues)) continue;
            String string = rawValues.substring(1, rawValues.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = string;
            Regex regex = LIST_SEPARATOR;
            int n = 0;
            parsedValues = regex.split((CharSequence)object, n);
            ((Map)variables).put(key, new CppCMakeLanguageVariable.CppCMakeLanguageList(parsedValues));
        }
        return variables.isEmpty() ? MapsKt.emptyMap() : (Map)variables;
    }
}

