/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.workspace.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.CppCMakeCompilerDotCmakeLocator;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.CppCMakeCompilerKind;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.CppCMakeLanguageId;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.CppCMakeLanguageVariable;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.CppCMakeSyntaxLexer;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.locators.CppApproximateVersionBasedLocator;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.locators.CppExactVersionBasedLocator;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.locators.CppFirstMatchLocator;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.locators.CppMakefileDotCmakeParser;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCBuiltInCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.system.HostMachine;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0010H\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/workspace/compiler/CppCMakeBasedCompilerResolver;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerResolver;", "<init>", "()V", "compilerKindCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/nio/file/Path;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "resolveOrNull", "compilerExecutable", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "cache", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "block", "Lkotlin/Function0;", "Companion", "intellij.cmake"})
@SourceDebugExtension(value={"SMAP\nCppCMakeBasedCompilerResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppCMakeBasedCompilerResolver.kt\ncom/jetbrains/cidr/cpp/workspace/compiler/CppCMakeBasedCompilerResolver\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,375:1\n1321#2,2:376\n*S KotlinDebug\n*F\n+ 1 CppCMakeBasedCompilerResolver.kt\ncom/jetbrains/cidr/cpp/workspace/compiler/CppCMakeBasedCompilerResolver\n*L\n71#1:376,2\n*E\n"})
public final class CppCMakeBasedCompilerResolver
implements OCCompilerResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, ConcurrentHashMap<Path, OCCompilerKind>> compilerKindCache = new ConcurrentHashMap();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final SecureRandom RANDOM;

    @Nullable
    public OCCompilerKind resolveOrNull(@NotNull Path compilerExecutable, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)compilerExecutable, (String)"compilerExecutable");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (SwingUtilities.isEventDispatchThread()) {
            Thread edt = Thread.currentThread();
            LOGGER.error("Compiler resolver invoked from an AWT EDT (id = " + edt.getId() + ", name = \"" + edt.getName() + "\").");
        }
        if (!(environment instanceof CPPEnvironment)) {
            LOGGER.warn("Environment is an instance of " + environment.getClass().getName() + " (" + CPPEnvironment.class.getSimpleName() + " expected).");
            return null;
        }
        return this.cache(compilerExecutable, (CPPEnvironment)environment, (Function0<? extends OCCompilerKind>)((Function0)() -> CppCMakeBasedCompilerResolver.resolveOrNull$lambda$0(compilerExecutable, environment)));
    }

    private final OCCompilerKind cache(Path compilerExecutable, CPPEnvironment environment, Function0<? extends OCCompilerKind> block) {
        String string = environment.calcToolchainHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"calcToolchainHash(...)");
        String environmentKey = string;
        this.compilerKindCache.putIfAbsent(environmentKey, new ConcurrentHashMap());
        ConcurrentHashMap<Path, OCCompilerKind> concurrentHashMap = this.compilerKindCache.get(environmentKey);
        OCCompilerKind cachedCompilerKind = concurrentHashMap != null ? concurrentHashMap.computeIfAbsent(compilerExecutable, arg_0 -> CppCMakeBasedCompilerResolver.cache$lambda$1(arg_0 -> CppCMakeBasedCompilerResolver.cache$lambda$0(block, arg_0), arg_0)) : null;
        return Intrinsics.areEqual((Object)cachedCompilerKind, (Object)UnknownCompilerKind.INSTANCE) ? null : cachedCompilerKind;
    }

    private static final OCCompilerKind resolveOrNull$lambda$0(Path $compilerExecutable, CidrToolEnvironment $environment) {
        List list2;
        String compilerFileName = ((Object)$compilerExecutable.getFileName()).toString();
        if (StringsKt.contains$default((CharSequence)compilerFileName, (CharSequence)"++", (boolean)false, (int)2, null)) {
            var4_3 = new CppCMakeLanguageId[]{CppCMakeLanguageId.CXX, CppCMakeLanguageId.CC, CppCMakeLanguageId.CUDA};
            list2 = CollectionsKt.listOf((Object[])var4_3);
        } else if (StringsKt.contains$default((CharSequence)compilerFileName, (CharSequence)"nvcc", (boolean)false, (int)2, null)) {
            var4_3 = new CppCMakeLanguageId[]{CppCMakeLanguageId.CUDA, CppCMakeLanguageId.CC, CppCMakeLanguageId.CXX};
            list2 = CollectionsKt.listOf((Object[])var4_3);
        } else {
            var4_3 = new CppCMakeLanguageId[]{CppCMakeLanguageId.CC, CppCMakeLanguageId.CXX, CppCMakeLanguageId.CUDA};
            list2 = CollectionsKt.listOf((Object[])var4_3);
        }
        List languageIds = list2;
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)languageIds);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CppCMakeLanguageId languageId = (CppCMakeLanguageId)((Object)element$iv);
            boolean bl = false;
            CppCMakeCompilerKind resolutionResult = CppCMakeBasedCompilerResolver.Companion.resolveForLanguage($compilerExecutable, (CPPEnvironment)$environment, languageId);
            if (resolutionResult instanceof CppCMakeCompilerKind.CppCMakeRegularCompilerKind) {
                return ((CppCMakeCompilerKind.CppCMakeRegularCompilerKind)resolutionResult).getValue();
            }
            if (resolutionResult instanceof CppCMakeCompilerKind.CppCMakeContinue) continue;
            if (resolutionResult instanceof CppCMakeCompilerKind.CppCMakeTerminate) {
                return null;
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    private static final OCCompilerKind cache$lambda$0(Function0 $block, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        OCCompilerKind oCCompilerKind = (OCCompilerKind)$block.invoke();
        if (oCCompilerKind == null) {
            oCCompilerKind = (OCCompilerKind)UnknownCompilerKind.INSTANCE;
        }
        return oCCompilerKind;
    }

    private static final OCCompilerKind cache$lambda$1(Function1 $tmp0, Object p0) {
        return (OCCompilerKind)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(CppCMakeBasedCompilerResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
        RANDOM = new SecureRandom();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\f2\u0006\u0010\r\u001a\u00020\u0013H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u001c\u001a\n \u001d*\u0004\u0018\u00010\f0\f*\u00020\fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u0012*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/cpp/workspace/compiler/CppCMakeBasedCompilerResolver$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RANDOM", "Ljava/security/SecureRandom;", "resolveForLanguage", "Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeCompilerKind;", "compilerExecutable", "Ljava/nio/file/Path;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "languageId", "Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeLanguageId;", "toCmakePath", "", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "cmakeVersion", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeCacheFile;", "getCmakeVersion", "(Lcom/jetbrains/cidr/cpp/cmake/model/CMakeCacheFile;)Ljava/lang/String;", "getCompilerKindOrNull", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "", "Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeLanguageVariable;", "deleteRecursively", "kotlin.jvm.PlatformType", "intellij.cmake"})
    @SourceDebugExtension(value={"SMAP\nCppCMakeBasedCompilerResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppCMakeBasedCompilerResolver.kt\ncom/jetbrains/cidr/cpp/workspace/compiler/CppCMakeBasedCompilerResolver$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,375:1\n1#2:376\n32#3,2:377\n*S KotlinDebug\n*F\n+ 1 CppCMakeBasedCompilerResolver.kt\ncom/jetbrains/cidr/cpp/workspace/compiler/CppCMakeBasedCompilerResolver$Companion\n*L\n221#1:377,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final CppCMakeCompilerKind resolveForLanguage(Path compilerExecutable, CPPEnvironment environment, CppCMakeLanguageId languageId) {
            String message;
            HostMachine hostMachine = environment.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
            HostMachine hostMachine2 = hostMachine;
            DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date now = new Date();
            Path path = hostMachine2.createTempDirectory(".clion-compiler-resolver-" + dateFormat.format(now) + "-" + RANDOM.nextLong(), null);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
            Path projectDirectory = path;
            try {
                CppCMakeCompilerKind cppCMakeCompilerKind;
                String string;
                Path path2;
                Files.write(projectDirectory.resolve("CMakeLists.txt"), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)("project(clion-compiler-resolver LANGUAGES " + languageId.getCmakeLanguageName() + ")")), new OpenOption[0]);
                String compilerExecutablePath = this.toCmakePath(compilerExecutable, (CidrToolEnvironment)environment);
                List cmakeOptions = CollectionsKt.listOf((Object)("-D" + languageId.getCmakeVariable() + ":FILEPATH=" + compilerExecutablePath));
                Map cmakeEnvironment = MapsKt.mapOf((Pair)TuplesKt.to((Object)languageId.getEnvironmentVariable(), (Object)compilerExecutablePath));
                CMakeRunner.CMakeOutput cMakeOutput = CMakeGeneratorUtils.runCMakeGenerator(environment, projectDirectory, projectDirectory, (List<String>)cmakeOptions, cmakeEnvironment);
                Intrinsics.checkNotNullExpressionValue((Object)cMakeOutput, (String)"runCMakeGenerator(...)");
                CMakeRunner.CMakeOutput cmakeOutput = cMakeOutput;
                if (cmakeOutput.getExitCode() != 0) {
                    CppCMakeCompilerKind cppCMakeCompilerKind2 = CppCMakeCompilerKind.CppCMakeContinue.INSTANCE;
                    return cppCMakeCompilerKind2;
                }
                CMakeCacheFile cmakeCache = new CMakeCacheFile(projectDirectory.resolve("CMakeCache.txt"), CppCMakeSyntaxLexer.INSTANCE.getCMAKE_OUTPUT_CHARSET$intellij_cmake().name());
                String cmakeVersion = this.getCmakeVersion(cmakeCache);
                List cmakeCompilerDotCmakeLocators = new ArrayList();
                ((Collection)cmakeCompilerDotCmakeLocators).add(CppMakefileDotCmakeParser.INSTANCE);
                if (cmakeVersion != null) {
                    ((Collection)cmakeCompilerDotCmakeLocators).add(new CppExactVersionBasedLocator(cmakeVersion));
                    ((Collection)cmakeCompilerDotCmakeLocators).add(new CppApproximateVersionBasedLocator(cmakeVersion));
                }
                ((Collection)cmakeCompilerDotCmakeLocators).add(CppFirstMatchLocator.INSTANCE);
                if ((Path)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)cmakeCompilerDotCmakeLocators), arg_0 -> Companion.resolveForLanguage$lambda$0(projectDirectory, languageId, arg_0))) == null) {
                    CppCMakeCompilerKind cppCMakeCompilerKind3 = CppCMakeCompilerKind.CppCMakeContinue.INSTANCE;
                    return cppCMakeCompilerKind3;
                }
                Path cmakeCompilerDotCmake = path2;
                Closeable closeable = Files.newBufferedReader(cmakeCompilerDotCmake, CppCMakeSyntaxLexer.INSTANCE.getCMAKE_OUTPUT_CHARSET$intellij_cmake());
                Object object = null;
                try {
                    Reader p0 = (Reader)closeable;
                    boolean bl = false;
                    string = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                String cmakeCompilerDotCmakeRaw = string;
                Map<String, CppCMakeLanguageVariable> cmakeCompilerDotCmakeParsed = CppCMakeSyntaxLexer.INSTANCE.readVariables(cmakeCompilerDotCmakeRaw);
                OCCompilerKind oCCompilerKind = this.getCompilerKindOrNull(cmakeCompilerDotCmakeParsed, languageId);
                if (oCCompilerKind != null) {
                    OCCompilerKind p0 = oCCompilerKind;
                    boolean bl = false;
                    cppCMakeCompilerKind = new CppCMakeCompilerKind.CppCMakeRegularCompilerKind(p0);
                } else {
                    cppCMakeCompilerKind = CppCMakeCompilerKind.CppCMakeTerminate.INSTANCE;
                }
                object = cppCMakeCompilerKind;
                return object;
            }
            catch (CMakeException ce) {
                String string = ce.getMessage();
                if (string == null) {
                    string = ce.toString();
                }
                message = string;
                LOGGER.error(message, (Throwable)ce);
            }
            catch (IOException ioe) {
                String string = ioe.getMessage();
                if (string == null) {
                    string = ioe.toString();
                }
                message = string;
                LOGGER.error(message, (Throwable)ioe);
            }
            finally {
                this.deleteRecursively(projectDirectory);
            }
            return CppCMakeCompilerKind.CppCMakeContinue.INSTANCE;
        }

        private final String toCmakePath(Path $this$toCmakePath, CidrToolEnvironment environment) {
            String cmakePath = null;
            cmakePath = ((Object)$this$toCmakePath).toString();
            char cmakeSeparatorChar = '/';
            Iterator $this$forEach$iv = environment.getSupportedFileSeparators().iterator();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                char separatorChar = ((Character)element$iv).charValue();
                boolean bl = false;
                if (separatorChar == cmakeSeparatorChar) continue;
                cmakePath = StringsKt.replace$default((String)cmakePath, (char)separatorChar, (char)cmakeSeparatorChar, (boolean)false, (int)4, null);
            }
            return cmakePath;
        }

        private final String getCmakeVersion(CMakeCacheFile $this$cmakeVersion) {
            String minorVersion;
            CharSequence charSequence;
            Object cmakeVersion = $this$cmakeVersion.getVariableValue("CMAKE_CACHE_MAJOR_VERSION");
            CharSequence charSequence2 = (CharSequence)cmakeVersion;
            if (!(charSequence2 == null || charSequence2.length() == 0) && !((charSequence = (CharSequence)(minorVersion = $this$cmakeVersion.getVariableValue("CMAKE_CACHE_MINOR_VERSION"))) == null || charSequence.length() == 0)) {
                cmakeVersion = (String)cmakeVersion + ".";
                cmakeVersion = (String)cmakeVersion + minorVersion;
                String patchVersion = $this$cmakeVersion.getVariableValue("CMAKE_CACHE_PATCH_VERSION");
                CharSequence charSequence3 = patchVersion;
                if (!(charSequence3 == null || charSequence3.length() == 0)) {
                    cmakeVersion = (String)cmakeVersion + ".";
                    cmakeVersion = (String)cmakeVersion + patchVersion;
                }
            }
            return cmakeVersion;
        }

        /*
         * WARNING - bad return control flow
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final OCCompilerKind getCompilerKindOrNull(Map<String, ? extends CppCMakeLanguageVariable> $this$getCompilerKindOrNull, CppCMakeLanguageId languageId) {
            OCCompilerKind oCCompilerKind;
            block16: {
                block17: {
                    OCBuiltInCompilerKind oCBuiltInCompilerKind;
                    String languageName;
                    Object compilerId;
                    String compiler;
                    String cmakeLanguageName;
                    block15: {
                        cmakeLanguageName = languageId.getCmakeLanguageName();
                        CppCMakeLanguageVariable cppCMakeLanguageVariable = $this$getCompilerKindOrNull.get("CMAKE_" + cmakeLanguageName + "_COMPILER");
                        CppCMakeLanguageVariable.CppCMakeLanguageQuotedString cppCMakeLanguageQuotedString = cppCMakeLanguageVariable instanceof CppCMakeLanguageVariable.CppCMakeLanguageQuotedString ? (CppCMakeLanguageVariable.CppCMakeLanguageQuotedString)cppCMakeLanguageVariable : null;
                        compiler = cppCMakeLanguageQuotedString != null ? cppCMakeLanguageQuotedString.getValue() : null;
                        Object object = $this$getCompilerKindOrNull.get("CMAKE_" + cmakeLanguageName + "_COMPILER_ID");
                        if (!(object instanceof CppCMakeLanguageVariable.CppCMakeLanguageQuotedString)) return null;
                        CppCMakeLanguageVariable.CppCMakeLanguageQuotedString cppCMakeLanguageQuotedString2 = (CppCMakeLanguageVariable.CppCMakeLanguageQuotedString)object;
                        Object object2 = cppCMakeLanguageQuotedString2;
                        if (cppCMakeLanguageQuotedString2 == null) return null;
                        if ((object2 = ((CppCMakeLanguageVariable.CppCMakeLanguageQuotedString)object2).getValue()) == null) {
                            return null;
                        }
                        compilerId = object2;
                        languageName = languageId.getLanguageName();
                        object = ((CharSequence)compilerId).length() == 0 ? "\"" + compiler + "\" resolved as a " + languageName + " compiler, but CMAKE_" + cmakeLanguageName + "_COMPILER_ID is empty." : "\"" + compiler + "\" resolved as " + (String)compilerId + " " + languageName + " compiler.";
                        Logger logger = LOGGER;
                        Object p0 = object;
                        boolean bl = false;
                        logger.info((String)p0);
                        object = compilerId;
                        switch (((String)object).hashCode()) {
                            case 1484200375: {
                                if (((String)object).equals("AppleClang")) break;
                                return null;
                            }
                            case 65190065: {
                                if (!((String)object).equals("Clang")) {
                                    return null;
                                }
                                break block15;
                            }
                            case -1980228293: {
                                if (!((String)object).equals("NVIDIA")) {
                                    return null;
                                }
                                break block16;
                            }
                            case 2376403: {
                                if (!((String)object).equals("MSVC")) {
                                    return null;
                                }
                                break block17;
                            }
                            case 70734: {
                                if (!((String)object).equals("GNU")) return null;
                                oCCompilerKind = (OCCompilerKind)GCCCompilerKind.INSTANCE;
                                return oCCompilerKind;
                            }
                        }
                        oCCompilerKind = (OCCompilerKind)AppleClangCompilerKind.INSTANCE;
                        return oCCompilerKind;
                    }
                    Object object = $this$getCompilerKindOrNull.get("CMAKE_" + cmakeLanguageName + "_SIMULATE_ID");
                    CppCMakeLanguageVariable.CppCMakeLanguageQuotedString cppCMakeLanguageQuotedString = object instanceof CppCMakeLanguageVariable.CppCMakeLanguageQuotedString ? (CppCMakeLanguageVariable.CppCMakeLanguageQuotedString)object : null;
                    String simulateId = cppCMakeLanguageQuotedString != null ? cppCMakeLanguageQuotedString.getValue() : null;
                    CppCMakeLanguageVariable cppCMakeLanguageVariable = $this$getCompilerKindOrNull.get("CMAKE_" + cmakeLanguageName + "_COMPILER_FRONTEND_VARIANT");
                    CppCMakeLanguageVariable.CppCMakeLanguageQuotedString cppCMakeLanguageQuotedString3 = cppCMakeLanguageVariable instanceof CppCMakeLanguageVariable.CppCMakeLanguageQuotedString ? (CppCMakeLanguageVariable.CppCMakeLanguageQuotedString)cppCMakeLanguageVariable : null;
                    String compilerFrontendVariant = cppCMakeLanguageQuotedString3 != null ? cppCMakeLanguageQuotedString3.getValue() : null;
                    object = simulateId;
                    if ((object == null || object.length() == 0) && ((object = (CharSequence)compilerFrontendVariant) == null || object.length() == 0 || Intrinsics.areEqual((Object)compilerFrontendVariant, (Object)"GNU"))) {
                        oCBuiltInCompilerKind = (OCBuiltInCompilerKind)ClangCompilerKind.INSTANCE;
                    } else if (Intrinsics.areEqual((Object)simulateId, (Object)"MSVC") || Intrinsics.areEqual((Object)compilerFrontendVariant, (Object)"MSVC")) {
                        oCBuiltInCompilerKind = (OCBuiltInCompilerKind)ClangClCompilerKind.INSTANCE;
                    } else {
                        Map<String, ? extends CppCMakeLanguageVariable> $this$getCompilerKindOrNull_u24lambda_u240 = $this$getCompilerKindOrNull;
                        boolean bl = false;
                        LOGGER.warn("\"" + compiler + "\" resolved as " + (String)compilerId + " " + languageName + " compiler, with unexpected CMAKE_" + cmakeLanguageName + "_SIMULATE_ID = \"" + simulateId + "\" and CMAKE_" + cmakeLanguageName + "_COMPILER_FRONTEND_VARIANT = \"" + compilerFrontendVariant + "\"; returning null...");
                        oCBuiltInCompilerKind = null;
                    }
                    oCCompilerKind = (OCCompilerKind)oCBuiltInCompilerKind;
                    return oCCompilerKind;
                }
                oCCompilerKind = (OCCompilerKind)MSVCCompilerKind.INSTANCE;
                return oCCompilerKind;
            }
            oCCompilerKind = (OCCompilerKind)NVCCCompilerKind.INSTANCE;
            return oCCompilerKind;
            return null;
        }

        private final Path deleteRecursively(Path $this$deleteRecursively) throws IOException {
            return Files.walkFileTree($this$deleteRecursively, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    try {
                        Files.delete(file);
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    try {
                        Files.delete(file);
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    if (exc != null) {
                        throw exc;
                    }
                    try {
                        Files.delete(dir);
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private static final Path resolveForLanguage$lambda$0(Path $projectDirectory, CppCMakeLanguageId $languageId, CppCMakeCompilerDotCmakeLocator locator) {
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            return locator.locate($projectDirectory, $languageId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

