/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.cpp.CMakeBundle;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugProcess;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeLineBreakpointProperties;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeLineBreakpointType
extends XLineBreakpointType<CMakeLineBreakpointProperties> {
    @NonNls
    private static final String ID = "CMakeLineBreakpoint";

    private CMakeLineBreakpointType() {
        super(ID, CMakeBundle.message("cmake.dbg.breakpoint.title", new Object[0]));
    }

    @Nullable
    public CMakeLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            CMakeLineBreakpointType.$$$reportNull$$$0(0);
        }
        return new CMakeLineBreakpointProperties();
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            CMakeLineBreakpointType.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CMakeLineBreakpointType.$$$reportNull$$$0(2);
        }
        if (!CMakeDebugProcess.isEnabled()) {
            return false;
        }
        if (line < 0 || LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file) != CMakeLanguage.INSTANCE) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null || document.getLineEndOffset(line) == document.getLineStartOffset(line)) {
            return false;
        }
        CommonProcessors.FindFirstProcessor<PsiElement> processor = new CommonProcessors.FindFirstProcessor<PsiElement>(this){

            protected boolean accept(PsiElement element) {
                IElementType type = element.getNode().getElementType();
                return !CMakeElementTypes.WHITE_SPACES.contains(type) && !CMakeElementTypes.COMMENTS.contains(type);
            }
        };
        XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)processor);
        return processor.isFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeLineBreakpointType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBreakpointProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

