/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProjectCollector;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceListener;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeProjectOpenedListener
implements CidrWorkspaceListener {
    @Nullable
    private static File findCMakeCacheFile(@NotNull CMakeWorkspace cmakeWorkspace) {
        List<CMakeSettings.Profile> profiles;
        List<File> buildDirs;
        if (cmakeWorkspace == null) {
            CMakeProjectOpenedListener.$$$reportNull$$$0(0);
        }
        if ((buildDirs = cmakeWorkspace.getEffectiveProfileGenerationDirs(ContainerUtil.map(profiles = cmakeWorkspace.getSettings().getActiveProfiles(), it -> Pair.create((Object)it.getName(), (Object)it.getGenerationDir())))).isEmpty()) {
            return null;
        }
        File cacheIOFile = new File(buildDirs.get(0), "CMakeCache.txt");
        if (!cacheIOFile.exists()) {
            return null;
        }
        return cacheIOFile;
    }

    private static void findQtAndLogEvent(@Nullable File cacheIOFile, @NotNull Project project) {
        if (project == null) {
            CMakeProjectOpenedListener.$$$reportNull$$$0(1);
        }
        if (cacheIOFile == null) {
            CMakeProjectCollector.PROJECT_OPENED.log(project, (Object)CMakeProjectCollector.ProjectType.Regular);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            VirtualFile cacheVFile = LocalFileSystem.getInstance().findFileByIoFile(cacheIOFile);
            try {
                CMakeCacheFile cacheFile = new CMakeCacheFile(cacheIOFile, cacheVFile == null ? "UTF-8" : cacheVFile.getCharset().name());
                boolean hasQt = ContainerUtil.exists(cacheFile.getVariables(), var -> var.getName().matches("^Qt\\d*_DIR$"));
                CMakeProjectCollector.PROJECT_OPENED.log(project, (Object)(hasQt ? CMakeProjectCollector.ProjectType.WithQt : CMakeProjectCollector.ProjectType.Regular));
            }
            catch (CMakeException cMakeException) {
                // empty catch block
            }
        });
    }

    public void initialized(@NotNull CidrWorkspace workspace) {
        if (workspace == null) {
            CMakeProjectOpenedListener.$$$reportNull$$$0(2);
        }
        if (!(workspace instanceof CMakeWorkspace)) {
            return;
        }
        final CMakeWorkspace cmakeWorkspace = (CMakeWorkspace)workspace;
        final @NotNull Project project = cmakeWorkspace.getProject();
        File cacheIOFile = CMakeProjectOpenedListener.findCMakeCacheFile(cmakeWorkspace);
        if (cacheIOFile != null) {
            CMakeProjectOpenedListener.findQtAndLogEvent(cacheIOFile, project);
            return;
        }
        final SimpleMessageBusConnection connection = project.getMessageBus().connect(cmakeWorkspace.coroutineScope);
        connection.subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            @Override
            public void reloadingFinished(boolean canceled) {
                connection.disconnect();
                CMakeProjectOpenedListener.findQtAndLogEvent(CMakeProjectOpenedListener.findCMakeCacheFile(cmakeWorkspace), project);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeWorkspace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeProjectOpenedListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findCMakeCacheFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findQtAndLogEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initialized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

